/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.stats;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Resource;
import games.strategy.engine.stats.IStat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;

public abstract class AbstractStat
implements IStat {
    protected static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("##0.##");

    @Override
    public double getValue(String alliance, GameData data) {
        Iterator<PlayerID> iter = data.getAllianceTracker().getPlayersInAlliance(alliance).iterator();
        double rVal = 0.0;
        while (iter.hasNext()) {
            PlayerID player = iter.next();
            rVal += this.getValue(player, data);
        }
        return rVal;
    }

    @Override
    public NumberFormat getFormatter() {
        return DECIMAL_FORMAT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Resource getResourcePUs(GameData data) {
        Resource pus = null;
        try {
            data.acquireReadLock();
            pus = data.getResourceList().getResource("PUs");
        }
        finally {
            data.releaseReadLock();
        }
        return pus;
    }
}

