/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid;

import games.strategy.engine.data.DefaultUnitFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.IUnitFactory;
import games.strategy.engine.delegate.IDelegate;
import games.strategy.engine.framework.AbstractGameLoader;
import games.strategy.engine.framework.IGame;
import games.strategy.engine.framework.IGameLoader;
import games.strategy.engine.framework.LocalPlayers;
import games.strategy.engine.framework.ServerGame;
import games.strategy.engine.framework.headlessGameServer.HeadlessGameServer;
import games.strategy.engine.framework.headlessGameServer.HeadlessGameServerUI;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.engine.message.IChannelSubscribor;
import games.strategy.engine.message.IRemote;
import games.strategy.grid.delegate.EditDelegate;
import games.strategy.grid.player.GridGamePlayer;
import games.strategy.grid.player.IGridGamePlayer;
import games.strategy.grid.ui.GridGameFrame;
import games.strategy.grid.ui.GridGameMenu;
import games.strategy.grid.ui.GridMapData;
import games.strategy.grid.ui.GridMapPanel;
import games.strategy.grid.ui.display.DummyGridGameDisplay;
import games.strategy.grid.ui.display.GridGameDisplay;
import games.strategy.grid.ui.display.IGridGameDisplay;
import games.strategy.sound.DefaultSoundChannel;
import games.strategy.sound.DummySound;
import games.strategy.sound.ISound;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

public abstract class GridGame
extends AbstractGameLoader
implements IGameLoader {
    private static final long serialVersionUID = -7194416906783331148L;
    protected transient IGridGameDisplay m_display;

    @Override
    public abstract Set<IGamePlayer> createPlayers(Map<String, String> var1);

    protected abstract Class<? extends GridMapPanel> getGridMapPanelClass();

    protected abstract Class<? extends GridMapData> getGridMapDataClass();

    protected abstract Class<? extends GridGameMenu<GridGameFrame>> getGridTableMenuClass();

    public int getSquareWidth() {
        return 50;
    }

    public int getSquareHeight() {
        return 50;
    }

    public int getBevelSize() {
        return 25;
    }

    protected void initializeGame() {
    }

    @Override
    public void startGame(final IGame game, final Set<IGamePlayer> players, boolean headless) throws Exception {
        try {
            this.m_game = game;
            if (game.getData().getDelegateList().getDelegate("edit") == null) {
                EditDelegate delegate = new EditDelegate();
                delegate.initialize("edit", "edit");
                this.m_game.getData().getDelegateList().addDelegate(delegate);
                if (game instanceof ServerGame) {
                    ((ServerGame)game).addDelegateMessenger(delegate);
                }
            }
            final LocalPlayers localPlayers = new LocalPlayers(players);
            if (headless) {
                boolean useServerUI = HeadlessGameServer.getUseGameServerUI();
                HeadlessGameServerUI headlessFrameUI = useServerUI ? new HeadlessGameServerUI(game, localPlayers, null) : null;
                this.m_display = new DummyGridGameDisplay(headlessFrameUI);
                this.m_soundChannel = new DummySound();
                this.m_game.addDisplay(this.m_display);
                this.m_game.addSoundChannel(this.m_soundChannel);
                this.initializeGame();
                this.connectPlayers(players, null);
                if (headlessFrameUI != null) {
                    headlessFrameUI.setLocationRelativeTo(null);
                    headlessFrameUI.setSize(700, 400);
                    headlessFrameUI.setVisible(true);
                    headlessFrameUI.toFront();
                }
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        final GridGameFrame frame = new GridGameFrame(game, localPlayers, GridGame.this.getGridMapPanelClass(), GridGame.this.getGridMapDataClass(), GridGame.this.getGridTableMenuClass(), GridGame.this.getSquareWidth(), GridGame.this.getSquareHeight(), GridGame.this.getBevelSize());
                        GridGame.this.m_display = new GridGameDisplay(frame);
                        GridGame.this.m_game.addDisplay(GridGame.this.m_display);
                        GridGame.this.m_soundChannel = new DefaultSoundChannel(localPlayers);
                        GridGame.this.m_game.addSoundChannel(GridGame.this.m_soundChannel);
                        GridGame.this.initializeGame();
                        GridGame.this.connectPlayers(players, frame);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Dimension screenResolution = Toolkit.getDefaultToolkit().getScreenSize();
                                int availHeight = screenResolution.height - 30;
                                int availWidth = screenResolution.width;
                                Dimension currentSize = frame.getPreferredSize();
                                currentSize.height = Math.min(availHeight, currentSize.height + 10);
                                currentSize.width = Math.min(availWidth, currentSize.width + 10);
                                frame.setPreferredSize(currentSize);
                                frame.setSize(currentSize);
                                if (currentSize.height > availHeight - 100 && currentSize.width > availWidth - 200) {
                                    frame.setExtendedState(6);
                                } else if (currentSize.height > availHeight) {
                                    frame.setExtendedState(4);
                                } else if (currentSize.width > availWidth) {
                                    frame.setExtendedState(2);
                                }
                                frame.setLocationRelativeTo(null);
                                frame.setVisible(true);
                                frame.toFront();
                                frame.minimizeRightSidePanel();
                            }
                        });
                    }
                });
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            e.printStackTrace();
            throw new IllegalStateException(e.getCause().getMessage());
        }
    }

    private void connectPlayers(Set<IGamePlayer> players, GridGameFrame frame) {
        for (IGamePlayer player : players) {
            if (!(player instanceof GridGamePlayer)) continue;
            ((GridGamePlayer)player).setFrame(frame);
        }
    }

    @Override
    public void shutDown() {
        super.shutDown();
        if (this.m_display != null) {
            this.m_game.removeDisplay(this.m_display);
            this.m_display.shutDown();
            this.m_display = null;
        }
    }

    @Override
    public Class<? extends IChannelSubscribor> getDisplayType() {
        return IGridGameDisplay.class;
    }

    @Override
    public Class<? extends IChannelSubscribor> getSoundType() {
        return ISound.class;
    }

    @Override
    public Class<? extends IRemote> getRemotePlayerType() {
        return IGridGamePlayer.class;
    }

    @Override
    public IUnitFactory getUnitFactory() {
        return new DefaultUnitFactory();
    }

    protected static final IDelegate findDelegate(GameData data, String delegate_name) {
        IDelegate delegate = data.getDelegateList().getDelegate(delegate_name);
        if (delegate == null) {
            throw new IllegalStateException(delegate_name + " delegate not found");
        }
        return delegate;
    }
}

