/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.chess.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.grid.chess.delegate.EndTurnExtendedDelegateState;
import games.strategy.grid.chess.delegate.PlayDelegate;
import games.strategy.grid.delegate.AbstractPlayByEmailOrForumDelegate;
import games.strategy.grid.ui.display.IGridGameDisplay;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class EndTurnDelegate
extends AbstractPlayByEmailOrForumDelegate {
    @Override
    public void start() {
        super.start();
        PlayerID winner = this.checkForWinner();
        if (winner != null) {
            this.signalGameOver(winner.getName() + " wins!");
        } else if (this.isDraw(this.m_player, this.getData(), 1)) {
            this.signalGameOver("Game Is A Draw!");
        }
    }

    @Override
    public void end() {
        super.end();
    }

    @Override
    public Serializable saveState() {
        EndTurnExtendedDelegateState state = new EndTurnExtendedDelegateState();
        state.superState = super.saveState();
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        EndTurnExtendedDelegateState s = (EndTurnExtendedDelegateState)state;
        super.loadState(s.superState);
    }

    private void signalGameOver(String status) {
        this.m_bridge.getHistoryWriter().startEvent(status);
        IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.setStatus(status);
        display.setGameOver();
        this.m_bridge.stopGameSequence();
    }

    private PlayerID checkForWinner() {
        if (EndTurnDelegate.doWeWin(this.m_player, this.getData(), 1)) {
            return this.m_player;
        }
        return null;
    }

    public static boolean doWeWin(PlayerID player, GameData data, int testForCheckTurnsAhead) {
        if (player == null) {
            throw new IllegalArgumentException("Checking for winner can not have null player");
        }
        ArrayList<PlayerID> enemies = new ArrayList<PlayerID>(data.getPlayerList().getPlayers());
        enemies.remove(player);
        Iterator iter = enemies.iterator();
        while (iter.hasNext()) {
            PlayerID e = (PlayerID)iter.next();
            if (!PlayDelegate.getKingTerritories(e, data).isEmpty() && (!PlayDelegate.areWeInCheck(e, data, testForCheckTurnsAhead) || PlayDelegate.canWeMakeAValidMoveThatIsNotPuttingUsInCheck(e, data, testForCheckTurnsAhead))) continue;
            iter.remove();
        }
        return enemies.isEmpty();
    }

    private boolean isDraw(PlayerID player, GameData data, int testForCheckTurnsAhead) {
        ArrayList<PlayerID> enemies = new ArrayList<PlayerID>(data.getPlayerList().getPlayers());
        enemies.remove(player);
        boolean haveMovesAvailable = false;
        for (PlayerID enemy : enemies) {
            if (!PlayDelegate.areWeInCheck(enemy, data, testForCheckTurnsAhead)) {
                for (Territory t1 : data.getMap().getTerritories()) {
                    for (Territory t2 : data.getMap().getTerritories()) {
                        if (PlayDelegate.isValidPlay(t1, t2, enemy, data, 2) != null) continue;
                        haveMovesAvailable = true;
                        break;
                    }
                    if (!haveMovesAvailable) continue;
                    break;
                }
            } else {
                haveMovesAvailable = true;
            }
            if (!haveMovesAvailable) continue;
            break;
        }
        return !haveMovesAvailable;
    }
}

