/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.chess.delegate;

import games.strategy.common.delegate.AbstractDelegate;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.ChangePerformer;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.delegate.AutoSave;
import games.strategy.engine.framework.GameDataUtils;
import games.strategy.engine.message.IRemote;
import games.strategy.grid.chess.ChessUnit;
import games.strategy.grid.chess.attachments.PlayerAttachment;
import games.strategy.grid.chess.delegate.ChessPlayExtendedDelegateState;
import games.strategy.grid.chess.delegate.EndTurnDelegate;
import games.strategy.grid.delegate.remote.IGridPlayDelegate;
import games.strategy.grid.player.IGridGamePlayer;
import games.strategy.grid.ui.GridPlayData;
import games.strategy.grid.ui.IGridPlayData;
import games.strategy.grid.ui.display.IGridGameDisplay;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.Match;
import games.strategy.util.Quadruple;
import games.strategy.util.Tuple;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@AutoSave(beforeStepStart=false, afterStepEnd=true)
public class PlayDelegate
extends AbstractDelegate
implements IGridPlayDelegate {
    public static final Match<PlayerID> PlayerBeginsAtLowestRank = new Match<PlayerID>(){

        @Override
        public boolean match(PlayerID player) {
            return player != null && player.getName().equalsIgnoreCase("Black");
        }
    };
    public static final Match<Unit> UnitHasNeverMovedBefore = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            return unit != null && ((ChessUnit)unit).getHasMoved() == 0;
        }
    };
    public static final Match<Unit> UnitHasOnlyMovedOnce = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            return unit != null && ((ChessUnit)unit).getHasMoved() == 1;
        }
    };
    public static final Match<Unit> UnitIsPawn = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            return unit != null && unit.getType().getName().equalsIgnoreCase("pawn");
        }
    };
    public static final Match<Unit> UnitIsKnight = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            return unit != null && unit.getType().getName().equalsIgnoreCase("knight");
        }
    };
    public static final Match<Unit> UnitIsBishop = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            return unit != null && unit.getType().getName().equalsIgnoreCase("bishop");
        }
    };
    public static final Match<Unit> UnitIsRook = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            return unit != null && unit.getType().getName().equalsIgnoreCase("rook");
        }
    };
    public static final Match<Unit> UnitIsQueen = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            return unit != null && unit.getType().getName().equalsIgnoreCase("queen");
        }
    };
    public static final Match<Unit> UnitIsKing = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            return unit != null && unit.getType().getName().equalsIgnoreCase("king");
        }
    };

    @Override
    public void start() {
        super.start();
        IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.setStatus(this.m_player.getName() + "'s turn");
    }

    @Override
    public void end() {
        super.end();
    }

    @Override
    public Serializable saveState() {
        ChessPlayExtendedDelegateState state = new ChessPlayExtendedDelegateState();
        state.superState = super.saveState();
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        ChessPlayExtendedDelegateState s = (ChessPlayExtendedDelegateState)state;
        super.loadState(s.superState);
    }

    @Override
    public boolean delegateCurrentlyRequiresUserInput() {
        return true;
    }

    @Override
    public void signalStatus(String status) {
        IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.setStatus(status);
    }

    @Override
    public String play(IGridPlayData play) {
        Territory start = play.getStart();
        Territory end = play.getEnd();
        if (start.getUnits().getUnitCount() > 1 || end.getUnits().getUnitCount() > 1) {
            throw new IllegalStateException("Can not have more than 1 unit in any territory");
        }
        String error = PlayDelegate.isValidPlay(start, end, this.m_player, this.getData(), 2);
        if (error != null) {
            return error;
        }
        Collection<Territory> captured = PlayDelegate.checkForCaptures(start, end, this.m_player, this.getData());
        this.performPlay(play, captured, this.m_player);
        if (start.getUnits().getUnitCount() > 1 || end.getUnits().getUnitCount() > 1) {
            throw new IllegalStateException("Can not have more than 1 unit in any territory");
        }
        return null;
    }

    public static String isValidPlay(Territory start, Territory end, PlayerID player, GameData data, int testForCheckTurnsAhead) {
        String basic = PlayDelegate.isValidMoveBasic(start, end, player, data);
        if (basic != null) {
            return basic;
        }
        String pieceBasic = PlayDelegate.isValidPieceMoveBasic(start, end, player, data, testForCheckTurnsAhead - 1);
        if (pieceBasic != null) {
            return pieceBasic;
        }
        if (testForCheckTurnsAhead > 0 && PlayDelegate.testTerritoryForUsInCheckAfter(start, end, player, data, testForCheckTurnsAhead - 1)) {
            return "Illegal To Move Into Check Or Stay In Check";
        }
        return null;
    }

    public static Collection<Territory> checkForCaptures(Territory start, Territory end, PlayerID player, GameData data) {
        HashSet<Territory> captured = new HashSet<Territory>(1);
        if (end.getUnits().getUnitCount() > 0) {
            captured.add(end);
        }
        if (start.getUnits().someMatch(UnitIsPawn) && PlayDelegate.isValidEnPassant(start, end, player, data) == null) {
            boolean startsAtLowRank = PlayerBeginsAtLowestRank.match(player);
            Territory territoryOfEnemyPawn = data.getMap().getTerritoryFromCoordinates(false, end.getX(), startsAtLowRank ? end.getY() - 1 : end.getY() + 1);
            if (territoryOfEnemyPawn.getUnits().getUnitCount() > 0) {
                captured.add(territoryOfEnemyPawn);
            }
        }
        return captured;
    }

    private void performPlay(IGridPlayData play, Collection<Territory> captured, PlayerID player) {
        ArrayList<Unit> promotionUnits;
        Territory start = play.getStart();
        Territory end = play.getEnd();
        Collection<Unit> units = start.getUnits().getUnits();
        if (PlayDelegate.isValidPawnPromotion(start, end, this.m_player, this.getData())) {
            promotionUnits = new ArrayList<Unit>();
            Set<UnitType> allowed = this.getData().getUnitTypeList().getAllUnitTypes();
            allowed.remove(this.getData().getUnitTypeList().getUnitType("king"));
            allowed.remove(this.getData().getUnitTypeList().getUnitType("pawn"));
            UnitType selectedUnit = ((IGridGamePlayer)this.getRemotePlayer(player)).selectUnit(units.iterator().next(), allowed, end, player, this.getData(), "Promote Pawn to what piece?");
            if (selectedUnit == null) {
                promotionUnits.add(this.getData().getUnitTypeList().getUnitType("queen").create(player));
            } else {
                promotionUnits.add(this.getData().getUnitTypeList().getUnitType(selectedUnit.getName()).create(player));
            }
        } else {
            promotionUnits = null;
        }
        this.m_bridge.getHistoryWriter().startEvent(play.toString(), units);
        Change removeUnit = ChangeFactory.removeUnits(start, units);
        Change addUnit = ChangeFactory.addUnits(end, promotionUnits == null ? units : promotionUnits);
        CompositeChange change = new CompositeChange();
        change.add(removeUnit);
        change.add(addUnit);
        for (Unit u : units) {
            int numMoves = ((ChessUnit)u).getHasMoved();
            change.add(ChangeFactory.unitPropertyChange(u, numMoves + 1, "hasMoved"));
        }
        HashSet<Unit> capturedUnitsTotal = new HashSet<Unit>();
        for (Territory at : captured) {
            Collection<Unit> capturedUnits;
            if (at == null || (capturedUnits = at.getUnits().getUnits()).isEmpty()) continue;
            Change capture = ChangeFactory.removeUnits(at, capturedUnits);
            change.add(capture);
            capturedUnitsTotal.addAll(capturedUnits);
        }
        if (!capturedUnitsTotal.isEmpty()) {
            this.m_bridge.getHistoryWriter().addChildToEvent(player.getName() + " captures units: " + MyFormatter.unitsToText(capturedUnitsTotal), capturedUnitsTotal);
        }
        HashSet<Territory> refresh = new HashSet<Territory>();
        refresh.add(start);
        refresh.add(end);
        refresh.addAll(captured);
        ArrayList<Unit> lastMovedPieces = new ArrayList<Unit>();
        lastMovedPieces.addAll(units);
        if (start.getUnits().someMatch(UnitIsKing) && PlayDelegate.isValidKingCastling(start, end, player, this.getData(), 2) == null) {
            GameMap map = this.getData().getMap();
            int lastColumn = map.getXDimension() - 1;
            if (end.getX() > start.getX()) {
                Territory rookTerOld = map.getTerritoryFromCoordinates(lastColumn, start.getY());
                Territory rookTerNew = map.getTerritoryFromCoordinates(end.getX() - 1, start.getY());
                List<Unit> rook = rookTerOld.getUnits().getMatches(new CompositeMatchAnd<Unit>(UnitIsRook, PlayDelegate.UnitIsOwnedBy(player), UnitHasNeverMovedBefore));
                Change removeRook = ChangeFactory.removeUnits(rookTerOld, rook);
                Change addRook = ChangeFactory.addUnits(rookTerNew, rook);
                change.add(removeRook);
                change.add(addRook);
                for (Unit u : rook) {
                    int numMoves = ((ChessUnit)u).getHasMoved();
                    change.add(ChangeFactory.unitPropertyChange(u, numMoves + 1, "hasMoved"));
                }
                refresh.add(rookTerOld);
                refresh.add(rookTerNew);
                lastMovedPieces.addAll(rook);
            } else {
                Territory rookTerOld = map.getTerritoryFromCoordinates(0, start.getY());
                Territory rookTerNew = map.getTerritoryFromCoordinates(end.getX() + 1, start.getY());
                List<Unit> rook = rookTerOld.getUnits().getMatches(new CompositeMatchAnd<Unit>(UnitIsRook, PlayDelegate.UnitIsOwnedBy(player), UnitHasNeverMovedBefore));
                Change removeRook = ChangeFactory.removeUnits(rookTerOld, rook);
                Change addRook = ChangeFactory.addUnits(rookTerNew, rook);
                change.add(removeRook);
                change.add(addRook);
                for (Unit u : rook) {
                    int numMoves = ((ChessUnit)u).getHasMoved();
                    change.add(ChangeFactory.unitPropertyChange(u, numMoves + 1, "hasMoved"));
                }
                refresh.add(rookTerOld);
                refresh.add(rookTerNew);
                lastMovedPieces.addAll(rook);
            }
        }
        change.add(ChangeFactory.attachmentPropertyChange(PlayerAttachment.get(player), lastMovedPieces, "lastPiecesMoved"));
        this.m_bridge.addChange(change);
        IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.refreshTerritories(refresh);
        display.showGridPlayDataMove(new GridPlayData(start, end, player));
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return IGridPlayDelegate.class;
    }

    public static Match<Territory> TerritoryHasUnitsOwnedBy(PlayerID player) {
        final Match<Unit> unitOwnedBy = PlayDelegate.UnitIsOwnedBy(player);
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return t.getUnits().someMatch(unitOwnedBy);
            }
        };
    }

    public static Match<Unit> UnitIsOwnedBy(final PlayerID player) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                return unit.getOwner().equals(player);
            }
        };
    }

    public static boolean canWeMakeAValidMoveThatIsNotPuttingUsInCheck(PlayerID player, GameData data, int testForCheckTurnsAhead) {
        List<Territory> allTerritories = data.getMap().getTerritories();
        for (Territory t1 : allTerritories) {
            for (Territory t2 : allTerritories) {
                if (PlayDelegate.isValidPlay(t1, t2, player, data, testForCheckTurnsAhead) != null) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Tuple<Territory, Territory>> getMovesThatCaptureThisTerritory(Territory end, PlayerID player, GameData data, int testForCheckTurnsAhead, boolean endAsSoonAsFindOne) {
        ArrayList<Tuple<Territory, Territory>> available = new ArrayList<Tuple<Territory, Territory>>();
        List<Territory> allTerritories = data.getMap().getTerritories();
        List<Territory> allOur = Match.getMatches(allTerritories, PlayDelegate.TerritoryHasUnitsOwnedBy(player));
        for (Territory t1 : allOur) {
            for (Territory t2 : allTerritories) {
                Collection<Territory> captured = PlayDelegate.checkForCaptures(t1, t2, player, data);
                if (!captured.contains(end) || PlayDelegate.isValidPlay(t1, t2, player, data, testForCheckTurnsAhead) != null) continue;
                available.add(new Tuple<Territory, Territory>(t1, t2));
                if (!endAsSoonAsFindOne) continue;
                return available;
            }
        }
        return available;
    }

    public static Collection<Tuple<Territory, List<Tuple<Territory, Territory>>>> whichOfOurPiecesCanBeCaptured(PlayerID player, GameData data) {
        ArrayList<Tuple<Territory, List<Tuple<Territory, Territory>>>> capturedPieces = new ArrayList<Tuple<Territory, List<Tuple<Territory, Territory>>>>();
        List<Territory> allOur = Match.getMatches(data.getMap().getTerritories(), PlayDelegate.TerritoryHasUnitsOwnedBy(player));
        for (PlayerID enemy : data.getPlayerList().getPlayers()) {
            if (enemy.equals(player)) continue;
            for (Territory t : allOur) {
                List<Tuple<Territory, Territory>> captures = PlayDelegate.getMovesThatCaptureThisTerritory(t, enemy, data, 1, true);
                if (captures.isEmpty()) continue;
                capturedPieces.add(new Tuple<Territory, List<Tuple<Territory, Territory>>>(t, captures));
            }
        }
        return capturedPieces;
    }

    public static boolean testTerritoryForEnemyCaptureUsAfter(Territory start, Territory end, PlayerID player, GameData data, int testForCheckTurnsAhead) {
        Quadruple<Territory, Territory, PlayerID, GameData> temp = PlayDelegate.copyGameDataAndAttemptMove(start, end, player, data);
        Territory newTempEnd = (Territory)temp.getSecond();
        PlayerID newTempPlayer = (PlayerID)temp.getThird();
        GameData newTempData = temp.getForth();
        for (PlayerID enemy : newTempData.getPlayerList().getPlayers()) {
            if (enemy.equals(newTempPlayer) || PlayDelegate.getMovesThatCaptureThisTerritory(newTempEnd, enemy, newTempData, testForCheckTurnsAhead, true).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean testTerritoryForEnemyInCheckAfter(Territory start, Territory end, PlayerID player, GameData data, int testForCheckTurnsAhead) {
        Quadruple<Territory, Territory, PlayerID, GameData> temp = PlayDelegate.copyGameDataAndAttemptMove(start, end, player, data);
        PlayerID newTempPlayer = (PlayerID)temp.getThird();
        GameData newTempData = temp.getForth();
        for (PlayerID enemy : newTempData.getPlayerList().getPlayers()) {
            if (enemy.equals(newTempPlayer) || !PlayDelegate.areWeInCheck(enemy, newTempData, testForCheckTurnsAhead)) continue;
            return true;
        }
        return false;
    }

    public static boolean testTerritoryForUsInCheckAfter(Territory start, Territory end, PlayerID player, GameData data, int testForCheckTurnsAhead) {
        GameData newTempData;
        Quadruple<Territory, Territory, PlayerID, GameData> temp = PlayDelegate.copyGameDataAndAttemptMove(start, end, player, data);
        PlayerID newTempPlayer = (PlayerID)temp.getThird();
        if (EndTurnDelegate.doWeWin(newTempPlayer, newTempData = temp.getForth(), testForCheckTurnsAhead)) {
            return false;
        }
        return PlayDelegate.areWeInCheck(newTempPlayer, newTempData, testForCheckTurnsAhead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Quadruple<Territory, Territory, PlayerID, GameData> copyGameDataAndAttemptMove(Territory start, Territory end, PlayerID player, GameData data) {
        PlayerID newTempPlayer;
        Territory newTempEnd;
        Territory newTempStart;
        GameData newTempData;
        if (start == null || end == null || player == null || data == null) {
            throw new IllegalArgumentException("copyGameDataAndAttemptMove can not accept null arguments");
        }
        data.acquireReadLock();
        try {
            newTempData = GameDataUtils.cloneGameData(data, false);
            newTempStart = (Territory)GameDataUtils.translateIntoOtherGameData(start, newTempData);
            newTempEnd = (Territory)GameDataUtils.translateIntoOtherGameData(end, newTempData);
            newTempPlayer = (PlayerID)GameDataUtils.translateIntoOtherGameData(player, newTempData);
        }
        finally {
            data.releaseReadLock();
        }
        if (newTempData == null || newTempStart == null || newTempEnd == null || newTempPlayer == null) {
            throw new IllegalStateException("Game Data translation did not work");
        }
        ChangePerformer changePerformer = new ChangePerformer(newTempData);
        Collection<Unit> unitsToMove = newTempStart.getUnits().getUnits();
        for (Territory t : PlayDelegate.checkForCaptures(newTempStart, newTempEnd, newTempPlayer, newTempData)) {
            changePerformer.perform(ChangeFactory.removeUnits(t, t.getUnits().getUnits()));
        }
        changePerformer.perform(ChangeFactory.removeUnits(newTempStart, unitsToMove));
        changePerformer.perform(ChangeFactory.addUnits(newTempEnd, unitsToMove));
        return new Quadruple<Territory, Territory, PlayerID, GameData>(newTempStart, newTempEnd, newTempPlayer, newTempData);
    }

    public static Collection<Territory> getKingTerritories(PlayerID player, GameData data) {
        ArrayList<Territory> kingTerritories = new ArrayList<Territory>();
        for (Territory t : data.getMap().getTerritories()) {
            if (!t.getUnits().someMatch(new CompositeMatchAnd<Unit>(PlayDelegate.UnitIsOwnedBy(player), UnitIsKing))) continue;
            kingTerritories.add(t);
        }
        return kingTerritories;
    }

    public static boolean areWeInCheck(PlayerID player, GameData data, int testForCheckTurnsAhead) {
        Collection<Territory> kingTerritories = PlayDelegate.getKingTerritories(player, data);
        if (kingTerritories.isEmpty()) {
            return false;
        }
        for (PlayerID enemy : data.getPlayerList().getPlayers()) {
            if (enemy.equals(player)) continue;
            for (Territory kingT : kingTerritories) {
                if (!PlayDelegate.canSomePieceMoveHere(kingT, enemy, data, testForCheckTurnsAhead)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canSomePieceMoveHere(Territory territory, PlayerID player, GameData data, int testForCheckTurnsAhead) {
        for (Territory t : data.getMap().getTerritories()) {
            if (!t.getUnits().someMatch(PlayDelegate.UnitIsOwnedBy(player)) || PlayDelegate.isValidPlay(t, territory, player, data, testForCheckTurnsAhead) != null) continue;
            return true;
        }
        return false;
    }

    public static String isValidMoveBasic(Territory start, Territory end, PlayerID player, GameData data) {
        if (start == null || end == null) {
            return "Can Not Move Off Board";
        }
        Collection<Unit> units = start.getUnits().getUnits();
        if (units == null || units.isEmpty()) {
            return "No Piece Selected";
        }
        if (start.equals(end)) {
            return "Must Move Piece To New Position";
        }
        Unit unit = units.iterator().next();
        if (!PlayDelegate.UnitIsOwnedBy(player).match(unit)) {
            return "You Do Not Own This Piece";
        }
        if (end.getUnits().someMatch(PlayDelegate.UnitIsOwnedBy(player))) {
            return "A Piece You Own Is In That Position";
        }
        return null;
    }

    public static String isValidPieceMoveBasic(Territory start, Territory end, PlayerID player, GameData data, int testForCheckTurnsAhead) {
        Collection<Unit> units = start.getUnits().getUnits();
        Unit unit = units.iterator().next();
        if (UnitIsPawn.match(unit)) {
            return PlayDelegate.isValidPawnMove(start, end, player, data);
        }
        if (UnitIsKnight.match(unit)) {
            return PlayDelegate.isValidKnightMove(start, end, player, data);
        }
        if (UnitIsBishop.match(unit)) {
            return PlayDelegate.isValidBishopMove(start, end, player, data);
        }
        if (UnitIsRook.match(unit)) {
            return PlayDelegate.isValidRookMove(start, end, player, data);
        }
        if (UnitIsQueen.match(unit)) {
            return PlayDelegate.isValidQueenMove(start, end, player, data);
        }
        if (UnitIsKing.match(unit)) {
            return PlayDelegate.isValidKingMove(start, end, player, data, testForCheckTurnsAhead);
        }
        return "?? Unit";
    }

    public static String isValidPawnMove(Territory start, Territory end, PlayerID player, GameData data) {
        GameMap map = data.getMap();
        boolean startsAtLowRank = PlayerBeginsAtLowestRank.match(player);
        if (startsAtLowRank) {
            if (end.getY() - start.getY() == 1) {
                if (end.getX() == start.getX()) {
                    if (map.getTerritoryFromCoordinates(false, end.getX(), end.getY()).getUnits().getUnitCount() > 0) {
                        return "A Piece Is In The Way";
                    }
                    return null;
                }
                if (Math.abs(end.getX() - start.getX()) == 1) {
                    if (map.getTerritoryFromCoordinates(false, end.getX(), end.getY()).getUnits().getUnitCount() == 0 && PlayDelegate.isValidEnPassant(start, end, player, data) != null) {
                        return "Must Capture A Piece To Move Diagonally";
                    }
                    return null;
                }
            } else if (end.getY() - start.getY() == 2 && end.getX() == start.getX() && start.getUnits().someMatch(UnitHasNeverMovedBefore)) {
                if (map.getTerritoryFromCoordinates(false, end.getX(), end.getY() - 1).getUnits().getUnitCount() > 0) {
                    return "A Piece Is In The Way";
                }
                if (map.getTerritoryFromCoordinates(false, end.getX(), end.getY()).getUnits().getUnitCount() > 0) {
                    return "A Piece Is In The Way";
                }
                return null;
            }
        } else if (start.getY() - end.getY() == 1) {
            if (end.getX() == start.getX()) {
                if (map.getTerritoryFromCoordinates(false, end.getX(), end.getY()).getUnits().getUnitCount() > 0) {
                    return "A Piece Is In The Way";
                }
                return null;
            }
            if (Math.abs(end.getX() - start.getX()) == 1) {
                if (map.getTerritoryFromCoordinates(false, end.getX(), end.getY()).getUnits().getUnitCount() == 0 && PlayDelegate.isValidEnPassant(start, end, player, data) != null) {
                    return "Must Capture A Piece To Move Diagonally";
                }
                return null;
            }
        } else if (start.getY() - end.getY() == 2 && end.getX() == start.getX() && start.getUnits().someMatch(UnitHasNeverMovedBefore)) {
            if (map.getTerritoryFromCoordinates(false, end.getX(), end.getY() + 1).getUnits().getUnitCount() > 0) {
                return "A Piece Is In The Way";
            }
            if (map.getTerritoryFromCoordinates(false, end.getX(), end.getY()).getUnits().getUnitCount() > 0) {
                return "A Piece Is In The Way";
            }
            return null;
        }
        return "Invalid Move";
    }

    public static String isValidEnPassant(Territory start, Territory end, PlayerID player, GameData data) {
        int yLevelOfEnemyPawn;
        boolean startsAtLowRank = PlayerBeginsAtLowestRank.match(player);
        int yLevelOfPawnShouldBe = startsAtLowRank ? data.getMap().getYDimension() - 4 : 3;
        int n = yLevelOfEnemyPawn = startsAtLowRank ? end.getY() - 1 : end.getY() + 1;
        if (yLevelOfEnemyPawn != yLevelOfPawnShouldBe) {
            return "Invalid Move";
        }
        Territory territoryOfEnemyPawn = data.getMap().getTerritoryFromCoordinates(false, end.getX(), yLevelOfEnemyPawn);
        if (!territoryOfEnemyPawn.getUnits().getMatches(new CompositeMatchAnd<Unit>(UnitIsPawn, UnitHasOnlyMovedOnce, PlayDelegate.UnitIsOwnedBy(player).invert())).isEmpty()) {
            ArrayList<Unit> lastMovedPiecesNotByCurrentPlayer = new ArrayList<Unit>();
            for (PlayerID enemy : data.getPlayerList().getPlayers()) {
                if (enemy.equals(player)) continue;
                lastMovedPiecesNotByCurrentPlayer.addAll(PlayerAttachment.get(enemy).getLastPiecesMoved());
            }
            if (lastMovedPiecesNotByCurrentPlayer.containsAll(territoryOfEnemyPawn.getUnits().getMatches(PlayDelegate.UnitIsOwnedBy(player).invert()))) {
                return null;
            }
        }
        return "Invalid Move";
    }

    public static boolean isValidPawnPromotion(Territory start, Territory end, PlayerID player, GameData data) {
        boolean startsAtLowRank = PlayerBeginsAtLowestRank.match(player);
        if (!start.getUnits().someMatch(UnitIsPawn)) {
            return false;
        }
        if (startsAtLowRank && end.getY() == data.getMap().getYDimension() - 1) {
            return true;
        }
        return !startsAtLowRank && end.getY() == 0;
    }

    public static String isValidKnightMove(Territory start, Territory end, PlayerID player, GameData data) {
        if (end.getX() - 2 == start.getX() ? end.getY() - 1 == start.getY() || end.getY() + 1 == start.getY() : (end.getX() + 2 == start.getX() ? end.getY() - 1 == start.getY() || end.getY() + 1 == start.getY() : (end.getX() - 1 == start.getX() ? end.getY() - 2 == start.getY() || end.getY() + 2 == start.getY() : end.getX() + 1 == start.getX() && (end.getY() - 2 == start.getY() || end.getY() + 2 == start.getY())))) {
            return null;
        }
        return "Invalid Move";
    }

    public static String isValidBishopMove(Territory start, Territory end, PlayerID player, GameData data) {
        GameMap map = data.getMap();
        if (Math.abs(end.getX() - start.getX()) == Math.abs(end.getY() - start.getY())) {
            if (end.getX() > start.getX()) {
                if (end.getY() > start.getY()) {
                    int i = 1;
                    while (start.getX() + i < end.getX()) {
                        if (map.getTerritoryFromCoordinates(false, start.getX() + i, start.getY() + i).getUnits().getUnitCount() > 0) {
                            return "A Piece Is In The Way";
                        }
                        ++i;
                    }
                    return null;
                }
                int i = 1;
                while (start.getX() + i < end.getX()) {
                    if (map.getTerritoryFromCoordinates(false, start.getX() + i, start.getY() - i).getUnits().getUnitCount() > 0) {
                        return "A Piece Is In The Way";
                    }
                    ++i;
                }
                return null;
            }
            if (end.getY() > start.getY()) {
                int i = 1;
                while (start.getX() - i > end.getX()) {
                    if (map.getTerritoryFromCoordinates(false, start.getX() - i, start.getY() + i).getUnits().getUnitCount() > 0) {
                        return "A Piece Is In The Way";
                    }
                    ++i;
                }
                return null;
            }
            int i = 1;
            while (start.getX() - i > end.getX()) {
                if (map.getTerritoryFromCoordinates(false, start.getX() - i, start.getY() - i).getUnits().getUnitCount() > 0) {
                    return "A Piece Is In The Way";
                }
                ++i;
            }
            return null;
        }
        return "Invalid Move";
    }

    public static String isValidRookMove(Territory start, Territory end, PlayerID player, GameData data) {
        GameMap map = data.getMap();
        if (Math.abs(end.getX() - start.getX()) > 0 && Math.abs(end.getY() - start.getY()) == 0) {
            if (end.getX() > start.getX()) {
                int i = 1;
                while (start.getX() + i < end.getX()) {
                    if (map.getTerritoryFromCoordinates(false, start.getX() + i, start.getY()).getUnits().getUnitCount() > 0) {
                        return "A Piece Is In The Way";
                    }
                    ++i;
                }
                return null;
            }
            int i = 1;
            while (start.getX() - i > end.getX()) {
                if (map.getTerritoryFromCoordinates(false, start.getX() - i, start.getY()).getUnits().getUnitCount() > 0) {
                    return "A Piece Is In The Way";
                }
                ++i;
            }
            return null;
        }
        if (Math.abs(end.getX() - start.getX()) == 0 && Math.abs(end.getY() - start.getY()) > 0) {
            if (end.getY() > start.getY()) {
                int i = 1;
                while (start.getY() + i < end.getY()) {
                    if (map.getTerritoryFromCoordinates(false, start.getX(), start.getY() + i).getUnits().getUnitCount() > 0) {
                        return "A Piece Is In The Way";
                    }
                    ++i;
                }
                return null;
            }
            int i = 1;
            while (start.getY() - i > end.getY()) {
                if (map.getTerritoryFromCoordinates(false, start.getX(), start.getY() - i).getUnits().getUnitCount() > 0) {
                    return "A Piece Is In The Way";
                }
                ++i;
            }
            return null;
        }
        return "Invalid Move";
    }

    public static String isValidQueenMove(Territory start, Territory end, PlayerID player, GameData data) {
        GameMap map = data.getMap();
        if (Math.abs(end.getX() - start.getX()) == Math.abs(end.getY() - start.getY())) {
            if (end.getX() > start.getX()) {
                if (end.getY() > start.getY()) {
                    int i = 1;
                    while (start.getX() + i < end.getX()) {
                        if (map.getTerritoryFromCoordinates(false, start.getX() + i, start.getY() + i).getUnits().getUnitCount() > 0) {
                            return "A Piece Is In The Way";
                        }
                        ++i;
                    }
                    return null;
                }
                int i = 1;
                while (start.getX() + i < end.getX()) {
                    if (map.getTerritoryFromCoordinates(false, start.getX() + i, start.getY() - i).getUnits().getUnitCount() > 0) {
                        return "A Piece Is In The Way";
                    }
                    ++i;
                }
                return null;
            }
            if (end.getY() > start.getY()) {
                int i = 1;
                while (start.getX() - i > end.getX()) {
                    if (map.getTerritoryFromCoordinates(false, start.getX() - i, start.getY() + i).getUnits().getUnitCount() > 0) {
                        return "A Piece Is In The Way";
                    }
                    ++i;
                }
                return null;
            }
            int i = 1;
            while (start.getX() - i > end.getX()) {
                if (map.getTerritoryFromCoordinates(false, start.getX() - i, start.getY() - i).getUnits().getUnitCount() > 0) {
                    return "A Piece Is In The Way";
                }
                ++i;
            }
            return null;
        }
        if (Math.abs(end.getX() - start.getX()) > 0 && Math.abs(end.getY() - start.getY()) == 0) {
            if (end.getX() > start.getX()) {
                int i = 1;
                while (start.getX() + i < end.getX()) {
                    if (map.getTerritoryFromCoordinates(false, start.getX() + i, start.getY()).getUnits().getUnitCount() > 0) {
                        return "A Piece Is In The Way";
                    }
                    ++i;
                }
                return null;
            }
            int i = 1;
            while (start.getX() - i > end.getX()) {
                if (map.getTerritoryFromCoordinates(false, start.getX() - i, start.getY()).getUnits().getUnitCount() > 0) {
                    return "A Piece Is In The Way";
                }
                ++i;
            }
            return null;
        }
        if (Math.abs(end.getX() - start.getX()) == 0 && Math.abs(end.getY() - start.getY()) > 0) {
            if (end.getY() > start.getY()) {
                int i = 1;
                while (start.getY() + i < end.getY()) {
                    if (map.getTerritoryFromCoordinates(false, start.getX(), start.getY() + i).getUnits().getUnitCount() > 0) {
                        return "A Piece Is In The Way";
                    }
                    ++i;
                }
                return null;
            }
            int i = 1;
            while (start.getY() - i > end.getY()) {
                if (map.getTerritoryFromCoordinates(false, start.getX(), start.getY() - i).getUnits().getUnitCount() > 0) {
                    return "A Piece Is In The Way";
                }
                ++i;
            }
            return null;
        }
        return "Invalid Move";
    }

    public static String isValidKingMove(Territory start, Territory end, PlayerID player, GameData data, int testForCheckTurnsAhead) {
        if (Math.abs(end.getX() - start.getX()) <= 1 && Math.abs(end.getY() - start.getY()) <= 1) {
            return null;
        }
        return PlayDelegate.isValidKingCastling(start, end, player, data, testForCheckTurnsAhead);
    }

    public static String isValidKingCastling(Territory start, Territory end, PlayerID player, GameData data, int testForCheckTurnsAhead) {
        Collection<Unit> units = start.getUnits().getUnits();
        Unit unit = units.iterator().next();
        GameMap map = data.getMap();
        if (start.getY() == end.getY() && UnitHasNeverMovedBefore.match(unit)) {
            int lastRow = map.getYDimension() - 1;
            int lastColumn = map.getXDimension() - 1;
            if ((start.getY() == 0 || start.getY() == lastRow) && Math.abs(start.getX() - end.getX()) == 2) {
                if (PlayDelegate.areWeInCheck(player, data, testForCheckTurnsAhead)) {
                    return "May Not Castle While In Check";
                }
                if (end.getX() > start.getX()) {
                    List<Unit> rook = map.getTerritoryFromCoordinates(lastColumn, start.getY()).getUnits().getMatches(new CompositeMatchAnd<Unit>(UnitIsRook, PlayDelegate.UnitIsOwnedBy(player), UnitHasNeverMovedBefore));
                    if (!rook.isEmpty()) {
                        int i = start.getX() + 1;
                        while (i < lastColumn) {
                            if (map.getTerritoryFromCoordinates(false, i++, start.getY()).getUnits().getUnitCount() <= 0) continue;
                            return "Can Not Castle King With Pieces In The Way";
                        }
                        Territory moveThroughTerritoryForKing = map.getTerritoryFromCoordinates(false, end.getX() - 1, start.getY());
                        if (PlayDelegate.testTerritoryForUsInCheckAfter(start, moveThroughTerritoryForKing, player, data, testForCheckTurnsAhead)) {
                            return "Illegal To Move Through Check To Castle";
                        }
                        return null;
                    }
                } else {
                    List<Unit> rook = map.getTerritoryFromCoordinates(0, start.getY()).getUnits().getMatches(new CompositeMatchAnd<Unit>(UnitIsRook, PlayDelegate.UnitIsOwnedBy(player), UnitHasNeverMovedBefore));
                    if (!rook.isEmpty()) {
                        int i = 1;
                        while (i < start.getX()) {
                            if (map.getTerritoryFromCoordinates(false, i++, start.getY()).getUnits().getUnitCount() <= 0) continue;
                            return "Can Not Castle King With Pieces In The Way";
                        }
                        Territory moveThroughTerritoryForKing = map.getTerritoryFromCoordinates(false, end.getX() + 1, start.getY());
                        if (PlayDelegate.testTerritoryForUsInCheckAfter(start, moveThroughTerritoryForKing, player, data, testForCheckTurnsAhead)) {
                            return "Illegal To Move Through Check To Castle";
                        }
                        return null;
                    }
                }
            }
        }
        return "Invalid Move";
    }
}

