/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.chess.player;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.framework.GameDataUtils;
import games.strategy.grid.chess.delegate.EndTurnDelegate;
import games.strategy.grid.chess.delegate.PlayDelegate;
import games.strategy.grid.delegate.remote.IGridPlayDelegate;
import games.strategy.grid.player.GridAbstractAI;
import games.strategy.grid.ui.GridPlayData;
import games.strategy.util.Quadruple;
import games.strategy.util.Triple;
import games.strategy.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

public class HeuristicAI
extends GridAbstractAI {
    public HeuristicAI(String name, String type) {
        super(name, type);
    }

    @Override
    protected void play() {
        this.pause();
        PlayerID me = this.getPlayerID();
        GameData data = this.getGameData();
        List<Triple<Territory, Territory, Collection<Territory>>> availableMoves = HeuristicAI.getAllAvailableMoves(me, data, true);
        if (availableMoves.isEmpty()) {
            System.err.println("No available moves for " + me.getName());
            return;
        }
        IGridPlayDelegate playDel = (IGridPlayDelegate)this.getPlayerBridge().getRemoteDelegate();
        List<PlayerID> enemies = data.getPlayerList().getPlayers();
        enemies.remove(me);
        PlayerID enemy = (PlayerID)enemies.iterator().next();
        ArrayList<Triple<Territory, Territory, Integer>> movesWithPoints = new ArrayList<Triple<Territory, Territory, Integer>>();
        for (Triple<Territory, Territory, Collection<Territory>> move1 : availableMoves) {
            Triple<Territory, Territory, Integer> move = HeuristicAI.getMoveWithPoints((Territory)move1.getFirst(), (Territory)move1.getSecond(), move1.getThird(), me, enemy, data, true);
            if (move == null) {
                HeuristicAI.doMove((Territory)move1.getFirst(), (Territory)move1.getSecond(), data, playDel, me);
                return;
            }
            movesWithPoints.add(move);
        }
        Collections.sort(movesWithPoints, HeuristicAI.getBestPointsComparatorInt());
        Triple ourMove = (Triple)movesWithPoints.iterator().next();
        HeuristicAI.doMove((Territory)ourMove.getFirst(), (Territory)ourMove.getSecond(), data, playDel, me);
    }

    static Triple<Territory, Territory, Integer> getMoveWithPoints(Territory start, Territory end, Collection<Territory> captures, PlayerID me, PlayerID enemy, GameData data, boolean returnEarlyIfWin) {
        Quadruple<Territory, Territory, PlayerID, GameData> temp = PlayDelegate.copyGameDataAndAttemptMove(start, end, me, data);
        PlayerID enemyTemp = (PlayerID)GameDataUtils.translateIntoOtherGameData(enemy, temp.getForth());
        int points = HeuristicAI.getPointsForBoardSituation((PlayerID)temp.getThird(), enemyTemp, captures, temp.getForth(), true);
        if (returnEarlyIfWin && points >= 1000000000) {
            return null;
        }
        return new Triple<Territory, Territory, Integer>(start, end, points);
    }

    static int getPointsForBoardSituation(PlayerID me, PlayerID enemy, Collection<Territory> captures, GameData data, boolean returnEarlyIfWin) {
        boolean enemyInCheck;
        int points = 0;
        if (EndTurnDelegate.doWeWin(me, data, 1)) {
            if (returnEarlyIfWin) {
                return 1000000000;
            }
            points += 1000000000;
        }
        points += (enemyInCheck = PlayDelegate.areWeInCheck(enemy, data, 1)) ? 5 : 0;
        Collection<Tuple<Territory, List<Tuple<Territory, Territory>>>> capturedPieces = PlayDelegate.whichOfOurPiecesCanBeCaptured(me, data);
        for (Tuple<Territory, List<Tuple<Territory, Territory>>> tuple : capturedPieces) {
            points -= HeuristicAI.getPointsForUnits(tuple.getFirst().getUnits().getUnits());
        }
        for (Territory territory : captures) {
            points += HeuristicAI.getPointsForUnits(territory.getUnits().getUnits());
        }
        return points;
    }

    static List<Triple<Territory, Territory, Collection<Territory>>> getAllAvailableMoves(PlayerID player, GameData data, boolean shuffle) {
        ArrayList<Territory> allTerritories1 = new ArrayList<Territory>(data.getMap().getTerritories());
        ArrayList<Territory> allTerritories2 = new ArrayList<Territory>(allTerritories1);
        if (shuffle) {
            Collections.shuffle(allTerritories1);
            Collections.shuffle(allTerritories2);
        }
        ArrayList<Triple<Territory, Territory, Collection<Territory>>> availableMoves = new ArrayList<Triple<Territory, Territory, Collection<Territory>>>();
        for (Territory t1 : allTerritories1) {
            for (Territory t2 : allTerritories2) {
                if (PlayDelegate.isValidPlay(t1, t2, player, data, 2) != null) continue;
                Collection<Territory> captures = PlayDelegate.checkForCaptures(t1, t2, player, data);
                availableMoves.add(new Triple<Territory, Territory, Collection<Territory>>(t1, t2, captures));
            }
        }
        return availableMoves;
    }

    static Comparator<Triple<Territory, Territory, Integer>> getBestPointsComparatorInt() {
        return new Comparator<Triple<Territory, Territory, Integer>>(){

            @Override
            public int compare(Triple<Territory, Territory, Integer> t1, Triple<Territory, Territory, Integer> t2) {
                if (t1 == null && t2 == null || t1 == t2) {
                    return 0;
                }
                if (t1 == null && t2 != null) {
                    return 1;
                }
                if (t1 != null && t2 == null) {
                    return -1;
                }
                if (t1.equals(t2)) {
                    return 0;
                }
                if (t1.getThird().intValue() == t2.getThird().intValue()) {
                    return 0;
                }
                if (t1.getThird() > t2.getThird()) {
                    return -1;
                }
                return 1;
            }
        };
    }

    static int getPointsForUnits(Collection<Unit> capturedUnits) {
        int points = 0;
        for (Unit u : capturedUnits) {
            if (PlayDelegate.UnitIsPawn.match(u)) {
                points += 22;
                continue;
            }
            if (PlayDelegate.UnitIsRook.match(u)) {
                points += 41;
                continue;
            }
            if (PlayDelegate.UnitIsBishop.match(u)) {
                points += 42;
                continue;
            }
            if (PlayDelegate.UnitIsKnight.match(u)) {
                points += 43;
                continue;
            }
            if (PlayDelegate.UnitIsQueen.match(u)) {
                points += 80;
                continue;
            }
            if (!PlayDelegate.UnitIsKing.match(u)) continue;
            points += 150;
        }
        return points;
    }

    static Comparator<Triple<Territory, Territory, Collection<Territory>>> getBestCaptureComparator(PlayerID player, GameData data) {
        return new Comparator<Triple<Territory, Territory, Collection<Territory>>>(){

            @Override
            public int compare(Triple<Territory, Territory, Collection<Territory>> t1, Triple<Territory, Territory, Collection<Territory>> t2) {
                int points2;
                if (t1 == null && t2 == null || t1 == t2) {
                    return 0;
                }
                if (t1 == null && t2 != null) {
                    return 1;
                }
                if (t1 != null && t2 == null) {
                    return -1;
                }
                if (t1.equals(t2)) {
                    return 0;
                }
                HashSet<Unit> units1 = new HashSet<Unit>();
                for (Territory t : t1.getThird()) {
                    units1.addAll(t.getUnits().getUnits());
                }
                HashSet<Unit> units2 = new HashSet<Unit>();
                for (Territory t : t2.getThird()) {
                    units2.addAll(t.getUnits().getUnits());
                }
                int points1 = HeuristicAI.getPointsForUnits(units1);
                if (points1 == (points2 = HeuristicAI.getPointsForUnits(units2))) {
                    return 0;
                }
                if (points1 > points2) {
                    return -1;
                }
                return 1;
            }
        };
    }

    static final void doMove(Territory start, Territory end, GameData data, IGridPlayDelegate playDel, PlayerID me) {
        GridPlayData play = new GridPlayData(start, end, me);
        String error = playDel.play(play);
        if (error != null) {
            System.err.println("Attempted Move Did Not Work: start: " + start.getName() + " end: " + end.getName());
            HeuristicAI.doRandomMove(data, playDel, me);
        }
    }

    static void doRandomMove(GameData data, IGridPlayDelegate playDel, PlayerID me) {
        int trymeEnd;
        int trymeStart;
        GridPlayData play;
        String error;
        List<Territory> territories = data.getMap().getTerritories();
        Territory[] territoryArray = territories.toArray(new Territory[territories.size()]);
        Random generator = new Random();
        while ((error = playDel.play(play = new GridPlayData(territoryArray[trymeStart = generator.nextInt(territoryArray.length)], territoryArray[trymeEnd = generator.nextInt(territoryArray.length)], me))) != null) {
        }
    }
}

