/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.delegate;

import games.strategy.common.delegate.AbstractDelegate;
import games.strategy.engine.message.IRemote;
import games.strategy.engine.pbem.PBEMMessagePoster;
import games.strategy.grid.delegate.AbstractPlayByEmailOrForumExtendedDelegateState;
import games.strategy.triplea.delegate.remote.IAbstractForumPosterDelegate;
import java.io.Serializable;

public abstract class AbstractPlayByEmailOrForumDelegate
extends AbstractDelegate
implements IAbstractForumPosterDelegate {
    private boolean m_needToInitialize = true;
    private boolean m_hasPostedTurnSummary = false;

    @Override
    public void start() {
        super.start();
        if (!this.m_needToInitialize) {
            return;
        }
        this.m_hasPostedTurnSummary = false;
        this.m_needToInitialize = false;
    }

    @Override
    public void end() {
        super.end();
        this.m_needToInitialize = true;
    }

    @Override
    public Serializable saveState() {
        AbstractPlayByEmailOrForumExtendedDelegateState state = new AbstractPlayByEmailOrForumExtendedDelegateState();
        state.superState = super.saveState();
        state.m_needToInitialize = this.m_needToInitialize;
        state.m_hasPostedTurnSummary = this.m_hasPostedTurnSummary;
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        AbstractPlayByEmailOrForumExtendedDelegateState s = (AbstractPlayByEmailOrForumExtendedDelegateState)state;
        super.loadState(s.superState);
        this.m_needToInitialize = s.m_needToInitialize;
        this.m_hasPostedTurnSummary = s.m_hasPostedTurnSummary;
    }

    @Override
    public boolean delegateCurrentlyRequiresUserInput() {
        return PBEMMessagePoster.GameDataHasPlayByEmailOrForumMessengers(this.getData());
    }

    @Override
    public void setHasPostedTurnSummary(boolean hasPostedTurnSummary) {
        this.m_hasPostedTurnSummary = hasPostedTurnSummary;
    }

    @Override
    public boolean getHasPostedTurnSummary() {
        return this.m_hasPostedTurnSummary;
    }

    @Override
    public boolean postTurnSummary(PBEMMessagePoster poster, String title, boolean includeSaveGame) {
        this.m_hasPostedTurnSummary = poster.post(this.m_bridge.getHistoryWriter(), title, includeSaveGame);
        return this.m_hasPostedTurnSummary;
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return IAbstractForumPosterDelegate.class;
    }
}

