/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.delegate;

import games.strategy.common.delegate.BaseEditDelegate;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.message.IRemote;
import games.strategy.grid.delegate.remote.IGridEditDelegate;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.util.Match;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class EditDelegate
extends BaseEditDelegate
implements IGridEditDelegate {
    @Override
    public String removeUnits(Territory territory, Collection<Unit> units) {
        String result = null;
        result = this.checkEditMode();
        if (null != result) {
            return result;
        }
        result = EditDelegate.validateRemoveUnits(this.getData(), territory, units);
        if (null != result) {
            return result;
        }
        if (units == null || units.isEmpty()) {
            return null;
        }
        HashSet<PlayerID> owners = new HashSet<PlayerID>();
        for (Unit u : units) {
            owners.add(u.getOwner());
        }
        for (PlayerID p : owners) {
            List<Unit> unitsOwned = Match.getMatches(units, Matches.unitIsOwnedBy(p));
            this.logEvent("Removing units owned by " + p.getName() + " from " + territory.getName() + ": " + MyFormatter.unitsToTextNoOwner(unitsOwned), unitsOwned);
            this.m_bridge.addChange(ChangeFactory.removeUnits(territory, unitsOwned));
        }
        return null;
    }

    public static String validateRemoveUnits(GameData data, Territory territory, Collection<Unit> units) {
        String result = null;
        if (units.isEmpty()) {
            return "No units selected";
        }
        return result;
    }

    @Override
    public String addUnits(Territory territory, Collection<Unit> units) {
        String result = null;
        result = this.checkEditMode();
        if (null != result) {
            return result;
        }
        result = EditDelegate.validateAddUnits(this.getData(), territory, units);
        if (null != result) {
            return result;
        }
        if (units == null || units.isEmpty()) {
            return null;
        }
        this.logEvent("Adding units owned by " + units.iterator().next().getOwner().getName() + " to " + territory.getName() + ": " + MyFormatter.unitsToTextNoOwner(units), units);
        this.m_bridge.addChange(ChangeFactory.addUnits(territory, units));
        return null;
    }

    public static String validateAddUnits(GameData data, Territory territory, Collection<Unit> units) {
        String result = null;
        if (units.isEmpty()) {
            return "No units selected";
        }
        if (territory.getUnits().getUnitCount() > 0) {
            return "Territory already contains units";
        }
        return result;
    }

    @Override
    public String changeTerritoryOwner(Territory territory, PlayerID player) {
        String result = null;
        result = this.checkEditMode();
        if (null != result) {
            return result;
        }
        result = EditDelegate.validateChangeTerritoryOwner(this.getData(), territory, player);
        if (null != result) {
            return result;
        }
        if (territory == null) {
            return null;
        }
        this.logEvent("Changing ownership of " + territory.getName() + " from " + territory.getOwner().getName() + " to " + player.getName(), territory);
        this.m_bridge.addChange(ChangeFactory.changeOwner(territory, player));
        return null;
    }

    public static String validateChangeTerritoryOwner(GameData data, Territory territory, PlayerID player) {
        String result = null;
        TerritoryAttachment ta = TerritoryAttachment.get(territory, true);
        if (ta == null) {
            return "Territory has no attachment";
        }
        return result;
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return IGridEditDelegate.class;
    }
}

