/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.go;

import games.strategy.engine.data.GameData;
import games.strategy.engine.framework.IGameLoader;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.grid.GridGame;
import games.strategy.grid.go.delegate.EndTurnDelegate;
import games.strategy.grid.go.delegate.PlayDelegate;
import games.strategy.grid.go.player.GoPlayer;
import games.strategy.grid.go.player.RandomAI;
import games.strategy.grid.go.ui.GoMapPanel;
import games.strategy.grid.go.ui.GoMenu;
import games.strategy.grid.ui.GridGameFrame;
import games.strategy.grid.ui.GridGameMenu;
import games.strategy.grid.ui.GridMapData;
import games.strategy.grid.ui.GridMapPanel;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Go
extends GridGame
implements IGameLoader {
    private static final long serialVersionUID = 2560802787325950593L;
    private static final String HUMAN_PLAYER_TYPE = "Human";
    private static final String RANDOM_COMPUTER_PLAYER_TYPE = "Random AI";

    @Override
    public String[] getServerPlayerTypes() {
        return new String[]{HUMAN_PLAYER_TYPE, RANDOM_COMPUTER_PLAYER_TYPE};
    }

    @Override
    public Set<IGamePlayer> createPlayers(Map<String, String> playerNames) {
        HashSet<IGamePlayer> iplayers = new HashSet<IGamePlayer>();
        for (String name : playerNames.keySet()) {
            String type = playerNames.get(name);
            if (type.equals(HUMAN_PLAYER_TYPE) || type.equals("Client")) {
                GoPlayer player = new GoPlayer(name, type);
                iplayers.add(player);
                continue;
            }
            if (type.equals(RANDOM_COMPUTER_PLAYER_TYPE)) {
                RandomAI ai = new RandomAI(name, type);
                iplayers.add(ai);
                continue;
            }
            throw new IllegalStateException("Player type not recognized:" + type);
        }
        return iplayers;
    }

    @Override
    protected Class<? extends GridMapPanel> getGridMapPanelClass() {
        return GoMapPanel.class;
    }

    @Override
    protected Class<? extends GridMapData> getGridMapDataClass() {
        return GridMapData.class;
    }

    @Override
    protected Class<? extends GridGameMenu<GridGameFrame>> getGridTableMenuClass() {
        return GoMenu.class;
    }

    @Override
    public int getSquareWidth() {
        return 30;
    }

    @Override
    public int getSquareHeight() {
        return 30;
    }

    @Override
    public int getBevelSize() {
        return 10;
    }

    public static final PlayDelegate playDelegate(GameData data) {
        return (PlayDelegate)Go.findDelegate(data, "play");
    }

    public static final EndTurnDelegate endTurnDelegate(GameData data) {
        return (EndTurnDelegate)Go.findDelegate(data, "endTurn");
    }
}

