/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.go.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.message.IRemote;
import games.strategy.grid.delegate.AbstractPlayByEmailOrForumDelegate;
import games.strategy.grid.go.Go;
import games.strategy.grid.go.delegate.GoEndTurnExtendedDelegateState;
import games.strategy.grid.go.delegate.PlayDelegate;
import games.strategy.grid.go.delegate.remote.IGoEndTurnDelegate;
import games.strategy.grid.ui.GridEndTurnData;
import games.strategy.grid.ui.IGridEndTurnData;
import games.strategy.grid.ui.display.IGridGameDisplay;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EndTurnDelegate
extends AbstractPlayByEmailOrForumDelegate
implements IGoEndTurnDelegate {
    protected Tuple<PlayerID, IGridEndTurnData> m_groupsThatShouldDie = null;
    protected boolean m_canScore = false;

    @Override
    public void start() {
        super.start();
        if (this.haveTwoPassedInARow()) {
            IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
            display.setStatus("End Game: " + this.m_player.getName() + " must click all dead groups. Pless 'C' to confirm, or 'R' to reject and continue playing.");
            display.refreshTerritories(this.getData().getMap().getTerritories());
            if (this.m_groupsThatShouldDie != null && this.m_groupsThatShouldDie.getSecond() != null) {
                display.showGridEndTurnData(this.m_groupsThatShouldDie.getSecond());
            }
        }
    }

    @Override
    public void end() {
        super.end();
        if (this.m_canScore && this.haveTwoPassedInARow()) {
            Tuple<Tuple<PlayerID, Integer>, Tuple<PlayerID, Integer>> scores = EndTurnDelegate.getFinalScores(this.m_groupsThatShouldDie == null ? new HashSet() : this.m_groupsThatShouldDie.getSecond().getTerritoryUnitsRemovalAdjustment(), this.getData());
            PlayerID p1 = scores.getFirst().getFirst();
            int score1 = scores.getFirst().getSecond();
            PlayerID p2 = scores.getSecond().getFirst();
            int score2 = scores.getSecond().getSecond();
            if (score1 > score2) {
                this.signalGameOver(p1.getName() + " wins with " + score1 + " against " + p2.getName() + " with " + score2 + ".5");
            } else {
                this.signalGameOver(p2.getName() + " wins with " + score2 + ".5 against " + p1.getName() + " with " + score1);
            }
            IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
            display.showGridEndTurnData(this.m_groupsThatShouldDie.getSecond());
        }
    }

    public static Tuple<Tuple<PlayerID, Integer>, Tuple<PlayerID, Integer>> getFinalScores(Collection<Territory> deadGroups, GameData data) {
        Map<Territory, PlayerID> currentState = EndTurnDelegate.getCurrentAreaScoreState(deadGroups, data);
        IntegerMap<PlayerID> score = new IntegerMap<PlayerID>();
        for (Map.Entry<Territory, PlayerID> entry : currentState.entrySet()) {
            score.add(entry.getValue(), 1);
        }
        List<PlayerID> players = data.getPlayerList().getPlayers();
        Iterator iter = players.iterator();
        PlayerID p1 = (PlayerID)iter.next();
        PlayerID p2 = (PlayerID)iter.next();
        int score1 = score.getInt(p1);
        int score2 = score.getInt(p2) + data.getProperties().get("White Bonus Komi", 0);
        boolean countCaptures = data.getProperties().get("Captured Pieces Count Towards Score", false);
        if (countCaptures) {
            Set<Unit> capturedAll = EndTurnDelegate.getCapturedUnits(data);
            score1 += Match.countMatches(capturedAll, PlayDelegate.UnitIsOwnedBy(p2));
            score2 += Match.countMatches(capturedAll, PlayDelegate.UnitIsOwnedBy(p1));
        }
        return new Tuple<Tuple<PlayerID, Integer>, Tuple<PlayerID, Integer>>(new Tuple<PlayerID, Integer>(p1, score1), new Tuple<PlayerID, Integer>(p2, score2));
    }

    @Override
    public Serializable saveState() {
        GoEndTurnExtendedDelegateState state = new GoEndTurnExtendedDelegateState();
        state.superState = super.saveState();
        state.m_groupsThatShouldDie = this.m_groupsThatShouldDie;
        state.m_canScore = this.m_canScore;
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        GoEndTurnExtendedDelegateState s = (GoEndTurnExtendedDelegateState)state;
        super.loadState(s.superState);
        this.m_groupsThatShouldDie = s.m_groupsThatShouldDie;
        this.m_canScore = s.m_canScore;
    }

    @Override
    public boolean delegateCurrentlyRequiresUserInput() {
        return this.haveTwoPassedInARow() || super.delegateCurrentlyRequiresUserInput();
    }

    public static Map<Territory, PlayerID> getCurrentAreaScoreState(Collection<Territory> deadGroups, GameData data) {
        boolean onlySurroundedTerritoryNotAllArea = data.getProperties().get("Territory Not Area Counts Towards Score", false);
        HashMap<Territory, PlayerID> currentAreaScoreState = new HashMap<Territory, PlayerID>();
        for (Territory t : data.getMap().getTerritories()) {
            HashSet<PlayerID> towners = new HashSet<PlayerID>();
            EndTurnDelegate.getAllNeighboringPlayers(t, towners, new HashSet<Territory>(), deadGroups, data);
            if (towners.size() != 1 || onlySurroundedTerritoryNotAllArea && t.getUnits().getUnitCount() > 0) continue;
            currentAreaScoreState.put(t, (PlayerID)towners.iterator().next());
        }
        return currentAreaScoreState;
    }

    public static Set<PlayerID> getAllNeighboringPlayers(Territory start, Set<PlayerID> playersSoFar, Set<Territory> checkedAlready, Collection<Territory> deadGroups, GameData data) {
        if (playersSoFar.size() >= 2) {
            return playersSoFar;
        }
        checkedAlready.add(start);
        Collection<Unit> units = start.getUnits().getUnits();
        if (!(units.isEmpty() || deadGroups != null && deadGroups.contains(start))) {
            for (Unit u : units) {
                playersSoFar.add(u.getOwner());
            }
        } else {
            HashSet<Territory> neighbors = new HashSet<Territory>(data.getMap().getNeighbors(start));
            neighbors.removeAll(checkedAlready);
            for (Territory t : neighbors) {
                EndTurnDelegate.getAllNeighboringPlayers(t, playersSoFar, checkedAlready, deadGroups, data);
            }
        }
        return playersSoFar;
    }

    private void signalGameOver(String status) {
        this.m_bridge.getHistoryWriter().startEvent(status);
        IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.setStatus(status);
        display.setGameOver();
        this.m_bridge.stopGameSequence();
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return IGoEndTurnDelegate.class;
    }

    @Override
    public void signalStatus(String status) {
        IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.setStatus(status);
    }

    @Override
    public IGridEndTurnData getTerritoryAdjustment() {
        return this.m_groupsThatShouldDie == null ? null : this.m_groupsThatShouldDie.getSecond();
    }

    @Override
    public boolean haveTwoPassedInARow() {
        PlayDelegate localPlayDel = Go.playDelegate(this.getData());
        if (localPlayDel != null) {
            return localPlayDel.haveTwoPassedInARow();
        }
        return false;
    }

    static Set<Unit> getCapturedUnits(GameData data) {
        PlayDelegate localPlayDel = Go.playDelegate(data);
        if (localPlayDel != null) {
            return localPlayDel.getCapturedUnits();
        }
        return null;
    }

    @Override
    public String territoryAdjustment(IGridEndTurnData groupsThatShouldDie) {
        String text;
        if (!this.haveTwoPassedInARow()) {
            return null;
        }
        if (groupsThatShouldDie == null) {
            return "Can Not Have Null For End Turn Data";
        }
        if (!groupsThatShouldDie.getWantToContinuePlaying()) {
            Tuple<PlayerID, IGridEndTurnData> oldGroupsFromLastPlayer = this.m_groupsThatShouldDie;
            if (oldGroupsFromLastPlayer == null) {
                text = groupsThatShouldDie.toString();
            } else {
                if (this.m_player.equals(oldGroupsFromLastPlayer.getFirst())) {
                    Object text2 = null;
                    return null;
                }
                if (!oldGroupsFromLastPlayer.getSecond().getTerritoryUnitsRemovalAdjustment().equals(groupsThatShouldDie.getTerritoryUnitsRemovalAdjustment())) {
                    text = groupsThatShouldDie.toString();
                } else {
                    this.m_canScore = true;
                    text = this.m_player.getName() + " agrees to the adjustments, game will now be scored.";
                }
            }
            this.m_groupsThatShouldDie = new Tuple<PlayerID, GridEndTurnData>(this.m_player, new GridEndTurnData(groupsThatShouldDie));
        } else {
            this.m_groupsThatShouldDie = null;
            Go.playDelegate(this.getData()).setPassesInARow(0);
            text = this.m_player.getName() + " decides to play it out.";
        }
        if (text != null) {
            this.m_bridge.getHistoryWriter().startEvent(text);
        }
        IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.showGridEndTurnData(groupsThatShouldDie);
        return null;
    }
}

