/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.go.delegate;

import games.strategy.common.delegate.AbstractDelegate;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.delegate.AutoSave;
import games.strategy.engine.message.IRemote;
import games.strategy.grid.go.Go;
import games.strategy.grid.go.delegate.GoPlayExtendedDelegateState;
import games.strategy.grid.go.delegate.remote.IGoPlayDelegate;
import games.strategy.grid.ui.GridPlayData;
import games.strategy.grid.ui.IGridPlayData;
import games.strategy.grid.ui.display.IGridGameDisplay;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.util.Match;
import games.strategy.util.Triple;
import games.strategy.util.Tuple;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@AutoSave(beforeStepStart=false, afterStepEnd=true)
public class PlayDelegate
extends AbstractDelegate
implements IGoPlayDelegate {
    protected List<Map<Territory, PlayerID>> m_previousMapStates = new ArrayList<Map<Territory, PlayerID>>();
    protected int m_passesInARow = 0;
    protected PlayerID m_firstPlayerToPass = null;
    protected int m_blackHandicap = -1;
    protected Set<Unit> m_capturedUnits = new HashSet<Unit>();
    public static Match<Territory> TerritoryHasNoUnits = new Match<Territory>(){

        @Override
        public boolean match(Territory t) {
            return t.getUnits().getUnitCount() <= 0;
        }
    };

    @Override
    public void start() {
        super.start();
        if (this.m_blackHandicap < 0) {
            this.m_blackHandicap = this.getData().getProperties().get("Black Player Handicap", 0);
        }
        if (this.delegateCurrentlyRequiresUserInput()) {
            IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
            display.setStatus(this.m_player.getName() + "'s turn. (Click to place stone, or 'P' to pass.)");
        }
    }

    @Override
    public void end() {
        super.end();
        if (this.m_blackHandicap > 0 && !this.m_player.getName().equalsIgnoreCase("Black")) {
            --this.m_blackHandicap;
        }
    }

    @Override
    public Serializable saveState() {
        GoPlayExtendedDelegateState state = new GoPlayExtendedDelegateState();
        state.superState = super.saveState();
        state.m_previousMapStates = this.m_previousMapStates;
        state.m_passesInARow = this.m_passesInARow;
        state.m_firstPlayerToPass = this.m_firstPlayerToPass;
        state.m_blackHandicap = this.m_blackHandicap;
        state.m_capturedUnits = this.m_capturedUnits;
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        GoPlayExtendedDelegateState s = (GoPlayExtendedDelegateState)state;
        super.loadState(s.superState);
        this.m_previousMapStates = s.m_previousMapStates;
        this.m_passesInARow = s.m_passesInARow;
        this.m_firstPlayerToPass = s.m_firstPlayerToPass;
        this.m_blackHandicap = s.m_blackHandicap;
        this.m_capturedUnits = s.m_capturedUnits;
    }

    @Override
    public boolean delegateCurrentlyRequiresUserInput() {
        return !(this.haveTwoPassedInARow() || this.m_firstPlayerToPass != null && this.m_passesInARow != 1 && !this.m_firstPlayerToPass.equals(this.m_player) || !this.m_player.getName().equalsIgnoreCase("Black") && this.m_blackHandicap > 0);
    }

    @Override
    public void signalStatus(String status) {
        IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.setStatus(status);
    }

    @Override
    public String play(IGridPlayData play) {
        if (!this.delegateCurrentlyRequiresUserInput()) {
            return null;
        }
        for (Territory t : play.getAllSteps()) {
            if (t.getUnits().getUnitCount() <= 1) continue;
            throw new IllegalStateException("Can not have more than 1 unit in any territory");
        }
        String error = PlayDelegate.isValidPlay(play, this.m_player, this.getData());
        if (error != null) {
            return error;
        }
        Collection<Territory> captured = PlayDelegate.checkForCaptures(play, this.m_player, this.getData());
        this.performPlay(play, captured, this.m_player);
        for (Territory t : play.getAllSteps()) {
            if (t.getUnits().getUnitCount() <= 1) continue;
            throw new IllegalStateException("Can not have more than 1 unit in any territory");
        }
        return null;
    }

    public static String isValidPlay(IGridPlayData play, PlayerID player, GameData data) {
        if (play.isPass()) {
            return null;
        }
        String basic = PlayDelegate.isValidMoveBasic(play, player, data);
        if (basic != null) {
            return basic;
        }
        String pieceBasic = PlayDelegate.isValidPieceMoveBasic(play, player, data);
        if (pieceBasic != null) {
            return pieceBasic;
        }
        String superko = PlayDelegate.isValidNonSuperPositionalKo(play, player, data);
        if (superko != null) {
            return superko;
        }
        return null;
    }

    public static Triple<List<Territory>, List<Tuple<Territory, Collection<Territory>>>, List<Territory>> getAllValidMovesCaptureMovesAndInvalidMoves(PlayerID player, GameData data) {
        ArrayList<Territory> validMovesWithoutCapture = new ArrayList<Territory>();
        ArrayList<Tuple<Territory, Collection<Territory>>> validCaptureMoves = new ArrayList<Tuple<Territory, Collection<Territory>>>();
        ArrayList<Territory> invalidMoves = new ArrayList<Territory>();
        for (Territory t : data.getMap().getTerritories()) {
            GridPlayData play = new GridPlayData(t, player);
            if (PlayDelegate.isValidPlay(play, player, data) == null) {
                Collection<Territory> captures = PlayDelegate.checkForCaptures(play, player, data);
                if (captures.isEmpty()) {
                    validMovesWithoutCapture.add(t);
                    continue;
                }
                validCaptureMoves.add(new Tuple<Territory, Collection<Territory>>(t, captures));
                continue;
            }
            invalidMoves.add(t);
        }
        return new Triple<List<Territory>, List<Tuple<Territory, Collection<Territory>>>, List<Territory>>(validMovesWithoutCapture, validCaptureMoves, invalidMoves);
    }

    public static Collection<Territory> checkForCaptures(IGridPlayData play, PlayerID player, GameData data) {
        HashSet<Territory> captured = new HashSet<Territory>();
        if (play.isPass()) {
            return captured;
        }
        Territory start = play.getStart();
        List<Set<Territory>> enemyChains = PlayDelegate.getEnemyStoneChainsConnectedToThisTerritory(start, player, data);
        for (Set<Territory> echain : enemyChains) {
            PlayerID enemy;
            if (!PlayDelegate.areAllLibertiesTakenByEnemy(play, echain, enemy = echain.iterator().next().getUnits().iterator().next().getOwner(), data)) continue;
            captured.addAll(echain);
        }
        return captured;
    }

    private void performPlay(IGridPlayData play, Collection<Territory> captured, PlayerID player) {
        if (play.isPass()) {
            this.m_bridge.getHistoryWriter().startEvent(play.toString());
            if (this.m_passesInARow == 0 && this.m_firstPlayerToPass == null) {
                this.m_firstPlayerToPass = player;
            }
            ++this.m_passesInARow;
            IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
            display.showGridPlayDataMove(play);
            return;
        }
        ArrayList<Unit> units = new ArrayList<Unit>();
        units.add(this.getData().getUnitTypeList().getUnitType("stone").create(player));
        this.m_bridge.getHistoryWriter().startEvent(play.toString(), units);
        CompositeChange change = new CompositeChange();
        Change addUnit = ChangeFactory.addUnits(play.getStart(), units);
        change.add(addUnit);
        HashSet<Unit> capturedUnitsTotal = new HashSet<Unit>();
        for (Territory at : captured) {
            Collection<Unit> capturedUnits;
            if (at == null || (capturedUnits = at.getUnits().getUnits()).isEmpty()) continue;
            Change capture = ChangeFactory.removeUnits(at, capturedUnits);
            change.add(capture);
            capturedUnitsTotal.addAll(capturedUnits);
        }
        if (!capturedUnitsTotal.isEmpty()) {
            this.m_bridge.getHistoryWriter().addChildToEvent(player.getName() + " captures units: " + MyFormatter.unitsToText(capturedUnitsTotal), capturedUnitsTotal);
        }
        this.m_capturedUnits.addAll(capturedUnitsTotal);
        HashSet<Territory> refresh = new HashSet<Territory>(play.getAllSteps());
        refresh.addAll(captured);
        this.m_bridge.addChange(change);
        IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.refreshTerritories(refresh);
        display.showGridPlayDataMove(play);
        this.m_previousMapStates.add(PlayDelegate.getCurrentMapState(this.getData()));
        while (this.m_previousMapStates.size() > 10) {
            this.m_previousMapStates.remove(0);
        }
        this.m_passesInARow = 0;
        this.m_firstPlayerToPass = null;
    }

    public static Map<Territory, PlayerID> getCurrentMapState(GameData data) {
        HashMap<Territory, PlayerID> state = new HashMap<Territory, PlayerID>();
        for (Territory t : data.getMap().getTerritories()) {
            Collection<Unit> units = t.getUnits().getUnits();
            if (units.isEmpty()) continue;
            state.put(t, units.iterator().next().getOwner());
        }
        return state;
    }

    @Override
    public List<Map<Territory, PlayerID>> getPreviousMapStates() {
        return this.m_previousMapStates;
    }

    @Override
    public boolean haveTwoPassedInARow() {
        return this.m_passesInARow >= 2;
    }

    public int getPassesInARow() {
        return this.m_passesInARow;
    }

    public void setPassesInARow(int passesInARow) {
        this.m_passesInARow = passesInARow;
    }

    @Override
    public Set<Unit> getCapturedUnits() {
        return this.m_capturedUnits;
    }

    public static String isValidNonSuperPositionalKo(IGridPlayData play, PlayerID player, GameData data) {
        Map<Territory, PlayerID> currentState = PlayDelegate.getCurrentMapState(data);
        currentState.put(play.getStart(), player);
        for (Territory t : PlayDelegate.checkForCaptures(play, player, data)) {
            currentState.remove(t);
        }
        PlayDelegate localPlayDelegate = Go.playDelegate(data);
        if (localPlayDelegate == null) {
            return null;
        }
        List<Map<Territory, PlayerID>> previousStates = localPlayDelegate.getPreviousMapStates();
        if (previousStates == null || previousStates.isEmpty()) {
            return null;
        }
        if (previousStates.contains(currentState)) {
            return "Can Not Recreate Any State That Previously Existed";
        }
        return null;
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return IGoPlayDelegate.class;
    }

    public static Match<Territory> TerritoryHasUnitsOwnedBy(PlayerID player) {
        final Match<Unit> unitOwnedBy = PlayDelegate.UnitIsOwnedBy(player);
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return t.getUnits().someMatch(unitOwnedBy);
            }
        };
    }

    public static Match<Unit> UnitIsOwnedBy(final PlayerID player) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unit) {
                return unit.getOwner().equals(player);
            }
        };
    }

    public static String isValidMoveBasic(IGridPlayData play, PlayerID player, GameData data) {
        if (play.getStart() == null) {
            return "Can Not Move Off Board";
        }
        if (play.getStart().getUnits().getUnitCount() > 0) {
            return "A Piece Is In That Position";
        }
        return null;
    }

    public static String isValidPieceMoveBasic(IGridPlayData play, PlayerID player, GameData data) {
        Collection<Territory> captures;
        Territory start = play.getStart();
        Set<Territory> chain = PlayDelegate.getOwnedStoneChainsConnectedToThisTerritory(start, new HashSet<Territory>(), player, data, true);
        if (PlayDelegate.areAllLibertiesTakenByEnemy(play, chain, player, data) && (captures = PlayDelegate.checkForCaptures(play, player, data)).isEmpty()) {
            return "May Not Suicide Move";
        }
        return null;
    }

    public static boolean areAllLibertiesTakenByEnemy(IGridPlayData play, Collection<Territory> chain, PlayerID player, GameData data) {
        Set<Territory> liberties = PlayDelegate.getAllNeighborsOfTerritoryChain(chain, data);
        for (Territory t : liberties) {
            if (!(t.equals(play.getStart()) ? player.equals(play.getPlayerID()) && !t.getUnits().someMatch(PlayDelegate.UnitIsOwnedBy(player).invert()) : !t.getUnits().someMatch(PlayDelegate.UnitIsOwnedBy(player).invert()))) continue;
            return false;
        }
        return true;
    }

    public static Set<Territory> getAllNeighborsOfTerritoryChain(Collection<Territory> chain, GameData data) {
        HashSet<Territory> neighbors = new HashSet<Territory>();
        GameMap map = data.getMap();
        for (Territory t : chain) {
            neighbors.addAll(map.getNeighbors(t));
        }
        neighbors.removeAll(chain);
        return neighbors;
    }

    public static List<Set<Territory>> getEnemyStoneChainsConnectedToThisTerritory(Territory start, PlayerID player, GameData data) {
        List<PlayerID> enemies = data.getPlayerList().getPlayers();
        enemies.remove(player);
        PlayerID enemy = (PlayerID)enemies.iterator().next();
        List<Territory> neighbors = Match.getMatches(data.getMap().getNeighbors(start), PlayDelegate.TerritoryHasUnitsOwnedBy(enemy));
        ArrayList<Set<Territory>> enemyGroups = new ArrayList<Set<Territory>>();
        for (Territory t : neighbors) {
            enemyGroups.add(PlayDelegate.getOwnedStoneChainsConnectedToThisTerritory(t, new HashSet<Territory>(), enemy, data, true));
        }
        return enemyGroups;
    }

    public static Set<Territory> getOwnedStoneChainsConnectedToThisTerritory(Territory start, Set<Territory> chainsSoFar, PlayerID player, GameData data, boolean includeStart) {
        List<Territory> neighbors = Match.getMatches(data.getMap().getNeighbors(start), PlayDelegate.TerritoryHasUnitsOwnedBy(player));
        neighbors.removeAll(chainsSoFar);
        chainsSoFar.addAll(neighbors);
        for (Territory t : neighbors) {
            chainsSoFar.addAll(PlayDelegate.getOwnedStoneChainsConnectedToThisTerritory(t, chainsSoFar, player, data, false));
        }
        if (includeStart) {
            chainsSoFar.add(start);
        }
        return chainsSoFar;
    }
}

