/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.go.player;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.grid.go.delegate.PlayDelegate;
import games.strategy.grid.go.delegate.remote.IGoEndTurnDelegate;
import games.strategy.grid.go.delegate.remote.IGoPlayDelegate;
import games.strategy.grid.player.GridAbstractAI;
import games.strategy.grid.ui.GridEndTurnData;
import games.strategy.grid.ui.GridPlayData;
import games.strategy.grid.ui.IGridEndTurnData;
import games.strategy.util.Triple;
import games.strategy.util.Tuple;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class RandomAI
extends GridAbstractAI {
    public RandomAI(String name, String type) {
        super(name, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void play() {
        GridPlayData play;
        String error;
        Iterator iter;
        Triple<List<Territory>, List<Tuple<Territory, Collection<Territory>>>, List<Territory>> totalMoves;
        IGoPlayDelegate playDel = (IGoPlayDelegate)this.getPlayerBridge().getRemoteDelegate();
        PlayerID me = this.getPlayerID();
        GameData data = this.getGameData();
        this.pause();
        try {
            data.acquireReadLock();
            totalMoves = PlayDelegate.getAllValidMovesCaptureMovesAndInvalidMoves(me, data);
        }
        finally {
            data.releaseReadLock();
        }
        List validNonCaptureMoves = (List)totalMoves.getFirst();
        List validCaptureMoves = (List)totalMoves.getSecond();
        if (!validCaptureMoves.isEmpty()) {
            Collections.shuffle(validCaptureMoves);
            Collections.sort(validCaptureMoves, RandomAI.getBestCaptureComparator(this.getPlayerID(), this.getGameData()));
            iter = validCaptureMoves.iterator();
            while ((error = playDel.play(play = new GridPlayData((Territory)((Tuple)iter.next()).getFirst(), me))) != null && iter.hasNext()) {
            }
            if (error == null) {
                return;
            }
        }
        if (validNonCaptureMoves.size() > 2 + data.getMap().getXDimension() * data.getMap().getYDimension() / 5) {
            Collections.shuffle(validNonCaptureMoves);
            iter = validNonCaptureMoves.iterator();
            while ((error = playDel.play(play = new GridPlayData((Territory)iter.next(), me))) != null && iter.hasNext()) {
            }
            if (error == null) {
                return;
            }
        }
        GridPlayData pass = new GridPlayData(true, me);
        playDel.play(pass);
    }

    @Override
    protected void endTurn() {
        IGoEndTurnDelegate endTurnDel = (IGoEndTurnDelegate)this.getPlayerBridge().getRemoteDelegate();
        this.pause();
        IGridEndTurnData lastPlayersEndTurn = endTurnDel.getTerritoryAdjustment();
        if (lastPlayersEndTurn == null) {
            GridEndTurnData endPlay = new GridEndTurnData(new HashSet<Territory>(), false, this.getPlayerID());
            endTurnDel.territoryAdjustment(endPlay);
        } else {
            endTurnDel.territoryAdjustment(lastPlayersEndTurn);
        }
    }

    static Comparator<Tuple<Territory, Collection<Territory>>> getBestCaptureComparator(PlayerID player, GameData data) {
        return new Comparator<Tuple<Territory, Collection<Territory>>>(){

            @Override
            public int compare(Tuple<Territory, Collection<Territory>> t1, Tuple<Territory, Collection<Territory>> t2) {
                int points2;
                if (t1 == null && t2 == null || t1 == t2) {
                    return 0;
                }
                if (t1 == null && t2 != null) {
                    return 1;
                }
                if (t1 != null && t2 == null) {
                    return -1;
                }
                if (t1.equals(t2)) {
                    return 0;
                }
                int points1 = t1.getSecond().size();
                if (points1 == (points2 = t2.getSecond().size())) {
                    return 0;
                }
                if (points1 > points2) {
                    return -1;
                }
                return 1;
            }
        };
    }
}

