/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.go.ui;

import games.strategy.common.delegate.BaseEditDelegate;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.gamePlayer.IPlayerBridge;
import games.strategy.grid.go.delegate.EndTurnDelegate;
import games.strategy.grid.go.delegate.PlayDelegate;
import games.strategy.grid.go.delegate.remote.IGoEndTurnDelegate;
import games.strategy.grid.ui.GridEndTurnData;
import games.strategy.grid.ui.GridGameFrame;
import games.strategy.grid.ui.GridMapData;
import games.strategy.grid.ui.GridMapPanel;
import games.strategy.grid.ui.GridPlayData;
import games.strategy.grid.ui.IGridEndTurnData;
import games.strategy.grid.ui.IGridPlayData;
import games.strategy.triplea.ui.MouseDetails;
import games.strategy.ui.ImageScrollModel;
import games.strategy.util.Match;
import games.strategy.util.Triple;
import games.strategy.util.Tuple;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.swing.SwingUtilities;

public class GoMapPanel
extends GridMapPanel {
    private static final long serialVersionUID = 2560185139493126853L;
    protected Set<Territory> m_territoryGroupsThatShouldDie = null;
    protected Triple<List<Territory>, List<Tuple<Territory, Collection<Territory>>>, List<Territory>> m_allMovesPossibleList = null;
    protected boolean m_passing = false;
    protected boolean m_wantToContinuePlaying = false;
    protected GO_DELEGATE_PHASE m_phase = GO_DELEGATE_PHASE.PLAY;

    public GoMapPanel(GameData data, GridMapData mapData, GridGameFrame parentGridGameFrame, ImageScrollModel imageScrollModel) {
        super(data, mapData, parentGridGameFrame, imageScrollModel);
    }

    public void changePhase(GO_DELEGATE_PHASE newPhase) {
        this.m_phase = newPhase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String isValidPlay(IGridPlayData play) {
        String error;
        try {
            this.m_gameData.acquireReadLock();
            error = PlayDelegate.isValidPlay(play, this.m_parentGridGameFrame.getActivePlayer(), this.m_gameData);
        }
        finally {
            this.m_gameData.releaseReadLock();
        }
        return error;
    }

    @Override
    protected Collection<Territory> getCapturesForPlay(IGridPlayData play) {
        return PlayDelegate.checkForCaptures(play, this.m_parentGridGameFrame.getActivePlayer(), this.m_gameData);
    }

    @Override
    protected Tuple<Collection<IGridPlayData>, Collection<Territory>> getValidMovesList(Territory clickedOn, PlayerID player) {
        if (clickedOn == null) {
            return null;
        }
        ArrayList<GridPlayData> plays = new ArrayList<GridPlayData>();
        HashSet<Territory> captures = new HashSet<Territory>();
        GridPlayData play = new GridPlayData(clickedOn, null, player);
        if (this.isValidPlay(play) == null) {
            plays.add(play);
            captures.addAll(this.getCapturesForPlay(play));
        }
        return new Tuple<Collection<IGridPlayData>, Collection<Territory>>(plays, captures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Triple<List<Territory>, List<Tuple<Territory, Collection<Territory>>>, List<Territory>> getAllPossibleMovesList(PlayerID activePlayer) {
        Triple<List<Territory>, List<Tuple<Territory, Collection<Territory>>>, List<Territory>> moves;
        try {
            this.m_gameData.acquireReadLock();
            moves = PlayDelegate.getAllValidMovesCaptureMovesAndInvalidMoves(activePlayer, this.m_gameData);
        }
        finally {
            this.m_gameData.releaseReadLock();
        }
        return moves;
    }

    @Override
    protected void paintComponentMiddleLayer(Graphics2D g2d, int topLeftX, int topLeftY) {
        g2d.setColor(Color.lightGray);
        g2d.fillRect(0, 0, this.m_model.getMaxWidth(), this.m_model.getMaxHeight());
        Color tileOdd = new Color(225, 161, 101);
        Color tileEven = new Color(226, 163, 103);
        int maxX = this.m_gameData.getMap().getXDimension() - 1;
        int maxY = this.m_gameData.getMap().getYDimension() - 1;
        int xOffset = this.m_mapData.getSquareWidth() / 2;
        int yOffset = this.m_mapData.getSquareHeight() / 2;
        for (Map.Entry<Territory, Polygon> entry : this.m_mapData.getTerritoryPolygons(this.m_gameData.getMap()).entrySet()) {
            Polygon p = entry.getValue();
            Territory at = entry.getKey();
            if (at == null || p == null) continue;
            Color backgroundColor = (at.getX() + at.getY()) % 2 == 0 ? tileEven : tileOdd;
            g2d.setColor(backgroundColor);
            g2d.fillPolygon(p);
            g2d.setColor(Color.black);
            g2d.translate(-xOffset, -yOffset);
            if (at.getY() != 0 && at.getX() != 0) {
                g2d.drawPolygon(p);
            }
            g2d.translate(xOffset * 2, 0);
            if (at.getY() != 0 && at.getX() != maxX) {
                g2d.drawPolygon(p);
            }
            g2d.translate(0, yOffset * 2);
            if (at.getY() != maxY && at.getX() != maxX) {
                g2d.drawPolygon(p);
            }
            g2d.translate(-(xOffset * 2), 0);
            if (at.getY() != maxY && at.getX() != 0) {
                g2d.drawPolygon(p);
            }
            g2d.translate(xOffset, -yOffset);
        }
        g2d.setColor(Color.black);
        for (int x = 0; x <= maxX; ++x) {
            for (int y = 0; y <= maxY; ++y) {
                boolean stary;
                boolean starx = (x - 3) % 6 == 0;
                boolean bl = stary = (y - 3) % 6 == 0;
                if (!starx || !stary) continue;
                Ellipse2D.Double circle = new Ellipse2D.Double(this.m_mapData.getBevelWidth() + x * this.m_mapData.getSquareWidth() + xOffset - 4, this.m_mapData.getBevelHeight() + y * this.m_mapData.getSquareHeight() + xOffset - 4, 8.0, 8.0);
                g2d.fill(circle);
            }
        }
        for (Map.Entry<Territory, Polygon> entry : this.m_mapData.getTerritoryPolygons(this.m_gameData.getMap()).entrySet()) {
            Image image;
            Polygon p = entry.getValue();
            Territory at = entry.getKey();
            if (at == null || p == null || (image = (Image)this.m_images.get(at)) == null) continue;
            Rectangle square = p.getBounds();
            g2d.drawImage(image, square.x, square.y, square.width, square.height, null, null);
        }
        this.paintAllPossibleMoves(g2d, topLeftX, topLeftY);
    }

    @Override
    protected void paintLastMove(Graphics2D g2d, int topLeftX, int topLeftY) {
        if (this.m_lastMove != null && this.m_lastMove.getStart() != null) {
            g2d.setColor(Color.gray);
            Territory last = this.m_lastMove.getStart();
            Rectangle start = this.m_mapData.getPolygon(last).getBounds();
            g2d.draw(new RoundRectangle2D.Double(start.x, start.y, start.width, start.height, start.width / 3, start.height / 3));
        }
    }

    protected void paintAllPossibleMoves(Graphics2D g2d, int topLeftX, int topLeftY) {
        if (this.m_allMovesPossibleList != null) {
            g2d.setComposite(AlphaComposite.getInstance(3, 0.6f));
            g2d.setColor(Color.yellow);
            List<Territory> invalid = Match.getMatches((Collection)this.m_allMovesPossibleList.getThird(), PlayDelegate.TerritoryHasNoUnits);
            for (Territory t : invalid) {
                Polygon p = this.m_mapData.getPolygon(t);
                Rectangle rect = p.getBounds();
                g2d.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height);
                g2d.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y);
            }
            for (Tuple entry : (List)this.m_allMovesPossibleList.getSecond()) {
                g2d.setColor(Color.black);
                Polygon p1 = this.m_mapData.getPolygon((Territory)entry.getFirst());
                Rectangle rect1 = p1.getBounds();
                g2d.drawLine(rect1.x, rect1.y, rect1.x + rect1.width, rect1.y + rect1.height);
                g2d.drawLine(rect1.x, rect1.y + rect1.height, rect1.x + rect1.width, rect1.y);
                g2d.setColor(Color.red);
                for (Territory t : (Collection)entry.getSecond()) {
                    Polygon p2 = this.m_mapData.getPolygon(t);
                    Rectangle rect2 = p2.getBounds();
                    g2d.drawLine(rect2.x, rect2.y, rect2.x + rect2.width, rect2.y + rect2.height);
                    g2d.drawLine(rect2.x, rect2.y + rect2.height, rect2.x + rect2.width, rect2.y);
                }
            }
        }
    }

    @Override
    protected void paintValidMoves(Graphics2D g2d, int topLeftX, int topLeftY) {
        if (this.m_parentGridGameFrame.isGameOver() || this.m_phase == GO_DELEGATE_PHASE.ENDGAME) {
            g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
            Map<Territory, PlayerID> currentScoreState = EndTurnDelegate.getCurrentAreaScoreState(this.m_territoryGroupsThatShouldDie, this.m_gameData);
            HashMap<PlayerID, Color> playerColors = new HashMap<PlayerID, Color>();
            playerColors.put(null, Color.blue);
            for (PlayerID player : this.m_gameData.getPlayerList().getPlayers()) {
                if (player.getName().equalsIgnoreCase("white")) {
                    playerColors.put(player, Color.white);
                    continue;
                }
                if (player.getName().equalsIgnoreCase("black")) {
                    playerColors.put(player, Color.black);
                    continue;
                }
                playerColors.put(player, Color.red);
            }
            for (Territory t : this.m_gameData.getMap().getTerritories()) {
                PlayerID player = currentScoreState.get(t);
                g2d.setColor((Color)playerColors.get(player));
                Polygon p2 = this.m_mapData.getPolygon(t);
                Rectangle rect2 = p2.getBounds();
                g2d.fillRect(rect2.x, rect2.y, rect2.width, rect2.height);
            }
        }
    }

    @Override
    protected void showGridPlayDataMove(final IGridPlayData move) {
        this.m_lastMove = move;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (move != null) {
                    GoMapPanel.this.m_parentGridGameFrame.updateRightSidePanel(move.toString(), GoMapPanel.this.m_lastMove.getStart() == null ? null : GoMapPanel.this.m_lastMove.getStart().getUnits().getUnits());
                }
            }
        });
    }

    @Override
    public void showGridEndTurnData(IGridEndTurnData endTurnData) {
        super.showGridEndTurnData(endTurnData);
        this.m_territoryGroupsThatShouldDie = endTurnData.getTerritoryUnitsRemovalAdjustment();
        this.updateAllImages();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.m_phase == GO_DELEGATE_PHASE.PLAY) {
            this.m_clickedAt = this.m_mapData.getTerritoryAt(e.getX() + this.m_model.getX(), e.getY() + this.m_model.getY(), this.m_gameData.getMap());
            if (this.m_clickedAt != null && e.getButton() != 1) {
                this.m_allMovesPossibleList = this.getAllPossibleMovesList(this.m_parentGridGameFrame.getActivePlayer());
            }
        } else if (this.m_phase == GO_DELEGATE_PHASE.ENDGAME) {
            Collection<Unit> units;
            Territory clickedAt = this.m_mapData.getTerritoryAt(e.getX() + this.m_model.getX(), e.getY() + this.m_model.getY(), this.m_gameData.getMap());
            if (clickedAt == null) {
                return;
            }
            if (this.m_territoryGroupsThatShouldDie == null) {
                this.m_territoryGroupsThatShouldDie = new HashSet<Territory>();
            }
            if ((units = clickedAt.getUnits().getUnits()).isEmpty()) {
                return;
            }
            PlayerID owner = units.iterator().next().getOwner();
            Set<Territory> group = PlayDelegate.getOwnedStoneChainsConnectedToThisTerritory(clickedAt, new HashSet<Territory>(), owner, this.m_gameData, true);
            if (this.m_territoryGroupsThatShouldDie.containsAll(group)) {
                this.m_territoryGroupsThatShouldDie.removeAll(group);
            } else {
                this.m_territoryGroupsThatShouldDie.addAll(group);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Territory at = this.m_mapData.getTerritoryAt(e.getX() + this.m_model.getX(), e.getY() + this.m_model.getY(), this.m_gameData.getMap());
        if (at != null) {
            this.notifyTerritorySelected(at, new MouseDetails(e, e.getX(), e.getY()));
        }
        if (BaseEditDelegate.getEditMode(this.m_gameData)) {
            return;
        }
        if (this.m_phase == GO_DELEGATE_PHASE.PLAY) {
            if (e.getButton() != 1) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GoMapPanel.this.repaint();
                    }
                });
                return;
            }
            this.m_allMovesPossibleList = null;
            if (this.m_waiting != null && this.m_clickedAt != null) {
                this.m_passing = false;
                this.m_waiting.countDown();
            }
        } else if (this.m_phase == GO_DELEGATE_PHASE.ENDGAME) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GoMapPanel.this.repaint();
                }
            });
        }
    }

    @Override
    public void doKeyListenerEvents(KeyEvent e) {
        if (BaseEditDelegate.getEditMode(this.m_gameData)) {
            return;
        }
        int keyCode = e.getKeyCode();
        if (keyCode == 80 && this.m_phase == GO_DELEGATE_PHASE.PLAY) {
            this.m_passing = true;
            if (this.m_waiting != null) {
                this.m_waiting.countDown();
            }
        }
        if (keyCode == 82 && this.m_phase == GO_DELEGATE_PHASE.ENDGAME) {
            this.m_wantToContinuePlaying = true;
            this.m_territoryGroupsThatShouldDie = null;
            if (this.m_waiting != null) {
                this.m_waiting.countDown();
            }
        }
        if (keyCode == 67 && this.m_phase == GO_DELEGATE_PHASE.ENDGAME) {
            this.m_wantToContinuePlaying = false;
            if (this.m_territoryGroupsThatShouldDie == null) {
                this.m_territoryGroupsThatShouldDie = new HashSet<Territory>();
            }
            if (this.m_waiting != null) {
                this.m_waiting.countDown();
            }
        }
    }

    @Override
    protected MouseMotionListener getMouseMotionListener() {
        return new MouseMotionAdapter(){};
    }

    @Override
    public void setMouseShadowUnits(Collection<Unit> units) {
    }

    @Override
    public GridPlayData waitForPlay(PlayerID player, IPlayerBridge bridge, CountDownLatch waiting) throws InterruptedException {
        if (waiting == null || waiting.getCount() != 1L) {
            throw new IllegalArgumentException("CountDownLatch must be non-null and have getCount()==1");
        }
        this.m_waiting = waiting;
        this.updateAllImages();
        this.m_waiting.await();
        if (this.m_clickedAt == null && !this.m_passing) {
            this.m_clickedAt = null;
            throw new InterruptedException("Interrupted while waiting for play.");
        }
        GridPlayData play = this.m_passing ? new GridPlayData(true, player) : new GridPlayData(this.m_clickedAt, player);
        this.m_clickedAt = null;
        this.m_passing = false;
        return play;
    }

    @Override
    public IGridEndTurnData waitForEndTurn(PlayerID player, IPlayerBridge bridge, CountDownLatch waiting) throws InterruptedException {
        if (waiting == null || waiting.getCount() != 1L) {
            throw new IllegalArgumentException("CountDownLatch must be non-null and have getCount()==1");
        }
        GridEndTurnData endPhaseData = new GridEndTurnData(null, false, player);
        IGoEndTurnDelegate endTurnDel = (IGoEndTurnDelegate)bridge.getRemoteDelegate();
        IGridEndTurnData lastEndTurnData = endTurnDel.getTerritoryAdjustment();
        if (lastEndTurnData != null && player.equals(lastEndTurnData.getPlayer())) {
            return endPhaseData;
        }
        boolean hasTwoPasses = endTurnDel.haveTwoPassedInARow();
        if (!hasTwoPasses) {
            return endPhaseData;
        }
        if (hasTwoPasses) {
            this.m_waiting = waiting;
            this.updateAllImages();
            this.m_waiting.await();
            if (this.m_territoryGroupsThatShouldDie == null && !this.m_wantToContinuePlaying) {
                this.m_territoryGroupsThatShouldDie = null;
                this.m_wantToContinuePlaying = false;
                throw new InterruptedException("Interrupted while waiting for play.");
            }
            endPhaseData = new GridEndTurnData(this.m_territoryGroupsThatShouldDie, this.m_wantToContinuePlaying, player);
            this.m_territoryGroupsThatShouldDie = null;
            this.m_wantToContinuePlaying = false;
        }
        return endPhaseData;
    }

    public IGridEndTurnData waitForEndTurnForumPoster(PlayerID player, IPlayerBridge bridge, CountDownLatch waiting) throws InterruptedException {
        if (waiting == null || waiting.getCount() != 1L) {
            throw new IllegalArgumentException("CountDownLatch must be non-null and have getCount()==1");
        }
        boolean waitForPBEM = this.waitForPlayByEmailOrForumPoster(player, bridge);
        GridEndTurnData endPhaseData = new GridEndTurnData(null, false, player);
        if (!waitForPBEM) {
            return endPhaseData;
        }
        this.showPlayByEmailOrForumPosterPanel(player, bridge, waiting);
        this.m_parentGridGameFrame.setStatus("Click Done To Continue");
        waiting.await();
        return endPhaseData;
    }

    public static enum GO_DELEGATE_PHASE {
        PLAY,
        ENDGAME;

    }
}

