/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.kingstable;

import games.strategy.engine.framework.IGameLoader;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.grid.GridGame;
import games.strategy.grid.kingstable.player.BetterAI;
import games.strategy.grid.kingstable.ui.KingsTableMapPanel;
import games.strategy.grid.kingstable.ui.KingsTableMenu;
import games.strategy.grid.player.GridAbstractAI;
import games.strategy.grid.player.GridGamePlayer;
import games.strategy.grid.player.RandomAI;
import games.strategy.grid.ui.GridGameFrame;
import games.strategy.grid.ui.GridGameMenu;
import games.strategy.grid.ui.GridMapData;
import games.strategy.grid.ui.GridMapPanel;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class KingsTable
extends GridGame
implements IGameLoader {
    private static final long serialVersionUID = -4160546942612903442L;
    private static final String HUMAN_PLAYER_TYPE = "Human";
    private static final String RANDOM_COMPUTER_PLAYER_TYPE = "Random AI";
    private static final String ALPHABETA_COMPUTER_PLAYER_TYPE = "\u03b1\u03b2 AI";

    @Override
    public Set<IGamePlayer> createPlayers(Map<String, String> playerNames) {
        HashSet<IGamePlayer> players = new HashSet<IGamePlayer>();
        for (String name : playerNames.keySet()) {
            GridAbstractAI ai;
            String type = playerNames.get(name);
            if (type.equals(HUMAN_PLAYER_TYPE) || type.equals("Client")) {
                GridGamePlayer player = new GridGamePlayer(name, type);
                players.add(player);
                continue;
            }
            if (type.equals(RANDOM_COMPUTER_PLAYER_TYPE)) {
                ai = new RandomAI(name, type);
                players.add(ai);
                continue;
            }
            if (type.equals(ALPHABETA_COMPUTER_PLAYER_TYPE)) {
                ai = new BetterAI(name, type, BetterAI.Algorithm.ALPHABETA);
                players.add(ai);
                continue;
            }
            throw new IllegalStateException("Player type not recognized:" + type);
        }
        return players;
    }

    @Override
    public String[] getServerPlayerTypes() {
        return new String[]{HUMAN_PLAYER_TYPE, ALPHABETA_COMPUTER_PLAYER_TYPE, RANDOM_COMPUTER_PLAYER_TYPE};
    }

    @Override
    protected Class<? extends GridMapPanel> getGridMapPanelClass() {
        return KingsTableMapPanel.class;
    }

    @Override
    protected Class<? extends GridMapData> getGridMapDataClass() {
        return GridMapData.class;
    }

    @Override
    protected Class<? extends GridGameMenu<GridGameFrame>> getGridTableMenuClass() {
        return KingsTableMenu.class;
    }
}

