/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.kingstable.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.grid.delegate.AbstractPlayByEmailOrForumDelegate;
import games.strategy.grid.kingstable.attachments.PlayerAttachment;
import games.strategy.grid.kingstable.attachments.TerritoryAttachment;
import games.strategy.grid.kingstable.delegate.KingsTableEndTurnExtendedDelegateState;
import games.strategy.grid.ui.display.IGridGameDisplay;
import java.io.Serializable;

public class EndTurnDelegate
extends AbstractPlayByEmailOrForumDelegate {
    @Override
    public void start() {
        super.start();
        PlayerID winner = this.checkForWinner();
        if (winner != null) {
            this.signalGameOver(winner.getName() + " wins!");
        }
    }

    @Override
    public void end() {
        super.end();
    }

    @Override
    public Serializable saveState() {
        KingsTableEndTurnExtendedDelegateState state = new KingsTableEndTurnExtendedDelegateState();
        state.superState = super.saveState();
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        KingsTableEndTurnExtendedDelegateState s = (KingsTableEndTurnExtendedDelegateState)state;
        super.loadState(s.superState);
    }

    private void signalGameOver(String status) {
        this.m_bridge.getHistoryWriter().startEvent(status);
        IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.setStatus(status);
        display.setGameOver();
        this.m_bridge.stopGameSequence();
    }

    private PlayerID checkForWinner() {
        boolean defenderHasKing = false;
        PlayerID attacker = null;
        PlayerID defender = null;
        GameData data = this.getData();
        for (PlayerID player : data.getPlayerList().getPlayers()) {
            PlayerAttachment pa = (PlayerAttachment)player.getAttachment("playerAttachment");
            if (pa == null) {
                attacker = player;
                continue;
            }
            if (pa.getNeedsKing()) {
                defender = player;
                continue;
            }
            attacker = player;
        }
        if (attacker == null) {
            throw new RuntimeException("Invalid game setup - no attacker is specified. Reconfigure the game xml file so that one player has a playerAttachment with needsKing set to false.");
        }
        if (defender == null) {
            throw new RuntimeException("Invalid game setup - no defender is specified. Reconfigure the game xml file so that one player has a playerAttachment with needsKing set to true.");
        }
        int numAttackerPieces = 0;
        int numDefenderPieces = 0;
        for (Territory t : data.getMap().getTerritories()) {
            TerritoryAttachment ta;
            if (t.getUnits().isEmpty()) continue;
            Unit unit = (Unit)t.getUnits().getUnits().toArray()[0];
            if (unit.getType().getName().equals("king")) {
                defenderHasKing = true;
            }
            if (unit.getOwner().equals(defender)) {
                ++numDefenderPieces;
            } else if (unit.getOwner().equals(attacker)) {
                ++numAttackerPieces;
            }
            if ((ta = (TerritoryAttachment)t.getAttachment("territoryAttachment")) == null || !ta.getKingsExit() || t.getUnits().isEmpty() || !unit.getOwner().equals(defender)) continue;
            return defender;
        }
        if (!defenderHasKing || numDefenderPieces == 0) {
            return attacker;
        }
        if (numAttackerPieces == 0) {
            return defender;
        }
        return null;
    }
}

