/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.ui;

import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.grid.ui.IGridEndTurnData;
import games.strategy.triplea.formatter.MyFormatter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class GridEndTurnData
implements IGridEndTurnData {
    private static final long serialVersionUID = -4940904520179372089L;
    protected final PlayerID m_player;
    protected final Set<Territory> m_territoryUnitsRemovalAdjustment;
    protected final boolean m_wantToContinuePlaying;

    public GridEndTurnData(Collection<Territory> territoryUnitsRemovalAdjustment, boolean wantToContinuePlaying, PlayerID player) {
        this.m_player = player;
        this.m_territoryUnitsRemovalAdjustment = territoryUnitsRemovalAdjustment == null ? null : new HashSet<Territory>(territoryUnitsRemovalAdjustment);
        this.m_wantToContinuePlaying = wantToContinuePlaying;
    }

    public GridEndTurnData(IGridEndTurnData groupsThatShouldDie) {
        this(groupsThatShouldDie.getTerritoryUnitsRemovalAdjustment(), groupsThatShouldDie.getWantToContinuePlaying(), groupsThatShouldDie.getPlayer());
    }

    @Override
    public Set<Territory> getTerritoryUnitsRemovalAdjustment() {
        return this.m_territoryUnitsRemovalAdjustment == null ? null : new HashSet<Territory>(this.m_territoryUnitsRemovalAdjustment);
    }

    @Override
    public boolean getWantToContinuePlaying() {
        return this.m_wantToContinuePlaying;
    }

    @Override
    public PlayerID getPlayer() {
        return this.m_player;
    }

    public String toString() {
        return (this.m_player == null ? "" : this.m_player.getName() + " ") + (this.m_wantToContinuePlaying ? "continuing play" : (this.m_territoryUnitsRemovalAdjustment == null || this.m_territoryUnitsRemovalAdjustment.isEmpty() ? "making no territory adjustments" : "changing the following territories: " + MyFormatter.defaultNamedToTextList(this.m_territoryUnitsRemovalAdjustment)));
    }
}

