/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.ui;

import games.strategy.common.delegate.BaseEditDelegate;
import games.strategy.common.image.UnitImageFactory;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.events.GameDataChangeListener;
import games.strategy.engine.data.events.GameMapListener;
import games.strategy.engine.gamePlayer.IPlayerBridge;
import games.strategy.engine.pbem.ForumPosterComponent;
import games.strategy.engine.pbem.PBEMMessagePoster;
import games.strategy.grid.ui.GridEndTurnData;
import games.strategy.grid.ui.GridGameFrame;
import games.strategy.grid.ui.GridMapData;
import games.strategy.grid.ui.GridPlayData;
import games.strategy.grid.ui.IGridEndTurnData;
import games.strategy.grid.ui.IGridPlayData;
import games.strategy.triplea.ResourceLoader;
import games.strategy.triplea.delegate.GameStepPropertiesHelper;
import games.strategy.triplea.delegate.remote.IAbstractForumPosterDelegate;
import games.strategy.triplea.ui.MapSelectionListener;
import games.strategy.triplea.ui.MouseDetails;
import games.strategy.ui.ImageScrollModel;
import games.strategy.ui.ImageScrollerLargeView;
import games.strategy.ui.ScrollListener;
import games.strategy.ui.Util;
import games.strategy.util.CountDownLatchHandler;
import games.strategy.util.ListenerList;
import games.strategy.util.Tuple;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public abstract class GridMapPanel
extends ImageScrollerLargeView
implements MouseListener {
    private static final long serialVersionUID = -1318170171400997968L;
    protected final GridMapData m_mapData;
    protected GameData m_gameData;
    protected Territory m_clickedAt = null;
    protected Territory m_releasedAt = null;
    protected final Map<Territory, Image> m_images;
    protected CountDownLatch m_waiting;
    protected final UnitImageFactory m_imageFactory;
    protected BufferedImage m_mouseShadowImage = null;
    protected Tuple<Collection<IGridPlayData>, Collection<Territory>> m_validMovesList = null;
    protected Point m_currentMouseLocation = new Point(0, 0);
    protected Territory m_currentMouseLocationTerritory = null;
    protected final GridGameFrame m_parentGridGameFrame;
    protected IGridPlayData m_lastMove = null;
    protected final ImageScrollModel m_imageScrollModel;
    protected PBEMMessagePoster m_posterPBEM = null;
    protected ForumPosterComponent m_forumPosterComponent;
    private final CountDownLatchHandler m_latchesToCloseOnShutdown = new CountDownLatchHandler(false);
    protected GameMapListener GAME_MAP_LISTENER = new GameMapListener(){

        @Override
        public void gameMapDataChanged() {
            GridMapPanel.this.m_mapData.setMapData(GridMapPanel.this.m_gameData.getMap(), GridMapPanel.this.m_gameData.getMap().getXDimension(), GridMapPanel.this.m_gameData.getMap().getYDimension(), GridMapPanel.this.m_mapData.getSquareWidth(), GridMapPanel.this.m_mapData.getSquareHeight(), GridMapPanel.this.m_mapData.getBevelHeight(), GridMapPanel.this.m_mapData.getBevelHeight());
            GridMapPanel.this.m_imageScrollModel.setMaxBounds(GridMapPanel.this.m_mapData.getMapDimensions());
            GridMapPanel.this.mapDataAndDimensionsChanged();
            GridMapPanel.this.updateAllImages();
        }
    };
    protected final GameDataChangeListener GAME_DATA_CHANGE_LISTENER = new GameDataChangeListener(){

        @Override
        public void gameDataChanged(Change aChange) {
            GridMapPanel.this.updateAllImages();
        }
    };
    protected final ListenerList<MapSelectionListener> m_mapSelectionListeners = new ListenerList();

    public GridMapPanel(GameData data, GridMapData mapData, GridGameFrame parentGridGameFrame, ImageScrollModel imageScrollModel) {
        super(mapData.getMapDimensions(), imageScrollModel);
        this.m_imageScrollModel = imageScrollModel;
        this.m_waiting = null;
        this.m_mapData = mapData;
        this.m_parentGridGameFrame = parentGridGameFrame;
        this.setGameData(data);
        String mapName = (String)this.m_gameData.getProperties().get("mapName");
        if (mapName == null || mapName.trim().length() == 0) {
            throw new IllegalStateException("Map name property not set on game");
        }
        this.m_imageFactory = new UnitImageFactory();
        this.m_imageFactory.setResourceLoader(ResourceLoader.getMapResourceLoader(mapName, true));
        Dimension mapDimension = this.m_mapData.getMapDimensions();
        this.setMinimumSize(mapDimension);
        this.setPreferredSize(mapDimension);
        this.setSize(mapDimension);
        this.m_images = new HashMap<Territory, Image>();
        for (Territory at : this.m_gameData.getMap().getTerritories()) {
            this.updateImage(at);
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this.getMouseMotionListener());
        this.addScrollListener(new ScrollListener(){

            @Override
            public void scrolled(int x, int y) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GridMapPanel.this.repaint();
                    }
                });
            }
        });
        this.setOpaque(true);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getImageDimensions();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    boolean mapWidthFitsOnScreen() {
        return (double)this.m_model.getMaxWidth() < this.getScaledWidth();
    }

    boolean mapHeightFitsOnScreen() {
        return (double)this.m_model.getMaxHeight() < this.getScaledHeight();
    }

    protected void refreshTerritories(Collection<Territory> territories) {
        if (territories != null) {
            for (Territory at : territories) {
                this.updateImage(at);
            }
        } else {
            for (Territory at : this.m_gameData.getMap().getTerritories()) {
                this.updateImage(at);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GridMapPanel.this.repaint();
            }
        });
    }

    protected void showGridPlayDataMove(final IGridPlayData move) {
        this.m_lastMove = move;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GridMapPanel.this.m_parentGridGameFrame.updateRightSidePanel(move.toString(), GridMapPanel.this.m_lastMove.getEnd().getUnits().getUnits());
            }
        });
    }

    public void showGridEndTurnData(final IGridEndTurnData endTurnData) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GridMapPanel.this.m_parentGridGameFrame.updateRightSidePanel(endTurnData.toString(), null);
            }
        });
    }

    protected void updateAllImages() {
        this.refreshTerritories(this.m_gameData.getMap().getTerritories());
    }

    private void updateImage(Territory at) {
        if (at != null && this.m_images != null) {
            if (at.getUnits().size() == 1) {
                Unit u = (Unit)at.getUnits().getUnits().toArray()[0];
                Image image = this.m_imageFactory.getImage(u.getType(), u.getOwner(), this.m_gameData);
                this.m_images.put(at, image);
            } else {
                this.m_images.remove(at);
            }
        }
    }

    public void setGameData(GameData data) {
        if (this.m_gameData != null) {
            this.m_gameData.removeGameMapListener(this.GAME_MAP_LISTENER);
            this.m_gameData.removeDataChangeListener(this.GAME_DATA_CHANGE_LISTENER);
        }
        this.m_gameData = data;
        this.m_gameData.addGameMapListener(this.GAME_MAP_LISTENER);
        this.m_gameData.addDataChangeListener(this.GAME_DATA_CHANGE_LISTENER);
        this.updateAllImages();
    }

    protected void mapDataAndDimensionsChanged() {
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.clip(new Rectangle2D.Double(0.0, 0.0, (double)this.getImageWidth() * this.m_scale, (double)this.getImageHeight() * this.m_scale));
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        int topLeftX = this.m_model.getX();
        int topLeftY = this.m_model.getY();
        g2d.translate(-topLeftX, -topLeftY);
        this.paintComponentMiddleLayer(g2d, topLeftX, topLeftY);
        this.paintValidMoves(g2d, topLeftX, topLeftY);
        this.paintLastMove(g2d, topLeftX, topLeftY);
        this.paintMouseShadow(g2d, topLeftX, topLeftY);
    }

    protected abstract void paintComponentMiddleLayer(Graphics2D var1, int var2, int var3);

    protected void paintValidMoves(Graphics2D g2d, int topLeftX, int topLeftY) {
        if (this.m_validMovesList != null) {
            g2d.setColor(Color.black);
            g2d.setComposite(AlphaComposite.getInstance(3, 0.6f));
            for (IGridPlayData play : this.m_validMovesList.getFirst()) {
                for (Territory t : play.getAllStepsExceptStart()) {
                    Polygon p = this.m_mapData.getPolygon(t);
                    Rectangle rect = p.getBounds();
                    g2d.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height);
                    g2d.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y);
                }
            }
            g2d.setColor(Color.red);
            for (Territory t : this.m_validMovesList.getSecond()) {
                Polygon p = this.m_mapData.getPolygon(t);
                Rectangle rect = p.getBounds();
                g2d.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height);
                g2d.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y);
            }
        }
    }

    protected void paintLastMove(Graphics2D g2d, int topLeftX, int topLeftY) {
        if (this.m_lastMove != null) {
            g2d.setColor(Color.gray);
            Territory last = this.m_lastMove.getStart();
            for (Territory t : this.m_lastMove.getAllStepsExceptStart()) {
                g2d.setComposite(AlphaComposite.getInstance(3, 0.6f));
                Rectangle start = this.m_mapData.getPolygon(last).getBounds();
                Rectangle end = this.m_mapData.getPolygon(t).getBounds();
                g2d.drawLine(start.x + start.width / 2, start.y + start.height / 2, end.x + end.width / 2, end.y + end.height / 2);
                last = t;
            }
        }
    }

    protected void paintMouseShadow(Graphics2D g2d, int topLeftX, int topLeftY) {
        if (this.m_mouseShadowImage != null) {
            AffineTransform t = new AffineTransform();
            t.translate(this.m_currentMouseLocation.x - this.m_mapData.getSquareWidth() / 2, this.m_currentMouseLocation.y - this.m_mapData.getSquareHeight() / 2);
            g2d.drawImage(this.m_mouseShadowImage, t, this);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.m_clickedAt = this.m_mapData.getTerritoryAt(e.getX() + this.m_model.getX(), e.getY() + this.m_model.getY(), this.m_gameData.getMap());
        if (this.m_clickedAt != null) {
            this.setMouseShadowUnits(this.m_clickedAt.getUnits().getUnits());
            this.m_validMovesList = this.getValidMovesList(this.m_clickedAt, this.m_parentGridGameFrame.getActivePlayer());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.m_releasedAt = this.m_mapData.getTerritoryAt(e.getX() + this.m_model.getX(), e.getY() + this.m_model.getY(), this.m_gameData.getMap());
        this.setMouseShadowUnits(null);
        this.m_validMovesList = null;
        if (this.m_releasedAt != null) {
            this.notifyTerritorySelected(this.m_releasedAt, new MouseDetails(e, e.getX(), e.getY()));
        }
        if (!BaseEditDelegate.getEditMode(this.m_gameData) && this.m_waiting != null && this.m_clickedAt != null && this.m_releasedAt != null) {
            this.m_waiting.countDown();
        }
    }

    protected MouseMotionListener getMouseMotionListener() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                GridMapPanel.this.m_currentMouseLocation = new Point(e.getX() + GridMapPanel.this.m_model.getX(), e.getY() + GridMapPanel.this.m_model.getY());
                GridMapPanel.this.m_currentMouseLocationTerritory = GridMapPanel.this.m_mapData.getTerritoryAt(e.getX() + GridMapPanel.this.m_model.getX(), e.getY() + GridMapPanel.this.m_model.getY(), GridMapPanel.this.m_gameData.getMap());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GridMapPanel.this.repaint();
                    }
                });
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.mouseMoved(e);
            }
        };
    }

    public void setMouseShadowUnits(Collection<Unit> units) {
        if (units == null || units.isEmpty()) {
            this.m_mouseShadowImage = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GridMapPanel.this.repaint();
                }
            });
            return;
        }
        int icon_width = this.m_mapData.getSquareWidth();
        int icon_height = this.m_mapData.getSquareHeight();
        int xSpace = this.m_mapData.getSquareWidth() / 5;
        BufferedImage img = Util.createImage(units.size() * (xSpace + icon_width), icon_height, true);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setComposite(AlphaComposite.getInstance(3, 0.6f));
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        int i = 0;
        for (Unit unit : units) {
            Point place = new Point(i * (icon_width + xSpace), 0);
            Image unitImage = this.m_imageFactory.getImage(unit.getType(), unit.getOwner(), this.m_gameData);
            g.drawImage(unitImage, place.x - bounds.x, place.y - bounds.y, null);
            ++i;
        }
        this.m_mouseShadowImage = img;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GridMapPanel.this.repaint();
            }
        });
        g.dispose();
    }

    public IGridPlayData waitForPlay(PlayerID player, IPlayerBridge bridge, CountDownLatch waiting) throws InterruptedException {
        if (waiting == null || waiting.getCount() != 1L) {
            throw new IllegalArgumentException("CountDownLatch must be non-null and have getCount()==1");
        }
        this.m_waiting = waiting;
        this.m_waiting.await();
        if (this.m_clickedAt == null || this.m_releasedAt == null) {
            this.m_clickedAt = null;
            this.m_releasedAt = null;
            throw new InterruptedException("Interrupted while waiting for play.");
        }
        if (this.m_clickedAt == this.m_releasedAt) {
            this.m_clickedAt = null;
            this.m_releasedAt = null;
            return null;
        }
        GridPlayData play = new GridPlayData(this.m_clickedAt, this.m_releasedAt, player);
        this.m_clickedAt = null;
        this.m_releasedAt = null;
        String error = this.isValidPlay(play);
        if (error == null) {
            return play;
        }
        this.m_parentGridGameFrame.notifyError(error);
        return null;
    }

    public IGridEndTurnData waitForEndTurn(PlayerID player, IPlayerBridge bridge, CountDownLatch waiting) throws InterruptedException {
        if (waiting == null || waiting.getCount() != 1L) {
            throw new IllegalArgumentException("CountDownLatch must be non-null and have getCount()==1");
        }
        boolean waitForPBEM = this.waitForPlayByEmailOrForumPoster(player, bridge);
        GridEndTurnData skipPhaseData = new GridEndTurnData(null, true, player);
        if (!waitForPBEM) {
            return skipPhaseData;
        }
        this.showPlayByEmailOrForumPosterPanel(player, bridge, waiting);
        this.m_waiting = waiting;
        this.m_waiting.await();
        return skipPhaseData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitForPlayByEmailOrForumPoster(PlayerID player, IPlayerBridge bridge) {
        int round = 0;
        try {
            this.m_gameData.acquireReadLock();
            round = this.m_gameData.getSequence().getRound();
        }
        finally {
            this.m_gameData.releaseReadLock();
        }
        this.m_posterPBEM = new PBEMMessagePoster(this.m_gameData, player, round, "Turn Summary");
        if (!this.m_posterPBEM.hasMessengers()) {
            return false;
        }
        return !this.skipPosting() && !GameStepPropertiesHelper.isSkipPosting(this.m_gameData);
    }

    protected boolean skipPosting() {
        return false;
    }

    protected void showPlayByEmailOrForumPosterPanel(final PlayerID player, final IPlayerBridge bridge, final CountDownLatch waiting) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GridMapPanel.this.m_parentGridGameFrame.updateRightSidePanel(GridMapPanel.this.getPlayByEmailOrForumPosterPanel(player, bridge, waiting, GridMapPanel.this.m_posterPBEM, false, true, false, false, false));
                GridMapPanel.this.m_parentGridGameFrame.maximizeRightSidePanel();
            }
        });
    }

    protected JPanel getPlayByEmailOrForumPosterPanel(PlayerID player, IPlayerBridge bridge, final CountDownLatch waiting, PBEMMessagePoster poster, boolean allowIncludeTerritorySummary, boolean allowIncludeTerritoryAllPlayersSummary, boolean allowIncludeProductionSummary, boolean allowDiceBattleDetails, boolean allowDiceStatistics) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new EmptyBorder(5, 5, 0, 0));
        panel.add(new JLabel("PBEM/PBF " + player.getName() + " Turn Summary"));
        IAbstractForumPosterDelegate delegate = (IAbstractForumPosterDelegate)bridge.getRemoteDelegate();
        boolean hasPosted = delegate.getHasPostedTurnSummary();
        AbstractAction doneAction = new AbstractAction("Done"){
            private static final long serialVersionUID = 2574764222648059066L;

            @Override
            public void actionPerformed(ActionEvent event) {
                if (waiting != null) {
                    waiting.countDown();
                    GridMapPanel.this.m_parentGridGameFrame.updateRightSidePanel(new JLabel(""));
                }
            }
        };
        this.m_forumPosterComponent = new ForumPosterComponent(this.m_gameData, doneAction, "Turn Summary");
        panel.add(this.m_forumPosterComponent.layoutComponents(poster, delegate, bridge, this.m_parentGridGameFrame, hasPosted, allowIncludeTerritorySummary, allowIncludeTerritoryAllPlayersSummary, allowIncludeProductionSummary, allowDiceBattleDetails, allowDiceStatistics));
        return panel;
    }

    protected abstract String isValidPlay(IGridPlayData var1);

    protected abstract Collection<Territory> getCapturesForPlay(IGridPlayData var1);

    protected Tuple<Collection<IGridPlayData>, Collection<Territory>> getValidMovesList(Territory clickedOn, PlayerID player) {
        if (clickedOn == null) {
            return null;
        }
        HashSet<GridPlayData> validMovesList = new HashSet<GridPlayData>();
        HashSet<Territory> capturesForValidMoves = new HashSet<Territory>();
        for (Territory t : this.m_gameData.getMap().getTerritories()) {
            GridPlayData play = new GridPlayData(clickedOn, t, player);
            if (this.isValidPlay(play) != null) continue;
            validMovesList.add(play);
            capturesForValidMoves.addAll(this.getCapturesForPlay(play));
        }
        return new Tuple<Collection<IGridPlayData>, Collection<Territory>>(validMovesList, capturesForValidMoves);
    }

    public UnitImageFactory getUnitImageFactory() {
        return this.m_imageFactory;
    }

    @Override
    public void setTopLeft(int x, int y) {
        this.m_model.set(x, y);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GridMapPanel.this.repaint();
            }
        });
    }

    public void doKeyListenerEvents(KeyEvent e) {
    }

    public void shutDown() {
        this.m_latchesToCloseOnShutdown.shutDown();
    }

    public void addShutdownLatch(CountDownLatch latch) {
        this.m_latchesToCloseOnShutdown.addShutdownLatch(latch);
    }

    public void removeShutdownLatch(CountDownLatch latch) {
        this.m_latchesToCloseOnShutdown.removeShutdownLatch(latch);
    }

    public CountDownLatchHandler getCountDownLatchHandler() {
        return this.m_latchesToCloseOnShutdown;
    }

    public GameData getData() {
        return this.m_gameData;
    }

    public void addMapSelectionListener(MapSelectionListener listener) {
        this.m_mapSelectionListeners.add(listener);
    }

    public void removeMapSelectionListener(MapSelectionListener listener) {
        this.m_mapSelectionListeners.remove(listener);
    }

    protected void notifyTerritorySelected(Territory t, MouseDetails me) {
        for (MapSelectionListener msl : this.m_mapSelectionListeners) {
            msl.territorySelected(t, me);
        }
    }

    protected void notifyMouseMoved(Territory t, MouseDetails me) {
        for (MapSelectionListener msl : this.m_mapSelectionListeners) {
            msl.mouseMoved(t, me);
        }
    }

    protected void notifyMouseEntered(Territory t) {
        for (MapSelectionListener msl : this.m_mapSelectionListeners) {
            msl.mouseEntered(t);
        }
    }
}

