/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.grid.ui;

import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.grid.ui.IGridPlayData;
import games.strategy.triplea.formatter.MyFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class GridPlayData
implements IGridPlayData {
    private static final long serialVersionUID = -1450796130971955757L;
    private final Territory m_start;
    private final List<Territory> m_middleSteps;
    private final Territory m_end;
    private final PlayerID m_player;
    private final boolean m_pass;
    public static Comparator<IGridPlayData> LargestToSmallestPlays = new Comparator<IGridPlayData>(){

        @Override
        public int compare(IGridPlayData p1, IGridPlayData p2) {
            int size2;
            if (p1 == null && p2 == null || p1 == p2) {
                return 0;
            }
            if (p1 == null && p2 != null) {
                return 1;
            }
            if (p1 != null && p2 == null) {
                return -1;
            }
            if (p1.equals(p2)) {
                return 0;
            }
            int size1 = p1.getAllSteps().size();
            if (size1 == (size2 = p2.getAllSteps().size())) {
                return 0;
            }
            if (size1 > size2) {
                return -1;
            }
            return 1;
        }
    };
    public static Comparator<IGridPlayData> SmallestToLargestPlays = new Comparator<IGridPlayData>(){

        @Override
        public int compare(IGridPlayData p1, IGridPlayData p2) {
            int size2;
            if (p1 == null && p2 == null || p1 == p2) {
                return 0;
            }
            if (p1 == null && p2 != null) {
                return 1;
            }
            if (p1 != null && p2 == null) {
                return -1;
            }
            if (p1.equals(p2)) {
                return 0;
            }
            int size1 = p1.getAllSteps().size();
            if (size1 == (size2 = p2.getAllSteps().size())) {
                return 0;
            }
            if (size1 > size2) {
                return 1;
            }
            return -1;
        }
    };

    public GridPlayData(Territory start, Territory end, PlayerID player) {
        this(start, new ArrayList<Territory>(), end, player);
    }

    public GridPlayData(Territory start, List<Territory> middleSteps, Territory end, PlayerID player) {
        this.m_start = start;
        this.m_end = end;
        this.m_middleSteps = middleSteps == null ? new ArrayList() : middleSteps;
        this.m_player = player;
        this.m_pass = false;
    }

    public GridPlayData(Territory start, PlayerID player) {
        this(start, new ArrayList<Territory>(), null, player);
    }

    public GridPlayData(boolean pass, PlayerID player) {
        this.m_start = null;
        this.m_end = null;
        this.m_middleSteps = new ArrayList<Territory>();
        this.m_player = player;
        this.m_pass = pass;
    }

    @Override
    public boolean isPass() {
        return this.m_pass;
    }

    @Override
    public Territory getStart() {
        return this.m_start;
    }

    @Override
    public Territory getEnd() {
        return this.m_end;
    }

    @Override
    public PlayerID getPlayerID() {
        return this.m_player;
    }

    @Override
    public List<Territory> getMiddleSteps() {
        return this.m_middleSteps;
    }

    @Override
    public List<Territory> getAllSteps() {
        ArrayList<Territory> all = new ArrayList<Territory>();
        if (this.m_start != null) {
            all.add(this.m_start);
        }
        all.addAll(this.m_middleSteps);
        if (this.m_end != null) {
            all.add(this.m_end);
        }
        return all;
    }

    @Override
    public List<Territory> getAllStepsExceptStart() {
        ArrayList<Territory> all = new ArrayList<Territory>();
        all.addAll(this.m_middleSteps);
        if (this.m_end != null) {
            all.add(this.m_end);
        }
        return all;
    }

    @Override
    public boolean isBiggerThanAndContains(IGridPlayData otherPlay) {
        List<Territory> otherSteps = otherPlay.getAllSteps();
        List<Territory> mySteps = this.getAllSteps();
        if (otherSteps.size() >= mySteps.size()) {
            return false;
        }
        for (int i = 0; i < otherSteps.size(); ++i) {
            if (otherSteps.get(i).equals(mySteps.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_end == null ? 0 : this.m_end.hashCode());
        result = 31 * result + (this.m_middleSteps == null ? 0 : this.m_middleSteps.hashCode());
        result = 31 * result + (this.m_player == null ? 0 : this.m_player.hashCode());
        result = 31 * result + (this.m_start == null ? 0 : this.m_start.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GridPlayData)) {
            return false;
        }
        GridPlayData other = (GridPlayData)obj;
        if (this.m_end == null ? other.m_end != null : !this.m_end.equals(other.m_end)) {
            return false;
        }
        if (this.m_middleSteps == null ? other.m_middleSteps != null : !this.m_middleSteps.equals(other.m_middleSteps)) {
            return false;
        }
        if (this.m_player == null ? other.m_player != null : !this.m_player.equals(other.m_player)) {
            return false;
        }
        return !(this.m_start == null ? other.m_start != null : !this.m_start.equals(other.m_start));
    }

    public String toString() {
        if (this.m_pass) {
            return "Pass of turn" + (this.m_player == null ? "" : " by " + this.m_player.getName());
        }
        return (this.m_player == null ? "" : this.m_player.getName() + " moving ") + (this.m_start == null ? "" : (this.m_start.getUnits().getUnitCount() > 0 ? MyFormatter.unitsToTextNoOwner(this.m_start.getUnits().getUnits()) + " " : "")) + (this.m_end == null ? "to " : "from ") + (this.m_start == null ? "null" : this.m_start.getName()) + (this.m_end == null ? "" : " to " + this.m_end.getName()) + (this.m_middleSteps == null || this.m_middleSteps.isEmpty() ? "" : " by way of: " + MyFormatter.defaultNamedToTextList(this.m_middleSteps));
    }
}

