/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.net;

import games.strategy.engine.framework.startup.mc.ServerModel;
import games.strategy.engine.framework.ui.SaveGameFileChooser;
import games.strategy.engine.message.HubInvoke;
import games.strategy.engine.message.RemoteMethodCall;
import games.strategy.engine.message.RemoteName;
import games.strategy.net.CouldNotLogInException;
import games.strategy.net.DefaultObjectStreamFactory;
import games.strategy.net.IClientMessenger;
import games.strategy.net.IConnectionLogin;
import games.strategy.net.IMessageListener;
import games.strategy.net.IMessengerErrorListener;
import games.strategy.net.INode;
import games.strategy.net.IObjectStreamFactory;
import games.strategy.net.MessageHeader;
import games.strategy.net.Node;
import games.strategy.net.nio.ClientQuarantineConversation;
import games.strategy.net.nio.NIOSocket;
import games.strategy.net.nio.NIOSocketListener;
import games.strategy.net.nio.QuarantineConversation;
import games.strategy.util.ListenerList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;

public class ClientMessenger
implements IClientMessenger,
NIOSocketListener {
    private INode m_node;
    private final ListenerList<IMessageListener> m_listeners = new ListenerList();
    private final ListenerList<IMessengerErrorListener> m_errorListeners = new ListenerList();
    private final CountDownLatch m_initLatch = new CountDownLatch(1);
    private Exception m_connectionRefusedError;
    private final NIOSocket m_socket;
    private final SocketChannel m_socketChannel = SocketChannel.open();
    private INode m_serverNode;
    private volatile boolean m_shutDown = false;

    public ClientMessenger(String host, int port, String name, String mac, IConnectionLogin login) throws IOException, UnknownHostException, CouldNotLogInException {
        this(host, port, name, mac, new DefaultObjectStreamFactory(), login);
    }

    public ClientMessenger(String host, int port, String name, String mac) throws IOException, UnknownHostException, CouldNotLogInException {
        this(host, port, name, mac, new DefaultObjectStreamFactory());
    }

    public ClientMessenger(String host, int port, String name, String mac, IObjectStreamFactory streamFact) throws IOException, UnknownHostException, CouldNotLogInException {
        this(host, port, name, mac, streamFact, null);
    }

    public ClientMessenger(String host, int port, String name, String mac, IObjectStreamFactory streamFact, IConnectionLogin login) throws IOException, UnknownHostException, CouldNotLogInException {
        this.m_socketChannel.configureBlocking(false);
        InetSocketAddress remote = new InetSocketAddress(host, port);
        if (!this.m_socketChannel.connect(remote)) {
            int waitTimeMilliseconds = 0;
            while (true) {
                if (waitTimeMilliseconds > 10000) {
                    this.m_socketChannel.close();
                    throw new IOException("Connection refused");
                }
                if (this.m_socketChannel.finishConnect()) break;
                try {
                    Thread.sleep(50L);
                    waitTimeMilliseconds += 50;
                }
                catch (InterruptedException e) {}
            }
        }
        Socket socket = this.m_socketChannel.socket();
        socket.setKeepAlive(true);
        this.m_socket = new NIOSocket(streamFact, this, name);
        ClientQuarantineConversation conversation = new ClientQuarantineConversation(login, this.m_socketChannel, this.m_socket, name, mac);
        this.m_socket.add(this.m_socketChannel, conversation);
        conversation.showCredentials();
        try {
            this.m_initLatch.await();
        }
        catch (InterruptedException e) {
            this.m_connectionRefusedError = e;
            try {
                this.m_socketChannel.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        if (conversation.getErrorMessage() != null || this.m_connectionRefusedError != null) {
            this.m_socket.shutDown();
            if (conversation.getErrorMessage() != null) {
                login.notifyFailedLogin(conversation.getErrorMessage());
                throw new CouldNotLogInException();
            }
            if (this.m_connectionRefusedError instanceof CouldNotLogInException) {
                throw (CouldNotLogInException)this.m_connectionRefusedError;
            }
            if (this.m_connectionRefusedError != null) {
                throw new IOException(this.m_connectionRefusedError.getMessage());
            }
        }
    }

    @Override
    public synchronized void send(Serializable msg, INode to) {
        MessageHeader header = new MessageHeader(to, this.m_node, msg);
        this.m_socket.send(this.m_socketChannel, header);
    }

    @Override
    public synchronized void broadcast(Serializable msg) {
        MessageHeader header = new MessageHeader(this.m_node, msg);
        this.m_socket.send(this.m_socketChannel, header);
    }

    @Override
    public void addMessageListener(IMessageListener listener) {
        this.m_listeners.add(listener);
    }

    @Override
    public void removeMessageListener(IMessageListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    public void addErrorListener(IMessengerErrorListener listener) {
        this.m_errorListeners.add(listener);
    }

    @Override
    public void removeErrorListener(IMessengerErrorListener listener) {
        this.m_errorListeners.remove(listener);
    }

    @Override
    public boolean isConnected() {
        return this.m_socketChannel.isConnected();
    }

    @Override
    public void shutDown() {
        this.m_shutDown = true;
        this.m_socket.shutDown();
        try {
            this.m_socketChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isShutDown() {
        return this.m_shutDown;
    }

    @Override
    public void messageReceived(MessageHeader msg, SocketChannel channel) {
        if (msg.getFor() != null && !msg.getFor().equals(this.m_node)) {
            throw new IllegalStateException("msg not for me:" + msg);
        }
        for (IMessageListener listener : this.m_listeners) {
            listener.messageReceived(msg.getMessage(), msg.getFrom());
        }
    }

    @Override
    public INode getLocalNode() {
        return this.m_node;
    }

    @Override
    public INode getServerNode() {
        return this.m_serverNode;
    }

    @Override
    public boolean isServer() {
        return false;
    }

    @Override
    public void socketUnqaurantined(SocketChannel channel, QuarantineConversation converstaion2) {
        ClientQuarantineConversation conversation = (ClientQuarantineConversation)converstaion2;
        this.m_node = new Node(conversation.getLocalName(), conversation.getNetworkVisibleSocketAdress());
        this.m_serverNode = new Node(conversation.getServerName(), conversation.getServerLocalAddress());
        this.m_initLatch.countDown();
    }

    @Override
    public void socketError(SocketChannel channel, Exception error) {
        if (this.m_shutDown) {
            return;
        }
        this.m_connectionRefusedError = error;
        for (IMessengerErrorListener errorListener : this.m_errorListeners) {
            errorListener.messengerInvalid(this, error);
        }
        this.shutDown();
        this.m_initLatch.countDown();
    }

    @Override
    public INode getRemoteNode(SocketChannel channel) {
        return this.m_serverNode;
    }

    @Override
    public InetSocketAddress getRemoteServerSocketAddress() {
        return (InetSocketAddress)this.m_socketChannel.socket().getRemoteSocketAddress();
    }

    private void bareBonesSendMessageToServer(String methodName, Object ... messages) {
        ArrayList<Object> args = new ArrayList<Object>();
        Class[] argTypes = new Class[messages.length];
        for (int i = 0; i < messages.length; ++i) {
            Object message = messages[i];
            args.add(message);
            argTypes[i] = args.get(i).getClass();
        }
        RemoteName rn = ServerModel.SERVER_REMOTE_NAME;
        RemoteMethodCall call = new RemoteMethodCall(rn.getName(), methodName, args.toArray(), argTypes, rn.getClazz());
        HubInvoke hubInvoke = new HubInvoke(null, false, call);
        this.send(hubInvoke, this.getServerNode());
    }

    @Override
    public void changeServerGameTo(String gameName) {
        this.bareBonesSendMessageToServer("changeServerGameTo", gameName);
    }

    @Override
    public void changeToLatestAutosave(SaveGameFileChooser.AUTOSAVE_TYPE typeOfAutosave) {
        this.bareBonesSendMessageToServer("changeToLatestAutosave", new Object[]{typeOfAutosave});
    }

    @Override
    public void changeToGameSave(byte[] bytes, String fileName) {
        this.bareBonesSendMessageToServer("changeToGameSave", bytes, fileName);
    }

    @Override
    public void changeToGameSave(File saveGame, String fileName) {
        byte[] bytes = ClientMessenger.getBytesFromFile(saveGame);
        if (bytes == null || bytes.length == 0) {
            return;
        }
        this.changeToGameSave(bytes, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytesFromFile(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            return null;
        }
        byte[] bytes = new byte[(int)length];
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            ((InputStream)is).read(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {}
            }
        }
        return bytes;
    }

    public String toString() {
        return "ClientMessenger LocalNode:" + this.m_node + " ServerNodes:" + this.m_serverNode;
    }
}

