/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.net;

import games.strategy.util.MD5Crypt;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;

public class MacFinder {
    public static void main(String[] args) {
        System.out.println(MacFinder.GetHashedMacAddress());
        System.out.println(MacFinder.tryToParseMACFromOutput("ether 12:34:56:78:89:01 ", Arrays.asList("-", ":", "."), false));
        System.out.println(MacFinder.tryToParseMACFromOutput("ether 0:00:00:00:01:34 ", Arrays.asList("-", ":", "."), true));
        System.out.println(MacFinder.isMacValid("00.00.00.00.00.E0") ? "valid" : "not valid");
        System.out.println(MacFinder.isMacValid("00.00.00.00.00.D0") ? "valid" : "not valid");
        System.out.println(MacFinder.isMacValid("00.1b.63.9f.b4.d3") ? "valid" : "not valid");
        System.out.println(MacFinder.isMacValid("00.60.08.C4.99.AA") ? "valid" : "not valid");
    }

    public static String GetHashedMacAddress() {
        String mac = MacFinder.GetMacAddress();
        if (mac == null) {
            throw new IllegalArgumentException("You have an invalid MAC address! (Or your Java is out of date, or TripleA simply can't find your mac address)");
        }
        return MD5Crypt.crypt(mac, "MH");
    }

    private static String GetMacAddress() {
        String mac;
        String results;
        Method m;
        byte[] rawMac;
        String mac2;
        try {
            InetAddress address = InetAddress.getLocalHost();
            NetworkInterface localHostNI = NetworkInterface.getByInetAddress(address);
            if (localHostNI != null && MacFinder.isMacValid(mac2 = MacFinder.convertMacBytesToString(rawMac = (byte[])(m = NetworkInterface.class.getMethod("getHardwareAddress", new Class[0])).invoke((Object)localHostNI, new Object[0])))) {
                return mac2;
            }
        }
        catch (Throwable ex) {
            System.out.println("Attempting to join the lobby. Lobby detects that your Java is out of date (older than Java 6)! Ignore this message if you join the lobby successfully.");
        }
        try {
            Enumeration<NetworkInterface> niIter = NetworkInterface.getNetworkInterfaces();
            while (niIter.hasMoreElements()) {
                NetworkInterface ni = niIter.nextElement();
                m = NetworkInterface.class.getMethod("getHardwareAddress", new Class[0]);
                rawMac = (byte[])m.invoke((Object)ni, new Object[0]);
                mac2 = MacFinder.convertMacBytesToString(rawMac);
                if (!MacFinder.isMacValid(mac2)) continue;
                return mac2;
            }
        }
        catch (Throwable ex) {
            // empty catch block
        }
        try {
            results = MacFinder.executeCommandAndGetResults("getmac");
            mac = MacFinder.tryToParseMACFromOutput(results, Arrays.asList("-", ":", "."), false);
            if (MacFinder.isMacValid(mac)) {
                return mac;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            results = MacFinder.executeCommandAndGetResults("ipconfig -all");
            mac = MacFinder.tryToParseMACFromOutput(results, Arrays.asList("-", ":", "."), false);
            if (MacFinder.isMacValid(mac)) {
                return mac;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            results = MacFinder.executeCommandAndGetResults("ipconfig /all");
            mac = MacFinder.tryToParseMACFromOutput(results, Arrays.asList("-", ":", "."), false);
            if (MacFinder.isMacValid(mac)) {
                return mac;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            results = MacFinder.executeCommandAndGetResults("ifconfig -a");
            mac = MacFinder.tryToParseMACFromOutput(results, Arrays.asList(":", "-", "."), true);
            if (MacFinder.isMacValid(mac)) {
                return mac;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            results = MacFinder.executeCommandAndGetResults("/sbin/ifconfig -a");
            mac = MacFinder.tryToParseMACFromOutput(results, Arrays.asList(":", "-", "."), true);
            if (MacFinder.isMacValid(mac)) {
                return mac;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            results = MacFinder.executeCommandAndGetResults("dmesg");
            mac = MacFinder.tryToParseMACFromOutput(results, Arrays.asList(":", "-", "."), false);
            if (MacFinder.isMacValid(mac)) {
                return mac;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private static String executeCommandAndGetResults(String command) {
        Process p = null;
        try {
            p = new ProcessBuilder(command).start();
        }
        catch (Exception ex) {
            try {
                p = Runtime.getRuntime().exec(command);
            }
            catch (IOException ex2) {
                // empty catch block
            }
        }
        if (p == null) {
            return null;
        }
        try {
            StringBuilder builder = new StringBuilder();
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    builder.append(line).append("\r\n");
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            in.close();
            return builder.toString();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static String convertMacBytesToString(byte[] mac) {
        if (mac == null) {
            return null;
        }
        StringBuilder macStringBuilder = new StringBuilder();
        for (int i = 0; i < mac.length; ++i) {
            if (i != 0) {
                macStringBuilder.append(".");
            }
            String hex = String.format("%02X", mac[i]);
            macStringBuilder.append(hex);
        }
        return macStringBuilder.toString();
    }

    public static boolean isMacValid(String mac) {
        if (mac == null) {
            return false;
        }
        if (mac.length() != 17) {
            return false;
        }
        if (!mac.contains(".")) {
            return false;
        }
        if (!mac.matches("[0-9A-Fa-f.]+")) {
            return false;
        }
        char[] chars = mac.toCharArray();
        int periodCount = 0;
        int nonZeroNumberCount = 0;
        int i = 1;
        for (char ch : chars) {
            if (ch == '.' && i % 3 != 0) {
                return false;
            }
            if (ch == '.') {
                ++periodCount;
            }
            if (ch != '.' && ch != '0') {
                ++nonZeroNumberCount;
            }
            ++i;
        }
        if (periodCount != 5) {
            return false;
        }
        if (nonZeroNumberCount == 0) {
            return false;
        }
        return !mac.equals("00.00.00.00.00.E0");
    }

    private static String tryToParseMACFromOutput(String output, List<String> possibleSeparators, boolean allowAppendedZeroCheck) {
        if (output == null || output.trim().length() < 6) {
            return null;
        }
        for (String separator : possibleSeparators) {
            int macStartIndex;
            for (String leftToSearch = output; leftToSearch != null && leftToSearch.length() > 0 && leftToSearch.contains(separator); leftToSearch = leftToSearch.substring(Math.min(macStartIndex + 1, leftToSearch.length()))) {
                macStartIndex = Math.max(0, leftToSearch.indexOf(separator) - 2);
                String rawMac = leftToSearch.substring(macStartIndex, Math.min(macStartIndex + 17, leftToSearch.length()));
                if (rawMac == null || rawMac.length() <= 0) continue;
                String mac = rawMac.replace(separator, ".");
                if (MacFinder.isMacValid(mac)) {
                    return mac;
                }
                if (!allowAppendedZeroCheck || !rawMac.substring(2, 3).equals(separator)) continue;
                macStartIndex = Math.max(0, leftToSearch.indexOf(separator) - 1);
                rawMac = "0" + leftToSearch.substring(macStartIndex, Math.min(macStartIndex + 16, leftToSearch.length()));
                mac = rawMac.replace(separator, ".");
                if (!MacFinder.isMacValid(mac)) continue;
                return mac;
            }
        }
        return null;
    }
}

