/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.net;

import games.strategy.net.ILoginValidator;
import games.strategy.net.MacFinder;
import games.strategy.net.ServerMessenger;
import games.strategy.net.SocketStreams;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class ServerLoginHelper {
    private static final Logger s_logger = Logger.getLogger(ServerLoginHelper.class.getName());
    private final SocketAddress m_remoteAddress;
    private final ILoginValidator m_loginValidator;
    private final SocketStreams m_streams;
    private String m_clientName;
    private final ServerMessenger m_serverMessenger;

    public ServerLoginHelper(SocketAddress remoteAddress, ILoginValidator loginValidator, SocketStreams streams, ServerMessenger messenger) {
        this.m_remoteAddress = remoteAddress;
        this.m_loginValidator = loginValidator;
        this.m_streams = streams;
        this.m_serverMessenger = messenger;
    }

    public boolean canConnect() {
        try {
            ObjectOutputStream out = new ObjectOutputStream(this.m_streams.getBufferedOut());
            out.flush();
            ObjectInputStream in = new ObjectInputStream(this.m_streams.getBufferedIn());
            this.m_clientName = (String)in.readObject();
            if (this.m_loginValidator == null) {
                out.writeObject(null);
                out.flush();
                String read = (String)in.readObject();
                if (read != null) {
                    throw new IllegalArgumentException("something non null read in response to null challenge " + read);
                }
                System.out.println("Server done");
                return true;
            }
            Map<String, String> challenge = this.m_loginValidator.getChallengeProperties(this.m_clientName, this.m_remoteAddress);
            if (challenge == null) {
                throw new IllegalStateException("Challenge can't be null");
            }
            out.writeObject(challenge);
            out.flush();
            Map credentials = (Map)in.readObject();
            Set entries = credentials.entrySet();
            for (Map.Entry entry : entries) {
                if (entry.getKey() instanceof String || entry.getValue() instanceof String) continue;
                throw new IllegalStateException("Value must be a String");
            }
            String mac = MacFinder.GetHashedMacAddress();
            String error = this.m_loginValidator.verifyConnection(challenge, credentials, this.m_clientName, mac, this.m_remoteAddress);
            if (error == null) {
                out.writeObject(null);
                this.m_clientName = this.m_serverMessenger.getUniqueName(this.m_clientName);
                out.writeObject(this.m_clientName);
                out.flush();
                return true;
            }
            out.writeObject(error);
            out.flush();
            return false;
        }
        catch (Exception e) {
            s_logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    public String getClientName() {
        return this.m_clientName;
    }
}

