/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.net;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sbbi.upnp.impls.InternetGatewayDevice;
import net.sbbi.upnp.messages.UPNPResponseException;

public class UniversalPlugAndPlayHelper {
    private int m_port = 3300;
    private InetAddress m_local = null;
    private InternetGatewayDevice m_device = null;
    private static UniversalPlugAndPlayHelper s_lastInstance = null;

    public static void main(String[] args) {
        UniversalPlugAndPlayHelper.attemptAddingPortForwarding(null, 3300);
    }

    public UniversalPlugAndPlayHelper(int port) {
        this.m_port = port;
    }

    public static UniversalPlugAndPlayHelper getLastInstance() {
        return s_lastInstance;
    }

    public static boolean attemptAddingPortForwarding(Component parent, int port) {
        UniversalPlugAndPlayHelper upnpHelper = new UniversalPlugAndPlayHelper(port);
        JTextArea textArea = new JTextArea();
        textArea.setEditable(false);
        String error = upnpHelper.attemptAddingPortForwarding(textArea);
        textArea.append("\r\n \r\n \r\n \r\n");
        boolean worked = error == null;
        String textResult = worked ? "It looks like it worked.  This program will close now.\r\nPlease try hosting again, to see if it 'really' worked.\r\nRemember that your firewall must allow TripleA, or else you still won't be able to host.\r\n" : "It appears TripleA failed to set your Port Forwarding.\r\nPlease make sure UPnP is turned on, in your router's settings.\r\n\r\nIf you still can not get TripleA to set them correctly, then you must set them yourself!\r\nSee 'How To Host...' in the help menu, at the top of the lobby screen in order to manually set them.\r\n\r\n\r\nThis program will close now.\r\n";
        System.out.println(textResult);
        textArea.append(textResult);
        JOptionPane.showMessageDialog(parent, new JScrollPane(textArea), "Setting Port Forwarding with UPnP", 1);
        return worked;
    }

    public String attemptAddingPortForwarding(JTextArea textArea) {
        System.out.println("Starting Universal Plug and Play (UPnP) add port forward map script.");
        textArea.append("Starting Universal Plug and Play (UPnP) add port forward map script.\r\n");
        String localError = this.findLocalInetAddress();
        if (localError != null) {
            textArea.append(localError + "\r\n");
            return localError;
        }
        textArea.append("Found Local IP/Inet Address to use: " + this.m_local + "\r\n");
        String gatewayError = this.findInternetGatewayDevice();
        if (gatewayError != null) {
            textArea.append(gatewayError + "\r\n");
            return gatewayError;
        }
        textArea.append("Internet Gateway Device (normally a router) found!\r\n");
        String addPortError = this.addPortForwardUPNP();
        if (addPortError != null) {
            textArea.append(addPortError + "\r\n");
            return addPortError;
        }
        textArea.append("Port Forwarding map added successfully.\r\n");
        s_lastInstance = this;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String testConnection() {
        System.out.println("Waiting for a connection");
        int internalPort = this.m_port;
        boolean connection = false;
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(internalPort);
            ss.setSoTimeout(5000);
            try {
                Socket s = ss.accept();
                connection = true;
                InputStream in = s.getInputStream();
                while (in.available() > 0) {
                    System.out.println("byte : " + in.read());
                }
            }
            catch (SocketTimeoutException stoe) {
                String string;
                try {
                    System.out.println("Connection Test Timed Out. Port Forward may still work anyway.");
                    string = "Connection Test Timed Out. Port Forward may still work anyway.";
                }
                catch (Throwable throwable) {
                    try {
                        ss.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        System.out.println("Connection Test Timed Out. Port Forward may still work anyway. \r\n " + e.getMessage());
                        String string2 = "Connection Test Timed Out. Port Forward may still work anyway. \r\n " + e.getMessage();
                        return string2;
                    }
                    finally {
                    }
                }
                ss.close();
                if (ss != null) {
                    try {
                        ss.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return string;
            }
            ss.close();
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (!connection) {
            System.out.println("Connection Test Timed Out. Port Forward may still work anyway.");
            return "Connection Test Timed Out. Port Forward may still work anyway.";
        }
        System.out.println("Connection made!");
        return null;
    }

    public String removePortForwardUPNP() {
        System.out.println("Attempting to remove Port Forwarding");
        int externalPort = this.m_port;
        boolean removed = false;
        try {
            removed = this.m_device.deletePortMapping(null, externalPort, "TCP");
        }
        catch (IOException e) {
            System.out.println("Failed to remove port mapping! \r\n " + e.getMessage());
            return "Failed to remove port mapping! \r\n " + e.getMessage();
        }
        catch (UPNPResponseException e) {
            System.out.println("Failed to remove port mapping! \r\n " + e.getMessage());
            return "Failed to remove port mapping! \r\n " + e.getMessage();
        }
        if (!removed) {
            System.out.println("Failed to remove port mapping!");
            return "Failed to remove port mapping!";
        }
        System.out.println("Success. Port Forwarding map removed.");
        return null;
    }

    private String addPortForwardUPNP() {
        int internalPort = this.m_port;
        int externalPort = this.m_port;
        System.out.print("Adding mapping from ");
        try {
            System.out.print(this.m_device.getExternalIPAddress());
        }
        catch (UPNPResponseException e1) {
        }
        catch (IOException e1) {
            // empty catch block
        }
        System.out.println(":" + externalPort);
        System.out.println("To " + this.m_local.getHostAddress() + ":" + internalPort);
        boolean mapped = false;
        try {
            mapped = this.m_device.addPortMapping("TripleA Game Hosting", "TCP", null, externalPort, this.m_local.getHostAddress(), internalPort, 0);
        }
        catch (IOException e) {
            System.out.println("Port Mapping Failed! Please try to Forward Ports manually! \r\n " + e.getMessage());
            return "Port Mapping Failed! Please try to Forward Ports manually! \r\n " + e.getMessage();
        }
        catch (UPNPResponseException e) {
            System.out.println("Port Mapping Failed! Please try to Forward Ports manually! \r\n " + e.getMessage());
            return "Port Mapping Failed! Please try to Forward Ports manually! \r\n " + e.getMessage();
        }
        if (!mapped) {
            System.out.println("Port Mapping Failed! Please try to Forward Ports manually!");
            return "Port Mapping Failed! Please try to Forward Ports manually!";
        }
        System.out.println("Success. Port Forwarding map added.");
        return null;
    }

    private String findInternetGatewayDevice() {
        System.out.println("Attempting to find internet gateway device (normally a router).");
        InternetGatewayDevice[] devices = null;
        try {
            devices = InternetGatewayDevice.getDevices(2000);
        }
        catch (IOException e) {
            System.out.println("Router/Device UPnP turned off. Or no Routers/Devices found.  Please make sure your router's UPNP is turned on! \r\n " + e.getMessage());
            return "Router/Device UPnP turned off. Or no Routers/Devices found.  Please make sure your router's UPNP is turned on! \r\n " + e.getMessage();
        }
        if (devices == null || 1 > devices.length) {
            System.out.println("Router/Device UPnP turned off. Or no Routers/Devices found.  Please make sure your router's UPNP is turned on!");
            return "Router/Device UPnP turned off. Or no Routers/Devices found.  Please make sure your router's UPNP is turned on!";
        }
        this.m_device = devices[0];
        System.out.println("Device found!");
        return null;
    }

    private String findLocalInetAddress() {
        this.m_local = null;
        System.out.println("Attempting to find local ip/inet address.");
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements() && this.m_local == null) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements() && this.m_local == null) {
                    InetAddress addr = addresses.nextElement();
                    if (!(addr instanceof Inet4Address) || addr.isLoopbackAddress()) continue;
                    this.m_local = addr;
                }
            }
        }
        catch (SocketException e) {
            this.m_local = null;
            System.out.println("Could not determine local ip/inet address!");
            return "Could not determine local ip/inet address! \r\n " + e.getMessage();
        }
        if (this.m_local == null) {
            System.out.println("Could not determine local ip/inet address!");
            return "Could not determine local ip/inet address!";
        }
        System.out.println("Local Address to use: " + this.m_local);
        return null;
    }
}

