/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.net.nio;

import games.strategy.net.IConnectionLogin;
import games.strategy.net.MessageHeader;
import games.strategy.net.Node;
import games.strategy.net.nio.NIOSocket;
import games.strategy.net.nio.QuarantineConversation;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClientQuarantineConversation
extends QuarantineConversation {
    private static final Logger s_logger = Logger.getLogger(ClientQuarantineConversation.class.getName());
    private final IConnectionLogin m_login;
    private final SocketChannel m_channel;
    private final NIOSocket m_socket;
    private STEP m_step = STEP.READ_CHALLENGE;
    private String m_localName;
    private final String m_macAddress;
    private String m_serverName;
    private InetSocketAddress m_networkVisibleAddress;
    private InetSocketAddress m_serverLocalAddress;
    private Map<String, String> m_challengeProperties;
    private Map<String, String> m_challengeResponse;
    private final CountDownLatch m_showLatch = new CountDownLatch(1);
    private final CountDownLatch m_doneShowLatch = new CountDownLatch(1);
    private volatile boolean m_closed = false;
    private volatile String m_errorMessage;

    public ClientQuarantineConversation(IConnectionLogin login, SocketChannel channel, NIOSocket socket, String localName, String mac) {
        this.m_login = login;
        this.m_localName = localName;
        this.m_macAddress = mac;
        this.m_socket = socket;
        this.m_channel = channel;
        this.send((Serializable)((Object)this.m_localName));
        this.send((Serializable)((Object)this.m_macAddress));
    }

    public String getLocalName() {
        return this.m_localName;
    }

    public String getMacAddress() {
        return this.m_macAddress;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    public String getServerName() {
        return this.m_serverName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showCredentials() {
        try {
            this.m_showLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.m_login != null && this.m_challengeProperties != null) {
            try {
                if (this.m_closed) {
                    return;
                }
                this.m_challengeResponse = this.m_login.getProperties(this.m_challengeProperties);
            }
            finally {
                this.m_doneShowLatch.countDown();
            }
        }
    }

    @Override
    public QuarantineConversation.ACTION message(Object o) {
        try {
            switch (this.m_step) {
                case READ_CHALLENGE: {
                    Map challenge = (Map)o;
                    if (s_logger.isLoggable(Level.FINER)) {
                        s_logger.log(Level.FINER, "read challenge:" + challenge);
                    }
                    if (challenge != null) {
                        this.m_challengeProperties = challenge;
                        this.m_showLatch.countDown();
                        try {
                            this.m_doneShowLatch.await();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (this.m_closed) {
                            return QuarantineConversation.ACTION.NONE;
                        }
                        if (s_logger.isLoggable(Level.FINER)) {
                            s_logger.log(Level.FINER, "writing response" + this.m_challengeResponse);
                        }
                        this.send((Serializable)((Object)this.m_challengeResponse));
                    } else {
                        this.m_showLatch.countDown();
                        if (s_logger.isLoggable(Level.FINER)) {
                            s_logger.log(Level.FINER, "sending null response");
                        }
                        this.send(null);
                    }
                    this.m_step = STEP.READ_ERROR;
                    return QuarantineConversation.ACTION.NONE;
                }
                case READ_ERROR: {
                    if (o != null) {
                        if (s_logger.isLoggable(Level.FINER)) {
                            s_logger.log(Level.FINER, "error:" + o);
                        }
                        this.m_errorMessage = (String)o;
                        this.send(null);
                        return QuarantineConversation.ACTION.TERMINATE;
                    }
                    this.m_step = STEP.READ_NAMES;
                    return QuarantineConversation.ACTION.NONE;
                }
                case READ_NAMES: {
                    String[] strings = (String[])o;
                    if (s_logger.isLoggable(Level.FINER)) {
                        s_logger.log(Level.FINER, "new local name:" + strings[0]);
                    }
                    this.m_localName = strings[0];
                    this.m_serverName = strings[1];
                    this.m_step = STEP.READ_ADDRESS;
                    return QuarantineConversation.ACTION.NONE;
                }
                case READ_ADDRESS: {
                    InetSocketAddress[] address = (InetSocketAddress[])o;
                    this.m_networkVisibleAddress = address[0];
                    this.m_serverLocalAddress = address[1];
                    if (s_logger.isLoggable(Level.FINE)) {
                        s_logger.log(Level.FINE, "Server local address:" + this.m_serverLocalAddress);
                        s_logger.log(Level.FINE, "channel remote address:" + this.m_channel.socket().getRemoteSocketAddress());
                        s_logger.log(Level.FINE, "network visible address:" + this.m_networkVisibleAddress);
                        s_logger.log(Level.FINE, "channel local adresss:" + this.m_channel.socket().getLocalSocketAddress());
                    }
                    return QuarantineConversation.ACTION.UNQUARANTINE;
                }
            }
            throw new IllegalStateException("Invalid state");
        }
        catch (Throwable t) {
            this.m_closed = true;
            this.m_showLatch.countDown();
            this.m_doneShowLatch.countDown();
            s_logger.log(Level.SEVERE, "error with connection", t);
            return QuarantineConversation.ACTION.TERMINATE;
        }
    }

    private void send(Serializable object) {
        MessageHeader header = new MessageHeader(Node.NULL_NODE, Node.NULL_NODE, object);
        this.m_socket.send(this.m_channel, header);
    }

    public InetSocketAddress getNetworkVisibleSocketAdress() {
        return this.m_networkVisibleAddress;
    }

    public InetSocketAddress getServerLocalAddress() {
        return this.m_serverLocalAddress;
    }

    @Override
    public void close() {
        this.m_closed = true;
        this.m_showLatch.countDown();
        this.m_doneShowLatch.countDown();
    }

    private static enum STEP {
        READ_CHALLENGE,
        READ_ERROR,
        READ_NAMES,
        READ_ADDRESS;

    }
}

