/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.net.nio;

import games.strategy.engine.message.HubInvocationResults;
import games.strategy.engine.message.HubInvoke;
import games.strategy.engine.message.SpokeInvocationResults;
import games.strategy.engine.message.SpokeInvoke;
import games.strategy.net.CouldNotLogInException;
import games.strategy.net.INode;
import games.strategy.net.IObjectStreamFactory;
import games.strategy.net.MessageHeader;
import games.strategy.net.Node;
import games.strategy.net.nio.IErrorReporter;
import games.strategy.net.nio.NIOReader;
import games.strategy.net.nio.NIOSocket;
import games.strategy.net.nio.QuarantineConversation;
import games.strategy.net.nio.SocketReadData;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Decoder {
    private static final Logger s_logger = Logger.getLogger(Decoder.class.getName());
    private final NIOReader m_reader;
    private volatile boolean m_running = true;
    private final IErrorReporter m_errorReporter;
    private final IObjectStreamFactory m_objectStreamFactory;
    private final NIOSocket m_nioSocket;
    private final ConcurrentHashMap<SocketChannel, QuarantineConversation> m_quarantine = new ConcurrentHashMap();
    private final Thread m_thread;

    public Decoder(NIOSocket nioSocket, NIOReader reader, IErrorReporter reporter, IObjectStreamFactory objectStreamFactory, String threadSuffix) {
        this.m_reader = reader;
        this.m_errorReporter = reporter;
        this.m_objectStreamFactory = objectStreamFactory;
        this.m_nioSocket = nioSocket;
        this.m_thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Decoder.this.loop();
            }
        }, "Decoder -" + threadSuffix);
        this.m_thread.start();
    }

    public void shutDown() {
        this.m_running = false;
        this.m_thread.interrupt();
    }

    private void loop() {
        while (this.m_running) {
            try {
                SocketReadData data;
                try {
                    data = this.m_reader.take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                if (data == null || !this.m_running) continue;
                if (s_logger.isLoggable(Level.FINEST)) {
                    s_logger.finest("Decoding packet:" + data);
                }
                ByteArrayInputStream stream = new ByteArrayInputStream(data.getData());
                try {
                    MessageHeader header = this.readMessageHeader(data.getChannel(), this.m_objectStreamFactory.create(stream));
                    if (s_logger.isLoggable(Level.FINEST)) {
                        s_logger.log(Level.FINEST, "header decoded:" + header);
                    }
                    Socket s = data.getChannel().socket();
                    if (!this.m_running || s == null || s.isInputShutdown()) continue;
                    QuarantineConversation converstation = this.m_quarantine.get(data.getChannel());
                    if (converstation != null) {
                        this.sendQuarantine(data.getChannel(), converstation, header);
                        continue;
                    }
                    if (this.m_nioSocket.getLocalNode() == null) {
                        throw new IllegalStateException("we are writing messages, but no local node");
                    }
                    if (header.getFrom() == null) {
                        throw new IllegalArgumentException("Null from:" + header);
                    }
                    if (s_logger.isLoggable(Level.FINER)) {
                        s_logger.log(Level.FINER, "decoded  msg:" + header.getMessage() + " size:" + data.size());
                    }
                    this.m_nioSocket.messageReceived(header, data.getChannel());
                }
                catch (Exception ioe) {
                    s_logger.log(Level.SEVERE, "error reading object", ioe);
                    this.m_errorReporter.error(data.getChannel(), ioe);
                }
            }
            catch (Exception e) {
                s_logger.log(Level.WARNING, "error in decoder", e);
            }
        }
    }

    private void sendQuarantine(SocketChannel channel, QuarantineConversation conversation, MessageHeader header) {
        QuarantineConversation.ACTION a = conversation.message(header.getMessage());
        if (a == QuarantineConversation.ACTION.TERMINATE) {
            if (s_logger.isLoggable(Level.FINER)) {
                s_logger.log(Level.FINER, "Terminating quarantined connection to:" + channel.socket().getRemoteSocketAddress());
            }
            conversation.close();
            this.m_errorReporter.error(channel, new CouldNotLogInException());
        } else if (a == QuarantineConversation.ACTION.UNQUARANTINE) {
            if (s_logger.isLoggable(Level.FINER)) {
                s_logger.log(Level.FINER, "Accepting quarantined connection to:" + channel.socket().getRemoteSocketAddress());
            }
            this.m_nioSocket.unquarantine(channel, conversation);
            this.m_quarantine.remove(channel);
        }
    }

    private MessageHeader readMessageHeader(SocketChannel channel, ObjectInputStream objectInput) throws IOException, ClassNotFoundException {
        Serializable message;
        INode from;
        INode to;
        if (objectInput.read() == 1) {
            to = null;
        } else if (objectInput.read() == 1) {
            to = this.m_nioSocket.getLocalNode();
        } else {
            to = new Node();
            ((Node)to).readExternal(objectInput);
        }
        int readMark = objectInput.read();
        if (readMark == 1) {
            from = this.m_nioSocket.getRemoteNode(channel);
        } else if (readMark == 2) {
            from = null;
        } else {
            from = new Node();
            ((Node)from).readExternal(objectInput);
        }
        byte type = (byte)objectInput.read();
        if (type != 127) {
            Externalizable template = Decoder.getTemplate(type);
            template.readExternal(objectInput);
            message = template;
        } else {
            message = (Serializable)objectInput.readObject();
        }
        return new MessageHeader(to, from, message);
    }

    public static Externalizable getTemplate(byte type) {
        switch (type) {
            case 1: {
                return new HubInvoke();
            }
            case 2: {
                return new SpokeInvoke();
            }
            case 3: {
                return new HubInvocationResults();
            }
            case 4: {
                return new SpokeInvocationResults();
            }
        }
        throw new IllegalStateException("not recognized, " + type);
    }

    public static byte getType(Object msg) {
        if (msg instanceof HubInvoke) {
            return 1;
        }
        if (msg instanceof SpokeInvoke) {
            return 2;
        }
        if (msg instanceof HubInvocationResults) {
            return 3;
        }
        if (msg instanceof SpokeInvocationResults) {
            return 4;
        }
        return 127;
    }

    public void add(SocketChannel channel, QuarantineConversation conversation) {
        this.m_quarantine.put(channel, conversation);
    }

    public void closed(SocketChannel channel) {
        QuarantineConversation conversation = this.m_quarantine.remove(channel);
        if (conversation != null) {
            conversation.close();
        }
    }
}

