/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.net.nio;

import games.strategy.net.IObjectStreamFactory;
import games.strategy.net.MessageHeader;
import games.strategy.net.Node;
import games.strategy.net.nio.ByteArrayOutputStream2;
import games.strategy.net.nio.Decoder;
import games.strategy.net.nio.NIOSocket;
import games.strategy.net.nio.NIOWriter;
import games.strategy.net.nio.SocketWriteData;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Encoder {
    private static final Logger s_logger = Logger.getLogger(Encoder.class.getName());
    private final NIOWriter m_writer;
    private final IObjectStreamFactory m_objectStreamFactory;
    private final NIOSocket m_nioSocket;

    public Encoder(NIOSocket nioSocket, NIOWriter writer, IObjectStreamFactory objectStreamFactory) {
        this.m_nioSocket = nioSocket;
        this.m_writer = writer;
        this.m_objectStreamFactory = objectStreamFactory;
    }

    public void write(SocketChannel to, MessageHeader header) {
        SocketWriteData data;
        if (s_logger.isLoggable(Level.FINEST)) {
            s_logger.log(Level.FINEST, "Encoding msg:" + header + " to:" + to);
        }
        if (header.getFrom() == null) {
            throw new IllegalArgumentException("No from node");
        }
        if (to == null) {
            throw new IllegalArgumentException("No to channel!");
        }
        ByteArrayOutputStream2 sink = new ByteArrayOutputStream2(512);
        try {
            this.write(header, this.m_objectStreamFactory.create(sink), to);
            data = new SocketWriteData(sink.getBuffer(), sink.size());
        }
        catch (Exception e) {
            s_logger.log(Level.SEVERE, "Error writing object:" + header, e);
            return;
        }
        if (s_logger.isLoggable(Level.FINER)) {
            s_logger.log(Level.FINER, "encoded  msg:" + header.getMessage() + " size:" + data.size());
        }
        this.m_writer.enque(data, to);
    }

    private void write(MessageHeader header, ObjectOutputStream out, SocketChannel remote) throws IOException {
        if (header.getFrom() == null) {
            throw new IllegalArgumentException("null from");
        }
        if (header.getFor() == null) {
            out.write(1);
        } else {
            out.write(0);
            if (header.getFor().equals(this.m_nioSocket.getRemoteNode(remote))) {
                out.write(1);
            } else {
                out.write(0);
                ((Node)header.getFor()).writeExternal(out);
            }
        }
        if (header.getFrom().equals(this.m_nioSocket.getLocalNode())) {
            out.write(1);
        } else if (this.m_nioSocket.getLocalNode() == null) {
            out.write(2);
        } else {
            out.write(0);
            ((Node)header.getFrom()).writeExternal(out);
        }
        byte type = Decoder.getType(header.getMessage());
        out.write(type);
        if (type != 127) {
            ((Externalizable)header.getMessage()).writeExternal(out);
        } else {
            out.writeObject(header.getMessage());
        }
        out.reset();
    }
}

