/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.net.nio;

import games.strategy.net.INode;
import games.strategy.net.IObjectStreamFactory;
import games.strategy.net.MessageHeader;
import games.strategy.net.nio.Decoder;
import games.strategy.net.nio.Encoder;
import games.strategy.net.nio.IErrorReporter;
import games.strategy.net.nio.NIOReader;
import games.strategy.net.nio.NIOSocketListener;
import games.strategy.net.nio.NIOWriter;
import games.strategy.net.nio.QuarantineConversation;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NIOSocket
implements IErrorReporter {
    private static final Logger s_logger = Logger.getLogger(NIOSocket.class.getName());
    private final Encoder m_encoder;
    private final Decoder m_decoder;
    private final NIOWriter m_writer;
    private final NIOReader m_reader;
    private final NIOSocketListener m_listener;

    public NIOSocket(IObjectStreamFactory factory, NIOSocketListener listener, String name) {
        this.m_listener = listener;
        this.m_writer = new NIOWriter(this, name);
        this.m_reader = new NIOReader(this, name);
        this.m_decoder = new Decoder(this, this.m_reader, this, factory, name);
        this.m_encoder = new Encoder(this, this.m_writer, factory);
    }

    INode getLocalNode() {
        return this.m_listener.getLocalNode();
    }

    INode getRemoteNode(SocketChannel channel) {
        return this.m_listener.getRemoteNode(channel);
    }

    public void shutDown() {
        this.m_writer.shutDown();
        this.m_reader.shutDown();
        this.m_decoder.shutDown();
    }

    public void send(SocketChannel to, MessageHeader header) {
        if (to == null) {
            throw new IllegalArgumentException("to cant be null!");
        }
        if (header == null) {
            throw new IllegalArgumentException("header cant be null");
        }
        this.m_encoder.write(to, header);
    }

    public void add(SocketChannel channel, QuarantineConversation conversation) {
        if (channel.isBlocking()) {
            throw new IllegalArgumentException("Channel is blocking");
        }
        this.m_decoder.add(channel, conversation);
        this.m_reader.add(channel);
    }

    void unquarantine(SocketChannel channel, QuarantineConversation conversation) {
        this.m_listener.socketUnqaurantined(channel, conversation);
    }

    @Override
    public void error(SocketChannel channel, Exception e) {
        this.close(channel);
        this.m_listener.socketError(channel, e);
    }

    public void close(SocketChannel channel) {
        try {
            Socket s = channel.socket();
            if (!s.isInputShutdown()) {
                s.shutdownInput();
            }
            if (!s.isOutputShutdown()) {
                s.shutdownOutput();
            }
            if (!s.isClosed()) {
                s.close();
            }
            channel.close();
        }
        catch (IOException e1) {
            s_logger.log(Level.FINE, "error closing channel", e1);
        }
        this.m_decoder.closed(channel);
        this.m_writer.closed(channel);
        this.m_reader.closed(channel);
    }

    void messageReceived(MessageHeader header, SocketChannel channel) {
        this.m_listener.messageReceived(header, channel);
    }
}

