/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.net.nio;

import games.strategy.net.nio.IErrorReporter;
import games.strategy.net.nio.SocketWriteData;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NIOWriter {
    private static final Logger s_logger = Logger.getLogger(NIOWriter.class.getName());
    private final Selector m_selector;
    private final IErrorReporter m_errorReporter;
    private final Map<SocketChannel, List<SocketWriteData>> m_writing = new HashMap<SocketChannel, List<SocketWriteData>>();
    private List<SocketChannel> m_socketsToWake = new ArrayList<SocketChannel>();
    private final Object m_mutex = new Object();
    private long m_totalBytes = 0L;
    private volatile boolean m_running = true;

    public NIOWriter(IErrorReporter reporter, String threadSuffix) {
        this.m_errorReporter = reporter;
        try {
            this.m_selector = Selector.open();
        }
        catch (IOException e) {
            s_logger.log(Level.SEVERE, "Could not create Selector", e);
            throw new IllegalStateException(e);
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                NIOWriter.this.loop();
            }
        }, "NIO Writer - " + threadSuffix);
        t.start();
    }

    public void shutDown() {
        this.m_running = false;
        try {
            this.m_selector.close();
        }
        catch (IOException e) {
            s_logger.log(Level.WARNING, "error closing selector", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewSocketsToSelector() {
        List<SocketChannel> socketsToWriteCopy;
        Object object = this.m_mutex;
        synchronized (object) {
            if (this.m_socketsToWake.isEmpty()) {
                return;
            }
            socketsToWriteCopy = this.m_socketsToWake;
            this.m_socketsToWake = new ArrayList<SocketChannel>();
        }
        for (SocketChannel channel : socketsToWriteCopy) {
            try {
                channel.register(this.m_selector, 4);
            }
            catch (ClosedChannelException e) {
                s_logger.log(Level.FINEST, "socket already closed", e);
            }
        }
    }

    private void loop() {
        while (this.m_running) {
            try {
                if (s_logger.isLoggable(Level.FINEST)) {
                    s_logger.finest("selecting...");
                }
                try {
                    this.m_selector.select();
                }
                catch (Exception e) {
                    s_logger.log(Level.INFO, "error reading selection", e);
                }
                if (!this.m_running) continue;
                this.addNewSocketsToSelector();
                Set<SelectionKey> selected = this.m_selector.selectedKeys();
                if (s_logger.isLoggable(Level.FINEST)) {
                    s_logger.finest("selected:" + selected.size());
                }
                Iterator<SelectionKey> iter = selected.iterator();
                while (iter.hasNext()) {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (!key.isValid() || !key.isWritable()) continue;
                    SocketChannel channel = (SocketChannel)key.channel();
                    SocketWriteData packet = this.getData(channel);
                    if (packet != null) {
                        try {
                            boolean done;
                            if (s_logger.isLoggable(Level.FINEST)) {
                                s_logger.finest("writing packet:" + packet + " to:" + channel.socket().getRemoteSocketAddress());
                            }
                            if (!(done = packet.write(channel))) continue;
                            this.m_totalBytes += (long)packet.size();
                            if (s_logger.isLoggable(Level.FINE)) {
                                String remote = "null";
                                Socket s = channel.socket();
                                SocketAddress sa = null;
                                if (s != null) {
                                    sa = s.getRemoteSocketAddress();
                                }
                                if (sa != null) {
                                    remote = sa.toString();
                                }
                                s_logger.log(Level.FINE, " done writing to:" + remote + " size:" + packet.size() + " writeCalls;" + packet.getWriteCalls() + " total:" + this.m_totalBytes);
                            }
                            this.removeLast(channel);
                        }
                        catch (Exception e) {
                            s_logger.log(Level.FINER, "exception writing", e);
                            this.m_errorReporter.error(channel, e);
                            key.cancel();
                        }
                        continue;
                    }
                    key.cancel();
                }
            }
            catch (Exception e) {
                s_logger.log(Level.WARNING, "error in writer", e);
            }
        }
    }

    public void closed(SocketChannel channel) {
        this.removeAll(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAll(SocketChannel to) {
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_writing.remove(to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLast(SocketChannel to) {
        Object object = this.m_mutex;
        synchronized (object) {
            List<SocketWriteData> values = this.m_writing.get(to);
            if (values == null) {
                s_logger.log(Level.SEVERE, "NO socket data to:" + to + " all:" + values);
                return;
            }
            values.remove(0);
            if (values.isEmpty()) {
                this.m_writing.remove(to);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketWriteData getData(SocketChannel to) {
        Object object = this.m_mutex;
        synchronized (object) {
            if (!this.m_writing.containsKey(to)) {
                return null;
            }
            List<SocketWriteData> values = this.m_writing.get(to);
            if (values.isEmpty()) {
                return null;
            }
            return values.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enque(SocketWriteData data, SocketChannel channel) {
        Object object = this.m_mutex;
        synchronized (object) {
            if (!this.m_running) {
                return;
            }
            if (this.m_writing.containsKey(channel)) {
                this.m_writing.get(channel).add(data);
            } else {
                ArrayList<SocketWriteData> values = new ArrayList<SocketWriteData>();
                values.add(data);
                this.m_writing.put(channel, values);
                this.m_socketsToWake.add(channel);
                this.m_selector.wakeup();
            }
        }
    }
}

