/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.net.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SocketWriteData {
    private static final Logger s_logger = Logger.getLogger(SocketWriteData.class.getName());
    private static final AtomicInteger s_counter = new AtomicInteger();
    private final ByteBuffer m_size;
    private final ByteBuffer m_content;
    private final int m_number = s_counter.incrementAndGet();
    private int m_writeCalls = 0;

    public SocketWriteData(byte[] data, int count) {
        this.m_content = ByteBuffer.allocate(count);
        this.m_content.put(data, 0, count);
        this.m_size = ByteBuffer.allocate(4);
        if (count < 0 || count > 10000000) {
            throw new IllegalStateException("Invalid message size:" + count);
        }
        this.m_size.putInt(count ^= 0x9B000000);
        this.m_size.flip();
        this.m_content.flip();
    }

    public int size() {
        return this.m_size.capacity() + this.m_content.capacity();
    }

    public int getWriteCalls() {
        return this.m_writeCalls;
    }

    public boolean write(SocketChannel channel) throws IOException {
        int count;
        ++this.m_writeCalls;
        if (this.m_size.hasRemaining()) {
            count = channel.write(this.m_size);
            if (count == -1) {
                throw new IOException("triplea: end of stream detected");
            }
            if (s_logger.isLoggable(Level.FINEST)) {
                s_logger.finest("wrote size_buffer bytes:" + count);
            }
            if (this.m_size.hasRemaining()) {
                return false;
            }
        }
        if ((count = channel.write(this.m_content)) == -1) {
            throw new IOException("triplea: end of stream detected");
        }
        if (s_logger.isLoggable(Level.FINEST)) {
            s_logger.finest("wrote content bytes:" + count);
        }
        return !this.m_content.hasRemaining();
    }

    public String toString() {
        return "<id:" + this.m_number + " size:" + this.m_content.capacity() + ">";
    }
}

