/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.sound;

import games.strategy.sound.ClipPlayer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.sound.sampled.Clip;

class ClipCache {
    private final HashMap<URL, Clip> m_clipMap = new HashMap();
    private final List<URL> m_cacheOrder = new ArrayList<URL>();
    private final int MAXSIZE;

    ClipCache(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("ClipCache max must be at least 1");
        }
        this.MAXSIZE = max;
    }

    public synchronized Clip get(URL file) {
        Clip clip = this.m_clipMap.get(file);
        if (clip != null) {
            this.m_cacheOrder.remove(file);
            this.m_cacheOrder.add(file);
            return clip;
        }
        if (this.m_clipMap.size() >= this.MAXSIZE) {
            URL leastPlayed = this.m_cacheOrder.get(0);
            Clip leastClip = this.m_clipMap.remove(leastPlayed);
            leastClip.stop();
            leastClip.flush();
            leastClip.close();
            this.m_cacheOrder.remove(leastPlayed);
        }
        clip = ClipPlayer.createClip(file, false);
        this.m_clipMap.put(file, clip);
        this.m_cacheOrder.add(file);
        return clip;
    }

    public synchronized void removeAll() {
        for (Clip clip : this.m_clipMap.values()) {
            clip.stop();
            clip.flush();
            clip.close();
        }
        this.m_clipMap.clear();
        this.m_cacheOrder.clear();
    }
}

