/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.sound;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.properties.IEditableProperty;
import games.strategy.engine.framework.GameRunner2;
import games.strategy.sound.ClipCache;
import games.strategy.sound.SoundPath;
import games.strategy.sound.SoundProperties;
import games.strategy.triplea.ResourceLoader;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class ClipPlayer {
    private static ClipPlayer s_clipPlayer;
    private boolean m_beSilent = false;
    private final HashSet<String> m_mutedClips = new HashSet();
    private final HashMap<String, List<URL>> m_sounds = new HashMap();
    private final ResourceLoader m_resourceLoader;
    private final Set<String> m_subFolders = new HashSet<String>();
    private final ClipCache m_clipCache = new ClipCache(24);
    private static final String ASSETS_SOUNDS_FOLDER = "sounds";
    private static final String SOUND_PREFERENCE_GLOBAL_SWITCH = "beSilent2";
    private static final String SOUND_PREFERENCE_PREFIX = "sound_";
    private static final boolean DEFAULT_SOUND_SILENCED_SWITCH_SETTING = false;

    public static synchronized ClipPlayer getInstance() {
        if (s_clipPlayer == null) {
            s_clipPlayer = new ClipPlayer(ResourceLoader.getMapResourceLoader(null, true));
            SoundPath.preLoadSounds(SoundPath.SoundType.GENERAL);
        }
        return s_clipPlayer;
    }

    public static synchronized ClipPlayer getInstance(ResourceLoader resourceLoader, GameData data) {
        if (s_clipPlayer == null || ClipPlayer.s_clipPlayer.m_resourceLoader != resourceLoader) {
            if (s_clipPlayer != null) {
                ClipPlayer.s_clipPlayer.m_clipCache.removeAll();
            }
            s_clipPlayer = new ClipPlayer(resourceLoader, data);
            SoundPath.preLoadSounds(SoundPath.SoundType.GENERAL);
        }
        return s_clipPlayer;
    }

    private ClipPlayer(ResourceLoader resourceLoader) {
        this.m_resourceLoader = resourceLoader;
        Preferences prefs = Preferences.userNodeForPackage(ClipPlayer.class);
        this.m_beSilent = Boolean.parseBoolean(System.getProperty("triplea.headless", "false")) || prefs.getBoolean(SOUND_PREFERENCE_GLOBAL_SWITCH, false);
        HashSet<String> choices = SoundPath.getAllSoundOptions();
        for (String sound : choices) {
            boolean muted = prefs.getBoolean(SOUND_PREFERENCE_PREFIX + sound, false);
            if (!muted) continue;
            this.m_mutedClips.add(sound);
        }
    }

    private ClipPlayer(ResourceLoader resourceLoader, GameData data) {
        this(resourceLoader);
        for (PlayerID p : data.getPlayerList().getPlayers()) {
            this.m_subFolders.add(p.getName());
        }
    }

    public static void setBeSilent(boolean aBool) {
        ClipPlayer clipPlayer = ClipPlayer.getInstance();
        clipPlayer.m_beSilent = aBool;
        ClipPlayer.setBeSilentInPreferencesWithoutAffectingCurrent(aBool);
    }

    public static void setBeSilentInPreferencesWithoutAffectingCurrent(boolean silentBool) {
        boolean setPref;
        Preferences prefs = Preferences.userNodeForPackage(ClipPlayer.class);
        boolean current = prefs.getBoolean(SOUND_PREFERENCE_GLOBAL_SWITCH, false);
        boolean bl = setPref = silentBool != current;
        if (!setPref) {
            try {
                setPref = !Arrays.asList(prefs.keys()).contains(SOUND_PREFERENCE_GLOBAL_SWITCH);
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        if (setPref) {
            prefs.putBoolean(SOUND_PREFERENCE_GLOBAL_SWITCH, silentBool);
            try {
                prefs.flush();
            }
            catch (BackingStoreException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static boolean getBeSilent() {
        ClipPlayer clipPlayer = ClipPlayer.getInstance();
        return clipPlayer.m_beSilent;
    }

    public static boolean isSilencedClip(String clipName) {
        ClipPlayer clipPlayer = ClipPlayer.getInstance();
        return clipPlayer == null || clipPlayer.m_beSilent || clipPlayer.isMuted(clipName);
    }

    public boolean isMuted(String clipName) {
        if (this.m_mutedClips.contains(clipName)) {
            return true;
        }
        if (!SoundPath.getAllSoundOptions().contains(clipName)) {
            if (clipName.startsWith("battle_") && clipName.endsWith("_hit")) {
                return this.m_mutedClips.contains("battle_aa_hit");
            }
            if (clipName.startsWith("battle_") && clipName.endsWith("_miss")) {
                return this.m_mutedClips.contains("battle_aa_miss");
            }
            if (clipName.startsWith("notification_")) {
                return this.m_mutedClips.contains("notification_");
            }
            if (clipName.startsWith("defeat_")) {
                return this.m_mutedClips.contains("defeat_");
            }
            if (clipName.startsWith("victory_")) {
                return this.m_mutedClips.contains("victory_");
            }
        }
        return false;
    }

    public void setMute(String clipName, boolean value) {
        boolean isCurrentCorrect;
        boolean bl = isCurrentCorrect = this.m_mutedClips.contains(clipName) == value;
        if (isCurrentCorrect) {
            return;
        }
        if (value) {
            this.m_mutedClips.add(clipName);
        } else {
            this.m_mutedClips.remove(clipName);
        }
        this.putSoundInPreferences(clipName, value);
    }

    private void putSoundInPreferences(String clip, boolean isMuted) {
        Preferences prefs = Preferences.userNodeForPackage(ClipPlayer.class);
        prefs.putBoolean(SOUND_PREFERENCE_PREFIX + clip, isMuted);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    public ArrayList<IEditableProperty> getSoundOptions(SoundPath.SoundType sounds) {
        return SoundPath.getSoundOptions(sounds);
    }

    static void play(String clipName, String subFolder) {
        ClipPlayer.getInstance().playClip(clipName, subFolder);
    }

    private void playClip(final String clipName, final String subFolder) {
        if (this.m_beSilent || this.isMuted(clipName)) {
            return;
        }
        Runnable loadSounds = new Runnable(){

            @Override
            public void run() {
                try {
                    Clip clip = ClipPlayer.this.loadClip(clipName, subFolder, false);
                    if (clip != null) {
                        clip.setFramePosition(0);
                        clip.loop(0);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        new Thread(loadSounds, "Triplea sound loader for " + clipName).start();
    }

    public void preLoadClip(String clipName) {
        this.loadClip(clipName, null, true);
        for (String sub : this.m_subFolders) {
            this.loadClip(clipName, sub, true);
        }
    }

    private synchronized Clip loadClip(String clipName, String subFolder, boolean parseThenTestOnly) {
        if (this.m_beSilent || this.isMuted(clipName)) {
            return null;
        }
        try {
            if (subFolder != null && subFolder.length() > 0) {
                Clip clip = this.loadClipPath(clipName + "_" + subFolder, true, parseThenTestOnly);
                if (clip != null) {
                    return clip;
                }
                return this.loadClipPath(clipName, false, parseThenTestOnly);
            }
            return this.loadClipPath(clipName, false, parseThenTestOnly);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Clip loadClipPath(String pathName, boolean subFolder, boolean parseThenTestOnly) {
        if (!this.m_sounds.containsKey(pathName)) {
            this.parseClipPaths(pathName, subFolder);
        }
        List<URL> availableSounds = this.m_sounds.get(pathName);
        if (parseThenTestOnly || availableSounds == null || availableSounds.isEmpty()) {
            return null;
        }
        Collections.shuffle(availableSounds);
        URL clipFile = availableSounds.get(0);
        return this.m_clipCache.get(clipFile);
    }

    private void parseClipPaths(String pathName, boolean subFolder) {
        String resourcePath = SoundProperties.getInstance(this.m_resourceLoader).getProperty(pathName);
        if (resourcePath == null) {
            resourcePath = SoundProperties.getInstance(this.m_resourceLoader).getDefaultEraFolder() + "/" + pathName;
        }
        resourcePath = resourcePath.replace('\\', '/');
        ArrayList<URL> availableSounds = new ArrayList<URL>();
        if ("NONE".equals(resourcePath)) {
            this.m_sounds.put(pathName, availableSounds);
            return;
        }
        for (String path : resourcePath.split(";")) {
            availableSounds.addAll(this.createAndAddClips("sounds/" + path));
        }
        if (availableSounds.isEmpty()) {
            String genericPath = "generic/" + pathName;
            availableSounds.addAll(this.createAndAddClips("sounds/" + genericPath));
        }
        this.m_sounds.put(pathName, availableSounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<URL> createAndAddClips(String resourceAndPathURL) {
        File thisSoundFile;
        ArrayList<URL> availableSounds = new ArrayList<URL>();
        URL thisSoundURL = this.m_resourceLoader.getResource(resourceAndPathURL);
        if (thisSoundURL == null) {
            return availableSounds;
        }
        try {
            URI thisSoundURI = thisSoundURL.toURI();
            try {
                thisSoundFile = new File(thisSoundURI);
            }
            catch (Exception e) {
                try {
                    thisSoundFile = new File(thisSoundURI.getPath());
                }
                catch (Exception e3) {
                    thisSoundFile = new File(thisSoundURL.getPath());
                }
            }
        }
        catch (URISyntaxException e1) {
            try {
                thisSoundFile = new File(thisSoundURL.getPath());
            }
            catch (Exception e4) {
                thisSoundFile = null;
            }
        }
        catch (Exception e2) {
            thisSoundFile = null;
        }
        if (thisSoundFile == null || !thisSoundFile.exists()) {
            int index1;
            String zipFilePath;
            String soundFilePath = thisSoundURL.getPath();
            if (soundFilePath == null || soundFilePath.length() <= 5 || soundFilePath.indexOf(".zip!") == -1 || (zipFilePath = soundFilePath.substring(index1 = Math.max(0, Math.min(soundFilePath.length(), soundFilePath.indexOf("file:") != -1 ? soundFilePath.indexOf("file:") + 5 : 0)), Math.max(index1, Math.min(soundFilePath.length(), soundFilePath.lastIndexOf("!"))))).length() <= 5 || !zipFilePath.endsWith(".zip")) return availableSounds;
            ZipFile zf = null;
            try {
                String decoded;
                try {
                    decoded = URLDecoder.decode(zipFilePath, "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    decoded = zipFilePath.replaceAll("%20", " ");
                }
                File zipFile = new File(decoded);
                if (zipFile == null || !zipFile.exists() || (zf = new ZipFile(zipFile)) == null) return availableSounds;
                Enumeration<? extends ZipEntry> zipEnumeration = zf.entries();
                while (zipEnumeration.hasMoreElements()) {
                    ZipEntry zipElement = zipEnumeration.nextElement();
                    if (zipElement == null || zipElement.getName() == null || zipElement.getName().indexOf(resourceAndPathURL) == -1 || !zipElement.getName().endsWith(".wav") && !zipElement.getName().endsWith(".au") && !zipElement.getName().endsWith(".aiff") && !zipElement.getName().endsWith(".midi")) continue;
                    try {
                        URL zipSoundURL = this.m_resourceLoader.getResource(zipElement.getName());
                        if (zipSoundURL == null || !ClipPlayer.testClipSuccessful(zipSoundURL)) continue;
                        availableSounds.add(zipSoundURL);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return availableSounds;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                return availableSounds;
            }
            finally {
                if (zf != null) {
                    try {
                        zf.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (!thisSoundFile.isDirectory()) {
            if (!(thisSoundFile.getName().endsWith(".wav") || thisSoundFile.getName().endsWith(".au") || thisSoundFile.getName().endsWith(".aiff") || thisSoundFile.getName().endsWith(".midi"))) {
                return availableSounds;
            }
            if (!ClipPlayer.testClipSuccessful(thisSoundURL)) return availableSounds;
            availableSounds.add(thisSoundURL);
            return availableSounds;
        } else {
            for (File sound : thisSoundFile.listFiles()) {
                if (!sound.getName().endsWith(".wav") && !sound.getName().endsWith(".au") && !sound.getName().endsWith(".aiff") && !sound.getName().endsWith(".midi")) continue;
                try {
                    URL individualSoundURL = sound.toURI().toURL();
                    if (!ClipPlayer.testClipSuccessful(individualSoundURL)) continue;
                    availableSounds.add(individualSoundURL);
                }
                catch (MalformedURLException e) {
                    System.out.println("Error " + e.getMessage() + " with sound file: " + sound.getPath());
                }
            }
        }
        return availableSounds;
    }

    static synchronized Clip createClip(URL clipFile, boolean testOnly) {
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(clipFile);
            AudioFormat format = audioInputStream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            Clip clip = (Clip)AudioSystem.getLine(info);
            clip.open(audioInputStream);
            if (!testOnly) {
                return clip;
            }
            clip.close();
            return null;
        }
        catch (LineUnavailableException e) {
            e.printStackTrace(System.out);
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace(System.out);
        }
        catch (RuntimeException re) {
            re.printStackTrace(System.out);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized boolean testClipSuccessful(URL clipFile) {
        block13: {
            Line clip = null;
            boolean successful = false;
            try {
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(clipFile);
                AudioFormat format = audioInputStream.getFormat();
                DataLine.Info info = new DataLine.Info(Clip.class, format);
                clip = (Clip)AudioSystem.getLine(info);
                clip.open(audioInputStream);
                successful = true;
            }
            catch (LineUnavailableException e) {
                e.printStackTrace(System.out);
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
            }
            catch (UnsupportedAudioFileException e) {
                e.printStackTrace(System.out);
            }
            catch (RuntimeException e) {
                e.printStackTrace(System.out);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            finally {
                if (clip == null) break block13;
                clip.close();
                if (!successful) break block13;
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        ClipPlayer.getInstance();
        File root = new File(GameRunner2.getRootFolder(), "assets" + File.separator + ASSETS_SOUNDS_FOLDER);
        for (File folder : root.listFiles()) {
            if (!folder.getName().equals("ww2") && !folder.getName().equals("preindustrial") && !folder.getName().equals("classical")) continue;
            for (File file : folder.listFiles()) {
                if (file.getName().indexOf("svn") != -1) continue;
                String name = folder.getName() + "/" + file.getName();
                ArrayList<URL> availableSounds = new ArrayList<URL>();
                availableSounds.addAll(ClipPlayer.getInstance().createAndAddClips("sounds/" + name));
                ClipPlayer.getInstance().m_sounds.put(name, availableSounds);
            }
        }
        block4: while (true) {
            File[] arr$ = root.listFiles();
            int len$ = arr$.length;
            int i$ = 0;
            while (true) {
                File folder;
                if (i$ >= len$) continue block4;
                folder = arr$[i$];
                if (folder.getName().equals("ww2") || folder.getName().equals("preindustrial") || folder.getName().equals("classical")) {
                    for (File file : folder.listFiles()) {
                        if (file.getName().indexOf("svn") != -1) continue;
                        String soundPath = folder.getName() + "/" + file.getName();
                        System.out.println(soundPath);
                        ClipPlayer.play(soundPath, null);
                        try {
                            Thread.sleep(4000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++i$;
            }
            break;
        }
    }
}

