/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.sound;

import games.strategy.engine.data.PlayerID;
import games.strategy.engine.framework.LocalPlayers;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.sound.ClipPlayer;
import games.strategy.sound.ISound;
import games.strategy.triplea.TripleAPlayer;
import java.util.Collection;
import java.util.Collections;

public class DefaultSoundChannel
implements ISound {
    private LocalPlayers m_localPlayers;

    public DefaultSoundChannel(LocalPlayers localPlayers) {
        this.m_localPlayers = localPlayers;
    }

    public static void playSoundOnLocalMachine(String clipName, String subFolder) {
        ClipPlayer.play(clipName, subFolder);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void shutDown() {
        this.m_localPlayers = null;
    }

    @Override
    public void playSoundForAll(String clipName, String subFolder) {
        this.playSoundForAll(clipName, subFolder, false, false, false);
    }

    @Override
    public void playSoundForAll(String clipName, String subFolder, boolean doNotIncludeHost, boolean doNotIncludeClients, boolean doNotIncludeObservers) {
        if (doNotIncludeHost && doNotIncludeClients && doNotIncludeObservers) {
            return;
        }
        if (doNotIncludeHost || doNotIncludeClients || doNotIncludeObservers) {
            boolean isHost = false;
            boolean isClient = false;
            boolean isObserver = true;
            if (doNotIncludeHost || doNotIncludeClients || doNotIncludeObservers) {
                for (IGamePlayer player : this.m_localPlayers.getLocalPlayers()) {
                    isObserver = false;
                    if (player instanceof TripleAPlayer) {
                        if ("Client".equals(((TripleAPlayer)player).getType())) {
                            isClient = true;
                            continue;
                        }
                        isHost = true;
                        continue;
                    }
                    isHost = true;
                }
            }
            if (doNotIncludeHost && isHost || doNotIncludeClients && isClient || doNotIncludeObservers && isObserver) {
                return;
            }
        }
        DefaultSoundChannel.playSoundOnLocalMachine(clipName, subFolder);
    }

    @Override
    public void playSoundToPlayers(String clipName, String subFolder, Collection<PlayerID> playersToSendTo, Collection<PlayerID> butNotThesePlayers, boolean includeObservers) {
        if (playersToSendTo == null || playersToSendTo.isEmpty()) {
            return;
        }
        if (butNotThesePlayers != null) {
            for (PlayerID p : butNotThesePlayers) {
                if (!this.m_localPlayers.playing(p)) continue;
                return;
            }
        }
        boolean isPlaying = false;
        for (PlayerID p : playersToSendTo) {
            if (!this.m_localPlayers.playing(p)) continue;
            isPlaying = true;
            break;
        }
        if (includeObservers && this.m_localPlayers.getLocalPlayers().isEmpty()) {
            isPlaying = true;
        }
        if (isPlaying) {
            DefaultSoundChannel.playSoundOnLocalMachine(clipName, subFolder);
        }
    }

    @Override
    public void playSoundToPlayer(String clipName, String subFolder, PlayerID playerToSendTo, boolean includeObservers) {
        this.playSoundToPlayers(clipName, subFolder, Collections.singleton(playerToSendTo), null, includeObservers);
    }
}

