/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.sound;

import games.strategy.triplea.ResourceLoader;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SoundProperties {
    private static final String PROPERTY_FILE = "sounds.properties";
    static final String PROPERTY_DEFAULT_FOLDER = "Sound.Default.Folder";
    static final String DEFAULT_ERA_FOLDER = "ww2";
    static final String GENERIC_FOLDER = "generic";
    static final String OBJECTIVES_PANEL_NAME = "Objectives.Panel.Name";
    private static SoundProperties s_op = null;
    private static long s_timestamp = 0L;
    private final Properties m_properties = new Properties();

    protected SoundProperties(ResourceLoader loader) {
        URL url = loader.getResource(PROPERTY_FILE);
        if (url != null) {
            try {
                this.m_properties.load(url.openStream());
            }
            catch (IOException e) {
                System.out.println("Error reading sounds.properties : " + e);
            }
        }
    }

    public static SoundProperties getInstance(ResourceLoader loader) {
        if (s_op == null || Calendar.getInstance().getTimeInMillis() > s_timestamp + 1000L) {
            s_op = new SoundProperties(loader);
            s_timestamp = Calendar.getInstance().getTimeInMillis();
        }
        return s_op;
    }

    public String getDefaultEraFolder() {
        return this.getProperty(PROPERTY_DEFAULT_FOLDER, DEFAULT_ERA_FOLDER);
    }

    public String getProperty(String key) {
        return this.m_properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.m_properties.getProperty(key, defaultValue);
    }

    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.m_properties.entrySet();
    }
}

