/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.thread;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;

public class LockUtil {
    private static final ThreadLocal<Map<Lock, Integer>> m_locksHeld = new ThreadLocal();
    private static final Map<Lock, Set<WeakLockRef>> m_locksHeldWhenAcquired = new WeakHashMap<Lock, Set<WeakLockRef>>();
    private final Object m_mutex = new Object();
    private static ErrorReporter m_errorReporter = new ErrorReporter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireLock(Lock aLock) {
        Object object = this.m_mutex;
        synchronized (object) {
            if (m_locksHeld.get() == null) {
                m_locksHeld.set(new HashMap());
            }
            if (m_locksHeld.get().containsKey(aLock)) {
                int current = m_locksHeld.get().get(aLock);
                m_locksHeld.get().put(aLock, current + 1);
            } else {
                if (!m_locksHeldWhenAcquired.containsKey(aLock)) {
                    m_locksHeldWhenAcquired.put(aLock, new HashSet());
                }
                for (Lock l : m_locksHeld.get().keySet()) {
                    m_locksHeldWhenAcquired.get(aLock).add(new WeakLockRef(l));
                }
                for (Lock l : m_locksHeld.get().keySet()) {
                    Set<WeakLockRef> held = m_locksHeldWhenAcquired.get(l);
                    Iterator<WeakLockRef> iter = held.iterator();
                    while (iter.hasNext()) {
                        if (iter.next().get() != null) continue;
                        iter.remove();
                    }
                    if (!held.contains(new WeakLockRef(aLock))) continue;
                    m_errorReporter.reportError(aLock, l);
                }
                m_locksHeld.get().put(aLock, 1);
            }
        }
        aLock.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Lock aLock) {
        Object object = this.m_mutex;
        synchronized (object) {
            int count = m_locksHeld.get().get(aLock);
            if (--count == 0) {
                m_locksHeld.get().remove(aLock);
            } else {
                m_locksHeld.get().put(aLock, count);
            }
        }
        aLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLockHeld(Lock aLock) {
        if (m_locksHeld.get() == null) {
            return false;
        }
        Object object = this.m_mutex;
        synchronized (object) {
            return m_locksHeld.get().containsKey(aLock);
        }
    }

    public void setErrorReporter(ErrorReporter reporter) {
        m_errorReporter = reporter;
    }

    protected static final class WeakLockRef
    extends WeakReference<Lock> {
        private final int hashCode;

        public WeakLockRef(Lock referent) {
            super(referent);
            this.hashCode = referent.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof WeakLockRef) {
                WeakLockRef other = (WeakLockRef)o;
                return other.get() == this.get();
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    public static class ErrorReporter {
        public void reportError(Lock from, Lock to) {
            System.err.println("Invalid lock ordering at, from:" + from + " to:" + to + " stack trace:" + this.getStackTrace());
        }

        private String getStackTrace() {
            StackTraceElement[] trace = Thread.currentThread().getStackTrace();
            StringBuilder builder = new StringBuilder();
            for (StackTraceElement e : trace) {
                builder.append(e.toString());
                builder.append("\n");
            }
            return builder.toString();
        }
    }
}

