/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.thread;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadPool {
    private final String m_name;
    private final int m_maxThreadCount;
    private final AtomicInteger m_threadCount = new AtomicInteger();
    private final AtomicInteger m_availableThreads = new AtomicInteger();
    private final AtomicInteger m_unfinishedTaskCount = new AtomicInteger();
    private final LinkedBlockingQueue<Runnable> m_pendingTasks = new LinkedBlockingQueue();
    private volatile boolean m_isRunning = true;

    public ThreadPool(int max, String name) {
        if (max < 1) {
            throw new IllegalArgumentException("Max must be >= 1, instead its:" + max);
        }
        this.m_name = name == null ? "Unamed" : name;
        this.m_maxThreadCount = max;
    }

    private void grow() {
        int threadCount = this.m_threadCount.incrementAndGet();
        if (threadCount > this.m_maxThreadCount) {
            this.m_threadCount.decrementAndGet();
            return;
        }
        ThreadTracker tracker = new ThreadTracker();
        Thread thread = new Thread((Runnable)tracker, this.getClass().getName() + ":" + this.m_name + ":" + threadCount);
        thread.start();
    }

    public void runTask(Runnable task) {
        if (!this.m_isRunning) {
            return;
        }
        this.m_unfinishedTaskCount.incrementAndGet();
        if (this.m_availableThreads.get() == 0 && this.m_threadCount.get() < this.m_maxThreadCount) {
            this.grow();
        }
        if (!this.m_pendingTasks.offer(task)) {
            throw new IllegalStateException("Could not offer to queue");
        }
    }

    public void waitForAll() {
        while (this.m_unfinishedTaskCount.get() != 0) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    int getThreadCount() {
        return this.m_threadCount.get();
    }

    public void shutDown() {
        this.m_isRunning = false;
        while (this.m_pendingTasks.poll() != null) {
            this.m_unfinishedTaskCount.decrementAndGet();
        }
        Runnable dummy = new Runnable(){

            @Override
            public void run() {
            }
        };
        for (int i = 0; i < this.m_maxThreadCount; ++i) {
            this.m_pendingTasks.offer(dummy);
        }
    }

    private class ThreadTracker
    implements Runnable {
        private ThreadTracker() {
        }

        @Override
        public void run() {
            while (ThreadPool.this.m_isRunning) {
                Runnable task = this.getTask();
                if (task == null) continue;
                Thread.interrupted();
                if (!ThreadPool.this.m_isRunning) continue;
                this.runTask(task);
            }
            ThreadPool.this.m_threadCount.decrementAndGet();
        }

        private void runTask(Runnable task) {
            try {
                task.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            ThreadPool.this.m_unfinishedTaskCount.decrementAndGet();
        }

        private Runnable getTask() {
            Runnable task;
            ThreadPool.this.m_availableThreads.incrementAndGet();
            try {
                task = (Runnable)ThreadPool.this.m_pendingTasks.take();
            }
            catch (InterruptedException e) {
                return null;
            }
            ThreadPool.this.m_availableThreads.decrementAndGet();
            return task;
        }
    }
}

