/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea;

import games.strategy.engine.framework.GameRunner2;
import games.strategy.util.ClassLoaderUtil;
import games.strategy.util.Match;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class ResourceLoader {
    private final URLClassLoader m_loader;
    public static String RESOURCE_FOLDER = "assets";

    public static ResourceLoader getMapResourceLoader(String mapName, boolean allowNoneFound) {
        List<String> dirs = ResourceLoader.getPaths(mapName, allowNoneFound);
        ResourceLoader.addAssets(dirs);
        return new ResourceLoader(dirs.toArray(new String[dirs.size()]));
    }

    private static void addAssets(List<String> dirs) {
        File resourceFolder;
        File atFolder = GameRunner2.getRootFolder();
        do {
            resourceFolder = new File(atFolder, RESOURCE_FOLDER);
            atFolder = atFolder.getParentFile();
        } while (!resourceFolder.exists() && !resourceFolder.isDirectory());
        dirs.add(resourceFolder.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getPaths(String mapName, boolean allowNoneFound) {
        ArrayList<String> rVal;
        block13: {
            if (mapName == null) {
                if (allowNoneFound) {
                    return new ArrayList<String>();
                }
                throw new IllegalArgumentException("mapName can not be null, it must exist");
            }
            String dirName = File.separator + mapName;
            String zipName = dirName + ".zip";
            ArrayList<File> candidates = new ArrayList<File>();
            candidates.add(new File(GameRunner2.getUserMapsFolder(), dirName));
            candidates.add(new File(GameRunner2.getUserMapsFolder(), zipName));
            candidates.add(new File(GameRunner2.getRootFolder() + File.separator + "maps", dirName));
            candidates.add(new File(GameRunner2.getRootFolder() + File.separator + "maps", zipName));
            List<File> existing = Match.getMatches(candidates, new Match<File>(){

                @Override
                public boolean match(File f) {
                    return f.exists();
                }
            });
            if (existing.size() > 1) {
                System.out.println("INFO: Found too many files for: " + mapName + "  found: " + existing);
            }
            if (existing.isEmpty()) {
                if (allowNoneFound) {
                    return new ArrayList<String>();
                }
                throw new IllegalStateException("Could not find file folder or zip for map: " + mapName + "\r\n" + "Please DOWNLOAD THIS MAP if you do not have it." + "\r\n" + "If you are making a map or mod, make sure the mapName property within the xml game file exactly matches the map zip or folder name." + "\r\n" + "\r\n");
            }
            File match = (File)existing.iterator().next();
            String fileName = match.getName();
            if (fileName.indexOf(46) > 0) {
                fileName = fileName.substring(0, fileName.lastIndexOf(46));
            }
            if (!fileName.equals(mapName)) {
                throw new IllegalStateException("Map case is incorrect, xml: " + mapName + " file: " + match.getName() + "\r\n" + "Make sure the mapName property within the xml game file exactly matches the map zip or folder name." + "\r\n");
            }
            rVal = new ArrayList<String>();
            rVal.add(match.getAbsolutePath());
            try {
                URLClassLoader url = new URLClassLoader(new URL[]{match.toURI().toURL()});
                URL dependencesURL = url.getResource("dependencies.txt");
                ClassLoaderUtil.closeLoader(url);
                if (dependencesURL == null) break block13;
                Properties dependenciesFile = new Properties();
                InputStream stream = dependencesURL.openStream();
                try {
                    dependenciesFile.load(stream);
                    String dependencies = dependenciesFile.getProperty("dependencies");
                    StringTokenizer tokens = new StringTokenizer(dependencies, ",", false);
                    while (tokens.hasMoreTokens()) {
                        rVal.addAll(ResourceLoader.getPaths(tokens.nextToken(), allowNoneFound));
                    }
                }
                finally {
                    stream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException(e.getMessage());
            }
        }
        return rVal;
    }

    public void close() {
        ClassLoaderUtil.closeLoader(this.m_loader);
    }

    private ResourceLoader(String[] paths) {
        URL[] urls = new URL[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            File f = new File(paths[i]);
            if (!f.exists()) {
                System.err.println(f + " does not exist");
            }
            if (!f.isDirectory() && !f.getName().endsWith(".zip")) {
                System.err.println(f + " is not a directory or a zip file");
            }
            try {
                urls[i] = f.toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                throw new IllegalStateException(e.getMessage());
            }
        }
        this.m_loader = new URLClassLoader(urls);
    }

    public boolean hasPath(String path) {
        URL rVal = this.m_loader.getResource(path);
        return rVal != null;
    }

    public URL getResource(String pathURL) {
        String fileName;
        URL rVal = this.m_loader.getResource(pathURL);
        if (rVal == null) {
            return null;
        }
        try {
            fileName = URLDecoder.decode(rVal.getFile(), "UTF-8");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (!fileName.endsWith(pathURL)) {
            throw new IllegalStateException("The file:" + fileName + "  does not have the correct case.  It must match the case declared in the xml:" + pathURL);
        }
        return rVal;
    }

    public InputStream getResourceAsStream(String path) {
        return this.m_loader.getResourceAsStream(path);
    }
}

