/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionFrontier;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.util.Match;
import java.util.Collection;
import java.util.Comparator;

public class AIUtils {
    public static int getCost(UnitType unitType, PlayerID player, GameData data) {
        if (unitType == null) {
            throw new IllegalArgumentException("null unit type");
        }
        if (player == null) {
            throw new IllegalArgumentException("null player id");
        }
        Resource PUs = data.getResourceList().getResource("PUs");
        ProductionRule rule = AIUtils.getProductionRule(unitType, player, data);
        if (rule == null) {
            return Integer.MAX_VALUE;
        }
        return rule.getCosts().getInt(PUs);
    }

    public static Comparator<Unit> getCostComparator() {
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit o1, Unit o2) {
                return AIUtils.getCost(o1.getType(), o1.getOwner(), o1.getData()) - AIUtils.getCost(o2.getType(), o2.getOwner(), o2.getData());
            }
        };
    }

    public static ProductionRule getProductionRule(UnitType unitType, PlayerID player, GameData data) {
        if (unitType == null) {
            throw new IllegalArgumentException("null unit type");
        }
        if (player == null) {
            throw new IllegalArgumentException("null player id");
        }
        ProductionFrontier frontier = player.getProductionFrontier();
        if (frontier == null) {
            return null;
        }
        for (ProductionRule rule : frontier) {
            if (rule.getResults().getInt(unitType) != 1) continue;
            return rule;
        }
        return null;
    }

    public static float strength(Collection<Unit> units, boolean attacking, boolean sea) {
        int strength = 0;
        for (Unit u : units) {
            UnitAttachment unitAttachment = UnitAttachment.get(u.getType());
            if (unitAttachment.getIsInfrastructure() || unitAttachment.getIsSea() != sea) continue;
            strength += 2;
            strength = (int)((double)strength + 1.5 * (double)unitAttachment.getHitPoints());
            strength = attacking ? (strength += unitAttachment.getAttack(u.getOwner())) : (strength += unitAttachment.getDefense(u.getOwner()));
            if (!attacking || unitAttachment.getAttack(u.getOwner()) != 0) continue;
            strength = (int)((double)strength - 1.2);
        }
        if (attacking) {
            int art = Match.countMatches(units, Matches.UnitIsArtillery);
            int artSupport = Match.countMatches(units, Matches.UnitIsArtillerySupportable);
            strength += Math.min(art, artSupport);
        }
        return strength;
    }
}

