/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai;

import games.strategy.common.player.AbstractBaseAI;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.net.GUID;
import games.strategy.triplea.ai.AdvancedUtils;
import games.strategy.triplea.ai.BasicPoliticalAI;
import games.strategy.triplea.attatchments.PlayerAttachment;
import games.strategy.triplea.attatchments.PoliticalActionAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.PoliticsDelegate;
import games.strategy.triplea.delegate.dataObjects.CasualtyDetails;
import games.strategy.triplea.delegate.dataObjects.CasualtyList;
import games.strategy.triplea.delegate.remote.IAbstractForumPosterDelegate;
import games.strategy.triplea.delegate.remote.IAbstractPlaceDelegate;
import games.strategy.triplea.delegate.remote.IBattleDelegate;
import games.strategy.triplea.delegate.remote.IMoveDelegate;
import games.strategy.triplea.delegate.remote.IPoliticsDelegate;
import games.strategy.triplea.delegate.remote.IPurchaseDelegate;
import games.strategy.triplea.delegate.remote.ITechDelegate;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public abstract class AbstractAI
extends AbstractBaseAI
implements ITripleaPlayer,
IGamePlayer {
    private static final Logger s_logger = Logger.getLogger(AbstractAI.class.getName());

    public AbstractAI(String name, String type) {
        super(name, type);
    }

    public final Class<ITripleaPlayer> getRemotePlayerType() {
        return ITripleaPlayer.class;
    }

    protected abstract void purchase(boolean var1, int var2, IPurchaseDelegate var3, GameData var4, PlayerID var5);

    protected abstract void tech(ITechDelegate var1, GameData var2, PlayerID var3);

    protected abstract void move(boolean var1, IMoveDelegate var2, GameData var3, PlayerID var4);

    protected abstract void place(boolean var1, IAbstractPlaceDelegate var2, GameData var3, PlayerID var4);

    @Override
    public Territory selectBombardingTerritory(Unit unit, Territory unitTerritory, Collection<Territory> territories, boolean noneAvailable) {
        return territories.iterator().next();
    }

    @Override
    public boolean selectAttackSubs(Territory unitTerritory) {
        return true;
    }

    @Override
    public boolean selectAttackTransports(Territory unitTerritory) {
        return true;
    }

    @Override
    public boolean selectAttackUnits(Territory unitTerritory) {
        return true;
    }

    @Override
    public boolean selectShoreBombard(Territory unitTerritory) {
        return true;
    }

    @Override
    public boolean confirmMoveKamikaze() {
        return false;
    }

    @Override
    public boolean confirmMoveHariKari() {
        return false;
    }

    @Override
    public Territory whereShouldRocketsAttack(Collection<Territory> candidates, Territory from) {
        return candidates.iterator().next();
    }

    @Override
    public CasualtyDetails selectCasualties(Collection<Unit> selectFrom, Map<Unit, Collection<Unit>> dependents, int count, String message, DiceRoll dice, PlayerID hit, Collection<Unit> friendlyUnits, PlayerID enemyPlayer, Collection<Unit> enemyUnits, boolean amphibious, Collection<Unit> amphibiousLandAttackers, CasualtyList defaultCasualties, GUID battleID, Territory battlesite, boolean allowMultipleHitsPerUnit) {
        if (defaultCasualties.size() != count) {
            throw new IllegalStateException("Select Casualties showing different numbers for number of hits to take vs total size of default casualty selections");
        }
        if (defaultCasualties.getKilled().size() <= 0) {
            return new CasualtyDetails(defaultCasualties, false);
        }
        boolean numberOfPlanesThatDoNotNeedToLandOnCarriers = false;
        CasualtyDetails myCasualties = new CasualtyDetails(false);
        myCasualties.addToDamaged(defaultCasualties.getDamaged());
        ArrayList<Unit> selectFromSorted = new ArrayList<Unit>(selectFrom);
        ArrayList<Unit> interleavedTargetList = new ArrayList<Unit>(AdvancedUtils.interleaveCarriersAndPlanes(selectFromSorted, 0));
        for (int i = 0; i < defaultCasualties.getKilled().size(); ++i) {
            myCasualties.addToKilled((Unit)interleavedTargetList.get(i));
        }
        if (count != myCasualties.size()) {
            throw new IllegalStateException("AI chose wrong number of casualties");
        }
        return myCasualties;
    }

    @Override
    public Unit whatShouldBomberBomb(Territory territory, Collection<Unit> potentialTargets, Collection<Unit> bombers) {
        if (potentialTargets == null || potentialTargets.isEmpty()) {
            return null;
        }
        List<Unit> factories = Match.getMatches(potentialTargets, Matches.UnitCanProduceUnitsAndCanBeDamaged);
        if (factories.isEmpty()) {
            return potentialTargets.iterator().next();
        }
        return (Unit)factories.iterator().next();
    }

    @Override
    public Collection<Unit> getNumberOfFightersToMoveToNewCarrier(Collection<Unit> fightersThatCanBeMoved, Territory from) {
        ArrayList<Unit> rVal = new ArrayList<Unit>();
        for (Unit fighter : fightersThatCanBeMoved) {
            if (!(Math.random() < 0.8)) continue;
            rVal.add(fighter);
        }
        return rVal;
    }

    @Override
    public Territory selectTerritoryForAirToLand(Collection<Territory> candidates, Territory currentTerritory, String unitMessage) {
        return candidates.iterator().next();
    }

    @Override
    public boolean confirmMoveInFaceOfAA(Collection<Territory> aaFiringTerritories) {
        return true;
    }

    @Override
    public Territory retreatQuery(GUID battleID, boolean submerge, Territory battleTerritory, Collection<Territory> possibleTerritories, String message) {
        return null;
    }

    @Override
    public HashMap<Territory, Collection<Unit>> scrambleUnitsQuery(Territory scrambleTo, Map<Territory, Tuple<Collection<Unit>, Collection<Unit>>> possibleScramblers) {
        return null;
    }

    @Override
    public Collection<Unit> selectUnitsQuery(Territory current, Collection<Unit> possible, String message) {
        return null;
    }

    @Override
    public abstract boolean shouldBomberBomb(Territory var1);

    @Override
    public boolean acceptAction(PlayerID playerSendingProposal, String acceptanceQuestion, boolean politics) {
        if (!this.getPlayerID().amNotDeadYet(this.getGameData())) {
            return true;
        }
        if (!politics) {
            return true;
        }
        if (Matches.isAllied(this.getPlayerID(), this.getGameData()).match(playerSendingProposal)) {
            return true;
        }
        List<String> allies = Arrays.asList("Americans", "Australians", "British", "Canadians", "Chinese", "French", "Russians");
        if (allies.contains(this.getPlayerID().getName()) && allies.contains(playerSendingProposal.getName())) {
            return true;
        }
        List<String> axis = Arrays.asList("Germans", "Italians", "Japanese", "Puppet_States");
        if (axis.contains(this.getPlayerID().getName()) && axis.contains(playerSendingProposal.getName())) {
            return true;
        }
        HashSet<String> myAlliances = new HashSet<String>(this.getGameData().getAllianceTracker().getAlliancesPlayerIsIn(this.getPlayerID()));
        myAlliances.retainAll(this.getGameData().getAllianceTracker().getAlliancesPlayerIsIn(playerSendingProposal));
        if (!myAlliances.isEmpty()) {
            return true;
        }
        return Math.random() < 0.5;
    }

    @Override
    public HashMap<Territory, HashMap<Unit, IntegerMap<Resource>>> selectKamikazeSuicideAttacks(HashMap<Territory, Collection<Unit>> possibleUnitsToAttack) {
        PlayerID id = this.getPlayerID();
        PlayerAttachment pa = PlayerAttachment.get(id);
        if (pa == null) {
            return null;
        }
        IntegerMap<Resource> resourcesAndAttackValues = pa.getSuicideAttackResources();
        if (resourcesAndAttackValues.size() <= 0) {
            return null;
        }
        IntegerMap<Resource> playerResourceCollection = id.getResources().getResourcesCopy();
        IntegerMap<Resource> attackTokens = new IntegerMap<Resource>();
        for (Resource possible : resourcesAndAttackValues.keySet()) {
            int amount = playerResourceCollection.getInt(possible);
            if (amount <= 0) continue;
            attackTokens.put(possible, amount);
        }
        if (attackTokens.size() <= 0) {
            return null;
        }
        HashMap<Territory, HashMap<Unit, IntegerMap<Resource>>> rVal = new HashMap<Territory, HashMap<Unit, IntegerMap<Resource>>>();
        for (Map.Entry<Territory, Collection<Unit>> entry : possibleUnitsToAttack.entrySet()) {
            if (attackTokens.size() <= 0) continue;
            Territory t = entry.getKey();
            ArrayList<Unit> targets = new ArrayList<Unit>(entry.getValue());
            Collections.shuffle(targets);
            for (Unit u : targets) {
                if (attackTokens.size() <= 0) continue;
                IntegerMap<Resource> rMap = new IntegerMap<Resource>();
                Resource r = (Resource)attackTokens.keySet().iterator().next();
                int num = Math.min(attackTokens.getInt(r), UnitAttachment.get(u.getType()).getHitPoints() * (Math.random() < 0.3 ? 1 : (Math.random() < 0.5 ? 2 : 3)));
                rMap.put(r, num);
                HashMap<Unit, IntegerMap<Resource>> attMap = rVal.get(t);
                if (attMap == null) {
                    attMap = new HashMap();
                }
                attMap.put(u, rMap);
                rVal.put(t, attMap);
                attackTokens.add(r, -num);
                if (attackTokens.getInt(r) > 0) continue;
                attackTokens.removeKey(r);
            }
        }
        return rVal;
    }

    public void battleInfoMessage(String shortMessage, DiceRoll dice) {
    }

    @Override
    public void confirmEnemyCasualties(GUID battleId, String message, PlayerID hitPlayer) {
    }

    public void retreatNotificationMessage(Collection<Unit> units) {
    }

    @Override
    public void reportError(String error) {
    }

    @Override
    public void reportMessage(String message, String title) {
    }

    @Override
    public void confirmOwnCasualties(GUID battleId, String message) {
        this.pause();
    }

    @Override
    public int[] selectFixedDice(int numRolls, int hitAt, boolean hitOnlyIfEquals, String message, int diceSides) {
        int[] dice = new int[numRolls];
        for (int i = 0; i < numRolls; ++i) {
            dice[i] = (int)Math.ceil(Math.random() * (double)diceSides);
        }
        return dice;
    }

    @Override
    public final void start(String name) {
        super.start(name);
        PlayerID id = this.getPlayerID();
        if (name.endsWith("Bid")) {
            IPurchaseDelegate purchaseDelegate = (IPurchaseDelegate)this.getPlayerBridge().getRemoteDelegate();
            String propertyName = id.getName() + " bid";
            int bidAmount = this.getGameData().getProperties().get(propertyName, 0);
            this.purchase(true, bidAmount, purchaseDelegate, this.getGameData(), id);
        } else if (name.endsWith("Purchase")) {
            IPurchaseDelegate purchaseDelegate = (IPurchaseDelegate)this.getPlayerBridge().getRemoteDelegate();
            Resource PUs = this.getGameData().getResourceList().getResource("PUs");
            int leftToSpend = id.getResources().getQuantity(PUs);
            this.purchase(false, leftToSpend, purchaseDelegate, this.getGameData(), id);
        } else if (name.endsWith("Tech")) {
            ITechDelegate techDelegate = (ITechDelegate)this.getPlayerBridge().getRemoteDelegate();
            this.tech(techDelegate, this.getGameData(), id);
        } else if (name.endsWith("Move")) {
            IMoveDelegate moveDel = (IMoveDelegate)this.getPlayerBridge().getRemoteDelegate();
            if (name.endsWith("AirborneCombatMove")) {
                return;
            }
            this.move(name.endsWith("NonCombatMove"), moveDel, this.getGameData(), id);
        } else if (name.endsWith("Battle")) {
            this.battle((IBattleDelegate)this.getPlayerBridge().getRemoteDelegate(), this.getGameData(), id);
        } else if (name.endsWith("Politics")) {
            this.politicalActions();
        } else if (name.endsWith("Place")) {
            IAbstractPlaceDelegate placeDel = (IAbstractPlaceDelegate)this.getPlayerBridge().getRemoteDelegate();
            this.place(name.indexOf("Bid") != -1, placeDel, this.getGameData(), id);
        } else if (name.endsWith("EndTurn")) {
            this.endTurn((IAbstractForumPosterDelegate)this.getPlayerBridge().getRemoteDelegate(), this.getGameData(), id);
        }
    }

    protected void endTurn(IAbstractForumPosterDelegate endTurnForumPosterDelegate, GameData data, PlayerID player) {
    }

    /*
     * Exception decompiling
     */
    protected void battle(IBattleDelegate battleDelegate, GameData data, PlayerID player) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[DOLOOP]], but top level block is 2[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void politicalActions() {
        IPoliticsDelegate iPoliticsDelegate = (IPoliticsDelegate)this.getPlayerBridge().getRemoteDelegate();
        GameData data = this.getGameData();
        PlayerID id = this.getPlayerID();
        float numPlayers = data.getPlayerList().getPlayers().size();
        PoliticsDelegate politicsDelegate = DelegateFinder.politicsDelegate(data);
        if (Math.random() < 0.5) {
            int MAX_WAR_ACTIONS_PER_TURN;
            List<PoliticalActionAttachment> actionChoicesTowardsWar = BasicPoliticalAI.getPoliticalActionsTowardsWar(id, politicsDelegate.getTestedConditions(), data);
            if (actionChoicesTowardsWar == null || actionChoicesTowardsWar.isEmpty()) return;
            Collections.shuffle(actionChoicesTowardsWar);
            int i = 0;
            double random = Math.random();
            int n = random < 0.5 ? 0 : (random < 0.9 ? 1 : (MAX_WAR_ACTIONS_PER_TURN = random < 0.99 ? 2 : (int)numPlayers / 2));
            if (MAX_WAR_ACTIONS_PER_TURN > 0 && (double)((float)Match.countMatches(data.getRelationshipTracker().getRelationships(id), Matches.RelationshipIsAtWar) / numPlayers) < 0.4) {
                MAX_WAR_ACTIONS_PER_TURN = Math.random() < 0.9 ? 0 : 1;
            }
            Iterator<PoliticalActionAttachment> actionWarIter = actionChoicesTowardsWar.iterator();
            while (actionWarIter.hasNext() && MAX_WAR_ACTIONS_PER_TURN > 0) {
                PoliticalActionAttachment action = actionWarIter.next();
                if (!Matches.AbstractUserActionAttachmentCanBeAttempted(politicsDelegate.getTestedConditions()).match(action)) continue;
                if (++i > MAX_WAR_ACTIONS_PER_TURN) return;
                iPoliticsDelegate.attemptAction(action);
            }
            return;
        } else {
            List<PoliticalActionAttachment> actionChoicesOther = BasicPoliticalAI.getPoliticalActionsOther(id, politicsDelegate.getTestedConditions(), data);
            if (actionChoicesOther == null || actionChoicesOther.isEmpty()) return;
            Collections.shuffle(actionChoicesOther);
            int i = 0;
            double random = Math.random();
            int MAX_OTHER_ACTIONS_PER_TURN = random < 0.3 ? 0 : (random < 0.6 ? 1 : (random < 0.9 ? 2 : (random < 0.99 ? 3 : (int)numPlayers)));
            Iterator<PoliticalActionAttachment> actionOtherIter = actionChoicesOther.iterator();
            while (actionOtherIter.hasNext() && MAX_OTHER_ACTIONS_PER_TURN > 0) {
                PoliticalActionAttachment action = actionOtherIter.next();
                if (!Matches.AbstractUserActionAttachmentCanBeAttempted(politicsDelegate.getTestedConditions()).match(action) || action.getCostPU() > 0 && action.getCostPU() > id.getResources().getQuantity("PUs")) continue;
                if (++i > MAX_OTHER_ACTIONS_PER_TURN) return;
                iPoliticsDelegate.attemptAction(action);
            }
        }
    }

    @Override
    public Tuple<Territory, Set<Unit>> pickTerritoryAndUnits(List<Territory> territoryChoices, List<Unit> unitChoices, int unitsPerPick) {
        HashSet<Unit> unitsToPlace;
        Territory picked;
        block31: {
            this.pause();
            GameData data = this.getGameData();
            PlayerID me = this.getPlayerID();
            if (territoryChoices == null || territoryChoices.isEmpty()) {
                picked = null;
            } else if (territoryChoices.size() == 1) {
                picked = territoryChoices.get(0);
            } else {
                Collections.shuffle(territoryChoices);
                List<Territory> notOwned = Match.getMatches(territoryChoices, Matches.isTerritoryOwnedBy(me).invert());
                if (notOwned.isEmpty()) {
                    IntegerMap<Territory> distanceMap;
                    boolean nonFactoryUnitsLeft = Match.someMatch(unitChoices, Matches.UnitCanProduceUnits.invert());
                    CompositeMatchAnd<Unit> ownedFactories = new CompositeMatchAnd<Unit>(Matches.UnitCanProduceUnits, Matches.unitIsOwnedBy(me));
                    List<Territory> capitals = TerritoryAttachment.getAllCapitals(me, data);
                    ArrayList<Territory> test = new ArrayList<Territory>(capitals);
                    test.retainAll(territoryChoices);
                    List<Territory> territoriesWithFactories = Match.getMatches(territoryChoices, Matches.territoryHasUnitsThatMatch(ownedFactories));
                    if (!nonFactoryUnitsLeft) {
                        test.retainAll(Match.getMatches(test, Matches.territoryHasUnitsThatMatch(ownedFactories).invert()));
                        if (!test.isEmpty()) {
                            picked = (Territory)test.get(0);
                        } else {
                            if (capitals.isEmpty()) {
                                capitals.addAll(Match.getMatches(data.getMap().getTerritories(), new CompositeMatchAnd(Matches.isTerritoryOwnedBy(me), Matches.territoryHasUnitsOwnedBy(me), Matches.TerritoryIsLand)));
                            }
                            List<Territory> doesNotHaveFactoryYet = Match.getMatches(territoryChoices, Matches.territoryHasUnitsThatMatch(ownedFactories).invert());
                            if (capitals.isEmpty() || doesNotHaveFactoryYet.isEmpty()) {
                                picked = territoryChoices.get(0);
                            } else {
                                distanceMap = data.getMap().getDistance(capitals.get(0), doesNotHaveFactoryYet, Match.<Territory>getAlwaysMatch());
                                picked = distanceMap.lowestKey();
                            }
                        }
                    } else {
                        int maxTerritoriesToPopulate = Math.min(territoryChoices.size(), Math.max(4, Match.countMatches(unitChoices, Matches.UnitCanProduceUnits)));
                        test.addAll(territoriesWithFactories);
                        if (!test.isEmpty()) {
                            if (test.size() < maxTerritoriesToPopulate) {
                                distanceMap = data.getMap().getDistance((Territory)test.get(0), territoryChoices, Match.<Territory>getAlwaysMatch());
                                for (int i = 0; i < maxTerritoriesToPopulate; ++i) {
                                    Territory choice = distanceMap.lowestKey();
                                    distanceMap.removeKey(choice);
                                    test.add(choice);
                                }
                            }
                            Collections.shuffle(test);
                            picked = (Territory)test.get(0);
                        } else {
                            if (capitals.isEmpty()) {
                                capitals.addAll(Match.getMatches(data.getMap().getTerritories(), new CompositeMatchAnd(Matches.isTerritoryOwnedBy(me), Matches.territoryHasUnitsOwnedBy(me), Matches.TerritoryIsLand)));
                            }
                            if (capitals.isEmpty()) {
                                picked = territoryChoices.get(0);
                            } else {
                                distanceMap = data.getMap().getDistance(capitals.get(0), territoryChoices, Match.<Territory>getAlwaysMatch());
                                if (territoryChoices.contains(capitals.get(0))) {
                                    distanceMap.put(capitals.get(0), 0);
                                }
                                ArrayList<Territory> choices = new ArrayList<Territory>();
                                for (int i = 0; i < maxTerritoriesToPopulate; ++i) {
                                    Territory choice = distanceMap.lowestKey();
                                    distanceMap.removeKey(choice);
                                    choices.add(choice);
                                }
                                Collections.shuffle(choices);
                                picked = (Territory)choices.get(0);
                            }
                        }
                    }
                } else {
                    List<Territory> capitals = TerritoryAttachment.getAllCapitals(me, data);
                    ArrayList<Territory> test = new ArrayList<Territory>(capitals);
                    test.retainAll(notOwned);
                    if (!test.isEmpty()) {
                        picked = (Territory)test.get(0);
                    } else {
                        if (capitals.isEmpty()) {
                            capitals.addAll(Match.getMatches(data.getMap().getTerritories(), new CompositeMatchAnd(Matches.isTerritoryOwnedBy(me), Matches.territoryHasUnitsOwnedBy(me), Matches.TerritoryIsLand)));
                        }
                        if (capitals.isEmpty()) {
                            picked = territoryChoices.get(0);
                        } else {
                            IntegerMap<Territory> distanceMap = data.getMap().getDistance(capitals.get(0), notOwned, Match.<Territory>getAlwaysMatch());
                            picked = distanceMap.lowestKey();
                        }
                    }
                }
            }
            unitsToPlace = new HashSet<Unit>();
            if (unitChoices == null || unitChoices.isEmpty() || unitsPerPick <= 0) break block31;
            Collections.shuffle(unitChoices);
            List<Unit> nonFactory = Match.getMatches(unitChoices, Matches.UnitCanProduceUnits.invert());
            if (nonFactory.isEmpty()) {
                for (int i = 0; i < unitsPerPick && !unitChoices.isEmpty(); ++i) {
                    unitsToPlace.add(unitChoices.get(0));
                }
            } else {
                for (int i = 0; i < unitsPerPick && !nonFactory.isEmpty(); ++i) {
                    unitsToPlace.add(nonFactory.get(0));
                }
            }
        }
        return new Tuple<Territory, Set<Unit>>(picked, unitsToPlace);
    }
}

