/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class AdvancedUtils {
    public static Unit getLastUnitMatching(List<Unit> units, Match<Unit> match, int endIndex) {
        int index = AdvancedUtils.getIndexOfLastUnitMatching(units, match, endIndex);
        if (index == -1) {
            return null;
        }
        return units.get(index);
    }

    public static int getIndexOfLastUnitMatching(List<Unit> units, Match<Unit> match, int endIndex) {
        for (int i = endIndex; i >= 0; --i) {
            Unit unit = units.get(i);
            if (!match.match(unit)) continue;
            return i;
        }
        return -1;
    }

    public static Unit getFirstUnitMatching(List<Unit> units, Match<Unit> match, int startIndex) {
        int index = AdvancedUtils.getIndexOfFirstUnitMatching(units, match, startIndex);
        if (index == -1) {
            return null;
        }
        return units.get(index);
    }

    public static int getIndexOfFirstUnitMatching(List<Unit> units, Match<Unit> match, int startIndex) {
        for (int i = startIndex; i < units.size(); ++i) {
            Unit unit = units.get(i);
            if (!match.match(unit)) continue;
            return i;
        }
        return -1;
    }

    public static int getSlowestMovementUnitInList(Collection<Unit> list) {
        int lowestMovement = Integer.MAX_VALUE;
        for (Unit unit : list) {
            TripleAUnit tu = TripleAUnit.get(unit);
            if (tu.getMovementLeft() >= lowestMovement || TripleAUnit.get(unit).getTransportedBy() != null && list.contains(TripleAUnit.get(unit).getTransportedBy())) continue;
            lowestMovement = tu.getMovementLeft();
        }
        if (lowestMovement == Integer.MAX_VALUE) {
            return -1;
        }
        return lowestMovement;
    }

    public static int getFastestMovementUnitInList(Collection<Unit> list) {
        int fastestMovement = Integer.MIN_VALUE;
        for (Unit unit : list) {
            TripleAUnit tu = TripleAUnit.get(unit);
            if (tu.getMovementLeft() <= fastestMovement) continue;
            fastestMovement = tu.getMovementLeft();
        }
        if (fastestMovement == Integer.MIN_VALUE) {
            return -1;
        }
        return fastestMovement;
    }

    public static Route trimRouteAtFirstTerWithEnemyUnits(Route route, int newRouteJumpCount, PlayerID player, GameData data) {
        return AdvancedUtils.trimRouteAtFirstTerMatchingX(route, newRouteJumpCount, player, data, Matches.territoryHasUnitsThatMatch(new CompositeMatchAnd<Unit>(Matches.unitHasDefenseThatIsMoreThanOrEqualTo(1), Matches.unitIsEnemyOf(data, player))));
    }

    public static Route trimRouteAtFirstTerMatchingX(Route route, int newRouteJumpCount, PlayerID player, GameData data, Match<Territory> match) {
        ArrayList<Territory> newTers = new ArrayList<Territory>();
        int i = 0;
        for (Territory ter : route.getTerritories()) {
            newTers.add(ter);
            if ((!match.match(ter) || i == 0) && ++i <= newRouteJumpCount) continue;
            break;
        }
        return new Route(newTers);
    }

    public static Route trimRouteAtLastFriendlyTer(Route route, int newRouteJumpCount, PlayerID player, GameData data) {
        return AdvancedUtils.trimRouteBeforeFirstTerMatching(route, newRouteJumpCount, player, data, Matches.isTerritoryEnemyAndNotUnownedWater(player, data));
    }

    public static Route trimRouteBeforeFirstTerMatching(Route route, int newRouteJumpCount, PlayerID player, GameData data, Match<Territory> match) {
        ArrayList<Territory> newTers = new ArrayList<Territory>();
        int i = 0;
        for (Territory ter : route.getTerritories()) {
            if (match.match(ter) && i != 0) break;
            newTers.add(ter);
            if (++i <= newRouteJumpCount) continue;
            break;
        }
        if (newTers.size() < 2) {
            return null;
        }
        return new Route(newTers);
    }

    public static Route trimRouteBeforeFirstTerWithEnemyUnits(Route route, int newRouteJumpCount, PlayerID player, GameData data) {
        return AdvancedUtils.trimRouteBeforeFirstTerMatching(route, newRouteJumpCount, player, data, Matches.territoryHasUnitsThatMatch(new CompositeMatchAnd<Unit>(Matches.unitHasDefenseThatIsMoreThanOrEqualTo(1), Matches.unitIsEnemyOf(data, player))));
    }

    public static Route trimRouteToLength(Route route, int newRouteJumpCount, PlayerID player, GameData data) {
        ArrayList<Territory> newTers = new ArrayList<Territory>();
        int i = 0;
        for (Territory ter : route.getTerritories()) {
            newTers.add(ter);
            if (++i <= newRouteJumpCount) continue;
            break;
        }
        if (newTers.size() < 2) {
            return null;
        }
        return new Route(newTers);
    }

    public static List<Territory> getTerritoriesWithinXDistanceOfY(GameData data, Territory start, int maxDistance) {
        return AdvancedUtils.getTerritoriesWithinXDistanceOfYMatchingZ(data, start, maxDistance, Match.ALWAYS_MATCH);
    }

    public static List<Territory> getTerritoriesWithinXDistanceOfYMatchingZ(GameData data, Territory start, int maxDistance, Match<Territory> match) {
        return AdvancedUtils.getTerritoriesWithinXDistanceOfYMatchingZAndHavingRouteMatchingA(data, start, maxDistance, match, Match.ALWAYS_MATCH);
    }

    public static List<Territory> getTerritoriesWithinXDistanceOfYMatchingZAndHavingRouteMatchingA(GameData data, Territory start, int maxDistance, Match<Territory> match, Match<Territory> routeMatch) {
        HashSet<Territory> processed = new HashSet<Territory>();
        processed.add(start);
        ArrayList<Territory> result = new ArrayList<Territory>();
        HashSet<Territory> nextSet = new HashSet<Territory>(data.getMap().getNeighbors(start));
        if (match.match(start)) {
            result.add(start);
        }
        for (int dist = 1; nextSet.size() > 0 && dist <= maxDistance; ++dist) {
            HashSet<Territory> newSet = new HashSet<Territory>();
            for (Territory ter : nextSet) {
                processed.add(ter);
                if (routeMatch.match(ter)) {
                    newSet.addAll(data.getMap().getNeighbors(ter));
                }
                if (!match.match(ter)) continue;
                result.add(ter);
            }
            newSet.removeAll(processed);
            nextSet = newSet;
        }
        return result;
    }

    public static List<Unit> interleaveCarriersAndPlanes(List<Unit> units, int planesThatDontNeedToLand) {
        if (!Match.someMatch(units, Matches.UnitIsCarrier) || !Match.someMatch(units, Matches.UnitCanLandOnCarrier)) {
            return units;
        }
        ArrayList<Unit> result = new ArrayList<Unit>(units);
        Unit seekedCarrier = null;
        int indexToPlaceCarrierAt = -1;
        int spaceLeftOnSeekedCarrier = -1;
        int processedPlaneCount = 0;
        ArrayList<Unit> filledCarriers = new ArrayList<Unit>();
        for (int i = result.size() - 1; i >= 0; --i) {
            Unit unit = result.get(i);
            UnitAttachment ua = UnitAttachment.get(unit.getUnitType());
            if (ua.getCarrierCost() <= 0) continue;
            if (processedPlaneCount < planesThatDontNeedToLand) {
                ++processedPlaneCount;
                continue;
            }
            if (seekedCarrier == null) {
                int seekedCarrierIndex = AdvancedUtils.getIndexOfLastUnitMatching(result, new CompositeMatchAnd<Unit>(Matches.UnitIsCarrier, Matches.isNotInList(filledCarriers)), result.size() - 1);
                if (seekedCarrierIndex == -1) break;
                seekedCarrier = result.get(seekedCarrierIndex);
                indexToPlaceCarrierAt = i + 1;
                spaceLeftOnSeekedCarrier = UnitAttachment.get(seekedCarrier.getUnitType()).getCarrierCapacity();
            }
            if ((spaceLeftOnSeekedCarrier -= ua.getCarrierCost()) > 0) continue;
            if (spaceLeftOnSeekedCarrier < 0) {
                ++i;
            }
            if (result.indexOf(seekedCarrier) < i) {
                result.remove(seekedCarrier);
                result.add(indexToPlaceCarrierAt - 1, seekedCarrier);
                --i;
                filledCarriers.add(seekedCarrier);
                seekedCarrier = AdvancedUtils.getLastUnitMatching(result, new CompositeMatchAnd<Unit>(Matches.UnitIsCarrier, Matches.isNotInList(filledCarriers)), result.size() - 1);
                if (seekedCarrier == null) break;
                indexToPlaceCarrierAt = i;
                spaceLeftOnSeekedCarrier = UnitAttachment.get(seekedCarrier.getUnitType()).getCarrierCapacity();
                continue;
            }
            int oldIndex = result.indexOf(seekedCarrier);
            int carrierPlaceLocation = indexToPlaceCarrierAt;
            result.remove(seekedCarrier);
            if (oldIndex < indexToPlaceCarrierAt) {
                --carrierPlaceLocation;
            }
            result.add(carrierPlaceLocation, seekedCarrier);
            filledCarriers.add(seekedCarrier);
            ArrayList<Unit> planesBetweenHereAndCarrier = new ArrayList<Unit>();
            for (int i2 = i; i2 < carrierPlaceLocation; ++i2) {
                Unit unit2 = result.get(i2);
                UnitAttachment ua2 = UnitAttachment.get(unit2.getUnitType());
                if (ua2.getCarrierCost() <= 0) continue;
                planesBetweenHereAndCarrier.add(unit2);
            }
            Collections.reverse(planesBetweenHereAndCarrier);
            int planeMoveCount = 0;
            for (Unit plane : planesBetweenHereAndCarrier) {
                result.remove(plane);
                result.add(carrierPlaceLocation - 1, plane);
                ++planeMoveCount;
            }
            seekedCarrier = AdvancedUtils.getLastUnitMatching(result, new CompositeMatchAnd<Unit>(Matches.UnitIsCarrier, Matches.isNotInList(filledCarriers)), result.size() - 1);
            if (seekedCarrier == null) break;
            indexToPlaceCarrierAt = carrierPlaceLocation - planeMoveCount;
            spaceLeftOnSeekedCarrier = UnitAttachment.get(seekedCarrier.getUnitType()).getCarrierCapacity();
        }
        return result;
    }
}

