/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.proAI;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameStep;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.TechnologyFrontier;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.framework.GameDataUtils;
import games.strategy.net.GUID;
import games.strategy.triplea.Properties;
import games.strategy.triplea.ai.AbstractAI;
import games.strategy.triplea.ai.proAI.ProAttackTerritoryData;
import games.strategy.triplea.ai.proAI.ProBattleResultData;
import games.strategy.triplea.ai.proAI.ProCombatMoveAI;
import games.strategy.triplea.ai.proAI.ProNonCombatMoveAI;
import games.strategy.triplea.ai.proAI.ProPoliticsAI;
import games.strategy.triplea.ai.proAI.ProPurchaseAI;
import games.strategy.triplea.ai.proAI.ProPurchaseTerritory;
import games.strategy.triplea.ai.proAI.ProRetreatAI;
import games.strategy.triplea.ai.proAI.ProScrambleAI;
import games.strategy.triplea.ai.proAI.logging.LogUI;
import games.strategy.triplea.ai.proAI.simulate.ProDummyDelegateBridge;
import games.strategy.triplea.ai.proAI.simulate.ProSimulateTurnUtils;
import games.strategy.triplea.ai.proAI.util.LogUtils;
import games.strategy.triplea.ai.proAI.util.ProAttackOptionsUtils;
import games.strategy.triplea.ai.proAI.util.ProBattleUtils;
import games.strategy.triplea.ai.proAI.util.ProMoveUtils;
import games.strategy.triplea.ai.proAI.util.ProPurchaseUtils;
import games.strategy.triplea.ai.proAI.util.ProTerritoryValueUtils;
import games.strategy.triplea.ai.proAI.util.ProTransportUtils;
import games.strategy.triplea.ai.proAI.util.ProUtils;
import games.strategy.triplea.ai.strongAI.SUtils;
import games.strategy.triplea.attatchments.PoliticalActionAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.AbstractMoveDelegate;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.BattleDelegate;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.PoliticsDelegate;
import games.strategy.triplea.delegate.TechAdvance;
import games.strategy.triplea.delegate.dataObjects.CasualtyDetails;
import games.strategy.triplea.delegate.dataObjects.CasualtyList;
import games.strategy.triplea.delegate.remote.IAbstractPlaceDelegate;
import games.strategy.triplea.delegate.remote.IMoveDelegate;
import games.strategy.triplea.delegate.remote.IPurchaseDelegate;
import games.strategy.triplea.delegate.remote.ITechDelegate;
import games.strategy.triplea.oddsCalculator.ta.ConcurrentOddsCalculator;
import games.strategy.triplea.oddsCalculator.ta.IOddsCalculator;
import games.strategy.triplea.ui.TripleAFrame;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProAI
extends AbstractAI {
    private static final Logger s_logger = Logger.getLogger(ProAI.class.getName());
    private static final IOddsCalculator s_battleCalculator = new ConcurrentOddsCalculator("ProAI");
    private final ProUtils utils = new ProUtils(this);
    private final ProBattleUtils battleUtils = new ProBattleUtils(this, this.utils);
    private final ProTransportUtils transportUtils = new ProTransportUtils(this, this.utils);
    private final ProAttackOptionsUtils attackOptionsUtils;
    private final ProMoveUtils moveUtils;
    private final ProTerritoryValueUtils territoryValueUtils;
    private final ProSimulateTurnUtils simulateTurnUtils;
    private final ProPurchaseUtils purchaseUtils = new ProPurchaseUtils(this);
    private final ProCombatMoveAI combatMoveAI;
    private final ProNonCombatMoveAI nonCombatMoveAI;
    private final ProPurchaseAI purchaseAI;
    private final ProRetreatAI retreatAI;
    private final ProScrambleAI scrambleAI;
    private final ProPoliticsAI politicsAI;
    private GameData data = null;
    private Map<Territory, ProAttackTerritoryData> storedCombatMoveMap = null;
    private Map<Territory, ProAttackTerritoryData> storedFactoryMoveMap;
    private Map<Territory, ProPurchaseTerritory> storedPurchaseTerritories = null;
    private List<PoliticalActionAttachment> storedPoliticalActions;

    public ProAI(String name, String type) {
        super(name, type);
        this.attackOptionsUtils = new ProAttackOptionsUtils(this, this.utils, this.battleUtils, this.transportUtils, this.purchaseUtils);
        this.moveUtils = new ProMoveUtils(this, this.utils);
        this.territoryValueUtils = new ProTerritoryValueUtils(this, this.utils, this.battleUtils);
        this.simulateTurnUtils = new ProSimulateTurnUtils(this, this.utils, this.battleUtils, this.moveUtils);
        this.combatMoveAI = new ProCombatMoveAI(this.utils, this.battleUtils, this.transportUtils, this.attackOptionsUtils, this.moveUtils, this.territoryValueUtils, this.purchaseUtils);
        this.nonCombatMoveAI = new ProNonCombatMoveAI(this.utils, this.battleUtils, this.transportUtils, this.attackOptionsUtils, this.moveUtils, this.territoryValueUtils, this.purchaseUtils);
        this.purchaseAI = new ProPurchaseAI(this, this.utils, this.battleUtils, this.transportUtils, this.attackOptionsUtils, this.moveUtils, this.territoryValueUtils, this.purchaseUtils);
        this.retreatAI = new ProRetreatAI(this, this.battleUtils);
        this.scrambleAI = new ProScrambleAI(this, this.battleUtils, this.attackOptionsUtils);
        this.politicsAI = new ProPoliticsAI(this, this.utils, this.attackOptionsUtils);
    }

    public static void Initialize(TripleAFrame frame) {
        LogUI.initialize(frame);
        LogUtils.log(Level.FINE, "Initialized Hard AI");
    }

    public static void ShowSettingsWindow() {
        LogUtils.log(Level.FINE, "Showing Hard AI settings window");
        LogUI.showSettingsWindow();
    }

    public static Logger getLogger() {
        return s_logger;
    }

    public static void gameOverClearCache() {
        s_battleCalculator.setGameData(null);
        LogUI.clearCachedInstances();
    }

    public IOddsCalculator getCalc() {
        return s_battleCalculator;
    }

    @Override
    public final GameData getGameData() {
        if (this.data != null) {
            return this.data;
        }
        return super.getGameData();
    }

    @Override
    public void stopGame() {
        super.stopGame();
        s_battleCalculator.cancel();
    }

    @Override
    protected void move(boolean nonCombat, IMoveDelegate moveDel, GameData data, PlayerID player) {
        long start = System.currentTimeMillis();
        BattleCalculator.clearOOLCache();
        LogUI.notifyStartOfRound(data.getSequence().getRound(), player.getName());
        s_battleCalculator.setGameData(data);
        if (nonCombat) {
            this.nonCombatMoveAI.doNonCombatMove(this.storedFactoryMoveMap, this.storedPurchaseTerritories, moveDel, data, player, false);
            this.storedFactoryMoveMap = null;
        } else if (this.storedCombatMoveMap == null) {
            this.combatMoveAI.doCombatMove(moveDel, data, player, false);
        } else {
            this.combatMoveAI.doMove(this.storedCombatMoveMap, moveDel, data, player, false);
            this.storedCombatMoveMap = null;
        }
        LogUtils.log(Level.FINE, player.getName() + " time for nonCombat=" + nonCombat + " time=" + (System.currentTimeMillis() - start));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void purchase(boolean purchaseForBid, int PUsToSpend, IPurchaseDelegate purchaseDelegate, GameData data, PlayerID player) {
        long start = System.currentTimeMillis();
        BattleCalculator.clearOOLCache();
        LogUI.notifyStartOfRound(data.getSequence().getRound(), player.getName());
        if (PUsToSpend <= 0) {
            return;
        }
        if (purchaseForBid) {
            this.purchaseAI.bid(PUsToSpend, purchaseDelegate, data, player);
        } else {
            GameData dataCopy;
            PUsToSpend = this.purchaseAI.repair(PUsToSpend, purchaseDelegate, data, player);
            Map<Territory, ProPurchaseTerritory> purchaseTerritories = this.purchaseUtils.findPurchaseTerritories(player);
            if (purchaseTerritories.isEmpty()) {
                LogUtils.log(Level.FINE, "No possible place territories owned so exiting purchase logic");
                return;
            }
            LogUtils.log(Level.FINE, "Starting simulation for purchase phase");
            try {
                data.acquireReadLock();
                dataCopy = GameDataUtils.cloneGameData(data, true);
            }
            catch (Throwable t) {
                LogUtils.log(Level.WARNING, "Error trying to clone game data for simulating phases", t);
                return;
            }
            finally {
                data.releaseReadLock();
            }
            this.data = dataCopy;
            s_battleCalculator.setGameData(dataCopy);
            PlayerID playerCopy = dataCopy.getPlayerList().getPlayerID(player.getName());
            AbstractMoveDelegate moveDel = DelegateFinder.moveDelegate(dataCopy);
            ProDummyDelegateBridge bridge = new ProDummyDelegateBridge(this, playerCopy, dataCopy);
            moveDel.setDelegateBridgeAndPlayer(bridge);
            ArrayList<GameStep> gameSteps = new ArrayList<GameStep>();
            for (GameStep gameStep : dataCopy.getSequence()) {
                gameSteps.add(gameStep);
            }
            int nextStepIndex = dataCopy.getSequence().getStepIndex() + 1;
            Map<Unit, Territory> unitTerritoryMap = this.utils.createUnitTerritoryMap(playerCopy);
            for (int i = nextStepIndex; i < gameSteps.size(); ++i) {
                GameStep step = (GameStep)gameSteps.get(i);
                if (!playerCopy.equals(step.getPlayerID())) continue;
                dataCopy.getSequence().setRoundAndStep(dataCopy.getSequence().getRound(), step.getDisplayName(), step.getPlayerID());
                String stepName = step.getName();
                LogUtils.log(Level.FINE, "Simulating phase: " + stepName);
                if (stepName.endsWith("NonCombatMove")) {
                    Map<Territory, ProAttackTerritoryData> factoryMoveMap = this.nonCombatMoveAI.doNonCombatMove(null, null, moveDel, dataCopy, playerCopy, true);
                    if (this.storedFactoryMoveMap != null) continue;
                    this.storedFactoryMoveMap = this.simulateTurnUtils.transferMoveMap(factoryMoveMap, unitTerritoryMap, dataCopy, data, player);
                    continue;
                }
                if (stepName.endsWith("CombatMove") && !stepName.endsWith("AirborneCombatMove")) {
                    Map<Territory, ProAttackTerritoryData> moveMap = this.combatMoveAI.doCombatMove(moveDel, dataCopy, playerCopy, true);
                    if (this.storedCombatMoveMap != null) continue;
                    this.storedCombatMoveMap = this.simulateTurnUtils.transferMoveMap(moveMap, unitTerritoryMap, dataCopy, data, player);
                    continue;
                }
                if (stepName.endsWith("Battle")) {
                    this.simulateTurnUtils.simulateBattles(dataCopy, playerCopy, bridge);
                    continue;
                }
                if (stepName.endsWith("Place") || stepName.endsWith("EndTurn")) {
                    this.storedPurchaseTerritories = this.purchaseAI.purchase(PUsToSpend, purchaseDelegate, dataCopy, data, player);
                    this.data = null;
                    break;
                }
                if (!stepName.endsWith("Politics")) continue;
                PoliticsDelegate politicsDelegate = DelegateFinder.politicsDelegate(dataCopy);
                politicsDelegate.setDelegateBridgeAndPlayer(bridge);
                List<PoliticalActionAttachment> actions = this.politicsAI.politicalActions();
                if (this.storedPoliticalActions != null) continue;
                this.storedPoliticalActions = actions;
            }
        }
        LogUtils.log(Level.FINE, player.getName() + " time for purchase=" + (System.currentTimeMillis() - start));
    }

    @Override
    protected void place(boolean bid, IAbstractPlaceDelegate placeDelegate, GameData data, PlayerID player) {
        long start = System.currentTimeMillis();
        BattleCalculator.clearOOLCache();
        LogUI.notifyStartOfRound(data.getSequence().getRound(), player.getName());
        if (bid) {
            this.purchaseAI.bidPlace(this.storedPurchaseTerritories, placeDelegate, data, player);
        } else {
            this.purchaseAI.place(this.storedPurchaseTerritories, placeDelegate, data, player);
            this.storedPurchaseTerritories = null;
        }
        LogUtils.log(Level.FINE, player.getName() + " time for place=" + (System.currentTimeMillis() - start));
    }

    @Override
    protected void tech(ITechDelegate techDelegate, GameData data, PlayerID player) {
        if (!Properties.getWW2V3TechModel(data)) {
            return;
        }
        long last = System.currentTimeMillis();
        s_logger.fine("Doing Tech ");
        Territory myCapitol = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        float eStrength = SUtils.getStrengthOfPotentialAttackers(myCapitol, data, player, false, true, null);
        float myStrength = SUtils.strength(myCapitol.getUnits().getUnits(), false, false, false);
        List<Territory> areaStrength = SUtils.getNeighboringLandTerritories(data, player, myCapitol);
        for (Territory areaTerr : areaStrength) {
            myStrength += SUtils.strength(areaTerr.getUnits().getUnits(), false, false, false) * 0.75f;
        }
        boolean capDanger = myStrength < eStrength * 1.25f + 3.0f;
        Resource pus = data.getResourceList().getResource("PUs");
        int PUs = player.getResources().getQuantity(pus);
        Resource techtokens = data.getResourceList().getResource("techTokens");
        int TechTokens = player.getResources().getQuantity(techtokens);
        int TokensToBuy = 0;
        if (!capDanger && TechTokens < 3 && (double)PUs > Math.random() * 160.0) {
            TokensToBuy = 1;
        }
        if (TechTokens > 0 || TokensToBuy > 0) {
            List<TechnologyFrontier> cats = TechAdvance.getPlayerTechCategories(data, player);
            if (data.getTechnologyFrontier().isEmpty()) {
                if (Math.random() > 0.35) {
                    techDelegate.rollTech(TechTokens + TokensToBuy, cats.get(1), TokensToBuy, null);
                } else {
                    techDelegate.rollTech(TechTokens + TokensToBuy, cats.get(0), TokensToBuy, null);
                }
            } else {
                int rand = (int)(Math.random() * (double)cats.size());
                techDelegate.rollTech(TechTokens + TokensToBuy, cats.get(rand), TokensToBuy, null);
            }
        }
        long now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
    }

    @Override
    public Territory retreatQuery(GUID battleID, boolean submerge, Territory battleTerritory, Collection<Territory> possibleTerritories, String message) {
        GameData data = this.getGameData();
        PlayerID player = this.getPlayerID();
        BattleDelegate delegate = DelegateFinder.battleDelegate(data);
        IBattle battle = delegate.getBattleTracker().getPendingBattle(battleID);
        if (battle == null || battleTerritory == null || battle.isAmphibious()) {
            return null;
        }
        boolean isAttacker = player.equals(battle.getAttacker());
        List attackers = (List)battle.getAttackingUnits();
        List defenders = (List)battle.getDefendingUnits();
        double strengthDifference = this.battleUtils.estimateStrengthDifference(battleTerritory, attackers, defenders);
        LogUtils.log(Level.FINE, player.getName() + " checking retreat from territory " + battleTerritory + ", attackers=" + attackers.size() + ", defenders=" + defenders.size() + ", submerge=" + submerge + ", attacker=" + isAttacker);
        if (isAttacker && strengthDifference > 50.0 && (battleTerritory.isWater() || Match.someMatch(attackers, Matches.UnitIsLand))) {
            return null;
        }
        s_battleCalculator.setGameData(this.getGameData());
        return this.retreatAI.retreatQuery(battleID, submerge, battleTerritory, possibleTerritories, message);
    }

    @Override
    public boolean shouldBomberBomb(Territory territory) {
        return false;
    }

    @Override
    public Collection<Unit> getNumberOfFightersToMoveToNewCarrier(Collection<Unit> fightersThatCanBeMoved, Territory from) {
        ArrayList<Unit> rVal = new ArrayList<Unit>();
        return rVal;
    }

    @Override
    public CasualtyDetails selectCasualties(Collection<Unit> selectFrom, Map<Unit, Collection<Unit>> dependents, int count, String message, DiceRoll dice, PlayerID hit, Collection<Unit> friendlyUnits, PlayerID enemyPlayer, Collection<Unit> enemyUnits, boolean amphibious, Collection<Unit> amphibiousLandAttackers, CasualtyList defaultCasualties, GUID battleID, Territory battlesite, boolean allowMultipleHitsPerUnit) {
        if (defaultCasualties.size() != count) {
            throw new IllegalStateException("Select Casualties showing different numbers for number of hits to take vs total size of default casualty selections");
        }
        if (defaultCasualties.getKilled().size() <= 0) {
            return new CasualtyDetails(defaultCasualties, false);
        }
        CasualtyDetails myCasualties = new CasualtyDetails(false);
        myCasualties.addToDamaged(defaultCasualties.getDamaged());
        ArrayList<Unit> selectFromSorted = new ArrayList<Unit>(selectFrom);
        if (enemyUnits.isEmpty()) {
            Collections.sort(selectFromSorted, ProPurchaseUtils.getCostComparator());
        } else {
            GameData data = this.getGameData();
            PlayerID player = this.getPlayerID();
            BattleDelegate delegate = DelegateFinder.battleDelegate(data);
            IBattle battle = delegate.getBattleTracker().getPendingBattle(battleID);
            boolean needToCheck = true;
            boolean isAttacker = player.equals(battle.getAttacker());
            if (!isAttacker) {
                List attackers = (List)battle.getAttackingUnits();
                List defenders = (List)battle.getDefendingUnits();
                defenders.removeAll(defaultCasualties.getKilled());
                double strengthDifference = this.battleUtils.estimateStrengthDifference(battlesite, attackers, defenders);
                int minStrengthDifference = 60;
                if (!Properties.getLow_Luck(data)) {
                    minStrengthDifference = 55;
                }
                if (strengthDifference > (double)minStrengthDifference) {
                    needToCheck = false;
                }
            }
            while (needToCheck) {
                needToCheck = false;
                for (int i = 0; i < selectFromSorted.size() - 1; ++i) {
                    double unitCost2;
                    Unit unit1 = (Unit)selectFromSorted.get(i);
                    Unit unit2 = (Unit)selectFromSorted.get(i + 1);
                    double unitCost1 = ProPurchaseUtils.getCost(unit1.getType(), unit1.getOwner(), unit1.getData());
                    if (!(unitCost1 > 1.5 * (unitCost2 = ProPurchaseUtils.getCost(unit2.getType(), unit2.getOwner(), unit2.getData())))) continue;
                    selectFromSorted.set(i, unit2);
                    selectFromSorted.set(i + 1, unit1);
                    needToCheck = true;
                }
            }
        }
        ArrayList<Unit> interleavedTargetList = new ArrayList<Unit>(ProTransportUtils.InterleaveUnits_CarriersAndPlanes(selectFromSorted, 0));
        for (int i = 0; i < defaultCasualties.getKilled().size(); ++i) {
            myCasualties.addToKilled((Unit)interleavedTargetList.get(i));
        }
        if (count != myCasualties.size()) {
            throw new IllegalStateException("AI chose wrong number of casualties");
        }
        return myCasualties;
    }

    @Override
    public HashMap<Territory, Collection<Unit>> scrambleUnitsQuery(Territory scrambleTo, Map<Territory, Tuple<Collection<Unit>, Collection<Unit>>> possibleScramblers) {
        GameData data = this.getGameData();
        PlayerID player = this.getPlayerID();
        BattleDelegate delegate = DelegateFinder.battleDelegate(data);
        IBattle battle = delegate.getBattleTracker().getPendingBattle(scrambleTo, false, IBattle.BattleType.NORMAL);
        if (battle == null) {
            return null;
        }
        List attackers = (List)battle.getAttackingUnits();
        List defenders = (List)battle.getDefendingUnits();
        LogUtils.log(Level.FINE, player.getName() + " checking scramble to " + scrambleTo + ", attackers=" + attackers.size() + ", defenders=" + defenders.size() + ", possibleScramblers=" + possibleScramblers);
        s_battleCalculator.setGameData(this.getGameData());
        return this.scrambleAI.scrambleUnitsQuery(scrambleTo, possibleScramblers);
    }

    @Override
    public boolean selectAttackSubs(Territory unitTerritory) {
        GameData data = this.getGameData();
        PlayerID player = this.getPlayerID();
        BattleDelegate delegate = DelegateFinder.battleDelegate(data);
        IBattle battle = delegate.getBattleTracker().getPendingBattle(unitTerritory, false, IBattle.BattleType.NORMAL);
        if (battle == null) {
            return false;
        }
        List attackers = (List)battle.getAttackingUnits();
        List defenders = (List)battle.getDefendingUnits();
        LogUtils.log(Level.FINE, player.getName() + " checking sub attack in " + unitTerritory + ", attackers=" + attackers + ", defenders=" + defenders);
        s_battleCalculator.setGameData(this.getGameData());
        ProBattleResultData result = this.battleUtils.calculateBattleResults(player, unitTerritory, attackers, defenders, new HashSet<Unit>(), true);
        LogUtils.log(Level.FINER, player.getName() + " sub attack TUVSwing=" + result.getTUVSwing());
        return result.getTUVSwing() > 0.0;
    }

    @Override
    public void politicalActions() {
        if (this.storedPoliticalActions == null) {
            this.politicsAI.politicalActions();
        } else {
            this.politicsAI.doActions(this.storedPoliticalActions);
            this.storedPoliticalActions = null;
        }
    }
}

