/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.proAI;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ProAmphibData {
    private Unit transport;
    private Map<Territory, Set<Territory>> transportMap;
    private Map<Territory, Set<Territory>> seaTransportMap;

    public ProAmphibData(Unit transport) {
        this.transport = transport;
        this.transportMap = new HashMap<Territory, Set<Territory>>();
        this.seaTransportMap = new HashMap<Territory, Set<Territory>>();
    }

    public void addTerritories(Set<Territory> attackTerritories, Set<Territory> myUnitsToLoadTerritories) {
        for (Territory attackTerritory : attackTerritories) {
            if (this.transportMap.containsKey(attackTerritory)) {
                this.transportMap.get(attackTerritory).addAll(myUnitsToLoadTerritories);
                continue;
            }
            HashSet<Territory> territories = new HashSet<Territory>();
            territories.addAll(myUnitsToLoadTerritories);
            this.transportMap.put(attackTerritory, territories);
        }
    }

    public void addSeaTerritories(Set<Territory> attackTerritories, Set<Territory> myUnitsToLoadTerritories, GameData data) {
        for (Territory attackTerritory : attackTerritories) {
            if (this.seaTransportMap.containsKey(attackTerritory)) {
                this.seaTransportMap.get(attackTerritory).addAll(myUnitsToLoadTerritories);
                continue;
            }
            HashSet<Territory> territories = new HashSet<Territory>();
            territories.addAll(myUnitsToLoadTerritories);
            this.seaTransportMap.put(attackTerritory, territories);
        }
    }

    public void setTransport(Unit transport) {
        this.transport = transport;
    }

    public Unit getTransport() {
        return this.transport;
    }

    public void setTransportMap(Map<Territory, Set<Territory>> transportMap) {
        this.transportMap = transportMap;
    }

    public Map<Territory, Set<Territory>> getTransportMap() {
        return this.transportMap;
    }

    public void setSeaTransportMap(Map<Territory, Set<Territory>> seaTransportMap) {
        this.seaTransportMap = seaTransportMap;
    }

    public Map<Territory, Set<Territory>> getSeaTransportMap() {
        return this.seaTransportMap;
    }
}

