/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.proAI;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.Properties;
import games.strategy.triplea.ai.proAI.ProBattleResultData;
import games.strategy.triplea.ai.proAI.ProCombatMoveAI;
import games.strategy.triplea.ai.proAI.util.ProMatches;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProAttackTerritoryData {
    private Territory territory;
    private List<Unit> maxUnits;
    private List<Unit> units;
    private ProBattleResultData maxBattleResult;
    private double value;
    private double seaValue;
    private boolean canHold;
    private boolean canAttack;
    private double strengthEstimate;
    private List<Unit> maxAmphibUnits;
    private Map<Unit, List<Unit>> amphibAttackMap;
    private final Map<Unit, Territory> transportTerritoryMap;
    private boolean needAmphibUnits;
    private Map<Unit, Boolean> isTransportingMap;
    private Set<Unit> maxBombardUnits;
    private Map<Unit, Set<Territory>> bombardOptionsMap;
    private final Map<Unit, Territory> bombardTerritoryMap;
    private boolean currentlyWins;
    private ProBattleResultData battleResult;
    private List<Unit> cantMoveUnits;
    private List<Unit> maxEnemyUnits;
    private Set<Unit> maxEnemyBombardUnits;
    private ProBattleResultData minBattleResult;
    private final List<Unit> tempUnits;
    private final Map<Unit, List<Unit>> tempAmphibAttackMap;
    private double loadValue;
    private List<Unit> maxScrambleUnits;

    public ProAttackTerritoryData(Territory territory) {
        this.territory = territory;
        this.maxUnits = new ArrayList<Unit>();
        this.units = new ArrayList<Unit>();
        this.cantMoveUnits = new ArrayList<Unit>();
        this.maxEnemyUnits = new ArrayList<Unit>();
        this.maxEnemyBombardUnits = new HashSet<Unit>();
        this.maxBattleResult = new ProBattleResultData();
        this.canHold = true;
        this.canAttack = false;
        this.strengthEstimate = Double.POSITIVE_INFINITY;
        this.maxAmphibUnits = new ArrayList<Unit>();
        this.maxBombardUnits = new HashSet<Unit>();
        this.needAmphibUnits = false;
        this.amphibAttackMap = new HashMap<Unit, List<Unit>>();
        this.isTransportingMap = new HashMap<Unit, Boolean>();
        this.transportTerritoryMap = new HashMap<Unit, Territory>();
        this.bombardOptionsMap = new HashMap<Unit, Set<Territory>>();
        this.bombardTerritoryMap = new HashMap<Unit, Territory>();
        this.currentlyWins = false;
        this.battleResult = null;
        this.minBattleResult = new ProBattleResultData();
        this.tempUnits = new ArrayList<Unit>();
        this.tempAmphibAttackMap = new HashMap<Unit, List<Unit>>();
        this.loadValue = 0.0;
        this.value = 0.0;
        this.seaValue = 0.0;
        this.maxScrambleUnits = new ArrayList<Unit>();
    }

    public ProAttackTerritoryData(ProAttackTerritoryData patd) {
        this.territory = patd.getTerritory();
        this.maxUnits = new ArrayList<Unit>(patd.getMaxUnits());
        this.units = new ArrayList<Unit>(patd.getUnits());
        this.cantMoveUnits = new ArrayList<Unit>(patd.getCantMoveUnits());
        this.maxEnemyUnits = new ArrayList<Unit>(patd.getMaxEnemyUnits());
        this.maxEnemyBombardUnits = new HashSet<Unit>(patd.getMaxEnemyBombardUnits());
        this.minBattleResult = patd.getMaxBattleResult();
        this.canHold = patd.isCanHold();
        this.canAttack = patd.isCanAttack();
        this.strengthEstimate = patd.getStrengthEstimate();
        this.maxAmphibUnits = new ArrayList<Unit>(patd.getMaxAmphibUnits());
        this.maxBombardUnits = new HashSet<Unit>(patd.getMaxBombardUnits());
        this.needAmphibUnits = patd.isNeedAmphibUnits();
        this.amphibAttackMap = new HashMap<Unit, List<Unit>>(patd.getAmphibAttackMap());
        this.isTransportingMap = new HashMap<Unit, Boolean>(patd.getIsTransportingMap());
        this.transportTerritoryMap = new HashMap<Unit, Territory>(patd.getTransportTerritoryMap());
        this.bombardOptionsMap = new HashMap<Unit, Set<Territory>>(patd.getBombardOptionsMap());
        this.bombardTerritoryMap = new HashMap<Unit, Territory>(patd.getBombardTerritoryMap());
        this.currentlyWins = patd.isCurrentlyWins();
        this.battleResult = patd.getBattleResult();
        this.minBattleResult = patd.getMinBattleResult();
        this.tempUnits = new ArrayList<Unit>(patd.getTempUnits());
        this.tempAmphibAttackMap = new HashMap<Unit, List<Unit>>(patd.getTempAmphibAttackMap());
        this.loadValue = patd.getLoadValue();
        this.value = patd.getValue();
        this.seaValue = patd.getSeaValue();
        this.maxScrambleUnits = new ArrayList<Unit>(patd.getMaxScrambleUnits());
    }

    public List<Unit> getAllDefenders() {
        ArrayList<Unit> defenders = new ArrayList<Unit>(this.units);
        defenders.addAll(this.cantMoveUnits);
        defenders.addAll(this.tempUnits);
        return defenders;
    }

    public List<Unit> getAllDefendersForCarrierCalcs(GameData data, PlayerID player) {
        if (Properties.getProduceNewFightersOnOldCarriers(data)) {
            return this.getAllDefenders();
        }
        List<Unit> defenders = Match.getMatches(this.cantMoveUnits, ProMatches.UnitIsOwnedCarrier(player).invert());
        defenders.addAll(this.units);
        defenders.addAll(this.tempUnits);
        return defenders;
    }

    public List<Unit> getMaxDefenders() {
        ArrayList<Unit> defenders = new ArrayList<Unit>(this.maxUnits);
        defenders.addAll(this.cantMoveUnits);
        return defenders;
    }

    public List<Unit> getMaxEnemyDefenders(PlayerID player, GameData data) {
        List<Unit> defenders = this.territory.getUnits().getMatches(Matches.enemyUnit(player, data));
        defenders.addAll(this.maxScrambleUnits);
        return defenders;
    }

    public String toString() {
        return this.territory.getName();
    }

    public void addUnit(Unit unit) {
        this.units.add(unit);
    }

    public void addUnits(List<Unit> units) {
        this.units.addAll(units);
    }

    public void addMaxUnits(List<Unit> units) {
        this.maxUnits.addAll(units);
    }

    public void addMaxAmphibUnits(List<Unit> amphibUnits) {
        this.maxAmphibUnits.addAll(amphibUnits);
    }

    public void addMaxUnit(Unit unit) {
        this.maxUnits.add(unit);
    }

    public void setTerritory(Territory territory) {
        this.territory = territory;
    }

    public Territory getTerritory() {
        return this.territory;
    }

    public void setMaxUnits(List<Unit> units) {
        this.maxUnits = units;
    }

    public List<Unit> getMaxUnits() {
        return this.maxUnits;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public void setUnits(List<Unit> units) {
        this.units = units;
    }

    public List<Unit> getUnits() {
        return this.units;
    }

    public void setCanHold(boolean canHold) {
        this.canHold = canHold;
    }

    public boolean isCanHold() {
        return this.canHold;
    }

    public void setMaxAmphibUnits(List<Unit> maxAmphibUnits) {
        this.maxAmphibUnits = maxAmphibUnits;
    }

    public List<Unit> getMaxAmphibUnits() {
        return this.maxAmphibUnits;
    }

    public void setNeedAmphibUnits(boolean needAmphibUnits) {
        this.needAmphibUnits = needAmphibUnits;
    }

    public boolean isNeedAmphibUnits() {
        return this.needAmphibUnits;
    }

    public Map<Unit, List<Unit>> getAmphibAttackMap() {
        return this.amphibAttackMap;
    }

    public void setAmphibAttackMap(Map<Unit, List<Unit>> amphibAttackMap) {
        this.amphibAttackMap = amphibAttackMap;
    }

    public void putAllAmphibAttackMap(Map<Unit, List<Unit>> amphibAttackMap) {
        for (Unit u : amphibAttackMap.keySet()) {
            this.putAmphibAttackMap(u, amphibAttackMap.get(u));
        }
    }

    public void putAmphibAttackMap(Unit transport, List<Unit> amphibUnits) {
        this.amphibAttackMap.put(transport, amphibUnits);
        this.isTransportingMap.put(transport, TransportTracker.isTransporting(transport));
    }

    public void setCanAttack(boolean canAttack) {
        this.canAttack = canAttack;
    }

    public boolean isCanAttack() {
        return this.canAttack;
    }

    public void setStrengthEstimate(double strengthEstimate) {
        this.strengthEstimate = strengthEstimate;
    }

    public double getStrengthEstimate() {
        return this.strengthEstimate;
    }

    public boolean isCurrentlyWins() {
        return this.currentlyWins;
    }

    public void setBattleResult(ProBattleResultData battleResult) {
        this.battleResult = battleResult;
        if (battleResult == null) {
            this.currentlyWins = false;
        } else if (battleResult.getWinPercentage() >= ProCombatMoveAI.WIN_PERCENTAGE && battleResult.isHasLandUnitRemaining()) {
            this.currentlyWins = true;
        }
    }

    public ProBattleResultData getBattleResult() {
        return this.battleResult;
    }

    public String getResultString() {
        if (this.battleResult == null) {
            return "territory=" + this.territory.getName();
        }
        return "territory=" + this.territory.getName() + ", win%=" + this.battleResult.getWinPercentage() + ", TUVSwing=" + this.battleResult.getTUVSwing() + ", hasRemainingLandUnit=" + this.battleResult.isHasLandUnitRemaining();
    }

    public void setCantMoveUnits(List<Unit> cantMoveUnits) {
        this.cantMoveUnits = cantMoveUnits;
    }

    public List<Unit> getCantMoveUnits() {
        return this.cantMoveUnits;
    }

    public void addCantMoveUnit(Unit unit) {
        this.cantMoveUnits.add(unit);
    }

    public void setMaxEnemyUnits(List<Unit> maxEnemyUnits) {
        this.maxEnemyUnits = maxEnemyUnits;
    }

    public List<Unit> getMaxEnemyUnits() {
        return this.maxEnemyUnits;
    }

    public void setMinBattleResult(ProBattleResultData minBattleResult) {
        this.minBattleResult = minBattleResult;
    }

    public ProBattleResultData getMinBattleResult() {
        return this.minBattleResult;
    }

    public List<Unit> getTempUnits() {
        return this.tempUnits;
    }

    public void addTempUnit(Unit unit) {
        this.tempUnits.add(unit);
    }

    public void addTempUnits(List<Unit> units) {
        this.tempUnits.addAll(units);
    }

    public Map<Unit, List<Unit>> getTempAmphibAttackMap() {
        return this.tempAmphibAttackMap;
    }

    public void putTempAmphibAttackMap(Unit transport, List<Unit> amphibUnits) {
        this.tempAmphibAttackMap.put(transport, amphibUnits);
    }

    public Map<Unit, Territory> getTransportTerritoryMap() {
        return this.transportTerritoryMap;
    }

    public void setLoadValue(double loadValue) {
        this.loadValue = loadValue;
    }

    public double getLoadValue() {
        return this.loadValue;
    }

    public void setIsTransportingMap(Map<Unit, Boolean> isTransportingMap) {
        this.isTransportingMap = isTransportingMap;
    }

    public Map<Unit, Boolean> getIsTransportingMap() {
        return this.isTransportingMap;
    }

    public void setSeaValue(double seaValue) {
        this.seaValue = seaValue;
    }

    public double getSeaValue() {
        return this.seaValue;
    }

    public Map<Unit, Territory> getBombardTerritoryMap() {
        return this.bombardTerritoryMap;
    }

    public void setMaxBombardUnits(Set<Unit> maxBombardUnits) {
        this.maxBombardUnits = maxBombardUnits;
    }

    public Set<Unit> getMaxBombardUnits() {
        return this.maxBombardUnits;
    }

    public void addMaxBombardUnit(Unit unit) {
        this.maxBombardUnits.add(unit);
    }

    public void setBombardOptionsMap(Map<Unit, Set<Territory>> bombardOptionsMap) {
        this.bombardOptionsMap = bombardOptionsMap;
    }

    public Map<Unit, Set<Territory>> getBombardOptionsMap() {
        return this.bombardOptionsMap;
    }

    public void addBombardOptionsMap(Unit unit, Territory t) {
        if (this.bombardOptionsMap.containsKey(unit)) {
            this.bombardOptionsMap.get(unit).add(t);
        } else {
            HashSet<Territory> territories = new HashSet<Territory>();
            territories.add(t);
            this.bombardOptionsMap.put(unit, territories);
        }
    }

    public void setMaxEnemyBombardUnits(Set<Unit> maxEnemyBombardUnits) {
        this.maxEnemyBombardUnits = maxEnemyBombardUnits;
    }

    public Set<Unit> getMaxEnemyBombardUnits() {
        return this.maxEnemyBombardUnits;
    }

    public void setMaxBattleResult(ProBattleResultData maxBattleResult) {
        this.maxBattleResult = maxBattleResult;
    }

    public ProBattleResultData getMaxBattleResult() {
        return this.maxBattleResult;
    }

    public void setMaxScrambleUnits(List<Unit> maxScrambleUnits) {
        this.maxScrambleUnits = maxScrambleUnits;
    }

    public List<Unit> getMaxScrambleUnits() {
        return this.maxScrambleUnits;
    }
}

