/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.proAI;

import games.strategy.engine.data.DefaultNamed;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.ai.proAI.ProAmphibData;
import games.strategy.triplea.ai.proAI.ProAttackTerritoryData;
import games.strategy.triplea.ai.proAI.ProBattleResultData;
import games.strategy.triplea.ai.proAI.ProPurchaseOption;
import games.strategy.triplea.ai.proAI.util.LogUtils;
import games.strategy.triplea.ai.proAI.util.ProAttackOptionsUtils;
import games.strategy.triplea.ai.proAI.util.ProBattleUtils;
import games.strategy.triplea.ai.proAI.util.ProMatches;
import games.strategy.triplea.ai.proAI.util.ProMoveUtils;
import games.strategy.triplea.ai.proAI.util.ProPurchaseUtils;
import games.strategy.triplea.ai.proAI.util.ProTerritoryValueUtils;
import games.strategy.triplea.ai.proAI.util.ProTransportUtils;
import games.strategy.triplea.ai.proAI.util.ProUtils;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.triplea.delegate.remote.IMoveDelegate;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;

public class ProCombatMoveAI {
    public static double WIN_PERCENTAGE = 95.0;
    public static double MIN_WIN_PERCENTAGE = 75.0;
    private final ProUtils utils;
    private final ProBattleUtils battleUtils;
    private final ProTransportUtils transportUtils;
    private final ProAttackOptionsUtils attackOptionsUtils;
    private final ProMoveUtils moveUtils;
    private final ProTerritoryValueUtils territoryValueUtils;
    private final ProPurchaseUtils purchaseUtils;
    private boolean areNeutralsPassableByAir;
    private GameData data;
    private PlayerID player;
    private Territory myCapital;
    private boolean isDefensive;
    private double minCostPerHitPoint;

    public ProCombatMoveAI(ProUtils utils, ProBattleUtils battleUtils, ProTransportUtils transportUtils, ProAttackOptionsUtils attackOptionsUtils, ProMoveUtils moveUtils, ProTerritoryValueUtils territoryValueUtils, ProPurchaseUtils purchaseUtils) {
        this.utils = utils;
        this.battleUtils = battleUtils;
        this.transportUtils = transportUtils;
        this.attackOptionsUtils = attackOptionsUtils;
        this.moveUtils = moveUtils;
        this.territoryValueUtils = territoryValueUtils;
        this.purchaseUtils = purchaseUtils;
    }

    public Map<Territory, ProAttackTerritoryData> doCombatMove(IMoveDelegate moveDel, GameData data, PlayerID player, boolean isSimulation) {
        LogUtils.log(Level.FINE, "Starting combat move phase");
        this.data = data;
        this.player = player;
        this.areNeutralsPassableByAir = Properties.getNeutralFlyoverAllowed(data) && !Properties.getNeutralsImpassable(data);
        this.myCapital = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        if (!Properties.getLow_Luck(data)) {
            WIN_PERCENTAGE = 90.0;
            MIN_WIN_PERCENTAGE = 65.0;
        }
        HashMap<Territory, ProAttackTerritoryData> attackMap = new HashMap<Territory, ProAttackTerritoryData>();
        HashMap<Unit, Set<Territory>> unitAttackMap = new HashMap<Unit, Set<Territory>>();
        HashMap<Unit, Set<Territory>> transportAttackMap = new HashMap<Unit, Set<Territory>>();
        HashMap<Unit, Set<Territory>> bombardMap = new HashMap<Unit, Set<Territory>>();
        ArrayList<ProAmphibData> transportMapList = new ArrayList<ProAmphibData>();
        HashMap<Territory, Set<Territory>> landRoutesMap = new HashMap<Territory, Set<Territory>>();
        this.isDefensive = !this.battleUtils.territoryHasLocalLandSuperiority(this.myCapital, 3, player);
        LogUtils.log(Level.FINER, "Currently in defensive stance: " + this.isDefensive);
        ArrayList<ProPurchaseOption> specialPurchaseOptions = new ArrayList<ProPurchaseOption>();
        ArrayList<ProPurchaseOption> factoryPurchaseOptions = new ArrayList<ProPurchaseOption>();
        ArrayList<ProPurchaseOption> landPurchaseOptions = new ArrayList<ProPurchaseOption>();
        ArrayList<ProPurchaseOption> airPurchaseOptions = new ArrayList<ProPurchaseOption>();
        ArrayList<ProPurchaseOption> seaPurchaseOptions = new ArrayList<ProPurchaseOption>();
        this.purchaseUtils.findPurchaseOptions(player, landPurchaseOptions, airPurchaseOptions, seaPurchaseOptions, factoryPurchaseOptions, specialPurchaseOptions);
        this.minCostPerHitPoint = this.purchaseUtils.getMinCostPerHitPoint(player, landPurchaseOptions);
        List<Territory> myUnitTerritories = Match.getMatches(data.getMap().getTerritories(), Matches.territoryHasUnitsOwnedBy(player));
        this.attackOptionsUtils.findAttackOptions(player, myUnitTerritories, attackMap, unitAttackMap, transportAttackMap, bombardMap, landRoutesMap, transportMapList, new ArrayList<Territory>(), new ArrayList<Territory>(), false, false);
        this.attackOptionsUtils.findScrambleOptions(player, attackMap);
        List<ProAttackTerritoryData> prioritizedTerritories = this.attackOptionsUtils.removeTerritoriesThatCantBeConquered(player, attackMap, unitAttackMap, transportAttackMap, false);
        HashMap<Territory, ProAttackTerritoryData> enemyAttackMap = new HashMap<Territory, ProAttackTerritoryData>();
        ArrayList<Territory> territoriesToAttack = new ArrayList<Territory>();
        for (ProAttackTerritoryData patd : prioritizedTerritories) {
            territoriesToAttack.add(patd.getTerritory());
        }
        this.attackOptionsUtils.findMaxEnemyAttackUnits(player, territoriesToAttack, new ArrayList<Territory>(), enemyAttackMap);
        Map<Territory, Double> territoryValueMap = this.territoryValueUtils.findTerritoryValues(player, this.minCostPerHitPoint, new ArrayList<Territory>(), territoriesToAttack);
        this.determineTerritoriesThatCanBeHeld(prioritizedTerritories, attackMap, enemyAttackMap, territoryValueMap);
        this.prioritizeAttackOptions(player, prioritizedTerritories);
        this.removeTerritoriesThatArentWorthAttacking(prioritizedTerritories, enemyAttackMap);
        this.determineTerritoriesToAttack(attackMap, unitAttackMap, prioritizedTerritories, transportMapList, transportAttackMap, bombardMap);
        enemyAttackMap = new HashMap();
        territoriesToAttack = new ArrayList();
        HashSet<Territory> possibleTransportTerritories = new HashSet<Territory>();
        for (ProAttackTerritoryData patd : prioritizedTerritories) {
            territoriesToAttack.add(patd.getTerritory());
            if (patd.getAmphibAttackMap().isEmpty()) continue;
            possibleTransportTerritories.addAll(data.getMap().getNeighbors(patd.getTerritory(), Matches.TerritoryIsWater));
        }
        this.attackOptionsUtils.findMaxEnemyAttackUnits(player, territoriesToAttack, new ArrayList<Territory>(possibleTransportTerritories), enemyAttackMap);
        territoryValueMap = this.territoryValueUtils.findTerritoryValues(player, this.minCostPerHitPoint, new ArrayList<Territory>(), territoriesToAttack);
        this.determineTerritoriesThatCanBeHeld(prioritizedTerritories, attackMap, enemyAttackMap, territoryValueMap);
        this.removeTerritoriesThatArentWorthAttacking(prioritizedTerritories, enemyAttackMap);
        this.moveOneDefenderToLandTerritoriesBorderingEnemy(attackMap, unitAttackMap, prioritizedTerritories, myUnitTerritories);
        this.determineUnitsToAttackWith(attackMap, enemyAttackMap, unitAttackMap, prioritizedTerritories, transportMapList, transportAttackMap, bombardMap);
        this.moveUtils.calculateAmphibRoutes(player, new ArrayList<Collection<Unit>>(), new ArrayList<Route>(), new ArrayList<Collection<Unit>>(), attackMap, true);
        this.removeTerritoriesWhereTransportsAreExposed(attackMap, enemyAttackMap);
        if (this.myCapital != null && this.myCapital.getOwner().equals(player)) {
            this.determineIfCapitalCanBeHeld(attackMap, prioritizedTerritories, landPurchaseOptions);
        }
        this.checkContestedSeaTerritories(attackMap, myUnitTerritories);
        this.doMove(attackMap, moveDel, data, player, isSimulation);
        LogUtils.log(Level.FINE, "Logging results");
        this.logAttackMoves(attackMap, unitAttackMap, transportMapList, prioritizedTerritories, enemyAttackMap);
        return attackMap;
    }

    public void doMove(Map<Territory, ProAttackTerritoryData> attackMap, IMoveDelegate moveDel, GameData data, PlayerID player, boolean isSimulation) {
        this.data = data;
        this.player = player;
        this.areNeutralsPassableByAir = Properties.getNeutralFlyoverAllowed(data) && !Properties.getNeutralsImpassable(data);
        ArrayList<Collection<Unit>> moveUnits = new ArrayList<Collection<Unit>>();
        ArrayList<Route> moveRoutes = new ArrayList<Route>();
        this.moveUtils.calculateMoveRoutes(player, this.areNeutralsPassableByAir, moveUnits, moveRoutes, attackMap, true);
        this.moveUtils.doMove(moveUnits, moveRoutes, null, moveDel, isSimulation);
        moveUnits.clear();
        moveRoutes.clear();
        ArrayList<Collection<Unit>> transportsToLoad = new ArrayList<Collection<Unit>>();
        this.moveUtils.calculateAmphibRoutes(player, moveUnits, moveRoutes, transportsToLoad, attackMap, true);
        this.moveUtils.doMove(moveUnits, moveRoutes, transportsToLoad, moveDel, isSimulation);
        moveUnits.clear();
        moveRoutes.clear();
        this.moveUtils.calculateBombardMoveRoutes(player, moveUnits, moveRoutes, attackMap);
        this.moveUtils.doMove(moveUnits, moveRoutes, null, moveDel, isSimulation);
    }

    private List<ProAttackTerritoryData> prioritizeAttackOptions(PlayerID player, List<ProAttackTerritoryData> prioritizedTerritories) {
        LogUtils.log(Level.FINE, "Prioritizing territories to try to attack");
        Iterator<ProAttackTerritoryData> it = prioritizedTerritories.iterator();
        while (it.hasNext()) {
            double territoryValue;
            double attackValue;
            ProAttackTerritoryData patd = it.next();
            Territory t = patd.getTerritory();
            int isLand = !t.isWater() ? 1 : 0;
            boolean isNeutral = !t.isWater() && t.getOwner().isNull();
            int isCanHold = patd.isCanHold() ? 1 : 0;
            boolean isAmphib = patd.isNeedAmphibUnits();
            List<Unit> defendingUnits = Match.getMatches(patd.getMaxEnemyDefenders(player, this.data), ProMatches.unitIsEnemyAndNotInfa(player, this.data));
            int isEmptyLand = defendingUnits.isEmpty() && !patd.isNeedAmphibUnits() ? 1 : 0;
            boolean isAdjacentToMyCapital = !this.data.getMap().getNeighbors(t, Matches.territoryIs(this.myCapital)).isEmpty();
            int isNotNeutralAdjacentToMyCapital = isAdjacentToMyCapital && ProMatches.territoryIsEnemyNotNeutralLand(player, this.data).match(t) ? 1 : 0;
            int isFactory = ProMatches.territoryHasInfraFactoryAndIsLand(player).match(t) ? 1 : 0;
            int isFFA = this.utils.isFFA(this.data, player) ? 1 : 0;
            int production = 0;
            int isEnemyCapital = 0;
            TerritoryAttachment ta = TerritoryAttachment.get(t);
            if (ta != null) {
                production = ta.getProduction();
                if (ta.isCapital()) {
                    isEnemyCapital = 1;
                }
            }
            double TUVSwing = patd.getMaxBattleResult().getTUVSwing();
            if (isFFA == 1 && TUVSwing > 0.0) {
                TUVSwing *= 0.5;
            }
            if ((attackValue = (TUVSwing + (territoryValue = (double)((1 + isLand + isCanHold * (1 + 2 * isFFA)) * (1 + isEmptyLand) * (1 + isFactory)) * (1.0 - 0.5 * (double)isAmphib) * (double)production)) * (double)(1 + 4 * isEnemyCapital) * (double)(1 + 2 * isNotNeutralAdjacentToMyCapital) * (1.0 - 0.9 * (double)isNeutral)) <= 0.0 && !patd.isNeedAmphibUnits() && !t.isWater() && t.getOwner().isNull()) {
                double nearbyEnemyValue = 0.0;
                ArrayList<Territory> cantReachEnemyTerritories = new ArrayList<Territory>();
                Set<Territory> nearbyTerritories = this.data.getMap().getNeighbors(t, ProMatches.territoryCanMoveLandUnits(player, this.data, true));
                List<Territory> nearbyEnemyTerritories = Match.getMatches(nearbyTerritories, Matches.isTerritoryEnemy(player, this.data));
                List<Territory> nearbyTerritoriesWithOwnedUnits = Match.getMatches(nearbyTerritories, Matches.territoryHasUnitsOwnedBy(player));
                for (Territory nearbyEnemyTerritory : nearbyEnemyTerritories) {
                    boolean allAlliedNeighborsHaveRoute = true;
                    for (Territory nearbyAlliedTerritory : nearbyTerritoriesWithOwnedUnits) {
                        int distance = this.data.getMap().getDistance_IgnoreEndForCondition(nearbyAlliedTerritory, nearbyEnemyTerritory, ProMatches.territoryIsEnemyNotNeutralOrAllied(player, this.data));
                        if (distance >= 0 && distance <= 2) continue;
                        allAlliedNeighborsHaveRoute = false;
                        break;
                    }
                    if (allAlliedNeighborsHaveRoute) continue;
                    double value = this.territoryValueUtils.findTerritoryAttackValue(player, nearbyEnemyTerritory, this.minCostPerHitPoint);
                    if (value > 0.0) {
                        nearbyEnemyValue += value;
                    }
                    cantReachEnemyTerritories.add(nearbyEnemyTerritory);
                }
                LogUtils.log(Level.FINER, t.getName() + " calculated nearby enemy value=" + nearbyEnemyValue + " from " + cantReachEnemyTerritories);
                if (nearbyEnemyValue > 0.0) {
                    LogUtils.log(Level.FINEST, t.getName() + " updating negative neutral attack value=" + attackValue);
                    attackValue = nearbyEnemyValue * 0.001 / (1.0 - attackValue);
                } else {
                    double strengthDifference = this.battleUtils.estimateStrengthDifference(t, patd.getMaxUnits(), patd.getMaxEnemyDefenders(player, this.data));
                    LogUtils.log(Level.FINER, t.getName() + " calculated strengthDifference=" + strengthDifference);
                    if (strengthDifference > 500.0) {
                        LogUtils.log(Level.FINEST, t.getName() + " updating negative neutral attack value=" + attackValue);
                        attackValue = strengthDifference * 1.0E-5 / (1.0 - attackValue);
                    }
                }
            }
            patd.setValue(attackValue);
            if (!(attackValue <= 0.0) && (!this.isDefensive || !(attackValue <= 8.0) || this.data.getMap().getDistance(this.myCapital, t) > 3)) continue;
            LogUtils.log(Level.FINER, "Removing territory that has a negative attack value: " + t.getName() + ", AttackValue=" + patd.getValue());
            it.remove();
        }
        Collections.sort(prioritizedTerritories, new Comparator<ProAttackTerritoryData>(){

            @Override
            public int compare(ProAttackTerritoryData t1, ProAttackTerritoryData t2) {
                double value1 = t1.getValue();
                double value2 = t2.getValue();
                return Double.compare(value2, value1);
            }
        });
        for (ProAttackTerritoryData patd : prioritizedTerritories) {
            LogUtils.log(Level.FINER, "AttackValue=" + patd.getValue() + ", TUVSwing=" + patd.getMaxBattleResult().getTUVSwing() + ", isAmphib=" + patd.isNeedAmphibUnits() + ", " + patd.getTerritory().getName());
        }
        return prioritizedTerritories;
    }

    private void determineTerritoriesToAttack(Map<Territory, ProAttackTerritoryData> attackMap, Map<Unit, Set<Territory>> unitAttackMap, List<ProAttackTerritoryData> prioritizedTerritories, List<ProAmphibData> transportMapList, Map<Unit, Set<Territory>> transportAttackMap, Map<Unit, Set<Territory>> bombardMap) {
        LogUtils.log(Level.FINE, "Determine which territories to attack");
        int numToAttack = Math.min(1, prioritizedTerritories.size());
        boolean haveRemovedAllAmphibTerritories = false;
        while (true) {
            List<ProAttackTerritoryData> territoriesToTryToAttack = prioritizedTerritories.subList(0, numToAttack);
            LogUtils.log(Level.FINER, "Current number of territories: " + numToAttack);
            this.tryToAttackTerritories(attackMap, new HashMap<Territory, ProAttackTerritoryData>(), unitAttackMap, territoriesToTryToAttack, transportMapList, transportAttackMap, bombardMap);
            boolean areSuccessful = true;
            for (ProAttackTerritoryData patd : territoriesToTryToAttack) {
                Territory t = patd.getTerritory();
                if (patd.getBattleResult() == null) {
                    patd.setBattleResult(this.battleUtils.estimateAttackBattleResults(this.player, t, patd.getUnits(), patd.getMaxEnemyDefenders(this.player, this.data), patd.getBombardTerritoryMap().keySet()));
                }
                LogUtils.log(Level.FINEST, patd.getResultString() + " with attackers: " + patd.getUnits());
                double estimate = this.battleUtils.estimateStrengthDifference(t, patd.getUnits(), patd.getMaxEnemyDefenders(this.player, this.data));
                ProBattleResultData result = patd.getBattleResult();
                double winPercentage = WIN_PERCENTAGE;
                if (patd.isCanAttack() || territoriesToTryToAttack.size() == 1) {
                    winPercentage = MIN_WIN_PERCENTAGE;
                }
                if (!(estimate < patd.getStrengthEstimate()) || !(result.getWinPercentage() < winPercentage) && result.isHasLandUnitRemaining()) continue;
                areSuccessful = false;
            }
            if (areSuccessful) {
                for (ProAttackTerritoryData patd : territoriesToTryToAttack) {
                    patd.setCanAttack(true);
                    double estimate = this.battleUtils.estimateStrengthDifference(patd.getTerritory(), patd.getUnits(), patd.getMaxEnemyDefenders(this.player, this.data));
                    if (!(estimate < patd.getStrengthEstimate())) continue;
                    patd.setStrengthEstimate(estimate);
                }
                if (!haveRemovedAllAmphibTerritories) {
                    HashSet<Unit> movedTransports = new HashSet<Unit>();
                    for (ProAttackTerritoryData patd : prioritizedTerritories) {
                        movedTransports.addAll(patd.getAmphibAttackMap().keySet());
                        movedTransports.addAll(Match.getMatches(patd.getUnits(), Matches.UnitIsTransport));
                    }
                    if (movedTransports.size() >= transportMapList.size()) {
                        ArrayList<ProAttackTerritoryData> amphibTerritoriesToRemove = new ArrayList<ProAttackTerritoryData>();
                        for (int i = numToAttack; i < prioritizedTerritories.size(); ++i) {
                            if (!prioritizedTerritories.get(i).isNeedAmphibUnits()) continue;
                            amphibTerritoriesToRemove.add(prioritizedTerritories.get(i));
                            LogUtils.log(Level.FINER, "Removing amphib territory since already used all transports: " + prioritizedTerritories.get(i).getTerritory().getName());
                        }
                        prioritizedTerritories.removeAll(amphibTerritoriesToRemove);
                        haveRemovedAllAmphibTerritories = true;
                    }
                }
                if (++numToAttack <= prioritizedTerritories.size()) continue;
                break;
            }
            LogUtils.log(Level.FINER, "Removing territory: " + prioritizedTerritories.get(numToAttack - 1).getTerritory().getName());
            prioritizedTerritories.remove(numToAttack - 1);
            if (numToAttack <= prioritizedTerritories.size()) continue;
            --numToAttack;
        }
        LogUtils.log(Level.FINER, "Final number of territories: " + (numToAttack - 1));
    }

    private void determineTerritoriesThatCanBeHeld(List<ProAttackTerritoryData> prioritizedTerritories, Map<Territory, ProAttackTerritoryData> attackMap, Map<Territory, ProAttackTerritoryData> enemyAttackMap, Map<Territory, Double> territoryValueMap) {
        LogUtils.log(Level.FINE, "Check if we should try to hold attack territories");
        Map<Unit, Territory> unitTerritoryMap = this.utils.createUnitTerritoryMap(this.player);
        for (ProAttackTerritoryData patd : prioritizedTerritories) {
            Territory t = patd.getTerritory();
            if (enemyAttackMap.get(t) != null) {
                HashSet<Unit> enemyAttackingUnits = new HashSet<Unit>(enemyAttackMap.get(t).getMaxUnits());
                enemyAttackingUnits.addAll(enemyAttackMap.get(t).getMaxAmphibUnits());
                patd.setMaxEnemyUnits(new ArrayList<Unit>(enemyAttackingUnits));
                patd.setMaxEnemyBombardUnits(enemyAttackMap.get(t).getMaxBombardUnits());
            }
            int isFactory = 0;
            if (ProMatches.territoryHasInfraFactoryAndIsLand(this.player).match(t)) {
                isFactory = 1;
            }
            double totalValue = 0.0;
            List<Unit> nonAirAttackers = Match.getMatches(patd.getMaxUnits(), Matches.UnitIsNotAir);
            for (Unit u : nonAirAttackers) {
                totalValue += territoryValueMap.get(unitTerritoryMap.get(u)).doubleValue();
            }
            double averageValue = totalValue / (double)nonAirAttackers.size() * 0.75;
            double territoryValue = territoryValueMap.get(t) * (double)(1 + 4 * isFactory);
            if (!t.isWater() && territoryValue < averageValue) {
                attackMap.get(t).setCanHold(false);
                LogUtils.log(Level.FINER, t + ", CanHold=false, value=" + territoryValueMap.get(t) + ", averageAttackFromValue=" + averageValue);
                continue;
            }
            if (enemyAttackMap.get(t) != null) {
                HashSet<Unit> attackingUnits = new HashSet<Unit>(patd.getMaxUnits());
                attackingUnits.addAll(patd.getMaxAmphibUnits());
                ProBattleResultData result = this.battleUtils.estimateAttackBattleResults(this.player, t, new ArrayList<Unit>(attackingUnits), patd.getMaxEnemyDefenders(this.player, this.data), patd.getMaxBombardUnits());
                List<Unit> remainingUnitsToDefendWith = Match.getMatches(result.getAverageUnitsRemaining(), Matches.UnitIsAir.invert());
                LogUtils.log(Level.FINER, t + ", value=" + territoryValueMap.get(t) + ", averageAttackFromValue=" + averageValue + ", MyAttackers=" + attackingUnits.size() + ", RemainingUnits=" + remainingUnitsToDefendWith.size());
                ProBattleResultData result2 = this.battleUtils.calculateBattleResults(this.player, t, patd.getMaxEnemyUnits(), remainingUnitsToDefendWith, enemyAttackMap.get(t).getMaxBombardUnits(), false);
                boolean canHold = !result2.isHasLandUnitRemaining() && !t.isWater() || result2.getTUVSwing() < 0.0 || result2.getWinPercentage() < MIN_WIN_PERCENTAGE;
                patd.setCanHold(canHold);
                LogUtils.log(Level.FINER, t + ", CanHold=" + canHold + ", MyDefenders=" + remainingUnitsToDefendWith.size() + ", EnemyAttackers=" + patd.getMaxEnemyUnits().size() + ", win%=" + result2.getWinPercentage() + ", EnemyTUVSwing=" + result2.getTUVSwing() + ", hasLandUnitRemaining=" + result2.isHasLandUnitRemaining());
                continue;
            }
            attackMap.get(t).setCanHold(true);
            LogUtils.log(Level.FINER, t + ", CanHold=true since no enemy counter attackers, value=" + territoryValueMap.get(t) + ", averageAttackFromValue=" + averageValue);
        }
    }

    private void removeTerritoriesThatArentWorthAttacking(List<ProAttackTerritoryData> prioritizedTerritories, Map<Territory, ProAttackTerritoryData> enemyAttackMap) {
        LogUtils.log(Level.FINE, "Remove territories that aren't worth attacking");
        Iterator<ProAttackTerritoryData> it = prioritizedTerritories.iterator();
        while (it.hasNext()) {
            ProAttackTerritoryData patd = it.next();
            Territory t = patd.getTerritory();
            LogUtils.log(Level.FINER, "Checking territory=" + patd.getTerritory().getName() + " with isAmphib=" + patd.isNeedAmphibUnits());
            if (!patd.isCanHold() && enemyAttackMap.get(t) != null && t.isWater() && !t.getUnits().someMatch(Matches.enemyUnit(this.player, this.data))) {
                LogUtils.log(Level.FINER, "Removing convoy zone that can't be held: " + t.getName() + ", enemyAttackers=" + enemyAttackMap.get(t).getMaxUnits());
                it.remove();
                continue;
            }
            boolean isNeutral = t.getOwner().isNull();
            double strengthDifference = this.battleUtils.estimateStrengthDifference(t, patd.getMaxUnits(), patd.getMaxEnemyDefenders(this.player, this.data));
            if (!patd.isCanHold() && enemyAttackMap.get(t) != null && !t.isWater()) {
                if (isNeutral && strengthDifference <= 500.0) {
                    LogUtils.log(Level.FINER, "Removing neutral territory that can't be held: " + t.getName() + ", enemyAttackers=" + enemyAttackMap.get(t).getMaxUnits() + ", enemyAmphibAttackers=" + enemyAttackMap.get(t).getMaxAmphibUnits() + ", strengthDifference=" + strengthDifference);
                    it.remove();
                    continue;
                }
                if (patd.isNeedAmphibUnits() && patd.getValue() < 2.0) {
                    LogUtils.log(Level.FINER, "Removing low value amphib territory that can't be held: " + t.getName() + ", enemyAttackers=" + enemyAttackMap.get(t).getMaxUnits() + ", enemyAmphibAttackers=" + enemyAttackMap.get(t).getMaxAmphibUnits());
                    it.remove();
                    continue;
                }
            }
            if (!isNeutral || t.isWater() || !(strengthDifference <= 500.0)) continue;
            ArrayList<Territory> prioritizedTerritoryList = new ArrayList<Territory>();
            for (ProAttackTerritoryData prioritizedTerritory : prioritizedTerritories) {
                prioritizedTerritoryList.add(prioritizedTerritory.getTerritory());
            }
            Map<Unit, Territory> unitTerritoryMap = this.utils.createUnitTerritoryMap(this.player);
            HashSet<Territory> attackFromTerritories = new HashSet<Territory>();
            for (Unit u : patd.getMaxUnits()) {
                attackFromTerritories.add(unitTerritoryMap.get(u));
            }
            attackFromTerritories.retainAll(this.data.getMap().getNeighbors(t));
            boolean attackersHaveEnemyNeighbors = false;
            Territory attackFromTerritoryWithEnemyNeighbors = null;
            for (Territory attackFromTerritory : attackFromTerritories) {
                Set<Territory> enemyNeighbors = this.data.getMap().getNeighbors(attackFromTerritory, ProMatches.territoryIsEnemyNotNeutralLand(this.player, this.data));
                if (prioritizedTerritoryList.containsAll(enemyNeighbors)) continue;
                attackersHaveEnemyNeighbors = true;
                attackFromTerritoryWithEnemyNeighbors = attackFromTerritory;
                break;
            }
            if (!attackersHaveEnemyNeighbors) continue;
            LogUtils.log(Level.FINER, "Removing neutral territory that has attackers that are adjacent to enemies: " + t.getName() + ", attackFromTerritory=" + attackFromTerritoryWithEnemyNeighbors);
            it.remove();
        }
    }

    private void moveOneDefenderToLandTerritoriesBorderingEnemy(Map<Territory, ProAttackTerritoryData> attackMap, Map<Unit, Set<Territory>> unitAttackMap, List<ProAttackTerritoryData> prioritizedTerritories, List<Territory> myUnitTerritories) {
        LogUtils.log(Level.FINE, "Determine which territories to defend with one land unit");
        ArrayList<Territory> territoriesToAttack = new ArrayList<Territory>();
        for (ProAttackTerritoryData patd : prioritizedTerritories) {
            territoriesToAttack.add(patd.getTerritory());
        }
        IntegerMap<UnitType> playerCostMap = BattleCalculator.getCostsForTUV(this.player, this.data);
        for (Territory t : myUnitTerritories) {
            boolean hasAlliedLandUnits = Match.someMatch(t.getUnits().getUnits(), ProMatches.unitCantBeMovedAndIsAlliedDefenderAndNotInfra(this.player, this.data, t));
            Set<Territory> enemyNeighbors = this.data.getMap().getNeighbors(t, Matches.territoryIsEnemyNonNeutralAndHasEnemyUnitMatching(this.data, this.player, Matches.UnitIsLand));
            enemyNeighbors.removeAll(territoriesToAttack);
            if (t.isWater() || hasAlliedLandUnits || enemyNeighbors.isEmpty()) continue;
            int minCost = Integer.MAX_VALUE;
            Unit minUnit = null;
            for (Unit u : t.getUnits().getMatches(Matches.unitIsOwnedBy(this.player))) {
                if (playerCostMap.getInt(u.getType()) >= minCost) continue;
                minCost = playerCostMap.getInt(u.getType());
                minUnit = u;
            }
            if (minUnit == null) continue;
            unitAttackMap.remove(minUnit);
            LogUtils.log(Level.FINER, t + ", added one land unit: " + minUnit);
        }
    }

    private void removeTerritoriesWhereTransportsAreExposed(Map<Territory, ProAttackTerritoryData> attackMap, Map<Territory, ProAttackTerritoryData> enemyAttackMap) {
        LogUtils.log(Level.FINE, "Remove territories where transports are exposed");
        ArrayList<Territory> clearedTerritories = new ArrayList<Territory>();
        for (Territory t : attackMap.keySet()) {
            if (attackMap.get(t).getUnits().isEmpty()) continue;
            clearedTerritories.add(t);
        }
        Match<Territory> myUnitTerritoriesMatch = Matches.territoryHasUnitsThatMatch(ProMatches.unitCanBeMovedAndIsOwned(this.player));
        List<Territory> myUnitTerritories = Match.getMatches(this.data.getMap().getTerritories(), myUnitTerritoriesMatch);
        HashMap<Territory, ProAttackTerritoryData> moveMap = new HashMap<Territory, ProAttackTerritoryData>();
        HashMap<Unit, Set<Territory>> unitMoveMap = new HashMap<Unit, Set<Territory>>();
        HashMap<Unit, Set<Territory>> transportMoveMap = new HashMap<Unit, Set<Territory>>();
        ArrayList<ProAmphibData> transportMapList = new ArrayList<ProAmphibData>();
        HashMap<Territory, Set<Territory>> landRoutesMap = new HashMap<Territory, Set<Territory>>();
        this.attackOptionsUtils.findDefendOptions(this.player, myUnitTerritories, moveMap, unitMoveMap, transportMoveMap, landRoutesMap, transportMapList, clearedTerritories);
        HashSet<Unit> alreadyAttackedWithUnits = new HashSet<Unit>();
        for (Territory t : attackMap.keySet()) {
            alreadyAttackedWithUnits.addAll(attackMap.get(t).getUnits());
            alreadyAttackedWithUnits.addAll(attackMap.get(t).getAmphibAttackMap().keySet());
        }
        for (Territory t : moveMap.keySet()) {
            ((ProAttackTerritoryData)moveMap.get(t)).getMaxUnits().removeAll(alreadyAttackedWithUnits);
        }
        for (Territory t : attackMap.keySet()) {
            double attackValue;
            ArrayList<Unit> transports;
            Territory unloadTerritory;
            ProAttackTerritoryData patd = attackMap.get(t);
            LogUtils.log(Level.FINER, "Checking territory=" + patd.getTerritory().getName() + " with tranports size=" + patd.getTransportTerritoryMap().size());
            if (patd.getTerritory().isWater() || patd.getTransportTerritoryMap().isEmpty()) continue;
            HashMap territoryTransportAndBombardMap = new HashMap();
            for (Unit u : patd.getTransportTerritoryMap().keySet()) {
                unloadTerritory = patd.getTransportTerritoryMap().get(u);
                if (territoryTransportAndBombardMap.containsKey(unloadTerritory)) {
                    ((List)territoryTransportAndBombardMap.get(unloadTerritory)).add(u);
                    continue;
                }
                transports = new ArrayList<Unit>();
                transports.add(u);
                territoryTransportAndBombardMap.put(unloadTerritory, transports);
            }
            for (Unit u : patd.getBombardTerritoryMap().keySet()) {
                unloadTerritory = patd.getBombardTerritoryMap().get(u);
                if (territoryTransportAndBombardMap.containsKey(unloadTerritory)) {
                    ((List)territoryTransportAndBombardMap.get(unloadTerritory)).add(u);
                    continue;
                }
                transports = new ArrayList();
                transports.add(u);
                territoryTransportAndBombardMap.put(unloadTerritory, transports);
            }
            double totalEnemyTUVSwing = 0.0;
            for (Territory unloadTerritory2 : territoryTransportAndBombardMap.keySet()) {
                if (enemyAttackMap.get(unloadTerritory2) != null) {
                    List<Unit> enemyAttackers = enemyAttackMap.get(unloadTerritory2).getMaxUnits();
                    HashSet<Unit> defenders = new HashSet<Unit>(unloadTerritory2.getUnits().getMatches(ProMatches.unitIsAlliedNotOwned(this.player, this.data)));
                    defenders.addAll((Collection)territoryTransportAndBombardMap.get(unloadTerritory2));
                    if (moveMap.get(unloadTerritory2) != null) {
                        defenders.addAll(((ProAttackTerritoryData)moveMap.get(unloadTerritory2)).getMaxUnits());
                    }
                    ProBattleResultData result = this.battleUtils.calculateBattleResults(this.player, unloadTerritory2, enemyAttackMap.get(unloadTerritory2).getMaxUnits(), new ArrayList<Unit>(defenders), new HashSet<Unit>(), false);
                    ProBattleResultData minResult = this.battleUtils.calculateBattleResults(this.player, unloadTerritory2, enemyAttackMap.get(unloadTerritory2).getMaxUnits(), (List)territoryTransportAndBombardMap.get(unloadTerritory2), new HashSet<Unit>(), false);
                    double minTUVSwing = Math.min(result.getTUVSwing(), minResult.getTUVSwing());
                    if (minTUVSwing > 0.0) {
                        totalEnemyTUVSwing += minTUVSwing;
                    }
                    LogUtils.log(Level.FINEST, unloadTerritory2 + ", EnemyAttackers=" + enemyAttackers.size() + ", MaxDefenders=" + defenders.size() + ", MaxEnemyTUVSwing=" + result.getTUVSwing() + ", MinDefenders=" + ((List)territoryTransportAndBombardMap.get(unloadTerritory2)).size() + ", MinEnemyTUVSwing=" + minResult.getTUVSwing());
                    continue;
                }
                LogUtils.log(Level.FINEST, "Territory=" + unloadTerritory2.getName() + " has no enemy attackers");
            }
            ProBattleResultData result = this.battleUtils.calculateBattleResults(this.player, t, patd.getUnits(), patd.getMaxEnemyDefenders(this.player, this.data), patd.getBombardTerritoryMap().keySet(), true);
            int production = 0;
            TerritoryAttachment ta = TerritoryAttachment.get(t);
            if (ta != null) {
                production = ta.getProduction();
            }
            if (0.75 * totalEnemyTUVSwing > (attackValue = result.getTUVSwing() + (double)production)) {
                LogUtils.log(Level.FINER, "Removing amphib territory: " + patd.getTerritory() + ", totalEnemyTUVSwing=" + totalEnemyTUVSwing + ", attackValue=" + attackValue);
                attackMap.get(t).getUnits().clear();
                attackMap.get(t).getAmphibAttackMap().clear();
                attackMap.get(t).getBombardTerritoryMap().clear();
                continue;
            }
            LogUtils.log(Level.FINER, "Keeping amphib territory: " + patd.getTerritory() + ", totalEnemyTUVSwing=" + totalEnemyTUVSwing + ", attackValue=" + attackValue);
        }
    }

    private void determineUnitsToAttackWith(Map<Territory, ProAttackTerritoryData> attackMap, Map<Territory, ProAttackTerritoryData> enemyAttackMap, Map<Unit, Set<Territory>> unitAttackMap, List<ProAttackTerritoryData> prioritizedTerritories, List<ProAmphibData> transportMapList, Map<Unit, Set<Territory>> transportAttackMap, Map<Unit, Set<Territory>> bombardMap) {
        LogUtils.log(Level.FINE, "Determine units to attack each territory with");
        Map<Unit, Territory> unitTerritoryMap = this.utils.createUnitTerritoryMap(this.player);
        IntegerMap<UnitType> playerCostMap = BattleCalculator.getCostsForTUV(this.player, this.data);
        while (true) {
            ProBattleResultData result;
            ProAttackTerritoryData patd;
            Unit unit;
            Map<Unit, Set<Territory>> sortedUnitAttackOptions = this.tryToAttackTerritories(attackMap, enemyAttackMap, unitAttackMap, prioritizedTerritories, transportMapList, transportAttackMap, bombardMap);
            sortedUnitAttackOptions = this.attackOptionsUtils.sortUnitNeededOptionsThenAttack(this.player, sortedUnitAttackOptions, attackMap, unitTerritoryMap);
            Iterator<Unit> it = sortedUnitAttackOptions.keySet().iterator();
            while (it.hasNext()) {
                unit = it.next();
                boolean isAirUnit = UnitAttachment.get(unit.getType()).getIsAir();
                if (!isAirUnit) continue;
                Territory minWinTerritory = null;
                double minWinPercentage = Double.MAX_VALUE;
                for (Territory t : sortedUnitAttackOptions.get(unit)) {
                    ProBattleResultData result2;
                    boolean usesMoreThanHalfOfRange;
                    ProAttackTerritoryData patd2 = attackMap.get(t);
                    boolean isEnemyFactory = ProMatches.territoryHasInfraFactoryAndIsEnemyLand(this.player, this.data).match(t);
                    boolean isAdjacentToAlliedFactory = Matches.territoryHasNeighborMatching(this.data, ProMatches.territoryHasInfraFactoryAndIsAlliedLand(this.player, this.data)).match(t);
                    int range = TripleAUnit.get(unit).getMovementLeft();
                    int distance = this.data.getMap().getDistance_IgnoreEndForCondition(unitTerritoryMap.get(unit), t, ProMatches.territoryCanMoveAirUnitsAndNoAA(this.player, this.data, true));
                    boolean bl = usesMoreThanHalfOfRange = distance > range / 2;
                    if (!isEnemyFactory && !isAdjacentToAlliedFactory && usesMoreThanHalfOfRange) continue;
                    if (patd2.getBattleResult() == null) {
                        patd2.setBattleResult(this.battleUtils.estimateAttackBattleResults(this.player, t, patd2.getUnits(), patd2.getMaxEnemyDefenders(this.player, this.data), patd2.getBombardTerritoryMap().keySet()));
                    }
                    if (!((result2 = patd2.getBattleResult()).getWinPercentage() < minWinPercentage) && (result2.isHasLandUnitRemaining() || minWinTerritory != null)) continue;
                    List<Unit> attackingUnits = patd2.getUnits();
                    List<Unit> defendingUnits = patd2.getMaxEnemyDefenders(this.player, this.data);
                    boolean isOverwhelmingWin = this.battleUtils.checkForOverwhelmingWin(this.player, t, attackingUnits, defendingUnits);
                    boolean hasAA = Match.someMatch(defendingUnits, Matches.UnitIsAAforAnything);
                    if (hasAA || isOverwhelmingWin) continue;
                    minWinPercentage = result2.getWinPercentage();
                    minWinTerritory = t;
                }
                if (minWinTerritory == null) continue;
                attackMap.get(minWinTerritory).addUnit(unit);
                attackMap.get(minWinTerritory).setBattleResult(null);
                it.remove();
            }
            sortedUnitAttackOptions = this.attackOptionsUtils.sortUnitNeededOptionsThenAttack(this.player, sortedUnitAttackOptions, attackMap, unitTerritoryMap);
            it = sortedUnitAttackOptions.keySet().iterator();
            while (it.hasNext()) {
                unit = it.next();
                Territory minWinTerritory = null;
                for (Territory t : sortedUnitAttackOptions.get(unit)) {
                    List<Unit> defendingUnits;
                    patd = attackMap.get(t);
                    if (!patd.isCanHold()) continue;
                    if (patd.getBattleResult() == null) {
                        patd.setBattleResult(this.battleUtils.estimateAttackBattleResults(this.player, t, patd.getUnits(), patd.getMaxEnemyDefenders(this.player, this.data), patd.getBombardTerritoryMap().keySet()));
                    }
                    result = patd.getBattleResult();
                    List<Unit> attackingUnits = patd.getUnits();
                    boolean isOverwhelmingWin = this.battleUtils.checkForOverwhelmingWin(this.player, t, attackingUnits, defendingUnits = patd.getMaxEnemyDefenders(this.player, this.data));
                    if (isOverwhelmingWin || !(result.getBattleRounds() > 2.0)) continue;
                    minWinTerritory = t;
                    break;
                }
                if (minWinTerritory == null) continue;
                attackMap.get(minWinTerritory).addUnit(unit);
                attackMap.get(minWinTerritory).setBattleResult(null);
                it.remove();
            }
            sortedUnitAttackOptions = this.attackOptionsUtils.sortUnitNeededOptionsThenAttack(this.player, sortedUnitAttackOptions, attackMap, unitTerritoryMap);
            it = sortedUnitAttackOptions.keySet().iterator();
            block5: while (it.hasNext()) {
                unit = it.next();
                boolean isSeaUnit = UnitAttachment.get(unit.getType()).getIsSea();
                if (!isSeaUnit) continue;
                for (Territory t : sortedUnitAttackOptions.get(unit)) {
                    patd = attackMap.get(t);
                    if (attackMap.get(t).getBattleResult() == null) {
                        attackMap.get(t).setBattleResult(this.battleUtils.estimateAttackBattleResults(this.player, t, patd.getUnits(), patd.getMaxEnemyDefenders(this.player, this.data), patd.getBombardTerritoryMap().keySet()));
                    }
                    result = attackMap.get(t).getBattleResult();
                    ArrayList<Unit> attackers = new ArrayList<Unit>(patd.getUnits());
                    attackers.add(unit);
                    ProBattleResultData result2 = this.battleUtils.estimateAttackBattleResults(this.player, t, attackers, patd.getMaxEnemyDefenders(this.player, this.data), patd.getBombardTerritoryMap().keySet());
                    double unitValue = playerCostMap.getInt(unit.getType());
                    if (!(result2.getTUVSwing() - unitValue / 3.0 > result.getTUVSwing())) continue;
                    attackMap.get(t).addUnit(unit);
                    attackMap.get(t).setBattleResult(null);
                    it.remove();
                    continue block5;
                }
            }
            ArrayList<Unit> usedUnits = new ArrayList<Unit>();
            for (ProAttackTerritoryData patd3 : prioritizedTerritories) {
                usedUnits.addAll(patd3.getUnits());
            }
            ProAttackTerritoryData territoryToRemove = null;
            for (ProAttackTerritoryData patd4 : prioritizedTerritories) {
                Territory t = patd4.getTerritory();
                if (patd4.getBattleResult() == null) {
                    patd4.setBattleResult(this.battleUtils.estimateAttackBattleResults(this.player, t, patd4.getUnits(), patd4.getMaxEnemyDefenders(this.player, this.data), patd4.getBombardTerritoryMap().keySet()));
                }
                ProBattleResultData result3 = patd4.getBattleResult();
                boolean canHold = true;
                double enemyCounterTUVSwing = 0.0;
                if (enemyAttackMap.get(t) != null && !ProMatches.territoryIsWaterAndAdjacentToOwnedFactory(this.player, this.data).match(t)) {
                    List<Unit> remainingUnitsToDefendWith = Match.getMatches(result3.getAverageUnitsRemaining(), Matches.UnitIsAir.invert());
                    ProBattleResultData result2 = this.battleUtils.calculateBattleResults(this.player, t, patd4.getMaxEnemyUnits(), remainingUnitsToDefendWith, patd4.getMaxBombardUnits(), false);
                    if (patd4.isCanHold() && result2.getTUVSwing() > 0.0) {
                        ArrayList<Unit> unusedUnits = new ArrayList<Unit>(patd4.getMaxUnits());
                        unusedUnits.addAll(patd4.getMaxAmphibUnits());
                        unusedUnits.removeAll(usedUnits);
                        unusedUnits.addAll(remainingUnitsToDefendWith);
                        ProBattleResultData result32 = this.battleUtils.calculateBattleResults(this.player, t, patd4.getMaxEnemyUnits(), unusedUnits, patd4.getMaxBombardUnits(), false);
                        if (result32.getTUVSwing() < result2.getTUVSwing()) {
                            result2 = result32;
                            remainingUnitsToDefendWith = unusedUnits;
                        }
                    }
                    boolean bl = canHold = !result2.isHasLandUnitRemaining() && !t.isWater() || result2.getTUVSwing() < 0.0 || result2.getWinPercentage() < MIN_WIN_PERCENTAGE;
                    if (result2.getTUVSwing() > 0.0) {
                        enemyCounterTUVSwing = result2.getTUVSwing();
                    }
                    LogUtils.log(Level.FINEST, "Territory=" + t.getName() + ", CanHold=" + canHold + ", MyDefenders=" + remainingUnitsToDefendWith.size() + ", EnemyAttackers=" + patd4.getMaxEnemyUnits().size() + ", win%=" + result2.getWinPercentage() + ", EnemyTUVSwing=" + result2.getTUVSwing() + ", hasLandUnitRemaining=" + result2.isHasLandUnitRemaining());
                }
                boolean isNeutral = !t.isWater() && t.getOwner().isNull();
                int isLand = !t.isWater() ? 1 : 0;
                int isCanHold = canHold ? 1 : 0;
                int isCantHoldAmphib = !canHold && !patd4.getAmphibAttackMap().isEmpty() ? 1 : 0;
                int isFactory = ProMatches.territoryHasInfraFactoryAndIsLand(this.player).match(t) ? 1 : 0;
                int isFFA = this.utils.isFFA(this.data, this.player) ? 1 : 0;
                int production = TerritoryAttachment.getProduction(t);
                double capitalValue = 0.0;
                TerritoryAttachment ta = TerritoryAttachment.get(t);
                if (ta != null && ta.isCapital()) {
                    capitalValue = this.utils.getPlayerProduction(t.getOwner(), this.data);
                }
                double territoryValue = (double)((1 + isLand - isCantHoldAmphib + isFactory + isCanHold * (1 + 2 * isFFA + 2 * isFactory)) * production) + capitalValue;
                double TUVSwing = result3.getTUVSwing();
                if (isFFA == 1 && TUVSwing > 0.0) {
                    TUVSwing *= 0.5;
                }
                double attackValue = TUVSwing + territoryValue * result3.getWinPercentage() / 100.0 - enemyCounterTUVSwing * 2.0 / 3.0;
                boolean allUnitsCanAttackOtherTerritory = true;
                if (isNeutral && attackValue < 0.0) {
                    for (Unit u : patd4.getUnits()) {
                        boolean canAttackOtherTerritory = false;
                        for (ProAttackTerritoryData patd2 : prioritizedTerritories) {
                            if (patd4.equals(patd2) || unitAttackMap.get(u) == null || !unitAttackMap.get(u).contains(patd2.getTerritory())) continue;
                            canAttackOtherTerritory = true;
                            break;
                        }
                        if (canAttackOtherTerritory) continue;
                        allUnitsCanAttackOtherTerritory = false;
                        break;
                    }
                }
                if (result3.getWinPercentage() < MIN_WIN_PERCENTAGE || !result3.isHasLandUnitRemaining() || isNeutral && !canHold || attackValue < 0.0 && (!isNeutral || allUnitsCanAttackOtherTerritory || result3.getBattleRounds() >= 4.0)) {
                    territoryToRemove = patd4;
                }
                LogUtils.log(Level.FINER, patd4.getResultString() + ", attackValue=" + attackValue + ", territoryValue=" + territoryValue + ", allUnitsCanAttackOtherTerritory=" + allUnitsCanAttackOtherTerritory + " with attackers=" + patd4.getUnits());
            }
            if (territoryToRemove == null) break;
            prioritizedTerritories.remove(territoryToRemove);
            LogUtils.log(Level.FINER, "Removing " + territoryToRemove.getTerritory().getName());
        }
    }

    private Map<Unit, Set<Territory>> tryToAttackTerritories(Map<Territory, ProAttackTerritoryData> attackMap, Map<Territory, ProAttackTerritoryData> enemyAttackMap, Map<Unit, Set<Territory>> unitAttackMap, List<ProAttackTerritoryData> prioritizedTerritories, List<ProAmphibData> transportMapList, Map<Unit, Set<Territory>> transportAttackMap, Map<Unit, Set<Territory>> bombardMap) {
        boolean hasAA;
        boolean isOverwhelmingWin;
        boolean hasNoDefenders;
        List<Unit> defendingUnits;
        ProBattleResultData result;
        ProAttackTerritoryData patd4;
        Territory minWinTerritory;
        Unit unit;
        Map<Unit, Territory> unitTerritoryMap = this.utils.createUnitTerritoryMap(this.player);
        IntegerMap<UnitType> playerCostMap = BattleCalculator.getCostsForTUV(this.player, this.data);
        for (Territory t : attackMap.keySet()) {
            attackMap.get(t).getUnits().clear();
            attackMap.get(t).getBombardTerritoryMap().clear();
            attackMap.get(t).getAmphibAttackMap().clear();
            attackMap.get(t).getTransportTerritoryMap().clear();
            attackMap.get(t).setBattleResult(null);
        }
        HashMap<Unit, Set<Territory>> unitAttackOptions = new HashMap<Unit, Set<Territory>>();
        for (Unit unit2 : unitAttackMap.keySet()) {
            HashSet<Territory> canAttackTerritories = new HashSet<Territory>();
            for (ProAttackTerritoryData attackTerritoryData : prioritizedTerritories) {
                if (!unitAttackMap.get(unit2).contains(attackTerritoryData.getTerritory())) continue;
                canAttackTerritories.add(attackTerritoryData.getTerritory());
            }
            if (canAttackTerritories.size() < 1) continue;
            unitAttackOptions.put(unit2, canAttackTerritories);
        }
        Map<Unit, Set<Territory>> sortedUnitAttackOptions = this.attackOptionsUtils.sortUnitMoveOptions(this.player, unitAttackOptions);
        Iterator<Unit> it = sortedUnitAttackOptions.keySet().iterator();
        block3: while (it.hasNext()) {
            unit = it.next();
            boolean isDestroyerUnit = UnitAttachment.get(unit.getType()).getIsDestroyer();
            if (!isDestroyerUnit) continue;
            for (Territory t : sortedUnitAttackOptions.get(unit)) {
                List<Unit> defendingUnits2 = attackMap.get(t).getMaxEnemyDefenders(this.player, this.data);
                if (!Match.someMatch(defendingUnits2, Matches.UnitIsSub) || !Match.noneMatch(attackMap.get(t).getUnits(), Matches.UnitIsDestroyer)) continue;
                attackMap.get(t).addUnit(unit);
                it.remove();
                continue block3;
            }
        }
        it = sortedUnitAttackOptions.keySet().iterator();
        while (it.hasNext()) {
            unit = it.next();
            boolean isAirUnit = UnitAttachment.get(unit.getType()).getIsAir();
            if (isAirUnit) continue;
            TreeMap<Double, Territory> estimatesMap = new TreeMap<Double, Territory>();
            for (Territory t : sortedUnitAttackOptions.get(unit)) {
                if (t.isWater() && !attackMap.get(t).isCanHold()) continue;
                List<Unit> defendingUnits3 = attackMap.get(t).getMaxEnemyDefenders(this.player, this.data);
                double estimate = this.battleUtils.estimateStrengthDifference(t, attackMap.get(t).getUnits(), defendingUnits3);
                boolean hasAA2 = Match.someMatch(defendingUnits3, Matches.UnitIsAAforAnything);
                if (hasAA2) {
                    estimate -= 10.0;
                }
                estimatesMap.put(estimate, t);
            }
            if (estimatesMap.isEmpty() || !((Double)estimatesMap.firstKey() < 40.0)) continue;
            Territory minWinTerritory2 = (Territory)estimatesMap.entrySet().iterator().next().getValue();
            attackMap.get(minWinTerritory2).addUnit(unit);
            it.remove();
        }
        sortedUnitAttackOptions = this.attackOptionsUtils.sortUnitNeededOptionsThenAttack(this.player, sortedUnitAttackOptions, attackMap, unitTerritoryMap);
        it = sortedUnitAttackOptions.keySet().iterator();
        while (it.hasNext()) {
            unit = it.next();
            boolean isAirUnit = UnitAttachment.get(unit.getType()).getIsAir();
            if (isAirUnit) continue;
            minWinTerritory = null;
            double minWinPercentage = WIN_PERCENTAGE;
            for (Territory t : sortedUnitAttackOptions.get(unit)) {
                ProBattleResultData result2;
                patd4 = attackMap.get(t);
                if (attackMap.get(t).isCurrentlyWins() || !attackMap.get(t).isCanHold()) continue;
                if (attackMap.get(t).getBattleResult() == null) {
                    attackMap.get(t).setBattleResult(this.battleUtils.estimateAttackBattleResults(this.player, t, patd4.getUnits(), patd4.getMaxEnemyDefenders(this.player, this.data), patd4.getBombardTerritoryMap().keySet()));
                }
                if (!((result2 = attackMap.get(t).getBattleResult()).getWinPercentage() < minWinPercentage) && (result2.isHasLandUnitRemaining() || minWinTerritory != null)) continue;
                minWinPercentage = result2.getWinPercentage();
                minWinTerritory = t;
            }
            if (minWinTerritory == null) continue;
            attackMap.get(minWinTerritory).addUnit(unit);
            attackMap.get(minWinTerritory).setBattleResult(null);
            it.remove();
        }
        sortedUnitAttackOptions = this.attackOptionsUtils.sortUnitNeededOptionsThenAttack(this.player, sortedUnitAttackOptions, attackMap, unitTerritoryMap);
        it = sortedUnitAttackOptions.keySet().iterator();
        while (it.hasNext()) {
            unit = it.next();
            boolean isAirUnit = UnitAttachment.get(unit.getType()).getIsAir();
            if (!isAirUnit) continue;
            minWinTerritory = null;
            double minWinPercentage = WIN_PERCENTAGE;
            for (Territory t : sortedUnitAttackOptions.get(unit)) {
                boolean usesMoreThanHalfOfRange;
                patd4 = attackMap.get(t);
                if (patd4.isCurrentlyWins() || patd4.isCanHold()) continue;
                boolean isEnemyCapital = this.utils.getLiveEnemyCapitals(this.data, this.player).contains(t);
                boolean isAdjacentToAlliedCapital = Matches.territoryHasNeighborMatching(this.data, Matches.territoryIsInList(this.utils.getLiveAlliedCapitals(this.data, this.player))).match(t);
                int range = TripleAUnit.get(unit).getMovementLeft();
                int distance = this.data.getMap().getDistance_IgnoreEndForCondition(unitTerritoryMap.get(unit), t, ProMatches.territoryCanMoveAirUnitsAndNoAA(this.player, this.data, true));
                boolean bl = usesMoreThanHalfOfRange = distance > range / 2;
                if (isAirUnit && !isEnemyCapital && !isAdjacentToAlliedCapital && usesMoreThanHalfOfRange) continue;
                if (patd4.getBattleResult() == null) {
                    patd4.setBattleResult(this.battleUtils.estimateAttackBattleResults(this.player, t, patd4.getUnits(), patd4.getMaxEnemyDefenders(this.player, this.data), patd4.getBombardTerritoryMap().keySet()));
                }
                if (!((result = patd4.getBattleResult()).getWinPercentage() < minWinPercentage) && (result.isHasLandUnitRemaining() || minWinTerritory != null)) continue;
                defendingUnits = patd4.getMaxEnemyDefenders(this.player, this.data);
                hasNoDefenders = Match.noneMatch(defendingUnits, ProMatches.unitIsEnemyAndNotInfa(this.player, this.data));
                isOverwhelmingWin = this.battleUtils.checkForOverwhelmingWin(this.player, t, patd4.getUnits(), defendingUnits);
                hasAA = Match.someMatch(defendingUnits, Matches.UnitIsAAforAnything);
                if (isAirUnit && (hasNoDefenders || isOverwhelmingWin || hasAA && !(result.getWinPercentage() < minWinPercentage))) continue;
                minWinPercentage = result.getWinPercentage();
                minWinTerritory = t;
            }
            if (minWinTerritory == null) continue;
            attackMap.get(minWinTerritory).addUnit(unit);
            attackMap.get(minWinTerritory).setBattleResult(null);
            it.remove();
        }
        sortedUnitAttackOptions = this.attackOptionsUtils.sortUnitNeededOptionsThenAttack(this.player, sortedUnitAttackOptions, attackMap, unitTerritoryMap);
        it = sortedUnitAttackOptions.keySet().iterator();
        while (it.hasNext()) {
            unit = it.next();
            boolean isAirUnit = UnitAttachment.get(unit.getType()).getIsAir();
            minWinTerritory = null;
            double minWinPercentage = WIN_PERCENTAGE;
            for (Territory t : sortedUnitAttackOptions.get(unit)) {
                boolean territoryValueIsLessThanUnitValue;
                patd4 = attackMap.get(t);
                if (patd4.isCurrentlyWins()) continue;
                boolean isAdjacentToAlliedFactory = Matches.territoryHasNeighborMatching(this.data, ProMatches.territoryHasInfraFactoryAndIsAlliedLand(this.player, this.data)).match(t);
                int range = TripleAUnit.get(unit).getMovementLeft();
                int distance = this.data.getMap().getDistance_IgnoreEndForCondition(unitTerritoryMap.get(unit), t, ProMatches.territoryCanMoveAirUnitsAndNoAA(this.player, this.data, true));
                boolean usesMoreThanHalfOfRange = distance > range / 2;
                boolean bl = territoryValueIsLessThanUnitValue = patd4.getValue() < (double)playerCostMap.getInt(unit.getType());
                if (isAirUnit && !isAdjacentToAlliedFactory && usesMoreThanHalfOfRange && (territoryValueIsLessThanUnitValue || !t.isWater() && !patd4.isCanHold())) continue;
                if (patd4.getBattleResult() == null) {
                    patd4.setBattleResult(this.battleUtils.estimateAttackBattleResults(this.player, t, patd4.getUnits(), patd4.getMaxEnemyDefenders(this.player, this.data), patd4.getBombardTerritoryMap().keySet()));
                }
                if (!((result = patd4.getBattleResult()).getWinPercentage() < minWinPercentage) && (result.isHasLandUnitRemaining() || minWinTerritory != null)) continue;
                defendingUnits = patd4.getMaxEnemyDefenders(this.player, this.data);
                hasNoDefenders = Match.noneMatch(defendingUnits, ProMatches.unitIsEnemyAndNotInfa(this.player, this.data));
                isOverwhelmingWin = this.battleUtils.checkForOverwhelmingWin(this.player, t, patd4.getUnits(), defendingUnits);
                hasAA = Match.someMatch(defendingUnits, Matches.UnitIsAAforAnything);
                if (isAirUnit && (hasNoDefenders || isOverwhelmingWin || hasAA && !(result.getWinPercentage() < minWinPercentage))) continue;
                minWinPercentage = result.getWinPercentage();
                minWinTerritory = t;
            }
            if (minWinTerritory == null) continue;
            attackMap.get(minWinTerritory).addUnit(unit);
            attackMap.get(minWinTerritory).setBattleResult(null);
            it.remove();
        }
        sortedUnitAttackOptions = this.attackOptionsUtils.sortUnitNeededOptions(this.player, sortedUnitAttackOptions, attackMap);
        ArrayList<Unit> alreadyAttackedWithTransports = new ArrayList<Unit>();
        if (!Properties.getTransportCasualtiesRestricted(this.data)) {
            HashMap transportAttackOptions = new HashMap();
            for (Unit unit3 : transportAttackMap.keySet()) {
                HashSet<Territory> canAttackTerritories = new HashSet<Territory>();
                for (ProAttackTerritoryData attackTerritoryData : prioritizedTerritories) {
                    if (!transportAttackMap.get(unit3).contains(attackTerritoryData.getTerritory())) continue;
                    canAttackTerritories.add(attackTerritoryData.getTerritory());
                }
                if (canAttackTerritories.isEmpty()) continue;
                transportAttackOptions.put(unit3, canAttackTerritories);
            }
            block15: for (Unit transport : transportAttackOptions.keySet()) {
                for (Territory t : (Set)transportAttackOptions.get(transport)) {
                    ProBattleResultData result3;
                    ProAttackTerritoryData patd2 = attackMap.get(t);
                    List<Unit> defendingUnits4 = patd2.getMaxEnemyDefenders(this.player, this.data);
                    if (patd2.isCurrentlyWins() || TransportTracker.isTransporting(transport) || defendingUnits4.isEmpty()) continue;
                    if (patd2.getBattleResult() == null) {
                        patd2.setBattleResult(this.battleUtils.estimateAttackBattleResults(this.player, t, patd2.getUnits(), patd2.getMaxEnemyDefenders(this.player, this.data), patd2.getBombardTerritoryMap().keySet()));
                    }
                    if (!((result3 = patd2.getBattleResult()).getWinPercentage() < WIN_PERCENTAGE) && result3.isHasLandUnitRemaining()) continue;
                    patd2.addUnit(transport);
                    patd2.setBattleResult(null);
                    alreadyAttackedWithTransports.add(transport);
                    LogUtils.log(Level.FINEST, "Adding attack transport to: " + t.getName());
                    continue block15;
                }
            }
        }
        HashMap amphibAttackOptions = new HashMap();
        for (ProAmphibData proTransportData : transportMapList) {
            if (alreadyAttackedWithTransports.contains(proTransportData.getTransport())) continue;
            HashSet<Territory> canAmphibAttackTerritories = new HashSet<Territory>();
            for (ProAttackTerritoryData attackTerritoryData : prioritizedTerritories) {
                if (!proTransportData.getTransportMap().containsKey(attackTerritoryData.getTerritory())) continue;
                canAmphibAttackTerritories.add(attackTerritoryData.getTerritory());
            }
            if (canAmphibAttackTerritories.isEmpty()) continue;
            amphibAttackOptions.put(proTransportData.getTransport(), canAmphibAttackTerritories);
        }
        for (Unit transport : amphibAttackOptions.keySet()) {
            Territory minWinTerritory3 = null;
            double minWinPercentage = WIN_PERCENTAGE;
            List<Unit> minAmphibUnitsToAdd = null;
            Territory minUnloadFromTerritory = null;
            block20: for (Territory t : (Set)amphibAttackOptions.get(transport)) {
                ProBattleResultData result4;
                ProAttackTerritoryData patd3 = attackMap.get(t);
                if (patd3.isCurrentlyWins()) continue;
                if (patd3.getBattleResult() == null) {
                    patd3.setBattleResult(this.battleUtils.estimateAttackBattleResults(this.player, t, patd3.getUnits(), patd3.getMaxEnemyDefenders(this.player, this.data), patd3.getBombardTerritoryMap().keySet()));
                }
                if (!((result4 = patd3.getBattleResult()).getWinPercentage() < minWinPercentage) && (result4.isHasLandUnitRemaining() || minWinTerritory3 != null)) continue;
                ArrayList<Unit> alreadyAttackedWithUnits = new ArrayList<Unit>();
                for (Territory t2 : attackMap.keySet()) {
                    alreadyAttackedWithUnits.addAll(attackMap.get(t2).getUnits());
                }
                for (ProAmphibData proTransportData : transportMapList) {
                    Set<Territory> territoriesCanLoadFrom;
                    List<Unit> amphibUnitsToAdd;
                    if (!proTransportData.getTransport().equals(transport) || (amphibUnitsToAdd = this.transportUtils.getUnitsToTransportFromTerritories(this.player, transport, territoriesCanLoadFrom = proTransportData.getTransportMap().get(t), alreadyAttackedWithUnits)).isEmpty()) continue;
                    double minStrengthDifference = Double.POSITIVE_INFINITY;
                    minUnloadFromTerritory = null;
                    Set<Territory> territoriesToMoveTransport = this.data.getMap().getNeighbors(t, ProMatches.territoryCanMoveSeaUnits(this.player, this.data, false));
                    HashSet<Territory> loadFromTerritories = new HashSet<Territory>();
                    for (Unit u : amphibUnitsToAdd) {
                        loadFromTerritories.add(unitTerritoryMap.get(u));
                    }
                    for (Territory territoryToMoveTransport : territoriesToMoveTransport) {
                        if (!proTransportData.getSeaTransportMap().containsKey(territoryToMoveTransport) || !proTransportData.getSeaTransportMap().get(territoryToMoveTransport).containsAll(loadFromTerritories)) continue;
                        ArrayList<Unit> attackers = new ArrayList();
                        if (enemyAttackMap.get(territoryToMoveTransport) != null) {
                            attackers = enemyAttackMap.get(territoryToMoveTransport).getMaxUnits();
                        }
                        List<Unit> defenders = territoryToMoveTransport.getUnits().getMatches(Matches.isUnitAllied(this.player, this.data));
                        defenders.add(transport);
                        double strengthDifference = this.battleUtils.estimateStrengthDifference(territoryToMoveTransport, attackers, defenders);
                        if (!(strengthDifference < minStrengthDifference)) continue;
                        minStrengthDifference = strengthDifference;
                        minUnloadFromTerritory = territoryToMoveTransport;
                    }
                    minWinTerritory3 = t;
                    minWinPercentage = result4.getWinPercentage();
                    minAmphibUnitsToAdd = amphibUnitsToAdd;
                    continue block20;
                }
            }
            if (minWinTerritory3 == null) continue;
            if (minUnloadFromTerritory != null) {
                attackMap.get(minWinTerritory3).getTransportTerritoryMap().put(transport, minUnloadFromTerritory);
            }
            attackMap.get(minWinTerritory3).addUnits(minAmphibUnitsToAdd);
            attackMap.get(minWinTerritory3).putAmphibAttackMap(transport, minAmphibUnitsToAdd);
            attackMap.get(minWinTerritory3).setBattleResult(null);
            for (Unit unit4 : minAmphibUnitsToAdd) {
                sortedUnitAttackOptions.remove(unit4);
            }
            LogUtils.log(Level.FINEST, "Adding amphibious attack to " + minWinTerritory3 + ", units=" + minAmphibUnitsToAdd.size() + ", unloadFrom=" + minUnloadFromTerritory);
        }
        HashSet<Unit> alreadyMovedUnits = new HashSet<Unit>();
        for (Territory t : attackMap.keySet()) {
            alreadyMovedUnits.addAll(attackMap.get(t).getUnits());
            alreadyMovedUnits.addAll(attackMap.get(t).getAmphibAttackMap().keySet());
        }
        HashMap bombardOptions = new HashMap();
        for (Unit u : bombardMap.keySet()) {
            if (alreadyMovedUnits.contains(u)) continue;
            HashSet<Territory> canBombardTerritories = new HashSet<Territory>();
            for (ProAttackTerritoryData patd4 : prioritizedTerritories) {
                List<Unit> defendingUnits5 = patd4.getMaxEnemyDefenders(this.player, this.data);
                boolean hasDefenders = Match.someMatch(defendingUnits5, Matches.UnitIsInfrastructure.invert());
                if (!bombardMap.get(u).contains(patd4.getTerritory()) || patd4.getTransportTerritoryMap().isEmpty() || !hasDefenders || TransportTracker.isTransporting(u)) continue;
                canBombardTerritories.add(patd4.getTerritory());
            }
            if (canBombardTerritories.isEmpty()) continue;
            bombardOptions.put(u, canBombardTerritories);
        }
        for (Unit u : bombardOptions.keySet()) {
            Territory minWinTerritory4 = null;
            double minWinPercentage = Double.MAX_VALUE;
            Territory minBombardFromTerritory = null;
            for (Territory t : (Set)bombardOptions.get(u)) {
                ProBattleResultData result5;
                ProAttackTerritoryData patd5 = attackMap.get(t);
                if (patd5.getBattleResult() == null) {
                    patd5.setBattleResult(this.battleUtils.estimateAttackBattleResults(this.player, t, patd5.getUnits(), patd5.getMaxEnemyDefenders(this.player, this.data), patd5.getBombardTerritoryMap().keySet()));
                }
                if (!((result5 = patd5.getBattleResult()).getWinPercentage() < minWinPercentage) && (result5.isHasLandUnitRemaining() || minWinTerritory4 != null)) continue;
                Territory bombardFromTerritory = null;
                for (Territory unloadFromTerritory : patd5.getTransportTerritoryMap().values()) {
                    if (!patd5.getBombardOptionsMap().get(u).contains(unloadFromTerritory)) continue;
                    bombardFromTerritory = unloadFromTerritory;
                }
                if (bombardFromTerritory == null) continue;
                minWinTerritory4 = t;
                minWinPercentage = result5.getWinPercentage();
                minBombardFromTerritory = bombardFromTerritory;
            }
            if (minWinTerritory4 == null) continue;
            attackMap.get(minWinTerritory4).getBombardTerritoryMap().put(u, minBombardFromTerritory);
            attackMap.get(minWinTerritory4).setBattleResult(null);
            sortedUnitAttackOptions.remove(u);
            LogUtils.log(Level.FINEST, "Adding bombard to " + minWinTerritory4 + ", units=" + u + ", bombardFrom=" + minBombardFromTerritory);
        }
        return sortedUnitAttackOptions;
    }

    private void determineIfCapitalCanBeHeld(Map<Territory, ProAttackTerritoryData> attackMap, List<ProAttackTerritoryData> prioritizedTerritories, List<ProPurchaseOption> landPurchaseOptions) {
        LogUtils.log(Level.FINE, "Determine if capital can be held");
        List<Unit> placeUnits = this.purchaseUtils.findMaxPurchaseDefenders(this.player, this.myCapital, landPurchaseOptions);
        Map<Unit, Territory> unitTerritoryMap = this.utils.createUnitTerritoryMap(this.player);
        while (!prioritizedTerritories.isEmpty()) {
            ArrayList<Territory> territoriesToAttack = new ArrayList<Territory>();
            for (ProAttackTerritoryData t : prioritizedTerritories) {
                territoriesToAttack.add(t.getTerritory());
            }
            LogUtils.log(Level.FINEST, "Remaining territories to attack=" + territoriesToAttack);
            ArrayList<Territory> territoriesToCheck = new ArrayList<Territory>();
            territoriesToCheck.add(this.myCapital);
            HashMap<Territory, ProAttackTerritoryData> enemyAttackMap = new HashMap<Territory, ProAttackTerritoryData>();
            this.attackOptionsUtils.findMaxEnemyAttackUnits(this.player, territoriesToAttack, territoriesToCheck, enemyAttackMap);
            if (enemyAttackMap.get(this.myCapital) == null) break;
            Set<Territory> territoriesAdjacentToCapital = this.data.getMap().getNeighbors(this.myCapital, Matches.TerritoryIsLand);
            List<Unit> defenders = this.myCapital.getUnits().getMatches(Matches.isUnitAllied(this.player, this.data));
            defenders.addAll(placeUnits);
            for (Territory t : territoriesAdjacentToCapital) {
                defenders.addAll(t.getUnits().getMatches(ProMatches.unitCanBeMovedAndIsOwnedLand(this.player, false)));
            }
            for (Territory t : attackMap.keySet()) {
                defenders.removeAll(attackMap.get(t).getUnits());
            }
            HashSet<Unit> enemyAttackingUnits = new HashSet<Unit>(((ProAttackTerritoryData)enemyAttackMap.get(this.myCapital)).getMaxUnits());
            enemyAttackingUnits.addAll(((ProAttackTerritoryData)enemyAttackMap.get(this.myCapital)).getMaxAmphibUnits());
            ProBattleResultData result = this.battleUtils.estimateDefendBattleResults(this.player, this.myCapital, new ArrayList<Unit>(enemyAttackingUnits), defenders, ((ProAttackTerritoryData)enemyAttackMap.get(this.myCapital)).getMaxBombardUnits());
            LogUtils.log(Level.FINEST, "Current capital result hasLandUnitRemaining=" + result.isHasLandUnitRemaining() + ", TUVSwing=" + result.getTUVSwing() + ", defenders=" + defenders.size() + ", attackers=" + enemyAttackingUnits.size());
            if (result.isHasLandUnitRemaining()) {
                double maxUnitsNearCapitalPerValue = 0.0;
                DefaultNamed maxTerritory = null;
                Set<Territory> territoriesNearCapital = this.data.getMap().getNeighbors(this.myCapital, Matches.TerritoryIsLand);
                territoriesNearCapital.add(this.myCapital);
                for (Territory t : attackMap.keySet()) {
                    int unitsNearCapital = 0;
                    for (Unit u : attackMap.get(t).getUnits()) {
                        if (!territoriesNearCapital.contains(unitTerritoryMap.get(u))) continue;
                        ++unitsNearCapital;
                    }
                    double unitsNearCapitalPerValue = (double)unitsNearCapital / attackMap.get(t).getValue();
                    LogUtils.log(Level.FINEST, t.getName() + " has unit near capital per value: " + unitsNearCapitalPerValue);
                    if (!(unitsNearCapitalPerValue > maxUnitsNearCapitalPerValue)) continue;
                    maxUnitsNearCapitalPerValue = unitsNearCapitalPerValue;
                    maxTerritory = t;
                }
                if (maxTerritory == null) break;
                prioritizedTerritories.remove(attackMap.get(maxTerritory));
                attackMap.get(maxTerritory).getUnits().clear();
                attackMap.get(maxTerritory).getAmphibAttackMap().clear();
                attackMap.get(maxTerritory).setBattleResult(null);
                LogUtils.log(Level.FINER, "Removing territory to try to hold capital: " + maxTerritory.getName());
                continue;
            }
            LogUtils.log(Level.FINER, "Can hold capital: " + this.myCapital.getName());
            break;
        }
    }

    private void checkContestedSeaTerritories(Map<Territory, ProAttackTerritoryData> attackMap, List<Territory> myUnitTerritories) {
        for (Territory t : myUnitTerritories) {
            Set<Territory> possibleMoveTerritories;
            if (!t.isWater() || !Matches.territoryHasEnemyUnits(this.player, this.data).match(t) || attackMap.get(t) != null && !attackMap.get(t).getUnits().isEmpty() || (possibleMoveTerritories = this.data.getMap().getNeighbors(t, ProMatches.territoryCanMoveSeaUnitsThrough(this.player, this.data, true))).isEmpty()) continue;
            Territory moveToTerritory = possibleMoveTerritories.iterator().next();
            List<Unit> mySeaUnits = t.getUnits().getMatches(ProMatches.unitCanBeMovedAndIsOwnedSea(this.player, true));
            if (attackMap.containsKey(moveToTerritory)) {
                attackMap.get(moveToTerritory).addUnits(mySeaUnits);
            } else {
                ProAttackTerritoryData moveTerritoryData = new ProAttackTerritoryData(moveToTerritory);
                moveTerritoryData.addUnits(mySeaUnits);
                attackMap.put(moveToTerritory, moveTerritoryData);
            }
            LogUtils.log(Level.FINE, t + " is a contested territory so moving subs to " + moveToTerritory);
        }
    }

    private void logAttackMoves(Map<Territory, ProAttackTerritoryData> attackMap, Map<Unit, Set<Territory>> unitAttackMap, List<ProAmphibData> transportMapList, List<ProAttackTerritoryData> prioritizedTerritories, Map<Territory, ProAttackTerritoryData> enemyAttackMap) {
        LogUtils.log(Level.FINER, "Prioritized territories:");
        for (ProAttackTerritoryData attackTerritoryData : prioritizedTerritories) {
            LogUtils.log(Level.FINEST, "  " + attackTerritoryData.getMaxBattleResult().getTUVSwing() + "  " + attackTerritoryData.getValue() + "  " + attackTerritoryData.getTerritory().getName());
        }
        LogUtils.log(Level.FINER, "Territories that can be attacked:");
        int count = 0;
        for (Territory t : attackMap.keySet()) {
            LogUtils.log(Level.FINEST, ++count + ". ---" + t.getName());
            HashSet<Unit> combinedUnits = new HashSet<Unit>(attackMap.get(t).getMaxUnits());
            combinedUnits.addAll(attackMap.get(t).getMaxAmphibUnits());
            LogUtils.log(Level.FINEST, "  --- My max units ---");
            HashMap<String, Integer> printMap = new HashMap<String, Integer>();
            for (Unit unit : combinedUnits) {
                if (printMap.containsKey(unit.toStringNoOwner())) {
                    printMap.put(unit.toStringNoOwner(), (Integer)printMap.get(unit.toStringNoOwner()) + 1);
                    continue;
                }
                printMap.put(unit.toStringNoOwner(), 1);
            }
            for (String key : printMap.keySet()) {
                LogUtils.log(Level.FINEST, "    " + printMap.get(key) + " " + key);
            }
            LogUtils.log(Level.FINEST, "  --- My max bombard units ---");
            HashMap<String, Integer> printBombardMap = new HashMap<String, Integer>();
            for (Unit unit : attackMap.get(t).getMaxBombardUnits()) {
                if (printBombardMap.containsKey(unit.toStringNoOwner())) {
                    printBombardMap.put(unit.toStringNoOwner(), (Integer)printBombardMap.get(unit.toStringNoOwner()) + 1);
                    continue;
                }
                printBombardMap.put(unit.toStringNoOwner(), 1);
            }
            for (String key : printBombardMap.keySet()) {
                LogUtils.log(Level.FINEST, "    " + printBombardMap.get(key) + " " + key);
            }
            List<Unit> units3 = attackMap.get(t).getUnits();
            LogUtils.log(Level.FINEST, "  --- My actual units ---");
            HashMap<String, Integer> printMap3 = new HashMap<String, Integer>();
            for (Unit unit : units3) {
                if (printMap3.containsKey(unit.toStringNoOwner())) {
                    printMap3.put(unit.toStringNoOwner(), (Integer)printMap3.get(unit.toStringNoOwner()) + 1);
                    continue;
                }
                printMap3.put(unit.toStringNoOwner(), 1);
            }
            for (String key : printMap3.keySet()) {
                LogUtils.log(Level.FINEST, "    " + printMap3.get(key) + " " + key);
            }
            LogUtils.log(Level.FINEST, "  --- Enemy units ---");
            HashMap<String, Integer> printMap2 = new HashMap<String, Integer>();
            List<Unit> units2 = attackMap.get(t).getMaxEnemyDefenders(this.player, this.data);
            for (Unit unit : units2) {
                if (printMap2.containsKey(unit.toStringNoOwner())) {
                    printMap2.put(unit.toStringNoOwner(), (Integer)printMap2.get(unit.toStringNoOwner()) + 1);
                    continue;
                }
                printMap2.put(unit.toStringNoOwner(), 1);
            }
            for (String key : printMap2.keySet()) {
                LogUtils.log(Level.FINEST, "    " + printMap2.get(key) + " " + key);
            }
            LogUtils.log(Level.FINEST, "  --- Enemy Counter Attack Units ---");
            HashMap<String, Integer> printMap4 = new HashMap<String, Integer>();
            List<Unit> units4 = attackMap.get(t).getMaxEnemyUnits();
            for (Unit unit : units4) {
                if (printMap4.containsKey(unit.toStringNoOwner())) {
                    printMap4.put(unit.toStringNoOwner(), (Integer)printMap4.get(unit.toStringNoOwner()) + 1);
                    continue;
                }
                printMap4.put(unit.toStringNoOwner(), 1);
            }
            for (String key : printMap4.keySet()) {
                LogUtils.log(Level.FINEST, "    " + printMap4.get(key) + " " + key);
            }
            LogUtils.log(Level.FINEST, "  --- Enemy Counter Bombard Units ---");
            HashMap<String, Integer> printMap5 = new HashMap<String, Integer>();
            Set<Unit> units5 = attackMap.get(t).getMaxEnemyBombardUnits();
            for (Unit unit : units5) {
                if (printMap5.containsKey(unit.toStringNoOwner())) {
                    printMap5.put(unit.toStringNoOwner(), (Integer)printMap5.get(unit.toStringNoOwner()) + 1);
                    continue;
                }
                printMap5.put(unit.toStringNoOwner(), 1);
            }
            for (String key : printMap5.keySet()) {
                LogUtils.log(Level.FINEST, "    " + printMap4.get(key) + " " + key);
            }
        }
    }
}

