/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.proAI;

import games.strategy.engine.data.DefaultNamed;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.ai.proAI.ProAmphibData;
import games.strategy.triplea.ai.proAI.ProAttackTerritoryData;
import games.strategy.triplea.ai.proAI.ProBattleResultData;
import games.strategy.triplea.ai.proAI.ProPlaceTerritory;
import games.strategy.triplea.ai.proAI.ProPurchaseOption;
import games.strategy.triplea.ai.proAI.ProPurchaseTerritory;
import games.strategy.triplea.ai.proAI.util.LogUtils;
import games.strategy.triplea.ai.proAI.util.ProAttackOptionsUtils;
import games.strategy.triplea.ai.proAI.util.ProBattleUtils;
import games.strategy.triplea.ai.proAI.util.ProMatches;
import games.strategy.triplea.ai.proAI.util.ProMoveUtils;
import games.strategy.triplea.ai.proAI.util.ProPurchaseUtils;
import games.strategy.triplea.ai.proAI.util.ProTerritoryValueUtils;
import games.strategy.triplea.ai.proAI.util.ProTransportUtils;
import games.strategy.triplea.ai.proAI.util.ProUtils;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.AbstractMoveDelegate;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveValidator;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.triplea.delegate.dataObjects.MoveValidationResult;
import games.strategy.triplea.delegate.remote.IMoveDelegate;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;

public class ProNonCombatMoveAI {
    public static double WIN_PERCENTAGE = 95.0;
    public static double MIN_WIN_PERCENTAGE = 75.0;
    private final ProUtils utils;
    private final ProBattleUtils battleUtils;
    private final ProTransportUtils transportUtils;
    private final ProAttackOptionsUtils attackOptionsUtils;
    private final ProMoveUtils moveUtils;
    private final ProTerritoryValueUtils territoryValueUtils;
    private final ProPurchaseUtils purchaseUtils;
    private boolean areNeutralsPassableByAir;
    private GameData data;
    private PlayerID player;
    private Territory myCapital;
    private List<Territory> allTerritories;
    private Map<Unit, Territory> unitTerritoryMap;
    private IntegerMap<UnitType> playerCostMap;
    private double minCostPerHitPoint;

    public ProNonCombatMoveAI(ProUtils utils, ProBattleUtils battleUtils, ProTransportUtils transportUtils, ProAttackOptionsUtils attackOptionsUtils, ProMoveUtils moveUtils, ProTerritoryValueUtils territoryValueUtils, ProPurchaseUtils purchaseUtils) {
        this.utils = utils;
        this.battleUtils = battleUtils;
        this.transportUtils = transportUtils;
        this.attackOptionsUtils = attackOptionsUtils;
        this.moveUtils = moveUtils;
        this.territoryValueUtils = territoryValueUtils;
        this.purchaseUtils = purchaseUtils;
    }

    public Map<Territory, ProAttackTerritoryData> doNonCombatMove(Map<Territory, ProAttackTerritoryData> factoryMoveMap, Map<Territory, ProPurchaseTerritory> purchaseTerritories, IMoveDelegate moveDel, GameData data, PlayerID player, boolean isSimulation) {
        LogUtils.log(Level.FINE, "Starting non-combat move phase");
        this.data = data;
        this.player = player;
        this.areNeutralsPassableByAir = Properties.getNeutralFlyoverAllowed(data) && !Properties.getNeutralsImpassable(data);
        this.myCapital = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        this.allTerritories = data.getMap().getTerritories();
        this.unitTerritoryMap = this.createUnitTerritoryMap(player);
        this.playerCostMap = BattleCalculator.getCostsForTUV(player, data);
        if (!Properties.getLow_Luck(data)) {
            WIN_PERCENTAGE = 90.0;
            MIN_WIN_PERCENTAGE = 65.0;
        }
        HashMap<Territory, ProAttackTerritoryData> moveMap = new HashMap<Territory, ProAttackTerritoryData>();
        HashMap<Unit, Set<Territory>> unitMoveMap = new HashMap<Unit, Set<Territory>>();
        HashMap<Unit, Set<Territory>> transportMoveMap = new HashMap<Unit, Set<Territory>>();
        ArrayList<ProAmphibData> transportMapList = new ArrayList<ProAmphibData>();
        HashMap<Territory, Set<Territory>> landRoutesMap = new HashMap<Territory, Set<Territory>>();
        HashMap<Territory, ProAttackTerritoryData> enemyAttackMap = new HashMap<Territory, ProAttackTerritoryData>();
        HashMap<Unit, Set<Territory>> infraUnitMoveMap = new HashMap();
        ArrayList<ProAttackTerritoryData> prioritizedTerritories = new ArrayList();
        ArrayList<ProPurchaseOption> specialPurchaseOptions = new ArrayList<ProPurchaseOption>();
        ArrayList<ProPurchaseOption> factoryPurchaseOptions = new ArrayList<ProPurchaseOption>();
        ArrayList<ProPurchaseOption> landPurchaseOptions = new ArrayList<ProPurchaseOption>();
        ArrayList<ProPurchaseOption> airPurchaseOptions = new ArrayList<ProPurchaseOption>();
        ArrayList<ProPurchaseOption> seaPurchaseOptions = new ArrayList<ProPurchaseOption>();
        this.purchaseUtils.findPurchaseOptions(player, landPurchaseOptions, airPurchaseOptions, seaPurchaseOptions, factoryPurchaseOptions, specialPurchaseOptions);
        this.minCostPerHitPoint = this.purchaseUtils.getMinCostPerHitPoint(player, landPurchaseOptions);
        Match<Territory> myUnitTerritoriesMatch = Matches.territoryHasUnitsThatMatch(ProMatches.unitCanBeMovedAndIsOwned(player));
        List<Territory> myUnitTerritories = Match.getMatches(this.allTerritories, myUnitTerritoriesMatch);
        this.attackOptionsUtils.findDefendOptions(player, myUnitTerritories, moveMap, unitMoveMap, transportMoveMap, landRoutesMap, transportMapList, new ArrayList<Territory>());
        this.findUnitsThatCantMove(moveMap, unitMoveMap, purchaseTerritories, landPurchaseOptions, transportMapList);
        infraUnitMoveMap = this.findInfraUnitsThatCanMove(unitMoveMap);
        List<Territory> movedOneDefenderToTerritories = this.moveOneDefenderToLandTerritoriesBorderingEnemy(moveMap, unitMoveMap);
        this.attackOptionsUtils.findMaxEnemyAttackUnits(player, movedOneDefenderToTerritories, new ArrayList<Territory>(moveMap.keySet()), enemyAttackMap);
        this.determineIfMoveTerritoriesCanBeHeld(moveMap, enemyAttackMap);
        ArrayList<Territory> territoriesThatCantBeHeld = new ArrayList<Territory>();
        for (Territory t : moveMap.keySet()) {
            if (((ProAttackTerritoryData)moveMap.get(t)).isCanHold()) continue;
            territoriesThatCantBeHeld.add(t);
        }
        Map<Territory, Double> territoryValueMap = this.territoryValueUtils.findTerritoryValues(player, this.minCostPerHitPoint, territoriesThatCantBeHeld, new ArrayList<Territory>());
        Map<Territory, Double> seaTerritoryValueMap = this.territoryValueUtils.findSeaTerritoryValues(player, territoriesThatCantBeHeld);
        prioritizedTerritories = this.prioritizeDefendOptions(moveMap, factoryMoveMap, territoryValueMap, enemyAttackMap);
        int enemyDistance = this.utils.getClosestEnemyLandTerritoryDistance(data, player, this.myCapital);
        this.moveUnitsToDefendTerritories(moveMap, unitMoveMap, prioritizedTerritories, transportMapList, transportMoveMap, enemyDistance, territoryValueMap);
        HashMap<Territory, ProAttackTerritoryData> tempMoveMap = new HashMap<Territory, ProAttackTerritoryData>();
        for (Territory t : moveMap.keySet()) {
            tempMoveMap.put(t, new ProAttackTerritoryData((ProAttackTerritoryData)moveMap.get(t)));
        }
        HashMap<Unit, Set<Territory>> tempUnitMoveMap = new HashMap<Unit, Set<Territory>>(unitMoveMap);
        HashMap<Unit, Set<Territory>> tempTransportMoveMap = new HashMap<Unit, Set<Territory>>(transportMoveMap);
        ArrayList<ProAmphibData> tempTransportMapList = new ArrayList<ProAmphibData>(transportMapList);
        if (this.myCapital != null) {
            int defenseRange = -1;
            while (true) {
                for (Territory t : moveMap.keySet()) {
                    double value = territoryValueMap.get(t);
                    int distance = data.getMap().getDistance(this.myCapital, t, ProMatches.territoryCanMoveLandUnits(player, data, false));
                    if (distance >= 0 && distance <= defenseRange) {
                        value *= 10.0;
                    }
                    ((ProAttackTerritoryData)moveMap.get(t)).setValue(value);
                    if (!t.isWater()) continue;
                    ((ProAttackTerritoryData)moveMap.get(t)).setSeaValue(seaTerritoryValueMap.get(t));
                }
                this.moveUnitsToBestTerritories(moveMap, unitMoveMap, transportMapList, transportMoveMap);
                LogUtils.log(Level.FINE, "Checking if capital has local land superiority with enemyDistance=" + enemyDistance);
                if (enemyDistance < 2 || enemyDistance > 3 || defenseRange != -1 || this.battleUtils.territoryHasLocalLandSuperiorityAfterMoves(this.myCapital, enemyDistance, player, moveMap)) break;
                defenseRange = enemyDistance - 1;
                moveMap = tempMoveMap;
                unitMoveMap = tempUnitMoveMap;
                transportMoveMap = tempTransportMoveMap;
                transportMapList = tempTransportMapList;
                LogUtils.log(Level.FINER, "Capital doesn't have local land superiority so setting defensive stance");
            }
        }
        factoryMoveMap = this.moveInfraUnits(factoryMoveMap, moveMap, infraUnitMoveMap);
        for (Unit u : unitMoveMap.keySet()) {
            if (!Matches.UnitIsInfrastructure.invert().match(u)) continue;
            LogUtils.log(Level.WARNING, player + ": " + this.unitTerritoryMap.get(u) + " has unmoved unit: " + u + " with options: " + unitMoveMap.get(u));
        }
        this.doMove(moveMap, moveDel, data, player, isSimulation);
        LogUtils.log(Level.FINE, "Logging results");
        this.logAttackMoves(moveMap, unitMoveMap, transportMapList, prioritizedTerritories, enemyAttackMap);
        return factoryMoveMap;
    }

    public void doMove(Map<Territory, ProAttackTerritoryData> moveMap, IMoveDelegate moveDel, GameData data, PlayerID player, boolean isSimulation) {
        this.data = data;
        this.player = player;
        this.areNeutralsPassableByAir = Properties.getNeutralFlyoverAllowed(data) && !Properties.getNeutralsImpassable(data);
        ArrayList<Collection<Unit>> moveUnits = new ArrayList<Collection<Unit>>();
        ArrayList<Route> moveRoutes = new ArrayList<Route>();
        this.moveUtils.calculateMoveRoutes(player, this.areNeutralsPassableByAir, moveUnits, moveRoutes, moveMap, false);
        this.moveUtils.doMove(moveUnits, moveRoutes, null, moveDel, isSimulation);
        moveUnits.clear();
        moveRoutes.clear();
        ArrayList<Collection<Unit>> transportsToLoad = new ArrayList<Collection<Unit>>();
        this.moveUtils.calculateAmphibRoutes(player, moveUnits, moveRoutes, transportsToLoad, moveMap, false);
        this.moveUtils.doMove(moveUnits, moveRoutes, transportsToLoad, moveDel, isSimulation);
    }

    private void findUnitsThatCantMove(Map<Territory, ProAttackTerritoryData> moveMap, Map<Unit, Set<Territory>> unitMoveMap, Map<Territory, ProPurchaseTerritory> purchaseTerritories, List<ProPurchaseOption> landPurchaseOptions, List<ProAmphibData> transportMapList) {
        LogUtils.log(Level.FINE, "Find units that can't move");
        for (Territory t : moveMap.keySet()) {
            moveMap.get(t).getCantMoveUnits().addAll(t.getUnits().getMatches(ProMatches.unitCantBeMovedAndIsAlliedDefender(this.player, this.data, t)));
        }
        Iterator<Unit> it = unitMoveMap.keySet().iterator();
        while (it.hasNext()) {
            Territory onlyTerritory;
            Unit u = it.next();
            if (unitMoveMap.get(u).size() != 1 || !(onlyTerritory = unitMoveMap.get(u).iterator().next()).equals(this.unitTerritoryMap.get(u))) continue;
            boolean canBeTransported = false;
            for (ProAmphibData pad : transportMapList) {
                for (Territory t : pad.getTransportMap().keySet()) {
                    if (!pad.getTransportMap().get(t).contains(onlyTerritory)) continue;
                    canBeTransported = true;
                }
                for (Territory t : pad.getSeaTransportMap().keySet()) {
                    if (!pad.getSeaTransportMap().get(t).contains(onlyTerritory)) continue;
                    canBeTransported = true;
                }
            }
            if (canBeTransported) continue;
            moveMap.get(onlyTerritory).getCantMoveUnits().add(u);
            it.remove();
        }
        if (purchaseTerritories != null) {
            for (ProPurchaseTerritory ppt : purchaseTerritories.values()) {
                for (ProPlaceTerritory placeTerritory : ppt.getCanPlaceTerritories()) {
                    Territory t = placeTerritory.getTerritory();
                    if (moveMap.get(t) == null) continue;
                    moveMap.get(t).getCantMoveUnits().addAll(placeTerritory.getPlaceUnits());
                }
            }
        } else {
            for (Territory t : moveMap.keySet()) {
                if (!ProMatches.territoryHasInfraFactoryAndIsNotConqueredOwnedLand(this.player, this.data).match(t)) continue;
                moveMap.get(t).getCantMoveUnits().addAll(this.purchaseUtils.findMaxPurchaseDefenders(this.player, t, landPurchaseOptions));
            }
        }
        for (Territory t : moveMap.keySet()) {
            if (moveMap.get(t).getCantMoveUnits().isEmpty()) continue;
            LogUtils.log(Level.FINEST, t + " has units that can't move: " + moveMap.get(t).getCantMoveUnits());
        }
    }

    private Map<Unit, Set<Territory>> findInfraUnitsThatCanMove(Map<Unit, Set<Territory>> unitMoveMap) {
        LogUtils.log(Level.FINE, "Find non-combat infra units that can move");
        HashMap<Unit, Set<Territory>> infraUnitMoveMap = new HashMap<Unit, Set<Territory>>();
        Iterator<Unit> it = unitMoveMap.keySet().iterator();
        while (it.hasNext()) {
            Unit u = it.next();
            if (!ProMatches.unitCanBeMovedAndIsOwnedNonCombatInfra(this.player).match(u)) continue;
            infraUnitMoveMap.put(u, unitMoveMap.get(u));
            LogUtils.log(Level.FINEST, u + " is infra unit with move options: " + unitMoveMap.get(u));
            it.remove();
        }
        return infraUnitMoveMap;
    }

    private List<Territory> moveOneDefenderToLandTerritoriesBorderingEnemy(Map<Territory, ProAttackTerritoryData> moveMap, Map<Unit, Set<Territory>> unitMoveMap) {
        LogUtils.log(Level.FINE, "Determine which territories to defend with one land unit");
        ArrayList<Territory> territoriesToDefendWithOneUnit = new ArrayList<Territory>();
        for (Territory t : moveMap.keySet()) {
            boolean hasAlliedLandUnits = Match.someMatch(moveMap.get(t).getCantMoveUnits(), ProMatches.unitIsAlliedLandAndNotInfra(this.player, this.data));
            if (t.isWater() || hasAlliedLandUnits || !ProMatches.territoryHasNeighborOwnedByAndHasLandUnit(this.data, this.player, this.utils.getPotentialEnemyPlayers(this.player)).match(t)) continue;
            territoriesToDefendWithOneUnit.add(t);
        }
        ArrayList<Territory> result = new ArrayList<Territory>(territoriesToDefendWithOneUnit);
        Map<Unit, Set<Territory>> sortedUnitMoveOptions = this.attackOptionsUtils.sortUnitMoveOptions(this.player, unitMoveMap);
        for (Unit unit : sortedUnitMoveOptions.keySet()) {
            if (!Matches.UnitIsLand.match(unit)) continue;
            for (Territory t : sortedUnitMoveOptions.get(unit)) {
                int unitValue = this.playerCostMap.getInt(unit.getType());
                int production = 0;
                TerritoryAttachment ta = TerritoryAttachment.get(t);
                if (ta != null) {
                    production = ta.getProduction();
                }
                if (!territoriesToDefendWithOneUnit.contains(t) || unitValue > production + 3) continue;
                moveMap.get(t).addUnit(unit);
                unitMoveMap.remove(unit);
                territoriesToDefendWithOneUnit.remove(t);
                LogUtils.log(Level.FINER, t + ", added one land unit: " + unit);
                break;
            }
            if (!territoriesToDefendWithOneUnit.isEmpty()) continue;
            break;
        }
        return result;
    }

    private void determineIfMoveTerritoriesCanBeHeld(Map<Territory, ProAttackTerritoryData> moveMap, Map<Territory, ProAttackTerritoryData> enemyAttackMap) {
        LogUtils.log(Level.FINE, "Find max enemy attackers and if territories can be held");
        IntegerMap<UnitType> playerCostMap = BattleCalculator.getCostsForTUV(this.player, this.data);
        for (Territory t : moveMap.keySet()) {
            ProAttackTerritoryData patd = moveMap.get(t);
            if (enemyAttackMap.get(t) == null) {
                LogUtils.log(Level.FINER, "Territory=" + t.getName() + ", CanHold=true since has no enemy attackers");
                continue;
            }
            HashSet<Unit> enemyAttackingUnits = new HashSet<Unit>(enemyAttackMap.get(t).getMaxUnits());
            enemyAttackingUnits.addAll(enemyAttackMap.get(t).getMaxAmphibUnits());
            patd.setMaxEnemyUnits(new ArrayList<Unit>(enemyAttackingUnits));
            patd.setMaxEnemyBombardUnits(enemyAttackMap.get(t).getMaxBombardUnits());
            List<Unit> minDefendingUnitsAndNotAA = Match.getMatches(patd.getCantMoveUnits(), Matches.UnitIsAAforAnything.invert());
            ProBattleResultData minResult = this.battleUtils.calculateBattleResults(this.player, t, new ArrayList<Unit>(enemyAttackingUnits), minDefendingUnitsAndNotAA, enemyAttackMap.get(t).getMaxBombardUnits(), false);
            patd.setMinBattleResult(minResult);
            if (minResult.getTUVSwing() <= 0.0 && !minDefendingUnitsAndNotAA.isEmpty()) {
                LogUtils.log(Level.FINER, "Territory=" + t.getName() + ", CanHold=true" + ", MinDefenders=" + minDefendingUnitsAndNotAA.size() + ", EnemyAttackers=" + enemyAttackingUnits.size() + ", win%=" + minResult.getWinPercentage() + ", EnemyTUVSwing=" + minResult.getTUVSwing() + ", hasLandUnitRemaining=" + minResult.isHasLandUnitRemaining());
                continue;
            }
            HashSet<Unit> defendingUnits = new HashSet<Unit>(patd.getMaxUnits());
            defendingUnits.addAll(patd.getMaxAmphibUnits());
            defendingUnits.addAll(patd.getCantMoveUnits());
            List<Unit> defendingUnitsAndNotAA = Match.getMatches(defendingUnits, Matches.UnitIsAAforAnything.invert());
            ProBattleResultData result = this.battleUtils.calculateBattleResults(this.player, t, new ArrayList<Unit>(enemyAttackingUnits), defendingUnitsAndNotAA, enemyAttackMap.get(t).getMaxBombardUnits(), false);
            boolean isFactory = false;
            if (ProMatches.territoryHasInfraFactoryAndIsLand(this.player).match(t)) {
                isFactory = true;
            }
            int isMyCapital = 0;
            if (t.equals(this.myCapital)) {
                isMyCapital = 1;
            }
            ArrayList<Unit> extraUnits = new ArrayList<Unit>(defendingUnitsAndNotAA);
            extraUnits.removeAll(minDefendingUnitsAndNotAA);
            double extraUnitValue = BattleCalculator.getTUV(extraUnits, playerCostMap);
            double holdValue = extraUnitValue / 8.0 * (1.0 + 0.5 * (double)isFactory) * (double)(1 + 2 * isMyCapital);
            if (minDefendingUnitsAndNotAA.size() != defendingUnitsAndNotAA.size() && result.getTUVSwing() - holdValue < minResult.getTUVSwing()) {
                LogUtils.log(Level.FINER, "Territory=" + t.getName() + ", CanHold=true" + ", MaxDefenders=" + defendingUnitsAndNotAA.size() + ", EnemyAttackers=" + enemyAttackingUnits.size() + ", minTUVSwing=" + minResult.getTUVSwing() + ", win%=" + result.getWinPercentage() + ", EnemyTUVSwing=" + result.getTUVSwing() + ", hasLandUnitRemaining=" + result.isHasLandUnitRemaining() + ", holdValue=" + holdValue);
                continue;
            }
            patd.setCanHold(false);
            LogUtils.log(Level.FINER, "Can't hold Territory=" + t.getName() + ", MaxDefenders=" + defendingUnitsAndNotAA.size() + ", EnemyAttackers=" + enemyAttackingUnits.size() + ", minTUVSwing=" + minResult.getTUVSwing() + ", win%=" + result.getWinPercentage() + ", EnemyTUVSwing=" + result.getTUVSwing() + ", hasLandUnitRemaining=" + result.isHasLandUnitRemaining() + ", holdValue=" + holdValue);
        }
    }

    private List<ProAttackTerritoryData> prioritizeDefendOptions(Map<Territory, ProAttackTerritoryData> moveMap, Map<Territory, ProAttackTerritoryData> factoryMoveMap, Map<Territory, Double> territoryValueMap, Map<Territory, ProAttackTerritoryData> enemyAttackMap) {
        LogUtils.log(Level.FINE, "Prioritizing territories to try to defend");
        for (Territory t : moveMap.keySet()) {
            int isMyCapital = 0;
            if (t.equals(this.myCapital)) {
                isMyCapital = 1;
            }
            int isFactory = 0;
            if (ProMatches.territoryHasInfraFactoryAndIsLand(this.player).match(t) || factoryMoveMap != null && factoryMoveMap.containsKey(t)) {
                isFactory = 1;
            }
            int production = 0;
            int isEnemyOrAlliedCapital = 0;
            TerritoryAttachment ta = TerritoryAttachment.get(t);
            if (ta != null) {
                production = ta.getProduction();
                if (ta.isCapital() && !t.equals(this.myCapital)) {
                    isEnemyOrAlliedCapital = 1;
                }
            }
            double neighborValue = 0.0;
            if (!t.isWater()) {
                Set<Territory> landNeighbors = this.data.getMap().getNeighbors(t, Matches.TerritoryIsLand);
                for (Territory neighbor : landNeighbors) {
                    double neighborProduction = TerritoryAttachment.getProduction(neighbor);
                    if (Matches.isTerritoryAllied(this.player, this.data).match(neighbor)) {
                        neighborProduction = 0.1 * neighborProduction;
                    }
                    neighborValue += neighborProduction;
                }
            }
            int cantMoveUnitValue = BattleCalculator.getTUV(moveMap.get(t).getCantMoveUnits(), this.playerCostMap);
            double unitOwnerMultiplier = 1.0;
            if (Match.noneMatch(moveMap.get(t).getCantMoveUnits(), Matches.unitIsOwnedBy(this.player))) {
                unitOwnerMultiplier = t.isWater() && Match.noneMatch(moveMap.get(t).getCantMoveUnits(), Matches.UnitIsTransportButNotCombatTransport) ? 0.0 : 0.5;
            }
            double territoryValue = unitOwnerMultiplier * ((double)(2 * production + 10 * isFactory) + 0.5 * (double)cantMoveUnitValue + 0.5 * neighborValue) * (double)(1 + 10 * isMyCapital) * (double)(1 + 4 * isEnemyOrAlliedCapital);
            moveMap.get(t).setValue(territoryValue);
        }
        ArrayList<ProAttackTerritoryData> prioritizedTerritories = new ArrayList<ProAttackTerritoryData>(moveMap.values());
        Collections.sort(prioritizedTerritories, new Comparator<ProAttackTerritoryData>(){

            @Override
            public int compare(ProAttackTerritoryData t1, ProAttackTerritoryData t2) {
                double value1 = t1.getValue();
                double value2 = t2.getValue();
                return Double.compare(value2, value1);
            }
        });
        Iterator it = prioritizedTerritories.iterator();
        while (it.hasNext()) {
            boolean isNotFactoryAndOnlyAmphib;
            ProAttackTerritoryData patd = (ProAttackTerritoryData)it.next();
            Territory t = patd.getTerritory();
            boolean hasFactory = ProMatches.territoryHasInfraFactoryAndIsLand(this.player).match(t);
            ProBattleResultData minResult = patd.getMinBattleResult();
            int cantMoveUnitValue = BattleCalculator.getTUV(moveMap.get(t).getCantMoveUnits(), this.playerCostMap);
            boolean isLandAndCanOnlyBeAttackedByAir = !t.isWater() && Match.allMatch(patd.getMaxEnemyUnits(), Matches.UnitIsAir);
            boolean isNotFactoryAndShouldHold = !hasFactory && (minResult.getTUVSwing() <= 0.0 || !minResult.isHasLandUnitRemaining());
            boolean canAlreadyBeHeld = minResult.getTUVSwing() <= 0.0 && minResult.getWinPercentage() < 100.0 - WIN_PERCENTAGE;
            boolean isNotFactoryAndHasNoEnemyNeighbors = !t.isWater() && !hasFactory && !ProMatches.territoryHasNeighborOwnedByAndHasLandUnit(this.data, this.player, this.utils.getPotentialEnemyPlayers(this.player)).match(t);
            boolean bl = isNotFactoryAndOnlyAmphib = !t.isWater() && !hasFactory && Match.noneMatch(moveMap.get(t).getMaxUnits(), Matches.UnitIsLand) && cantMoveUnitValue < 5;
            if (patd.isCanHold() && !(patd.getValue() <= 0.0) && !isLandAndCanOnlyBeAttackedByAir && !isNotFactoryAndShouldHold && !canAlreadyBeHeld && !isNotFactoryAndHasNoEnemyNeighbors && !isNotFactoryAndOnlyAmphib) continue;
            double TUVSwing = minResult.getTUVSwing();
            boolean hasRemainingLandUnit = minResult.isHasLandUnitRemaining();
            LogUtils.log(Level.FINER, "Removing territory=" + t.getName() + ", value=" + patd.getValue() + ", CanHold=" + patd.isCanHold() + ", isLandAndCanOnlyBeAttackedByAir=" + isLandAndCanOnlyBeAttackedByAir + ", isNotFactoryAndShouldHold=" + isNotFactoryAndShouldHold + ", canAlreadyBeHeld=" + canAlreadyBeHeld + ", isNotFactoryAndHasNoEnemyNeighbors=" + isNotFactoryAndHasNoEnemyNeighbors + ", isNotFactoryAndOnlyAmphib=" + isNotFactoryAndOnlyAmphib + ", TUVSwing=" + TUVSwing + ", hasRemainingLandUnit=" + hasRemainingLandUnit + ", maxEnemyUnits=" + patd.getMaxEnemyUnits().size());
            it.remove();
        }
        List<Territory> seaFactories = Match.getMatches(this.data.getMap().getTerritories(), ProMatches.territoryHasInfraFactoryAndIsNotConqueredOwnedLand(this.player, this.data));
        seaFactories = Match.getMatches(seaFactories, ProMatches.territoryHasInfraFactoryAndIsOwnedLandAdjacentToSea(this.player, this.data));
        for (Territory t : seaFactories) {
            if (territoryValueMap.get(t) >= 1.0) continue;
            Set<Territory> neighbors = this.data.getMap().getNeighbors(t, ProMatches.territoryCanMoveSeaUnits(this.player, this.data, true));
            double maxValue = 0.0;
            Territory maxTerritory = null;
            for (Territory neighbor : neighbors) {
                if (moveMap.get(neighbor) == null || !moveMap.get(neighbor).isCanHold() || !(territoryValueMap.get(neighbor) > maxValue)) continue;
                maxTerritory = neighbor;
                maxValue = territoryValueMap.get(neighbor);
            }
            if (maxTerritory == null || enemyAttackMap.get(maxTerritory) == null) continue;
            boolean alreadyAdded = false;
            for (ProAttackTerritoryData patd : prioritizedTerritories) {
                if (!patd.getTerritory().equals(maxTerritory)) continue;
                alreadyAdded = true;
            }
            if (alreadyAdded) continue;
            prioritizedTerritories.add(moveMap.get(maxTerritory));
        }
        for (ProAttackTerritoryData attackTerritoryData : prioritizedTerritories) {
            LogUtils.log(Level.FINER, "Value=" + attackTerritoryData.getValue() + ", " + attackTerritoryData.getTerritory().getName());
        }
        return prioritizedTerritories;
    }

    /*
     * Unable to fully structure code
     */
    private void moveUnitsToDefendTerritories(Map<Territory, ProAttackTerritoryData> moveMap, Map<Unit, Set<Territory>> unitMoveMap, List<ProAttackTerritoryData> prioritizedTerritories, List<ProAmphibData> transportMapList, Map<Unit, Set<Territory>> transportMoveMap, int enemyDistance, Map<Territory, Double> territoryValueMap) {
        LogUtils.log(Level.FINE, "Determine units to defend territories with");
        if (prioritizedTerritories.isEmpty()) {
            return;
        }
        unitTerritoryMap = this.utils.createUnitTerritoryMap(this.player);
        numToDefend = 1;
        while (true) {
            for (Territory t : moveMap.keySet()) {
                moveMap.get(t).getTempUnits().clear();
                moveMap.get(t).getTempAmphibAttackMap().clear();
                moveMap.get(t).getTransportTerritoryMap().clear();
                moveMap.get(t).setBattleResult(null);
            }
            if (numToDefend <= 0) break;
            territoriesToTryToDefend = prioritizedTerritories.subList(0, numToDefend);
            unitDefendOptions = new HashMap<Unit, Set<Territory>>();
            for (Unit unit : unitMoveMap.keySet()) {
                canDefendTerritories = new LinkedHashSet<Territory>();
                for (ProAttackTerritoryData attackTerritoryData : territoriesToTryToDefend) {
                    if (!unitMoveMap.get(unit).contains(attackTerritoryData.getTerritory())) continue;
                    canDefendTerritories.add(attackTerritoryData.getTerritory());
                }
                unitDefendOptions.put(unit, canDefendTerritories);
            }
            sortedUnitMoveOptions = this.attackOptionsUtils.sortUnitMoveOptions(this.player, unitDefendOptions);
            it = sortedUnitMoveOptions.keySet().iterator();
            while (it.hasNext()) {
                unit = it.next();
                isAirUnit = UnitAttachment.get(unit.getType()).getIsAir();
                if (isAirUnit || Matches.UnitIsCarrier.match(unit)) continue;
                estimatesMap = new TreeMap<Double, Territory>();
                for (Territory t : sortedUnitMoveOptions.get(unit)) {
                    defendingUnits = Match.getMatches(moveMap.get(t).getAllDefenders(), ProMatches.unitIsAlliedNotOwnedAir(this.player, this.data).invert());
                    if (t.isWater()) {
                        defendingUnits = moveMap.get(t).getAllDefenders();
                    }
                    estimate = this.battleUtils.estimateStrengthDifference(t, moveMap.get(t).getMaxEnemyUnits(), defendingUnits);
                    estimatesMap.put(estimate, t);
                }
                if (estimatesMap.isEmpty() || !((Double)estimatesMap.lastKey() > 60.0)) continue;
                minWinTerritory = (Territory)estimatesMap.lastEntry().getValue();
                moveMap.get(minWinTerritory).addTempUnit(unit);
                it.remove();
            }
            it = sortedUnitMoveOptions.keySet().iterator();
            while (it.hasNext()) {
                unit = it.next();
                if (Matches.UnitCanLandOnCarrier.match(unit)) continue;
                maxWinTerritory = null;
                maxWinPercentage = -1.0;
                for (Territory t : sortedUnitMoveOptions.get(unit)) {
                    defendingUnits = Match.getMatches(moveMap.get(t).getAllDefenders(), ProMatches.unitIsAlliedNotOwnedAir(this.player, this.data).invert());
                    if (t.isWater()) {
                        defendingUnits = moveMap.get(t).getAllDefenders();
                    }
                    if (moveMap.get(t).getBattleResult() == null) {
                        moveMap.get(t).setBattleResult(this.battleUtils.estimateDefendBattleResults(this.player, t, moveMap.get(t).getMaxEnemyUnits(), defendingUnits, moveMap.get(t).getMaxEnemyBombardUnits()));
                    }
                    result = moveMap.get(t).getBattleResult();
                    hasFactory = ProMatches.territoryHasInfraFactoryAndIsLand(this.player).match(t);
                    if (!(result.getWinPercentage() > maxWinPercentage) || !(t.equals(this.myCapital) != false && result.getWinPercentage() > 100.0 - ProNonCombatMoveAI.WIN_PERCENTAGE || hasFactory != false && result.getWinPercentage() > 100.0 - ProNonCombatMoveAI.MIN_WIN_PERCENTAGE) && !(result.getTUVSwing() >= 0.0)) continue;
                    maxWinTerritory = t;
                    maxWinPercentage = result.getWinPercentage();
                }
                if (maxWinTerritory == null) continue;
                moveMap.get(maxWinTerritory).addTempUnit(unit);
                moveMap.get(maxWinTerritory).setBattleResult(null);
                it.remove();
                if (!Matches.UnitIsCarrier.match(unit) || !(carrierMustMoveWith = MoveValidator.carrierMustMoveWith((unitTerritory = unitTerritoryMap.get(unit)).getUnits().getUnits(), unitTerritory, this.data, this.player)).containsKey(unit)) continue;
                moveMap.get(maxWinTerritory).getTempUnits().addAll(carrierMustMoveWith.get(unit));
            }
            it = sortedUnitMoveOptions.keySet().iterator();
            while (it.hasNext()) {
                unit = it.next();
                maxWinTerritory = null;
                maxWinPercentage = -1.0;
                for (Territory t : sortedUnitMoveOptions.get(unit)) {
                    if (t.isWater() && Matches.UnitIsAir.match(unit) && !this.transportUtils.validateCarrierCapacity(this.player, t, moveMap.get(t).getAllDefendersForCarrierCalcs(this.data, this.player), unit) || !t.isWater() && !t.getOwner().equals(this.player) && Matches.UnitIsAir.match(unit) && !ProMatches.territoryHasInfraFactoryAndIsLand(this.player).match(t)) continue;
                    defendingUnits = Match.getMatches(moveMap.get(t).getAllDefenders(), ProMatches.unitIsAlliedNotOwnedAir(this.player, this.data).invert());
                    if (t.isWater()) {
                        defendingUnits = moveMap.get(t).getAllDefenders();
                    }
                    if (moveMap.get(t).getBattleResult() == null) {
                        moveMap.get(t).setBattleResult(this.battleUtils.estimateDefendBattleResults(this.player, t, moveMap.get(t).getMaxEnemyUnits(), defendingUnits, moveMap.get(t).getMaxEnemyBombardUnits()));
                    }
                    result = moveMap.get(t).getBattleResult();
                    hasFactory = ProMatches.territoryHasInfraFactoryAndIsLand(this.player).match(t);
                    if (!(result.getWinPercentage() > maxWinPercentage) || !(t.equals(this.myCapital) != false && result.getWinPercentage() > 100.0 - ProNonCombatMoveAI.WIN_PERCENTAGE || hasFactory != false && result.getWinPercentage() > 100.0 - ProNonCombatMoveAI.MIN_WIN_PERCENTAGE) && !(result.getTUVSwing() >= 0.0)) continue;
                    maxWinTerritory = t;
                    maxWinPercentage = result.getWinPercentage();
                }
                if (maxWinTerritory == null) continue;
                moveMap.get(maxWinTerritory).addTempUnit(unit);
                moveMap.get(maxWinTerritory).setBattleResult(null);
                it.remove();
            }
            alreadyMovedTransports = new ArrayList<Unit>();
            if (!Properties.getTransportCasualtiesRestricted(this.data)) {
                transportDefendOptions = new HashMap<Unit, HashSet<E>>();
                for (Unit unit : transportMoveMap.keySet()) {
                    canDefendTerritories = new HashSet<Territory>();
                    for (ProAttackTerritoryData attackTerritoryData : territoriesToTryToDefend) {
                        if (!transportMoveMap.get(unit).contains(attackTerritoryData.getTerritory())) continue;
                        canDefendTerritories.add(attackTerritoryData.getTerritory());
                    }
                    if (canDefendTerritories.isEmpty()) continue;
                    transportDefendOptions.put(unit, canDefendTerritories);
                }
                block12: for (Unit transport : transportDefendOptions.keySet()) {
                    for (Territory t : (Set)transportDefendOptions.get(transport)) {
                        if (TransportTracker.isTransporting(transport)) continue;
                        defendingUnits = moveMap.get(t).getAllDefenders();
                        if (moveMap.get(t).getBattleResult() == null) {
                            moveMap.get(t).setBattleResult(this.battleUtils.estimateDefendBattleResults(this.player, t, moveMap.get(t).getMaxEnemyUnits(), defendingUnits, moveMap.get(t).getMaxEnemyBombardUnits()));
                        }
                        if (!((result = moveMap.get(t).getBattleResult()).getTUVSwing() > 0.0)) continue;
                        moveMap.get(t).addTempUnit(transport);
                        moveMap.get(t).setBattleResult(null);
                        alreadyMovedTransports.add(transport);
                        LogUtils.log(Level.FINEST, "Adding defend transport to: " + t.getName());
                        continue block12;
                    }
                }
            }
            amphibMoveOptions = new HashMap<Unit, HashSet<E>>();
            for (ProAmphibData proTransportData : transportMapList) {
                if (alreadyMovedTransports.contains(proTransportData.getTransport())) continue;
                canAmphibMoveTerritories = new HashSet<Territory>();
                for (ProAttackTerritoryData attackTerritoryData : territoriesToTryToDefend) {
                    if (!proTransportData.getTransportMap().containsKey(attackTerritoryData.getTerritory())) continue;
                    canAmphibMoveTerritories.add(attackTerritoryData.getTerritory());
                }
                if (canAmphibMoveTerritories.isEmpty()) continue;
                amphibMoveOptions.put(proTransportData.getTransport(), canAmphibMoveTerritories);
            }
            block16: for (Unit transport : amphibMoveOptions.keySet()) {
                for (Territory t : (Set)amphibMoveOptions.get(transport)) {
                    defendingUnits = moveMap.get(t).getAllDefenders();
                    if (moveMap.get(t).getBattleResult() == null) {
                        moveMap.get(t).setBattleResult(this.battleUtils.estimateDefendBattleResults(this.player, t, moveMap.get(t).getMaxEnemyUnits(), defendingUnits, moveMap.get(t).getMaxEnemyBombardUnits()));
                    }
                    result = moveMap.get(t).getBattleResult();
                    hasFactory = ProMatches.territoryHasInfraFactoryAndIsLand(this.player).match(t);
                    if (!(hasFactory != false && result.getWinPercentage() > 100.0 - ProNonCombatMoveAI.WIN_PERCENTAGE) && !(result.getTUVSwing() > 0.0)) continue;
                    alreadyMovedUnits = new ArrayList<Unit>();
                    for (Territory t2 : moveMap.keySet()) {
                        alreadyMovedUnits.addAll(moveMap.get(t2).getUnits());
                        alreadyMovedUnits.addAll(moveMap.get(t2).getTempUnits());
                    }
                    addedAmphibUnits = false;
                    for (ProAmphibData proTransportData : transportMapList) {
                        if (!proTransportData.getTransport().equals(transport) || (amphibUnitsToAdd = this.transportUtils.getUnitsToTransportFromTerritories(this.player, transport, territoriesCanLoadFrom = proTransportData.getTransportMap().get(t), alreadyMovedUnits)).isEmpty()) continue;
                        minStrengthDifference = Infinity;
                        minTerritory = null;
                        territoriesToMoveTransport = this.data.getMap().getNeighbors(t, ProMatches.territoryCanMoveSeaUnits(this.player, this.data, false));
                        loadFromTerritories = new HashSet<Territory>();
                        for (Unit u : amphibUnitsToAdd) {
                            loadFromTerritories.add(unitTerritoryMap.get(u));
                        }
                        for (Territory territoryToMoveTransport : territoriesToMoveTransport) {
                            if (!proTransportData.getSeaTransportMap().containsKey(territoryToMoveTransport) || !proTransportData.getSeaTransportMap().get(territoryToMoveTransport).containsAll(loadFromTerritories) || moveMap.get(territoryToMoveTransport) == null || !moveMap.get(territoryToMoveTransport).isCanHold() && !hasFactory) continue;
                            attackers = moveMap.get(territoryToMoveTransport).getMaxEnemyUnits();
                            defenders = moveMap.get(territoryToMoveTransport).getAllDefenders();
                            defenders.add(transport);
                            strengthDifference = this.battleUtils.estimateStrengthDifference(territoryToMoveTransport, attackers, defenders);
                            if (!(strengthDifference < minStrengthDifference)) continue;
                            minTerritory = territoryToMoveTransport;
                            minStrengthDifference = strengthDifference;
                        }
                        if (minTerritory == null) continue;
                        moveMap.get(t).getTransportTerritoryMap().put(transport, minTerritory);
                        moveMap.get(t).addTempUnits(amphibUnitsToAdd);
                        moveMap.get(t).putTempAmphibAttackMap(transport, amphibUnitsToAdd);
                        moveMap.get(t).setBattleResult(null);
                        for (Unit unit : amphibUnitsToAdd) {
                            sortedUnitMoveOptions.remove(unit);
                        }
                        LogUtils.log(Level.FINEST, "Adding amphibious defense to: " + t + ", units=" + amphibUnitsToAdd + ", unloadTerritory=" + minTerritory);
                        addedAmphibUnits = true;
                        break;
                    }
                    if (!addedAmphibUnits) continue;
                    continue block16;
                }
            }
            areSuccessful = true;
            containsCapital = false;
            LogUtils.log(Level.FINER, "Current number of territories: " + numToDefend);
            for (ProAttackTerritoryData patd : territoriesToTryToDefend) {
                t = patd.getTerritory();
                defendingUnits = moveMap.get(t).getAllDefenders();
                moveMap.get(t).setBattleResult(this.battleUtils.calculateBattleResults(this.player, t, moveMap.get(t).getMaxEnemyUnits(), defendingUnits, moveMap.get(t).getMaxEnemyBombardUnits(), false));
                result = patd.getBattleResult();
                isFactory = false;
                if (ProMatches.territoryHasInfraFactoryAndIsLand(this.player).match(t)) {
                    isFactory = true;
                }
                isMyCapital = 0;
                if (t.equals(this.myCapital)) {
                    isMyCapital = 1;
                    containsCapital = true;
                }
                extraUnitValue = BattleCalculator.getTUV(moveMap.get(t).getTempUnits(), this.playerCostMap);
                unsafeTransports = new ArrayList<Unit>();
                for (Unit transport : moveMap.get(t).getTransportTerritoryMap().keySet()) {
                    transportTerritory = moveMap.get(t).getTransportTerritoryMap().get(transport);
                    if (moveMap.get(transportTerritory).isCanHold()) continue;
                    unsafeTransports.add(transport);
                }
                unsafeTransportValue = BattleCalculator.getTUV(unsafeTransports, this.playerCostMap);
                holdValue = extraUnitValue / 8.0 * (1.0 + 0.5 * (double)isFactory) * (double)(1 + 2 * isMyCapital) - (double)unsafeTransportValue;
                hasHigherStrategicValue = true;
                if (!(t.isWater() || t.equals(this.myCapital) || ProMatches.territoryHasInfraFactoryAndIsLand(this.player).match(t))) {
                    totalValue = 0.0;
                    nonAirDefenders = Match.getMatches(moveMap.get(t).getTempUnits(), Matches.UnitIsNotAir);
                    for (Unit u : nonAirDefenders) {
                        totalValue += territoryValueMap.get(unitTerritoryMap.get(u)).doubleValue();
                    }
                    averageValue = totalValue / (double)nonAirDefenders.size();
                    if (territoryValueMap.get(t) < averageValue) {
                        hasHigherStrategicValue = false;
                        LogUtils.log(Level.FINEST, t + " has lower value then move from with value=" + territoryValueMap.get(t) + ", averageMoveFromValue=" + averageValue);
                    }
                }
                if (result.getTUVSwing() - holdValue > patd.getMinBattleResult().getTUVSwing() || !hasHigherStrategicValue && result.getTUVSwing() + extraUnitValue / 2.0 >= patd.getMinBattleResult().getTUVSwing()) {
                    areSuccessful = false;
                }
                LogUtils.log(Level.FINER, patd.getResultString() + ", holdValue=" + holdValue + ", minTUVSwing=" + patd.getMinBattleResult().getTUVSwing() + ", hasHighStrategicValue=" + hasHigherStrategicValue + ", defenders=" + defendingUnits + ", attackers=" + moveMap.get(t).getMaxEnemyUnits());
            }
            currentTerritory = prioritizedTerritories.get(numToDefend - 1).getTerritory();
            if (this.myCapital != null) {
                if (containsCapital && !currentTerritory.equals(this.myCapital) && moveMap.get(this.myCapital).getBattleResult().getWinPercentage() > 100.0 - ProNonCombatMoveAI.WIN_PERCENTAGE && !Collections.disjoint(moveMap.get(currentTerritory).getAllDefenders(), moveMap.get(this.myCapital).getMaxDefenders())) {
                    areSuccessful = false;
                    LogUtils.log(Level.FINER, "Capital isn't safe after defense moves with winPercentage=" + moveMap.get(this.myCapital).getBattleResult().getWinPercentage());
                }
                if (!(currentTerritory.isWater() || enemyDistance < 2 || enemyDistance > 3 || (distance = this.data.getMap().getDistance(this.myCapital, currentTerritory, ProMatches.territoryCanMoveLandUnits(this.player, this.data, true))) <= 0 || enemyDistance != distance && enemyDistance != distance - 1 || this.battleUtils.territoryHasLocalLandSuperiorityAfterMoves(this.myCapital, enemyDistance, this.player, moveMap))) {
                    areSuccessful = false;
                    LogUtils.log(Level.FINER, "Capital doesn't have local land superiority after defense moves with enemyDistance=" + enemyDistance);
                }
            }
            if (areSuccessful) {
                ++numToDefend;
                for (ProAttackTerritoryData patd : territoriesToTryToDefend) {
                    patd.setCanAttack(true);
                }
                if (numToDefend <= prioritizedTerritories.size()) ** continue;
                break;
            }
            LogUtils.log(Level.FINER, "Removing territory: " + currentTerritory);
            prioritizedTerritories.get(numToDefend - 1).setCanHold(false);
            prioritizedTerritories.remove(numToDefend - 1);
            if (numToDefend <= prioritizedTerritories.size()) ** continue;
            --numToDefend;
        }
        for (Territory t : moveMap.keySet()) {
            alliedUnits = Match.getMatches(moveMap.get(t).getTempUnits(), Matches.unitIsOwnedBy(this.player).invert());
            for (Unit alliedUnit : alliedUnits) {
                moveMap.get(t).addCantMoveUnit(alliedUnit);
                moveMap.get(t).getTempUnits().remove(alliedUnit);
            }
            moveMap.get(t).addUnits(moveMap.get(t).getTempUnits());
            moveMap.get(t).putAllAmphibAttackMap(moveMap.get(t).getTempAmphibAttackMap());
            for (Unit u : moveMap.get(t).getTempUnits()) {
                if (Matches.UnitIsTransport.match(u)) {
                    transportMoveMap.remove(u);
                    it = transportMapList.iterator();
                    while (it.hasNext()) {
                        if (!it.next().getTransport().equals(u)) continue;
                        it.remove();
                    }
                    continue;
                }
                unitMoveMap.remove(u);
            }
            for (Unit u : moveMap.get(t).getTempAmphibAttackMap().keySet()) {
                transportMoveMap.remove(u);
                it = transportMapList.iterator();
                while (it.hasNext()) {
                    if (!it.next().getTransport().equals(u)) continue;
                    it.remove();
                }
            }
            moveMap.get(t).getTempUnits().clear();
            moveMap.get(t).getTempAmphibAttackMap().clear();
        }
        LogUtils.log(Level.FINER, "Final number of territories: " + (numToDefend - 1));
    }

    private void moveUnitsToBestTerritories(Map<Territory, ProAttackTerritoryData> moveMap, Map<Unit, Set<Territory>> unitMoveMap, List<ProAmphibData> transportMapList, Map<Unit, Set<Territory>> transportMoveMap) {
        Unit u;
        DefaultNamed minTerritory;
        Unit u2;
        boolean areSuccessful;
        do {
            ProBattleResultData result;
            List<Unit> defendingUnits;
            Unit u3;
            Unit transport;
            LogUtils.log(Level.FINE, "Move units to best value territories");
            HashSet<Territory> territoriesToDefend = new HashSet<Territory>();
            HashMap<Unit, Set<Territory>> currentUnitMoveMap = new HashMap<Unit, Set<Territory>>(unitMoveMap);
            HashMap<Unit, Set<Territory>> currentTransportMoveMap = new HashMap<Unit, Set<Territory>>(transportMoveMap);
            ArrayList<ProAmphibData> currentTransportMapList = new ArrayList<ProAmphibData>(transportMapList);
            for (Territory t : moveMap.keySet()) {
                moveMap.get(t).getTempUnits().clear();
                for (Unit transport2 : moveMap.get(t).getTempAmphibAttackMap().keySet()) {
                    moveMap.get(t).getTransportTerritoryMap().remove(transport2);
                }
                moveMap.get(t).getTempAmphibAttackMap().clear();
                moveMap.get(t).setBattleResult(null);
            }
            LogUtils.log(Level.FINER, "Move amphib units");
            Iterator<Object> it = currentTransportMapList.iterator();
            while (it.hasNext()) {
                Set<Territory> territoriesCanLoadFrom;
                List<Unit> amphibUnitsToAdd;
                ProAmphibData amphibData = (ProAmphibData)it.next();
                Unit transport3 = amphibData.getTransport();
                ArrayList<Unit> alreadyMovedUnits = new ArrayList<Unit>();
                for (Territory t : moveMap.keySet()) {
                    alreadyMovedUnits.addAll(moveMap.get(t).getUnits());
                    alreadyMovedUnits.addAll(moveMap.get(t).getTempUnits());
                }
                Territory maxValueTerritory = null;
                List<Unit> maxAmphibUnitsToAdd = null;
                double maxValue = Double.MIN_VALUE;
                double maxSeaValue = 0.0;
                Territory maxUnloadFromTerritory = null;
                for (Territory t : amphibData.getTransportMap().keySet()) {
                    if (!(moveMap.get(t).getValue() >= maxValue) || (amphibUnitsToAdd = this.transportUtils.getUnitsToTransportThatCantMoveToHigherValue(this.player, transport3, territoriesCanLoadFrom = amphibData.getTransportMap().get(t), alreadyMovedUnits, moveMap, currentUnitMoveMap, moveMap.get(t).getValue())).isEmpty()) continue;
                    HashSet<Territory> loadFromTerritories = new HashSet<Territory>();
                    for (Unit u4 : amphibUnitsToAdd) {
                        loadFromTerritories.add(this.unitTerritoryMap.get(u4));
                    }
                    Set<Territory> territoriesToMoveTransport = this.data.getMap().getNeighbors(t, ProMatches.territoryCanMoveSeaUnits(this.player, this.data, false));
                    for (Territory territoryToMoveTransport : territoriesToMoveTransport) {
                        if (!amphibData.getSeaTransportMap().containsKey(territoryToMoveTransport) || !amphibData.getSeaTransportMap().get(territoryToMoveTransport).containsAll(loadFromTerritories) || moveMap.get(territoryToMoveTransport) == null || !moveMap.get(territoryToMoveTransport).isCanHold() || !(moveMap.get(t).getValue() > maxValue) && !(moveMap.get(territoryToMoveTransport).getValue() > maxSeaValue)) continue;
                        maxValueTerritory = t;
                        maxAmphibUnitsToAdd = amphibUnitsToAdd;
                        maxValue = moveMap.get(t).getValue();
                        maxSeaValue = moveMap.get(territoryToMoveTransport).getValue();
                        maxUnloadFromTerritory = territoryToMoveTransport;
                    }
                }
                if (maxValueTerritory != null) {
                    LogUtils.log(Level.FINEST, transport3 + " moved to " + maxUnloadFromTerritory + " and unloading to best land at " + maxValueTerritory + " with " + maxAmphibUnitsToAdd + ", value=" + maxValue);
                    moveMap.get(maxValueTerritory).addTempUnits(maxAmphibUnitsToAdd);
                    moveMap.get(maxValueTerritory).putTempAmphibAttackMap(transport3, maxAmphibUnitsToAdd);
                    moveMap.get(maxValueTerritory).getTransportTerritoryMap().put(transport3, maxUnloadFromTerritory);
                    currentTransportMoveMap.remove(transport3);
                    for (Unit unit : maxAmphibUnitsToAdd) {
                        currentUnitMoveMap.remove(unit);
                    }
                    territoriesToDefend.add(maxUnloadFromTerritory);
                    it.remove();
                    continue;
                }
                for (Territory t : amphibData.getSeaTransportMap().keySet()) {
                    if (moveMap.get(t) == null || !(moveMap.get(t).getValue() > maxValue)) continue;
                    territoriesCanLoadFrom = amphibData.getSeaTransportMap().get(t);
                    territoriesCanLoadFrom.removeAll(this.data.getMap().getNeighbors(t));
                    amphibUnitsToAdd = this.transportUtils.getUnitsToTransportThatCantMoveToHigherValue(this.player, transport3, territoriesCanLoadFrom, alreadyMovedUnits, moveMap, currentUnitMoveMap, 0.1);
                    if (amphibUnitsToAdd.isEmpty()) continue;
                    maxValueTerritory = t;
                    maxAmphibUnitsToAdd = amphibUnitsToAdd;
                    maxValue = moveMap.get(t).getValue();
                }
                if (maxValueTerritory == null) continue;
                Set<Territory> possibleUnloadTerritories = this.data.getMap().getNeighbors(maxValueTerritory, ProMatches.territoryCanMoveLandUnitsAndIsAllied(this.player, this.data));
                Territory unloadToTerritory = null;
                int maxNumSeaNeighbors = 0;
                for (Territory t : possibleUnloadTerritories) {
                    int numSeaNeighbors = this.data.getMap().getNeighbors(t, Matches.TerritoryIsWater).size();
                    boolean isAdjacentToEnemy = ProMatches.territoryIsOrAdjacentToEnemyNotNeutralLand(this.player, this.data).match(t);
                    if (moveMap.get(t) == null || !moveMap.get(t).isCanHold() && isAdjacentToEnemy || numSeaNeighbors <= maxNumSeaNeighbors) continue;
                    unloadToTerritory = t;
                    maxNumSeaNeighbors = numSeaNeighbors;
                }
                if (unloadToTerritory != null) {
                    moveMap.get(unloadToTerritory).addTempUnits(maxAmphibUnitsToAdd);
                    moveMap.get(unloadToTerritory).putTempAmphibAttackMap(transport3, maxAmphibUnitsToAdd);
                    moveMap.get(unloadToTerritory).getTransportTerritoryMap().put(transport3, maxValueTerritory);
                    LogUtils.log(Level.FINEST, transport3 + " moved to best sea at " + maxValueTerritory + " and unloading to " + unloadToTerritory + " with " + maxAmphibUnitsToAdd + ", value=" + maxValue);
                } else {
                    moveMap.get(maxValueTerritory).addTempUnits(maxAmphibUnitsToAdd);
                    moveMap.get(maxValueTerritory).putTempAmphibAttackMap(transport3, maxAmphibUnitsToAdd);
                    moveMap.get(maxValueTerritory).getTransportTerritoryMap().put(transport3, maxValueTerritory);
                    LogUtils.log(Level.FINEST, transport3 + " moved to best sea at " + maxValueTerritory + " with " + maxAmphibUnitsToAdd + ", value=" + maxValue);
                }
                currentTransportMoveMap.remove(transport3);
                for (Unit unit : maxAmphibUnitsToAdd) {
                    currentUnitMoveMap.remove(unit);
                }
                territoriesToDefend.add(maxValueTerritory);
                it.remove();
            }
            LogUtils.log(Level.FINER, "Move empty transports to best loading territory");
            it = currentTransportMoveMap.keySet().iterator();
            block12: while (it.hasNext()) {
                transport = (Unit)it.next();
                Territory currentTerritory = this.unitTerritoryMap.get(transport);
                int moves = TripleAUnit.get(transport).getMovementLeft();
                if (TransportTracker.isTransporting(transport) || moves <= 0) continue;
                ArrayList<ProAttackTerritoryData> priorizitedLoadTerritories = new ArrayList<ProAttackTerritoryData>();
                for (Territory t : moveMap.keySet()) {
                    boolean territoryHasTransportableUnits = Matches.territoryHasUnitsThatMatch(ProMatches.unitIsOwnedTransportableUnitAndCanBeLoaded(this.player, false)).match(t);
                    int distance = this.data.getMap().getDistance_IgnoreEndForCondition(currentTerritory, t, ProMatches.territoryCanMoveSeaUnits(this.player, this.data, true));
                    boolean hasSeaNeighbor = Matches.territoryHasNeighborMatching(this.data, Matches.TerritoryIsWater).match(t);
                    boolean hasFactory = ProMatches.territoryHasInfraFactoryAndIsOwnedLand(this.player).match(t);
                    if (t.isWater() || !hasSeaNeighbor || distance <= 0 || distance == 1 && territoryHasTransportableUnits && !hasFactory) continue;
                    double territoryValue = moveMap.get(t).getValue();
                    int numUnitsToLoad = Match.getMatches(moveMap.get(t).getAllDefenders(), ProMatches.unitIsOwnedTransportableUnit(this.player)).size();
                    boolean hasUnconqueredFactory = ProMatches.territoryHasInfraFactoryAndIsOwnedLand(this.player).match(t) && !AbstractMoveDelegate.getBattleTracker(this.data).wasConquered(t);
                    int factoryProduction = 0;
                    if (hasUnconqueredFactory) {
                        factoryProduction = TerritoryAttachment.getProduction(t);
                    }
                    int numTurnsAway = (distance - 1) / moves;
                    if (distance <= moves) {
                        numTurnsAway = 0;
                    }
                    double value = territoryValue + 0.5 * (double)numTurnsAway - 0.1 * (double)numUnitsToLoad - 0.1 * (double)factoryProduction;
                    moveMap.get(t).setLoadValue(value);
                    priorizitedLoadTerritories.add(moveMap.get(t));
                }
                Collections.sort(priorizitedLoadTerritories, new Comparator<ProAttackTerritoryData>(){

                    @Override
                    public int compare(ProAttackTerritoryData t1, ProAttackTerritoryData t2) {
                        double value1 = t1.getLoadValue();
                        double value2 = t2.getLoadValue();
                        return Double.compare(value1, value2);
                    }
                });
                for (ProAttackTerritoryData patd : priorizitedLoadTerritories) {
                    Territory moveToTerritory;
                    boolean movedTransport = false;
                    HashSet<Territory> cantHoldTerritories = new HashSet<Territory>();
                    do {
                        CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(ProMatches.territoryCanMoveSeaUnitsThrough(this.player, this.data, false), Matches.territoryIsInList(cantHoldTerritories).invert());
                        Route route = this.data.getMap().getRoute_IgnoreEnd(currentTerritory, patd.getTerritory(), match);
                        if (route == null || MoveValidator.validateCanal(route, Collections.singletonList(transport), this.player, this.data) != null) break;
                        List<Territory> territories = route.getAllTerritories();
                        territories.remove(territories.size() - 1);
                        moveToTerritory = territories.get(Math.min(territories.size() - 1, moves));
                        ProAttackTerritoryData patd2 = moveMap.get(moveToTerritory);
                        if (patd2 == null || !patd2.isCanHold()) continue;
                        LogUtils.log(Level.FINEST, transport + " moved towards best loading territory " + patd.getTerritory() + " and moved to " + moveToTerritory);
                        patd2.addTempUnit(transport);
                        territoriesToDefend.add(moveToTerritory);
                        it.remove();
                        movedTransport = true;
                        break;
                    } while (cantHoldTerritories.add(moveToTerritory));
                    if (!movedTransport) continue;
                    continue block12;
                }
            }
            LogUtils.log(Level.FINER, "Move remaining transports to safest territory");
            it = currentTransportMoveMap.keySet().iterator();
            while (it.hasNext()) {
                transport = (Unit)it.next();
                ArrayList<Unit> alreadyMovedUnits = new ArrayList<Unit>();
                for (Territory t : moveMap.keySet()) {
                    alreadyMovedUnits.addAll(moveMap.get(t).getUnits());
                }
                double minStrengthDifference = Double.POSITIVE_INFINITY;
                Territory minTerritory2 = null;
                for (Territory t : (Set)currentTransportMoveMap.get(transport)) {
                    List<Unit> attackers = moveMap.get(t).getMaxEnemyUnits();
                    List<Unit> defenders = moveMap.get(t).getMaxDefenders();
                    defenders.removeAll(alreadyMovedUnits);
                    defenders.addAll(moveMap.get(t).getUnits());
                    double strengthDifference = this.battleUtils.estimateStrengthDifference(t, attackers, defenders);
                    LogUtils.log(Level.FINEST, transport + " at " + t + ", strengthDifference=" + strengthDifference);
                    if (!(strengthDifference < minStrengthDifference)) continue;
                    minStrengthDifference = strengthDifference;
                    minTerritory2 = t;
                }
                if (minTerritory2 == null) continue;
                if (TransportTracker.isTransporting(transport)) {
                    List amphibUnits = (List)TransportTracker.transporting(transport);
                    Set<Territory> possibleUnloadTerritories = this.data.getMap().getNeighbors(minTerritory2, ProMatches.territoryCanMoveLandUnitsAndIsAllied(this.player, this.data));
                    if (!possibleUnloadTerritories.isEmpty()) {
                        Territory unloadToTerritory = possibleUnloadTerritories.iterator().next();
                        for (Territory t : possibleUnloadTerritories) {
                            if (moveMap.get(t) == null || !moveMap.get(t).isCanHold()) continue;
                            unloadToTerritory = t;
                        }
                        LogUtils.log(Level.FINEST, transport + " moved to safest territory at " + minTerritory2 + " and unloading to " + unloadToTerritory + " with " + amphibUnits + ", strengthDifference=" + minStrengthDifference);
                        moveMap.get(unloadToTerritory).addTempUnits(amphibUnits);
                        moveMap.get(unloadToTerritory).putTempAmphibAttackMap(transport, amphibUnits);
                        moveMap.get(unloadToTerritory).getTransportTerritoryMap().put(transport, minTerritory2);
                        for (Unit unit : amphibUnits) {
                            currentUnitMoveMap.remove(unit);
                        }
                        it.remove();
                        continue;
                    }
                    LogUtils.log(Level.FINEST, transport + " moved to safest territory at " + minTerritory2 + " with " + amphibUnits + ", strengthDifference=" + minStrengthDifference);
                    moveMap.get(minTerritory2).addTempUnits(amphibUnits);
                    moveMap.get(minTerritory2).putTempAmphibAttackMap(transport, amphibUnits);
                    moveMap.get(minTerritory2).getTransportTerritoryMap().put(transport, minTerritory2);
                    for (Unit unit : amphibUnits) {
                        currentUnitMoveMap.remove(unit);
                    }
                    it.remove();
                    continue;
                }
                LogUtils.log(Level.FINEST, transport + " moved to safest territory at " + minTerritory2 + ", strengthDifference=" + minStrengthDifference);
                moveMap.get(minTerritory2).addTempUnit(transport);
                it.remove();
            }
            this.moveUtils.calculateAmphibRoutes(this.player, new ArrayList<Collection<Unit>>(), new ArrayList<Route>(), new ArrayList<Collection<Unit>>(), moveMap, false);
            for (Territory t : moveMap.keySet()) {
                for (Unit u5 : moveMap.get(t).getTransportTerritoryMap().keySet()) {
                    if (moveMap.get(moveMap.get(t).getTransportTerritoryMap().get(u5)) == null) continue;
                    moveMap.get(moveMap.get(t).getTransportTerritoryMap().get(u5)).addTempUnit(u5);
                }
            }
            LogUtils.log(Level.FINER, "Move sea units");
            it = currentUnitMoveMap.keySet().iterator();
            block24: while (it.hasNext()) {
                u3 = (Unit)it.next();
                if (!Matches.UnitIsSea.match(u3)) continue;
                for (Territory t : (Set)currentUnitMoveMap.get(u3)) {
                    Territory unitTerritory;
                    Map<Unit, Collection<Unit>> carrierMustMoveWith;
                    if (!moveMap.get(t).isCanHold() || moveMap.get(t).getAllDefenders().isEmpty() || !Match.someMatch(moveMap.get(t).getAllDefenders(), ProMatches.unitIsOwnedTransport(this.player))) continue;
                    defendingUnits = Match.getMatches(moveMap.get(t).getAllDefenders(), Matches.UnitIsNotLand);
                    if (moveMap.get(t).getBattleResult() == null) {
                        moveMap.get(t).setBattleResult(this.battleUtils.estimateDefendBattleResults(this.player, t, moveMap.get(t).getMaxEnemyUnits(), defendingUnits, moveMap.get(t).getMaxEnemyBombardUnits()));
                    }
                    result = moveMap.get(t).getBattleResult();
                    LogUtils.log(Level.FINEST, t.getName() + " TUVSwing=" + result.getTUVSwing() + ", Win%=" + result.getWinPercentage() + ", enemyAttackers=" + moveMap.get(t).getMaxEnemyUnits().size() + ", defenders=" + defendingUnits.size());
                    if (!(result.getWinPercentage() > 100.0 - WIN_PERCENTAGE) && !(result.getTUVSwing() > 0.0)) continue;
                    LogUtils.log(Level.FINEST, u3 + " added sea to defend transport at " + t);
                    moveMap.get(t).addTempUnit(u3);
                    moveMap.get(t).setBattleResult(null);
                    territoriesToDefend.add(t);
                    it.remove();
                    if (!Matches.UnitIsCarrier.match(u3) || !(carrierMustMoveWith = MoveValidator.carrierMustMoveWith((unitTerritory = this.unitTerritoryMap.get(u3)).getUnits().getUnits(), unitTerritory, this.data, this.player)).containsKey(u3)) continue block24;
                    moveMap.get(t).getTempUnits().addAll(carrierMustMoveWith.get(u3));
                    continue block24;
                }
            }
            it = currentUnitMoveMap.keySet().iterator();
            block26: while (it.hasNext()) {
                u3 = (Unit)it.next();
                if (!Matches.UnitCanLandOnCarrier.match(u3)) continue;
                for (Territory t : (Set)currentUnitMoveMap.get(u3)) {
                    if (!t.isWater() || !moveMap.get(t).isCanHold() || moveMap.get(t).getAllDefenders().isEmpty() || !Match.someMatch(moveMap.get(t).getAllDefenders(), ProMatches.unitIsOwnedTransport(this.player)) || !this.transportUtils.validateCarrierCapacity(this.player, t, moveMap.get(t).getAllDefendersForCarrierCalcs(this.data, this.player), u3)) continue;
                    defendingUnits = Match.getMatches(moveMap.get(t).getAllDefenders(), Matches.UnitIsNotLand);
                    if (moveMap.get(t).getBattleResult() == null) {
                        moveMap.get(t).setBattleResult(this.battleUtils.estimateDefendBattleResults(this.player, t, moveMap.get(t).getMaxEnemyUnits(), defendingUnits, moveMap.get(t).getMaxEnemyBombardUnits()));
                    }
                    result = moveMap.get(t).getBattleResult();
                    LogUtils.log(Level.FINEST, t.getName() + " TUVSwing=" + result.getTUVSwing() + ", Win%=" + result.getWinPercentage() + ", enemyAttackers=" + moveMap.get(t).getMaxEnemyUnits().size() + ", defenders=" + defendingUnits.size());
                    if (!(result.getWinPercentage() > 100.0 - WIN_PERCENTAGE) && !(result.getTUVSwing() > 0.0)) continue;
                    LogUtils.log(Level.FINEST, u3 + " added air to defend transport at " + t);
                    moveMap.get(t).addTempUnit(u3);
                    moveMap.get(t).setBattleResult(null);
                    territoriesToDefend.add(t);
                    it.remove();
                    continue block26;
                }
            }
            it = currentUnitMoveMap.keySet().iterator();
            while (it.hasNext()) {
                u3 = (Unit)it.next();
                if (!Matches.UnitIsSea.match(u3)) continue;
                Territory maxValueTerritory = null;
                double maxValue = 0.0;
                for (Territory t : (Set)currentUnitMoveMap.get(u3)) {
                    if (!moveMap.get(t).isCanHold()) continue;
                    int transports = Match.countMatches(moveMap.get(t).getAllDefenders(), ProMatches.unitIsOwnedTransport(this.player));
                    double value = (double)(1 + transports) * moveMap.get(t).getSeaValue() + (double)(1 + transports * 100) * moveMap.get(t).getValue() / 10000.0;
                    LogUtils.log(Level.FINEST, t + ", value=" + value + ", seaValue=" + moveMap.get(t).getSeaValue() + ", tValue=" + moveMap.get(t).getValue() + ", transports=" + transports);
                    if (!(value > maxValue)) continue;
                    maxValue = value;
                    maxValueTerritory = t;
                }
                if (maxValueTerritory != null) {
                    Territory unitTerritory;
                    Map<Unit, Collection<Unit>> carrierMustMoveWith;
                    LogUtils.log(Level.FINEST, u3 + " added to best territory " + maxValueTerritory + ", value=" + maxValue);
                    moveMap.get(maxValueTerritory).addTempUnit(u3);
                    moveMap.get(maxValueTerritory).setBattleResult(null);
                    territoriesToDefend.add(maxValueTerritory);
                    it.remove();
                    if (!Matches.UnitIsCarrier.match(u3) || !(carrierMustMoveWith = MoveValidator.carrierMustMoveWith((unitTerritory = this.unitTerritoryMap.get(u3)).getUnits().getUnits(), unitTerritory, this.data, this.player)).containsKey(u3)) continue;
                    moveMap.get(maxValueTerritory).getTempUnits().addAll(carrierMustMoveWith.get(u3));
                    continue;
                }
                ArrayList<Unit> alreadyMovedUnits = new ArrayList<Unit>();
                for (Territory t : moveMap.keySet()) {
                    alreadyMovedUnits.addAll(moveMap.get(t).getUnits());
                }
                double minStrengthDifference = Double.POSITIVE_INFINITY;
                Territory minTerritory3 = null;
                for (Territory t : (Set)currentUnitMoveMap.get(u3)) {
                    List<Unit> attackers = moveMap.get(t).getMaxEnemyUnits();
                    List<Unit> defenders = moveMap.get(t).getMaxDefenders();
                    defenders.removeAll(alreadyMovedUnits);
                    defenders.addAll(moveMap.get(t).getUnits());
                    double strengthDifference = this.battleUtils.estimateStrengthDifference(t, attackers, defenders);
                    if (!(strengthDifference < minStrengthDifference)) continue;
                    minStrengthDifference = strengthDifference;
                    minTerritory3 = t;
                }
                if (minTerritory3 != null) {
                    Territory unitTerritory;
                    Map<Unit, Collection<Unit>> carrierMustMoveWith;
                    LogUtils.log(Level.FINEST, u3 + " moved to safest territory at " + minTerritory3 + ", strengthDifference=" + minStrengthDifference);
                    moveMap.get(minTerritory3).addTempUnit(u3);
                    moveMap.get(minTerritory3).setBattleResult(null);
                    it.remove();
                    if (!Matches.UnitIsCarrier.match(u3) || !(carrierMustMoveWith = MoveValidator.carrierMustMoveWith((unitTerritory = this.unitTerritoryMap.get(u3)).getUnits().getUnits(), unitTerritory, this.data, this.player)).containsKey(u3)) continue;
                    moveMap.get(minTerritory3).getTempUnits().addAll(carrierMustMoveWith.get(u3));
                    continue;
                }
                Territory currentTerritory = this.unitTerritoryMap.get(u3);
                LogUtils.log(Level.FINEST, u3 + " added to current territory since no better options at " + currentTerritory);
                moveMap.get(currentTerritory).addTempUnit(u3);
                moveMap.get(currentTerritory).setBattleResult(null);
                it.remove();
            }
            LogUtils.log(Level.FINER, "Checking if all sea moves are safe for " + territoriesToDefend);
            areSuccessful = true;
            for (Territory t : territoriesToDefend) {
                List<Unit> defendingUnits2 = moveMap.get(t).getAllDefenders();
                moveMap.get(t).setBattleResult(this.battleUtils.calculateBattleResults(this.player, t, moveMap.get(t).getMaxEnemyUnits(), defendingUnits2, moveMap.get(t).getMaxEnemyBombardUnits(), false));
                ProBattleResultData result2 = moveMap.get(t).getBattleResult();
                int isWater = 0;
                if (t.isWater()) {
                    isWater = 1;
                }
                double extraUnitValue = BattleCalculator.getTUV(moveMap.get(t).getTempUnits(), this.playerCostMap);
                double holdValue = result2.getTUVSwing() - extraUnitValue / 8.0 * (double)(1 + isWater);
                ArrayList<Unit> minDefendingUnits = new ArrayList<Unit>(defendingUnits2);
                minDefendingUnits.removeAll(moveMap.get(t).getTempUnits());
                ProBattleResultData minResult = this.battleUtils.calculateBattleResults(this.player, t, moveMap.get(t).getMaxEnemyUnits(), minDefendingUnits, moveMap.get(t).getMaxEnemyBombardUnits(), false);
                if (holdValue > minResult.getTUVSwing()) {
                    areSuccessful = false;
                    moveMap.get(t).setCanHold(false);
                    moveMap.get(t).setValue(0.0);
                    moveMap.get(t).setSeaValue(0.0);
                    LogUtils.log(Level.FINEST, t + " unable to defend so removing with holdValue=" + holdValue + ", minTUVSwing=" + minResult.getTUVSwing() + ", defenders=" + defendingUnits2 + ", enemyAttackers=" + moveMap.get(t).getMaxEnemyUnits());
                }
                LogUtils.log(Level.FINEST, moveMap.get(t).getResultString() + ", holdValue=" + holdValue + ", minTUVSwing=" + minResult.getTUVSwing());
            }
        } while (!areSuccessful);
        for (Territory t : moveMap.keySet()) {
            Iterator<ProAmphibData> it;
            List<Unit> alliedUnits = Match.getMatches(moveMap.get(t).getTempUnits(), Matches.unitIsOwnedBy(this.player).invert());
            for (Unit alliedUnit : alliedUnits) {
                moveMap.get(t).addCantMoveUnit(alliedUnit);
                moveMap.get(t).getTempUnits().remove(alliedUnit);
            }
            moveMap.get(t).addUnits(moveMap.get(t).getTempUnits());
            moveMap.get(t).putAllAmphibAttackMap(moveMap.get(t).getTempAmphibAttackMap());
            for (Unit u6 : moveMap.get(t).getTempUnits()) {
                if (Matches.UnitIsTransport.match(u6)) {
                    transportMoveMap.remove(u6);
                    it = transportMapList.iterator();
                    while (it.hasNext()) {
                        if (!it.next().getTransport().equals(u6)) continue;
                        it.remove();
                    }
                    continue;
                }
                unitMoveMap.remove(u6);
            }
            for (Unit u7 : moveMap.get(t).getTempAmphibAttackMap().keySet()) {
                transportMoveMap.remove(u7);
                it = transportMapList.iterator();
                while (it.hasNext()) {
                    if (!it.next().getTransport().equals(u7)) continue;
                    it.remove();
                }
            }
            moveMap.get(t).getTempUnits().clear();
            moveMap.get(t).getTempAmphibAttackMap().clear();
        }
        LogUtils.log(Level.FINE, "Move land units");
        Iterator<Unit> it = unitMoveMap.keySet().iterator();
        while (it.hasNext()) {
            Unit u8 = it.next();
            if (!Matches.UnitIsLand.match(u8)) continue;
            Territory maxValueTerritory = null;
            double maxValue = 0.0;
            int maxNeedAmphibUnitValue = Integer.MIN_VALUE;
            for (Territory t : unitMoveMap.get(u8)) {
                if (!moveMap.get(t).isCanHold() || !(moveMap.get(t).getValue() >= maxValue)) continue;
                ArrayList<Unit> transports1 = new ArrayList<Unit>();
                Set<Territory> seaNeighbors = this.data.getMap().getNeighbors(t, ProMatches.territoryCanMoveSeaUnits(this.player, this.data, true));
                for (Territory neighborTerritory : seaNeighbors) {
                    if (!moveMap.containsKey(neighborTerritory)) continue;
                    transports1.addAll(Match.getMatches(moveMap.get(neighborTerritory).getAllDefenders(), ProMatches.unitIsOwnedTransport(this.player)));
                }
                int transportCapacity1 = 0;
                for (Unit transport : transports1) {
                    transportCapacity1 += UnitAttachment.get(transport.getType()).getTransportCapacity();
                }
                ArrayList<Unit> transports2 = new ArrayList<Unit>();
                Set<Territory> nearbySeaTerritories = this.data.getMap().getNeighbors(t, 2, ProMatches.territoryCanMoveSeaUnits(this.player, this.data, true));
                nearbySeaTerritories.removeAll(seaNeighbors);
                for (Territory neighborTerritory : nearbySeaTerritories) {
                    if (!moveMap.containsKey(neighborTerritory)) continue;
                    transports2.addAll(Match.getMatches(moveMap.get(neighborTerritory).getAllDefenders(), ProMatches.unitIsOwnedTransport(this.player)));
                }
                int transportCapacity2 = 0;
                for (Unit transport : transports2) {
                    transportCapacity2 += UnitAttachment.get(transport.getType()).getTransportCapacity();
                }
                List<Unit> unitsToTransport = Match.getMatches(moveMap.get(t).getAllDefenders(), ProMatches.unitIsOwnedTransportableUnit(this.player));
                int transportCost = 0;
                for (Unit unit : unitsToTransport) {
                    transportCost += UnitAttachment.get(unit.getType()).getTransportCost();
                }
                int hasFactory = 0;
                if (ProMatches.territoryHasInfraFactoryAndIsOwnedLandAdjacentToSea(this.player, this.data).match(t)) {
                    hasFactory = 1;
                }
                int neededNeighborTransportValue = Math.max(0, transportCapacity1 - transportCost);
                int neededNearbyTransportValue = Math.max(0, transportCapacity1 + transportCapacity2 - transportCost);
                int needAmphibUnitValue = 1000 * neededNeighborTransportValue + 100 * neededNearbyTransportValue + (1 + 10 * hasFactory) * this.data.getMap().getNeighbors(t, ProMatches.territoryCanMoveSeaUnits(this.player, this.data, true)).size();
                if (!(moveMap.get(t).getValue() > maxValue) && needAmphibUnitValue <= maxNeedAmphibUnitValue) continue;
                maxValue = moveMap.get(t).getValue();
                maxNeedAmphibUnitValue = needAmphibUnitValue;
                maxValueTerritory = t;
            }
            if (maxValueTerritory == null) continue;
            LogUtils.log(Level.FINEST, u8 + " moved to " + maxValueTerritory + " with value=" + maxValue + ", numNeededTransportUnits=" + maxNeedAmphibUnitValue);
            moveMap.get(maxValueTerritory).addUnit(u8);
            it.remove();
        }
        HashSet<Territory> myFactoriesAdjacentToSea = new HashSet<Territory>(Match.getMatches(this.allTerritories, ProMatches.territoryHasInfraFactoryAndIsOwnedLandAdjacentToSea(this.player, this.data)));
        Iterator<Unit> it2 = unitMoveMap.keySet().iterator();
        while (it2.hasNext()) {
            u2 = it2.next();
            if (!Matches.UnitIsLand.match(u2)) continue;
            int minDistance = Integer.MAX_VALUE;
            DefaultNamed minTerritory4 = null;
            for (Territory t : unitMoveMap.get(u2)) {
                if (!moveMap.get(t).isCanHold()) continue;
                for (Territory factory : myFactoriesAdjacentToSea) {
                    int distance = this.data.getMap().getDistance(t, factory, ProMatches.territoryCanMoveLandUnits(this.player, this.data, true));
                    if (distance < 0) {
                        distance = 10 * this.data.getMap().getDistance(t, factory);
                    }
                    if (distance < 0 || distance >= minDistance) continue;
                    minDistance = distance;
                    minTerritory4 = t;
                }
            }
            if (minTerritory4 == null) continue;
            LogUtils.log(Level.FINEST, u2.getType().getName() + " moved towards closest factory adjacent to sea at " + minTerritory4.getName());
            moveMap.get(minTerritory4).addUnit(u2);
            it2.remove();
        }
        LogUtils.log(Level.FINE, "Move land units to safest territory");
        it2 = unitMoveMap.keySet().iterator();
        while (it2.hasNext()) {
            u2 = it2.next();
            if (!Matches.UnitIsLand.match(u2)) continue;
            ArrayList<Unit> alreadyMovedUnits = new ArrayList<Unit>();
            for (Territory t : moveMap.keySet()) {
                alreadyMovedUnits.addAll(moveMap.get(t).getUnits());
            }
            double minStrengthDifference = Double.POSITIVE_INFINITY;
            minTerritory = null;
            for (Territory t : unitMoveMap.get(u2)) {
                List<Unit> attackers = moveMap.get(t).getMaxEnemyUnits();
                List<Unit> defenders = moveMap.get(t).getMaxDefenders();
                defenders.removeAll(alreadyMovedUnits);
                defenders.addAll(moveMap.get(t).getUnits());
                double strengthDifference = this.battleUtils.estimateStrengthDifference(t, attackers, defenders);
                if (!(strengthDifference < minStrengthDifference)) continue;
                minStrengthDifference = strengthDifference;
                minTerritory = t;
            }
            if (minTerritory == null) continue;
            LogUtils.log(Level.FINER, u2.getType().getName() + " moved to safest territory at " + minTerritory.getName() + " with strengthDifference=" + minStrengthDifference);
            moveMap.get(minTerritory).addUnit(u2);
            it2.remove();
        }
        LogUtils.log(Level.FINE, "Move air units");
        ArrayList<Territory> territoriesThatCantBeHeld = new ArrayList<Territory>();
        for (Territory t : moveMap.keySet()) {
            if (moveMap.get(t).isCanHold()) continue;
            territoriesThatCantBeHeld.add(t);
        }
        Iterator<Unit> it3 = unitMoveMap.keySet().iterator();
        while (it3.hasNext()) {
            u = it3.next();
            if (Matches.UnitIsNotAir.match(u)) continue;
            double maxAirValue = 0.0;
            Territory maxTerritory = null;
            for (Territory t : unitMoveMap.get(u)) {
                int hasOwnedCarrier;
                int isntFactory;
                Set<Territory> possibleMoveTerritories;
                int numNearbyEnemyTerritories;
                if (!moveMap.get(t).isCanHold()) continue;
                if (t.isWater() && !this.transportUtils.validateCarrierCapacity(this.player, t, moveMap.get(t).getAllDefendersForCarrierCalcs(this.data, this.player), u)) {
                    LogUtils.log(Level.FINEST, t + " already at MAX carrier capacity");
                    continue;
                }
                List<Unit> defendingUnits = moveMap.get(t).getAllDefenders();
                defendingUnits.add(u);
                if (moveMap.get(t).getBattleResult() == null) {
                    moveMap.get(t).setBattleResult(this.battleUtils.calculateBattleResults(this.player, t, moveMap.get(t).getMaxEnemyUnits(), defendingUnits, moveMap.get(t).getMaxEnemyBombardUnits(), false));
                }
                ProBattleResultData result = moveMap.get(t).getBattleResult();
                LogUtils.log(Level.FINEST, t + ", TUVSwing=" + result.getTUVSwing() + ", win%=" + result.getWinPercentage() + ", defendingUnits=" + defendingUnits + ", enemyAttackers=" + moveMap.get(t).getMaxEnemyUnits());
                if (result.getWinPercentage() >= MIN_WIN_PERCENTAGE || result.getTUVSwing() > 0.0) {
                    moveMap.get(t).setCanHold(false);
                    continue;
                }
                List<Unit> myDefenders = Match.getMatches(defendingUnits, Matches.unitIsOwnedBy(this.player));
                ProBattleResultData result2 = this.battleUtils.calculateBattleResults(this.player, t, moveMap.get(t).getMaxEnemyUnits(), myDefenders, moveMap.get(t).getMaxEnemyBombardUnits(), false);
                int cantHoldWithoutAllies = 0;
                if (result2.getWinPercentage() >= MIN_WIN_PERCENTAGE || result2.getTUVSwing() > 0.0) {
                    cantHoldWithoutAllies = 1;
                }
                int range = TripleAUnit.get(u).getMaxMovementAllowed();
                Set<Territory> possibleAttackTerritories = this.data.getMap().getNeighbors(t, range / 2, ProMatches.territoryCanMoveAirUnits(this.player, this.data, true));
                int numEnemyAttackTerritories = Match.countMatches(possibleAttackTerritories, ProMatches.territoryIsEnemyNotNeutralLand(this.player, this.data));
                int numLandAttackTerritories = Match.countMatches(possibleAttackTerritories, ProMatches.territoryIsEnemyOrCantBeHeldAndIsAdjacentToMyLandUnits(this.player, this.data, territoriesThatCantBeHeld));
                int numSeaAttackTerritories = Match.countMatches(possibleAttackTerritories, Matches.territoryHasEnemySeaUnits(this.player, this.data));
                double airValue = (200.0 * (double)numSeaAttackTerritories + (double)(100 * numLandAttackTerritories) + (double)(10 * numEnemyAttackTerritories) + (double)(numNearbyEnemyTerritories = Match.countMatches(possibleMoveTerritories = this.data.getMap().getNeighbors(t, range, ProMatches.territoryCanMoveAirUnits(this.player, this.data, true)), ProMatches.territoryIsEnemyNotNeutralLand(this.player, this.data)))) / (double)(1 + cantHoldWithoutAllies) / (double)(1 + cantHoldWithoutAllies * (isntFactory = ProMatches.territoryHasInfraFactoryAndIsLand(this.player).match(t) ? 0 : 1)) * (double)(1 + (hasOwnedCarrier = Match.someMatch(moveMap.get(t).getAllDefenders(), ProMatches.UnitIsOwnedCarrier(this.player)) ? 1 : 0));
                if (airValue > maxAirValue) {
                    maxAirValue = airValue;
                    maxTerritory = t;
                }
                LogUtils.log(Level.FINEST, "Safe territory: " + t + ", airValue=" + airValue + ", numLandAttackOptions=" + numLandAttackTerritories + ", numSeaAttackTerritories=" + numSeaAttackTerritories + ", numEnemyAttackTerritories=" + numEnemyAttackTerritories);
            }
            if (maxTerritory == null) continue;
            LogUtils.log(Level.FINER, u.getType().getName() + " added to safe territory with most attack options " + maxTerritory + ", maxAirValue=" + maxAirValue);
            moveMap.get(maxTerritory).addUnit(u);
            moveMap.get(maxTerritory).setBattleResult(null);
            it3.remove();
        }
        it3 = unitMoveMap.keySet().iterator();
        while (it3.hasNext()) {
            u = it3.next();
            if (Matches.UnitIsNotAir.match(u)) continue;
            double minStrengthDifference = Double.POSITIVE_INFINITY;
            minTerritory = null;
            for (Territory t : unitMoveMap.get(u)) {
                if (t.isWater() && !this.transportUtils.validateCarrierCapacity(this.player, t, moveMap.get(t).getAllDefendersForCarrierCalcs(this.data, this.player), u)) {
                    LogUtils.log(Level.FINEST, t + " already at MAX carrier capacity");
                    continue;
                }
                List<Unit> attackers = moveMap.get(t).getMaxEnemyUnits();
                List<Unit> defenders = moveMap.get(t).getAllDefenders();
                defenders.add(u);
                double strengthDifference = this.battleUtils.estimateStrengthDifference(t, attackers, defenders);
                LogUtils.log(Level.FINEST, "Unsafe territory: " + t + " with strengthDifference=" + strengthDifference);
                if (!(strengthDifference < minStrengthDifference)) continue;
                minStrengthDifference = strengthDifference;
                minTerritory = t;
            }
            if (minTerritory == null) continue;
            LogUtils.log(Level.FINER, u.getType().getName() + " added to safest territory at " + minTerritory + " with strengthDifference=" + minStrengthDifference);
            moveMap.get(minTerritory).addUnit(u);
            it3.remove();
        }
    }

    private Map<Territory, ProAttackTerritoryData> moveInfraUnits(Map<Territory, ProAttackTerritoryData> factoryMoveMap, Map<Territory, ProAttackTerritoryData> moveMap, Map<Unit, Set<Territory>> infraUnitMoveMap) {
        Unit u;
        Iterator<Unit> it;
        LogUtils.log(Level.FINE, "Determine where to move infra units");
        if (factoryMoveMap == null) {
            LogUtils.log(Level.FINER, "Creating factory move map");
            factoryMoveMap = new HashMap<Territory, ProAttackTerritoryData>();
            it = infraUnitMoveMap.keySet().iterator();
            while (it.hasNext()) {
                u = it.next();
                if (!Matches.UnitCanProduceUnits.match(u)) continue;
                DefaultNamed maxValueTerritory = null;
                double maxValue = 0.0;
                for (Territory t : infraUnitMoveMap.get(u)) {
                    if (!moveMap.get(t).isCanHold()) continue;
                    ArrayList<Unit> units = new ArrayList<Unit>(moveMap.get(t).getCantMoveUnits());
                    units.addAll(moveMap.get(t).getUnits());
                    int production = TerritoryAttachment.get(t).getProduction();
                    double value = 0.1 * moveMap.get(t).getValue();
                    if (ProMatches.territoryIsNotConqueredOwnedLand(this.player, this.data).match(t) && Match.noneMatch(units, Matches.UnitCanProduceUnitsAndIsInfrastructure)) {
                        value = moveMap.get(t).getValue() * (double)production + 0.01 * (double)production;
                    }
                    LogUtils.log(Level.FINEST, t.getName() + " has value=" + value + ", strategicValue=" + moveMap.get(t).getValue() + ", production=" + production);
                    if (!(value > maxValue)) continue;
                    maxValue = value;
                    maxValueTerritory = t;
                }
                if (maxValueTerritory == null) continue;
                LogUtils.log(Level.FINER, u.getType().getName() + " moved to " + maxValueTerritory.getName() + " with value=" + maxValue);
                moveMap.get(maxValueTerritory).addUnit(u);
                if (factoryMoveMap.containsKey(maxValueTerritory)) {
                    factoryMoveMap.get(maxValueTerritory).addUnit(u);
                } else {
                    ProAttackTerritoryData patd = new ProAttackTerritoryData((Territory)maxValueTerritory);
                    patd.addUnit(u);
                    factoryMoveMap.put((Territory)maxValueTerritory, patd);
                }
                it.remove();
            }
        } else {
            LogUtils.log(Level.FINER, "Using stored factory move map");
            for (Territory t : factoryMoveMap.keySet()) {
                moveMap.get(t).addUnits(factoryMoveMap.get(t).getUnits());
            }
        }
        LogUtils.log(Level.FINER, "Move infra AA units");
        it = infraUnitMoveMap.keySet().iterator();
        while (it.hasNext()) {
            u = it.next();
            Territory currentTerritory = this.unitTerritoryMap.get(u);
            if (!Matches.UnitIsAAforAnything.match(u) || moveMap.get(currentTerritory).isCanHold() || ProMatches.territoryHasInfraFactoryAndIsLand(this.player).match(currentTerritory)) continue;
            DefaultNamed maxValueTerritory = null;
            double maxValue = 0.0;
            for (Territory t : infraUnitMoveMap.get(u)) {
                if (!moveMap.get(t).isCanHold()) continue;
                Route r = this.data.getMap().getRoute_IgnoreEnd(currentTerritory, t, ProMatches.territoryCanMoveLandUnitsThrough(this.player, this.data, u, currentTerritory, false, new ArrayList<Territory>()));
                MoveValidationResult mvr = MoveValidator.validateMove(Collections.singletonList(u), r, this.player, new ArrayList<Unit>(), new HashMap<Unit, Collection<Unit>>(), true, null, this.data);
                if (!mvr.isMoveValid()) continue;
                ArrayList<Unit> units = new ArrayList<Unit>(moveMap.get(t).getCantMoveUnits());
                units.addAll(moveMap.get(t).getUnits());
                boolean hasAA = Match.someMatch(units, Matches.UnitIsAAforAnything);
                double value = moveMap.get(t).getValue();
                if (hasAA) {
                    value *= 0.01;
                }
                LogUtils.log(Level.FINEST, t.getName() + " has value=" + value);
                if (!(value > maxValue)) continue;
                maxValue = value;
                maxValueTerritory = t;
            }
            if (maxValueTerritory == null) continue;
            LogUtils.log(Level.FINER, u.getType().getName() + " moved to " + maxValueTerritory.getName() + " with value=" + maxValue);
            moveMap.get(maxValueTerritory).addUnit(u);
            it.remove();
        }
        return factoryMoveMap;
    }

    private void logAttackMoves(Map<Territory, ProAttackTerritoryData> moveMap, Map<Unit, Set<Territory>> unitAttackMap, List<ProAmphibData> transportMapList, List<ProAttackTerritoryData> prioritizedTerritories, Map<Territory, ProAttackTerritoryData> enemyAttackMap) {
        LogUtils.log(Level.FINER, "Prioritized territories:");
        for (ProAttackTerritoryData attackTerritoryData : prioritizedTerritories) {
            LogUtils.log(Level.FINEST, "  " + attackTerritoryData.getValue() + "  " + attackTerritoryData.getTerritory().getName());
        }
        LogUtils.log(Level.FINER, "Territories that can be attacked:");
        int count = 0;
        for (Territory t : moveMap.keySet()) {
            LogUtils.log(Level.FINEST, ++count + ". ---" + t.getName());
            HashSet<Unit> combinedUnits = new HashSet<Unit>(moveMap.get(t).getMaxUnits());
            combinedUnits.addAll(moveMap.get(t).getMaxAmphibUnits());
            combinedUnits.addAll(moveMap.get(t).getCantMoveUnits());
            LogUtils.log(Level.FINEST, "  --- My max units ---");
            HashMap<String, Integer> printMap = new HashMap<String, Integer>();
            for (Unit unit : combinedUnits) {
                if (printMap.containsKey(unit.toStringNoOwner())) {
                    printMap.put(unit.toStringNoOwner(), (Integer)printMap.get(unit.toStringNoOwner()) + 1);
                    continue;
                }
                printMap.put(unit.toStringNoOwner(), 1);
            }
            for (String key : printMap.keySet()) {
                LogUtils.log(Level.FINEST, "    " + printMap.get(key) + " " + key);
            }
            LogUtils.log(Level.FINEST, "  --- My max amphib units ---");
            HashMap<String, Integer> printMap5 = new HashMap<String, Integer>();
            for (Unit unit : moveMap.get(t).getMaxAmphibUnits()) {
                if (printMap5.containsKey(unit.toStringNoOwner())) {
                    printMap5.put(unit.toStringNoOwner(), (Integer)printMap5.get(unit.toStringNoOwner()) + 1);
                    continue;
                }
                printMap5.put(unit.toStringNoOwner(), 1);
            }
            for (String key : printMap5.keySet()) {
                LogUtils.log(Level.FINEST, "    " + printMap5.get(key) + " " + key);
            }
            List<Unit> units3 = moveMap.get(t).getUnits();
            LogUtils.log(Level.FINEST, "  --- My actual units ---");
            HashMap<String, Integer> printMap3 = new HashMap<String, Integer>();
            for (Unit unit : units3) {
                if (printMap3.containsKey(unit.toStringNoOwner())) {
                    printMap3.put(unit.toStringNoOwner(), (Integer)printMap3.get(unit.toStringNoOwner()) + 1);
                    continue;
                }
                printMap3.put(unit.toStringNoOwner(), 1);
            }
            for (String key : printMap3.keySet()) {
                LogUtils.log(Level.FINEST, "    " + printMap3.get(key) + " " + key);
            }
            LogUtils.log(Level.FINEST, "  --- Enemy units ---");
            HashMap<String, Integer> printMap2 = new HashMap<String, Integer>();
            List<Unit> units2 = moveMap.get(t).getMaxEnemyUnits();
            for (Unit unit : units2) {
                if (printMap2.containsKey(unit.toStringNoOwner())) {
                    printMap2.put(unit.toStringNoOwner(), (Integer)printMap2.get(unit.toStringNoOwner()) + 1);
                    continue;
                }
                printMap2.put(unit.toStringNoOwner(), 1);
            }
            for (String key : printMap2.keySet()) {
                LogUtils.log(Level.FINEST, "    " + printMap2.get(key) + " " + key);
            }
            LogUtils.log(Level.FINEST, "  --- Enemy bombard units ---");
            HashMap<String, Integer> printMap4 = new HashMap<String, Integer>();
            Set<Unit> units4 = moveMap.get(t).getMaxEnemyBombardUnits();
            for (Unit unit : units4) {
                if (printMap4.containsKey(unit.toStringNoOwner())) {
                    printMap4.put(unit.toStringNoOwner(), (Integer)printMap4.get(unit.toStringNoOwner()) + 1);
                    continue;
                }
                printMap4.put(unit.toStringNoOwner(), 1);
            }
            for (String key : printMap4.keySet()) {
                LogUtils.log(Level.FINEST, "    " + printMap4.get(key) + " " + key);
            }
        }
    }

    private Map<Unit, Territory> createUnitTerritoryMap(PlayerID player) {
        List<Territory> allTerritories = this.data.getMap().getTerritories();
        List<Territory> myUnitTerritories = Match.getMatches(allTerritories, Matches.territoryHasUnitsOwnedBy(player));
        HashMap<Unit, Territory> unitTerritoryMap = new HashMap<Unit, Territory>();
        for (Territory t : myUnitTerritories) {
            List<Unit> myUnits = t.getUnits().getMatches(Matches.unitIsOwnedBy(player));
            for (Unit u : myUnits) {
                unitTerritoryMap.put(u, t);
            }
        }
        return unitTerritoryMap;
    }
}

