/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.proAI;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.RelationshipType;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.ai.BasicPoliticalAI;
import games.strategy.triplea.ai.proAI.ProAI;
import games.strategy.triplea.ai.proAI.ProAmphibData;
import games.strategy.triplea.ai.proAI.ProAttackTerritoryData;
import games.strategy.triplea.ai.proAI.util.LogUtils;
import games.strategy.triplea.ai.proAI.util.ProAttackOptionsUtils;
import games.strategy.triplea.ai.proAI.util.ProUtils;
import games.strategy.triplea.attatchments.PoliticalActionAttachment;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.PoliticsDelegate;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class ProPoliticsAI {
    private final ProAI ai;
    private final ProUtils utils;
    private final ProAttackOptionsUtils attackOptionsUtils;

    public ProPoliticsAI(ProAI ai, ProUtils utils, ProAttackOptionsUtils attackOptionsUtils) {
        this.ai = ai;
        this.utils = utils;
        this.attackOptionsUtils = attackOptionsUtils;
    }

    public List<PoliticalActionAttachment> politicalActions() {
        List<PoliticalActionAttachment> actionChoicesOther;
        GameData data = this.ai.getGameData();
        PlayerID player = this.ai.getPlayerID();
        float numPlayers = data.getPlayerList().getPlayers().size();
        double round = data.getSequence().getRound();
        PoliticsDelegate politicsDelegate = DelegateFinder.politicsDelegate(data);
        ArrayList<PoliticalActionAttachment> results = new ArrayList<PoliticalActionAttachment>();
        LogUtils.log(Level.FINE, "Politics for " + player.getName());
        List<PoliticalActionAttachment> actionChoicesTowardsWar = BasicPoliticalAI.getPoliticalActionsTowardsWar(player, politicsDelegate.getTestedConditions(), data);
        LogUtils.log(Level.FINEST, "War options: " + actionChoicesTowardsWar);
        List<PoliticalActionAttachment> validWarActions = Match.getMatches(actionChoicesTowardsWar, new CompositeMatchAnd(Matches.AbstractUserActionAttachmentCanBeAttempted(politicsDelegate.getTestedConditions())));
        LogUtils.log(Level.FINEST, "Valid War options: " + validWarActions);
        HashMap enemyMap = new HashMap();
        HashMap neutralMap = new HashMap();
        for (PoliticalActionAttachment action : validWarActions) {
            ArrayList<PlayerID> warPlayers = new ArrayList<PlayerID>();
            for (String relationshipChange : action.getRelationshipChange()) {
                RelationshipType newRelation;
                String[] s = relationshipChange.split(":");
                PlayerID player1 = data.getPlayerList().getPlayerID(s[0]);
                PlayerID player2 = data.getPlayerList().getPlayerID(s[1]);
                RelationshipType oldRelation = data.getRelationshipTracker().getRelationshipType(player1, player2);
                if (oldRelation.equals(newRelation = data.getRelationshipTypeList().getRelationshipType(s[2])) || !Matches.RelationshipTypeIsAtWar.match(newRelation) || !player1.equals(player) && !player2.equals(player)) continue;
                PlayerID warPlayer = player2;
                if (warPlayer.equals(player)) {
                    warPlayer = player1;
                }
                warPlayers.add(warPlayer);
            }
            if (warPlayers.isEmpty()) continue;
            if (this.utils.isNeutralPlayer((PlayerID)warPlayers.get(0))) {
                neutralMap.put(action, warPlayers);
                continue;
            }
            enemyMap.put(action, warPlayers);
        }
        LogUtils.log(Level.FINER, "Neutral options: " + neutralMap);
        LogUtils.log(Level.FINER, "Enemy options: " + enemyMap);
        if (!enemyMap.isEmpty()) {
            HashMap<Territory, ProAttackTerritoryData> attackMap = new HashMap<Territory, ProAttackTerritoryData>();
            HashMap<Unit, Set<Territory>> unitAttackMap = new HashMap<Unit, Set<Territory>>();
            HashMap<Unit, Set<Territory>> transportAttackMap = new HashMap<Unit, Set<Territory>>();
            HashMap<Unit, Set<Territory>> bombardMap = new HashMap<Unit, Set<Territory>>();
            ArrayList<ProAmphibData> transportMapList = new ArrayList<ProAmphibData>();
            HashMap<Territory, Set<Territory>> landRoutesMap = new HashMap<Territory, Set<Territory>>();
            List<Territory> myUnitTerritories = Match.getMatches(data.getMap().getTerritories(), Matches.territoryHasUnitsOwnedBy(player));
            this.attackOptionsUtils.findPotentialAttackOptions(player, myUnitTerritories, attackMap, unitAttackMap, transportAttackMap, bombardMap, landRoutesMap, transportMapList);
            List<ProAttackTerritoryData> prioritizedTerritories = this.attackOptionsUtils.removeTerritoriesThatCantBeConquered(player, attackMap, unitAttackMap, transportAttackMap, true);
            LogUtils.log(Level.FINEST, player.getName() + ", numAttackOptions=" + prioritizedTerritories.size() + ", options=" + prioritizedTerritories);
            HashMap<PoliticalActionAttachment, Double> attackPercentageMap = new HashMap<PoliticalActionAttachment, Double>();
            for (PoliticalActionAttachment action : enemyMap.keySet()) {
                int count = 0;
                List enemyPlayers = (List)enemyMap.get(action);
                for (ProAttackTerritoryData patd : prioritizedTerritories) {
                    if (!Matches.isTerritoryOwnedBy(enemyPlayers).match(patd.getTerritory()) && !Matches.territoryHasUnitsThatMatch(Matches.unitOwnedBy(enemyPlayers)).match(patd.getTerritory())) continue;
                    ++count;
                }
                double attackPercentage = (double)count / ((double)prioritizedTerritories.size() + 1.0);
                attackPercentageMap.put(action, attackPercentage);
                LogUtils.log(Level.FINEST, enemyPlayers + ", count=" + count + ", attackPercentage=" + attackPercentage);
            }
            ArrayList options = new ArrayList(attackPercentageMap.keySet());
            Collections.shuffle(options);
            for (PoliticalActionAttachment action : options) {
                double roundFactor = (round - 1.0) * 0.05;
                double warChance = roundFactor + (Double)attackPercentageMap.get(action) * (1.0 + 10.0 * roundFactor);
                double random = Math.random();
                LogUtils.log(Level.FINEST, enemyMap.get(action) + ", warChance=" + warChance + ", random=" + random);
                if (!(random <= warChance)) continue;
                results.add(action);
                LogUtils.log(Level.FINER, "---Declared war on " + enemyMap.get(action));
                break;
            }
        } else if (!neutralMap.isEmpty()) {
            ArrayList options = new ArrayList(neutralMap.keySet());
            Collections.shuffle(options);
            double random = Math.random();
            double warChance = 0.01;
            LogUtils.log(Level.FINER, "warChance=0.01, random=" + random);
            if (random <= 0.01) {
                results.add((PoliticalActionAttachment)options.get(0));
                LogUtils.log(Level.FINER, "Declared war on " + enemyMap.get(options.get(0)));
            }
        }
        if (Math.random() < 0.5 && (actionChoicesOther = BasicPoliticalAI.getPoliticalActionsOther(player, politicsDelegate.getTestedConditions(), data)) != null && !actionChoicesOther.isEmpty()) {
            Collections.shuffle(actionChoicesOther);
            int i = 0;
            double random = Math.random();
            int MAX_OTHER_ACTIONS_PER_TURN = random < 0.3 ? 0 : (random < 0.6 ? 1 : (random < 0.9 ? 2 : (random < 0.99 ? 3 : (int)numPlayers)));
            Iterator<PoliticalActionAttachment> actionOtherIter = actionChoicesOther.iterator();
            while (actionOtherIter.hasNext() && MAX_OTHER_ACTIONS_PER_TURN > 0) {
                PoliticalActionAttachment action = actionOtherIter.next();
                if (!Matches.AbstractUserActionAttachmentCanBeAttempted(politicsDelegate.getTestedConditions()).match(action) || action.getCostPU() > 0 && action.getCostPU() > player.getResources().getQuantity("PUs")) continue;
                if (++i > MAX_OTHER_ACTIONS_PER_TURN) break;
                results.add(action);
            }
        }
        this.doActions(results);
        return results;
    }

    public void doActions(List<PoliticalActionAttachment> actions) {
        GameData data = this.ai.getGameData();
        PoliticsDelegate politicsDelegate = DelegateFinder.politicsDelegate(data);
        for (PoliticalActionAttachment action : actions) {
            LogUtils.log(Level.FINER, "Performing action: " + action);
            politicsDelegate.attemptAction(action);
        }
    }
}

