/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.proAI;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.NamedAttachable;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.RepairRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.ai.proAI.ProAI;
import games.strategy.triplea.ai.proAI.ProAttackTerritoryData;
import games.strategy.triplea.ai.proAI.ProBattleResultData;
import games.strategy.triplea.ai.proAI.ProPlaceTerritory;
import games.strategy.triplea.ai.proAI.ProPurchaseOption;
import games.strategy.triplea.ai.proAI.ProPurchaseOptionMap;
import games.strategy.triplea.ai.proAI.ProPurchaseTerritory;
import games.strategy.triplea.ai.proAI.util.LogUtils;
import games.strategy.triplea.ai.proAI.util.ProAttackOptionsUtils;
import games.strategy.triplea.ai.proAI.util.ProBattleUtils;
import games.strategy.triplea.ai.proAI.util.ProMatches;
import games.strategy.triplea.ai.proAI.util.ProMetricUtils;
import games.strategy.triplea.ai.proAI.util.ProMoveUtils;
import games.strategy.triplea.ai.proAI.util.ProPurchaseUtils;
import games.strategy.triplea.ai.proAI.util.ProTerritoryValueUtils;
import games.strategy.triplea.ai.proAI.util.ProTransportUtils;
import games.strategy.triplea.ai.proAI.util.ProUtils;
import games.strategy.triplea.ai.strongAI.SUtils;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.BattleDelegate;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveValidator;
import games.strategy.triplea.delegate.dataObjects.PlaceableUnits;
import games.strategy.triplea.delegate.remote.IAbstractPlaceDelegate;
import games.strategy.triplea.delegate.remote.IPurchaseDelegate;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class ProPurchaseAI {
    public static final double WIN_PERCENTAGE = 95.0;
    private final ProAI ai;
    private final ProUtils utils;
    private final ProBattleUtils battleUtils;
    private final ProTransportUtils transportUtils;
    private final ProAttackOptionsUtils attackOptionsUtils;
    private final ProMoveUtils moveUtils;
    private final ProTerritoryValueUtils territoryValueUtils;
    private final ProPurchaseUtils purchaseUtils;
    private GameData data;
    private GameData startOfTurnData;
    private PlayerID player;
    private Territory myCapital;
    private double minCostPerHitPoint;
    private List<Territory> allTerritories;
    private Map<Unit, Territory> unitTerritoryMap;

    public ProPurchaseAI(ProAI ai, ProUtils utils, ProBattleUtils battleUtils, ProTransportUtils transportUtils, ProAttackOptionsUtils attackOptionsUtils, ProMoveUtils moveUtils, ProTerritoryValueUtils territoryValueUtils, ProPurchaseUtils purchaseUtils) {
        this.ai = ai;
        this.utils = utils;
        this.battleUtils = battleUtils;
        this.transportUtils = transportUtils;
        this.attackOptionsUtils = attackOptionsUtils;
        this.moveUtils = moveUtils;
        this.territoryValueUtils = territoryValueUtils;
        this.purchaseUtils = purchaseUtils;
    }

    public void bid(int PUsToSpend, IPurchaseDelegate purchaseDelegate, GameData data, PlayerID player) {
        int cost;
        boolean buyAttack;
        int buyLimit;
        UnitType x;
        NamedAttachable resourceOrUnit;
        LogUtils.log(Level.FINE, "Starting bid purchase phase");
        this.data = data;
        this.player = player;
        this.myCapital = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        this.allTerritories = data.getMap().getTerritories();
        if (PUsToSpend == 0 && player.getResources().getQuantity(data.getResourceList().getResource("PUs")) == 0) {
            return;
        }
        int highPrice = 0;
        List<ProductionRule> rules = player.getProductionFrontier().getRules();
        IntegerMap<ProductionRule> purchase = new IntegerMap<ProductionRule>();
        ArrayList<ProductionRule> landProductionRules = new ArrayList<ProductionRule>();
        ArrayList<ProductionRule> airProductionRules = new ArrayList<ProductionRule>();
        ArrayList<ProductionRule> seaProductionRules = new ArrayList<ProductionRule>();
        ArrayList<ProductionRule> transportProductionRules = new ArrayList<ProductionRule>();
        ArrayList<ProductionRule> subProductionRules = new ArrayList<ProductionRule>();
        IntegerMap<ProductionRule> bestAttack = new IntegerMap<ProductionRule>();
        IntegerMap<ProductionRule> bestDefense = new IntegerMap<ProductionRule>();
        IntegerMap<ProductionRule> bestTransport = new IntegerMap<ProductionRule>();
        IntegerMap<ProductionRule> bestMaxUnits = new IntegerMap<ProductionRule>();
        IntegerMap<ProductionRule> bestMobileAttack = new IntegerMap<ProductionRule>();
        ProductionRule carrierRule = null;
        ProductionRule fighterRule = null;
        int carrierFighterLimit = 0;
        int maxFighterAttack = 0;
        float averageSeaMove = 0.0f;
        Resource pus = data.getResourceList().getResource("PUs");
        boolean isAmphib = this.isAmphibAttack(player, true);
        for (ProductionRule ruleCheck : rules) {
            int thisFighterAttack;
            int thisFighterLimit;
            int costCheck = ruleCheck.getCosts().getInt(pus);
            resourceOrUnit = ruleCheck.getResults().keySet().iterator().next();
            if (!(resourceOrUnit instanceof UnitType) || UnitAttachment.get(x = (UnitType)resourceOrUnit).getMovement(player) < 1 && !UnitAttachment.get(x).getCanProduceUnits() || !(UnitAttachment.get(x).getAttack(player) - UnitAttachment.get(x).getDefense(player) < 3 && UnitAttachment.get(x).getDefense(player) - UnitAttachment.get(x).getAttack(player) < 3 && UnitAttachment.get(x).getDefense(player) >= 1 || UnitAttachment.get(x).getCanProduceUnits() || UnitAttachment.get(x).getTransportCapacity() > 0 && Matches.UnitTypeIsSea.match(x)) && (Matches.UnitTypeIsAir.match(x) && !airProductionRules.isEmpty() || Matches.UnitTypeIsSea.match(x) && !seaProductionRules.isEmpty() || !Matches.UnitTypeCanProduceUnits.match(x) && !landProductionRules.isEmpty() && !Matches.UnitTypeIsAir.match(x) && !Matches.UnitTypeIsSea.match(x)) || Matches.UnitTypeHasMaxBuildRestrictions.match(x) || Matches.UnitTypeConsumesUnitsOnCreation.match(x)) continue;
            if (Matches.UnitTypeIsAir.match(x)) {
                airProductionRules.add(ruleCheck);
            } else if (Matches.UnitTypeIsSea.match(x)) {
                seaProductionRules.add(ruleCheck);
                averageSeaMove += (float)UnitAttachment.get(x).getMovement(player);
            } else if (!Matches.UnitTypeCanProduceUnits.match(x)) {
                if (costCheck > highPrice) {
                    highPrice = costCheck;
                }
                landProductionRules.add(ruleCheck);
            }
            if (Matches.UnitTypeCanTransport.match(x) && Matches.UnitTypeIsSea.match(x) && UnitAttachment.get(x).getTransportCapacity() > 1) {
                transportProductionRules.add(ruleCheck);
            }
            if (Matches.UnitTypeIsSub.match(x)) {
                subProductionRules.add(ruleCheck);
            }
            if (Matches.UnitTypeIsCarrier.match(x) && (thisFighterLimit = UnitAttachment.get(x).getCarrierCapacity()) >= carrierFighterLimit) {
                carrierRule = ruleCheck;
                carrierFighterLimit = thisFighterLimit;
            }
            if (!Matches.UnitTypeCanLandOnCarrier.match(x) || (thisFighterAttack = UnitAttachment.get(x).getAttack(player)) <= maxFighterAttack) continue;
            fighterRule = ruleCheck;
            maxFighterAttack = thisFighterAttack;
        }
        if ((double)(averageSeaMove / (float)seaProductionRules.size()) >= 1.8) {
            ArrayList seaProductionRulesCopy = new ArrayList(seaProductionRules);
            for (ProductionRule seaRule : seaProductionRulesCopy) {
                resourceOrUnit = seaRule.getResults().keySet().iterator().next();
                if (!(resourceOrUnit instanceof UnitType) || UnitAttachment.get(x = (UnitType)resourceOrUnit).getMovement(player) >= 2) continue;
                seaProductionRules.remove(seaRule);
            }
        }
        if (subProductionRules.size() > 0 && seaProductionRules.size() > 0 && (double)(subProductionRules.size() / seaProductionRules.size()) < 0.3) {
            seaProductionRules.removeAll(subProductionRules);
        }
        if ((buyLimit = PUsToSpend / 3) == 0) {
            buyLimit = 1;
        }
        boolean landPurchase = true;
        boolean goTransports = false;
        List<Territory> enemyTerritoryBorderingOurTerrs = SUtils.getNeighboringEnemyLandTerritories(data, player);
        if (enemyTerritoryBorderingOurTerrs.isEmpty()) {
            landPurchase = false;
        }
        if (Math.random() > 0.25) {
            seaProductionRules.removeAll(subProductionRules);
        }
        if (PUsToSpend < 25) {
            if ((!isAmphib || Math.random() < 0.15) && landPurchase) {
                SUtils.findPurchaseMix(bestAttack, bestDefense, bestTransport, bestMaxUnits, bestMobileAttack, landProductionRules, PUsToSpend, buyLimit, data, player, 2);
            } else {
                landPurchase = false;
                buyLimit = PUsToSpend / 5;
                if (Math.random() > 0.4) {
                    SUtils.findPurchaseMix(bestAttack, bestDefense, bestTransport, bestMaxUnits, bestMobileAttack, seaProductionRules, PUsToSpend, buyLimit, data, player, 2);
                } else {
                    goTransports = true;
                }
            }
        } else if ((!isAmphib || Math.random() < 0.15) && landPurchase) {
            if (Math.random() > 0.8) {
                SUtils.findPurchaseMix(bestAttack, bestDefense, bestTransport, bestMaxUnits, bestMobileAttack, landProductionRules, PUsToSpend, buyLimit, data, player, 2);
            }
        } else if (Math.random() < 0.35) {
            int fighterCost;
            int cost2;
            if (Math.random() > 0.55 && carrierRule != null && fighterRule != null && (cost2 = carrierRule.getCosts().getInt(pus)) + (fighterCost = fighterRule.getCosts().getInt(pus)) <= PUsToSpend) {
                purchase.add(carrierRule, 1);
                purchase.add(fighterRule, 1);
                --carrierFighterLimit;
                PUsToSpend -= cost2 + fighterCost;
                while (PUsToSpend >= fighterCost && carrierFighterLimit > 0) {
                    purchase.add(fighterRule, 1);
                    --carrierFighterLimit;
                    PUsToSpend -= fighterCost;
                }
            }
            int airPUs = PUsToSpend / 6;
            SUtils.findPurchaseMix(bestAttack, bestDefense, bestTransport, bestMaxUnits, bestMobileAttack, airProductionRules, airPUs, buyLimit, data, player, 2);
            buyAttack = Math.random() > 0.5;
            for (ProductionRule rule1 : airProductionRules) {
                int buyThese = bestAttack.getInt(rule1);
                int cost3 = rule1.getCosts().getInt(pus);
                if (!buyAttack) {
                    buyThese = bestDefense.getInt(rule1);
                }
                PUsToSpend -= cost3 * buyThese;
                while (PUsToSpend < 0 && buyThese > 0) {
                    --buyThese;
                    PUsToSpend += cost3;
                }
                if (buyThese <= 0) continue;
                purchase.add(rule1, buyThese);
            }
            int landPUs = PUsToSpend;
            buyLimit = landPUs / 3;
            bestAttack.clear();
            bestDefense.clear();
            bestMaxUnits.clear();
            bestMobileAttack.clear();
            SUtils.findPurchaseMix(bestAttack, bestDefense, bestTransport, bestMaxUnits, bestMobileAttack, landProductionRules, landPUs, buyLimit, data, player, 2);
        } else {
            landPurchase = false;
            buyLimit = PUsToSpend / 8;
            seaProductionRules.addAll(airProductionRules);
            if (Math.random() > 0.45) {
                SUtils.findPurchaseMix(bestAttack, bestDefense, bestTransport, bestMaxUnits, bestMobileAttack, seaProductionRules, PUsToSpend, buyLimit, data, player, 2);
            } else {
                goTransports = true;
            }
        }
        ArrayList<ProductionRule> processRules = new ArrayList<ProductionRule>();
        if (landPurchase) {
            processRules.addAll(landProductionRules);
        } else if (goTransports) {
            processRules.addAll(transportProductionRules);
        } else {
            processRules.addAll(seaProductionRules);
        }
        buyAttack = Math.random() > 0.25;
        int buyThese = 0;
        int numBought = 0;
        for (ProductionRule rule1 : processRules) {
            cost = rule1.getCosts().getInt(pus);
            buyThese = goTransports ? PUsToSpend / cost : (buyAttack ? bestAttack.getInt(rule1) : (Math.random() <= 0.25 ? bestDefense.getInt(rule1) : bestMaxUnits.getInt(rule1)));
            PUsToSpend -= cost * buyThese;
            while (buyThese > 0 && PUsToSpend < 0) {
                --buyThese;
                PUsToSpend += cost;
            }
            if (buyThese <= 0) continue;
            numBought += buyThese;
            purchase.add(rule1, buyThese);
        }
        bestAttack.clear();
        bestDefense.clear();
        bestTransport.clear();
        bestMaxUnits.clear();
        bestMobileAttack.clear();
        if (PUsToSpend > 0) {
            buyLimit = PUsToSpend / 2;
            SUtils.findPurchaseMix(bestAttack, bestDefense, bestTransport, bestMaxUnits, bestMobileAttack, landProductionRules, PUsToSpend, buyLimit, data, player, 2);
            for (ProductionRule rule2 : landProductionRules) {
                cost = rule2.getCosts().getInt(pus);
                PUsToSpend -= cost * buyThese;
                for (buyThese = bestDefense.getInt(rule2); buyThese > 0 && PUsToSpend < 0; --buyThese, PUsToSpend += cost) {
                }
                if (buyThese <= 0) continue;
                purchase.add(rule2, buyThese);
            }
        }
        purchaseDelegate.purchase(purchase);
    }

    private boolean isAmphibAttack(PlayerID player, boolean requireWaterFactory) {
        List<Territory> factories;
        List<Territory> waterFactories;
        Territory capitol = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, this.data);
        if (capitol == null || !capitol.getOwner().equals(player)) {
            return false;
        }
        if (requireWaterFactory && (waterFactories = SUtils.stripLandLockedTerr(this.data, factories = SUtils.findTersWithUnitsMatching(this.data, player, Matches.UnitCanProduceUnits))).isEmpty()) {
            return false;
        }
        boolean amphibPlayer = !SUtils.hasLandRouteToEnemyOwnedCapitol(capitol, player, this.data);
        int totProduction = 0;
        int allProduction = 0;
        if (amphibPlayer) {
            List<Territory> allFactories = SUtils.findTersWithUnitsMatching(this.data, player, Matches.UnitCanProduceUnits);
            for (Territory checkFactory : allFactories) {
                boolean isLandRoute = SUtils.hasLandRouteToEnemyOwnedCapitol(checkFactory, player, this.data);
                int factProduction = TripleAUnit.getProductionPotentialOfTerritory(checkFactory.getUnits().getUnits(), checkFactory, player, this.data, false, true);
                allProduction += factProduction;
                if (!isLandRoute) continue;
                totProduction += factProduction;
            }
        }
        amphibPlayer = amphibPlayer ? totProduction * 5 < allProduction * 2 : false;
        return amphibPlayer;
    }

    public int repair(int PUsRemaining, IPurchaseDelegate purchaseDelegate, GameData data, PlayerID player) {
        LogUtils.log(Level.FINE, "Repairing factories with PUsRemaining=" + PUsRemaining);
        this.data = data;
        this.player = player;
        this.myCapital = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        this.allTerritories = data.getMap().getTerritories();
        CompositeMatchAnd ourFactories = new CompositeMatchAnd(Matches.unitIsOwnedBy(player), Matches.UnitCanProduceUnits, Matches.UnitIsInfrastructure);
        List<Territory> rfactories = Match.getMatches(data.getMap().getTerritories(), ProMatches.territoryHasInfraFactoryAndIsNotConqueredOwnedLand(player, data));
        if (player.getRepairFrontier() != null && Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(data)) {
            LogUtils.log(Level.FINER, "Factories can be damaged");
            HashMap<Unit, Territory> unitsThatCanProduceNeedingRepair = new HashMap<Unit, Territory>();
            for (Territory fixTerr : rfactories) {
                Unit possibleFactoryNeedingRepair;
                if (!Matches.territoryIsOwnedAndHasOwnedUnitMatching(data, player, Matches.UnitCanProduceUnitsAndCanBeDamaged).match(fixTerr) || !Matches.UnitHasTakenSomeBombingUnitDamage.match(possibleFactoryNeedingRepair = TripleAUnit.getBiggestProducer(Match.getMatches(fixTerr.getUnits().getUnits(), ourFactories), fixTerr, player, data, false))) continue;
                unitsThatCanProduceNeedingRepair.put(possibleFactoryNeedingRepair, fixTerr);
            }
            LogUtils.log(Level.FINER, "Factories that need repaired: " + unitsThatCanProduceNeedingRepair);
            List<RepairRule> rrules = player.getRepairFrontier().getRules();
            for (RepairRule rrule : rrules) {
                for (Unit fixUnit : unitsThatCanProduceNeedingRepair.keySet()) {
                    TripleAUnit taUnit;
                    int diff;
                    if (fixUnit == null || !fixUnit.getType().equals(rrule.getResults().keySet().iterator().next()) || !Matches.territoryIsOwnedAndHasOwnedUnitMatching(data, player, Matches.UnitCanProduceUnitsAndCanBeDamaged).match((Territory)unitsThatCanProduceNeedingRepair.get(fixUnit)) || (diff = (taUnit = (TripleAUnit)fixUnit).getUnitDamage()) <= 0) continue;
                    IntegerMap<RepairRule> repairMap = new IntegerMap<RepairRule>();
                    repairMap.add(rrule, diff);
                    HashMap<Unit, IntegerMap<RepairRule>> repair = new HashMap<Unit, IntegerMap<RepairRule>>();
                    repair.put(fixUnit, repairMap);
                    PUsRemaining -= diff;
                    LogUtils.log(Level.FINER, "Repairing factory=" + fixUnit + ", damage=" + diff + ", repairRule=" + rrule);
                    purchaseDelegate.purchaseRepair(repair);
                }
            }
        }
        return PUsRemaining;
    }

    public Map<Territory, ProPurchaseTerritory> purchase(int PUsRemaining, IPurchaseDelegate purchaseDelegate, GameData data, GameData startOfTurnData, PlayerID player) {
        LogUtils.log(Level.FINE, "Starting purchase phase with PUsRemaining=" + PUsRemaining);
        if (!player.getUnits().getUnits().isEmpty()) {
            LogUtils.log(Level.FINE, "Starting purchase phase with unplaced units=" + player.getUnits().getUnits());
        }
        this.data = data;
        this.startOfTurnData = startOfTurnData;
        this.player = player;
        this.myCapital = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        this.allTerritories = data.getMap().getTerritories();
        ProPurchaseOptionMap purchaseOptions = new ProPurchaseOptionMap(player, data);
        this.minCostPerHitPoint = this.purchaseUtils.getMinCostPerHitPoint(player, purchaseOptions.getLandOptions());
        Map<Territory, ProPurchaseTerritory> purchaseTerritories = this.purchaseUtils.findPurchaseTerritories(player);
        HashSet<Territory> placeTerritories = new HashSet<Territory>();
        placeTerritories.addAll(Match.getMatches(data.getMap().getTerritoriesOwnedBy(player), Matches.TerritoryIsLand));
        for (Territory t : purchaseTerritories.keySet()) {
            for (ProPlaceTerritory ppt : purchaseTerritories.get(t).getCanPlaceTerritories()) {
                placeTerritories.add(ppt.getTerritory());
            }
        }
        HashMap<Territory, ProAttackTerritoryData> enemyAttackMap = new HashMap<Territory, ProAttackTerritoryData>();
        this.attackOptionsUtils.findMaxEnemyAttackUnits(player, new ArrayList<Territory>(), new ArrayList<Territory>(placeTerritories), enemyAttackMap);
        this.findDefendersInPlaceTerritories(purchaseTerritories);
        List<ProPlaceTerritory> needToDefendLandTerritories = this.prioritizeTerritoriesToDefend(purchaseTerritories, enemyAttackMap, true);
        PUsRemaining = this.purchaseDefenders(purchaseTerritories, enemyAttackMap, needToDefendLandTerritories, PUsRemaining, purchaseOptions.getLandFodderOptions(), purchaseOptions.getAirOptions(), true);
        LogUtils.log(Level.FINE, "Find strategic value for place territories");
        Map<Territory, Double> territoryValueMap = this.territoryValueUtils.findTerritoryValues(player, this.minCostPerHitPoint, new ArrayList<Territory>(), new ArrayList<Territory>());
        for (Territory t : purchaseTerritories.keySet()) {
            for (ProPlaceTerritory ppt : purchaseTerritories.get(t).getCanPlaceTerritories()) {
                ppt.setStrategicValue(territoryValueMap.get(ppt.getTerritory()));
                LogUtils.log(Level.FINER, ppt.getTerritory() + ", strategicValue=" + territoryValueMap.get(ppt.getTerritory()));
            }
        }
        List<ProPlaceTerritory> prioritizedLandTerritories = this.prioritizeLandTerritories(purchaseTerritories);
        PUsRemaining = this.purchaseAAUnits(purchaseTerritories, enemyAttackMap, prioritizedLandTerritories, PUsRemaining, purchaseOptions.getAAOptions());
        PUsRemaining = this.purchaseLandUnits(purchaseTerritories, enemyAttackMap, prioritizedLandTerritories, PUsRemaining, purchaseOptions, territoryValueMap);
        List<ProPlaceTerritory> needToDefendSeaTerritories = this.prioritizeTerritoriesToDefend(purchaseTerritories, enemyAttackMap, false);
        PUsRemaining = this.purchaseDefenders(purchaseTerritories, enemyAttackMap, needToDefendSeaTerritories, PUsRemaining, purchaseOptions.getSeaDefenseOptions(), purchaseOptions.getAirOptions(), false);
        HashMap<Territory, ProPurchaseTerritory> factoryPurchaseTerritories = new HashMap<Territory, ProPurchaseTerritory>();
        PUsRemaining = this.purchaseFactory(factoryPurchaseTerritories, enemyAttackMap, PUsRemaining, purchaseTerritories, prioritizedLandTerritories, purchaseOptions, false);
        List<ProPlaceTerritory> prioritizedSeaTerritories = this.prioritizeSeaTerritories(purchaseTerritories, enemyAttackMap);
        PUsRemaining = this.purchaseSeaAndAmphibUnits(purchaseTerritories, enemyAttackMap, prioritizedSeaTerritories, territoryValueMap, PUsRemaining, purchaseOptions);
        PUsRemaining = this.purchaseUnitsWithRemainingProduction(purchaseTerritories, PUsRemaining, purchaseOptions.getLandOptions(), purchaseOptions.getAirOptions());
        PUsRemaining = this.upgradeUnitsWithRemainingPUs(purchaseTerritories, PUsRemaining, purchaseOptions);
        PUsRemaining = this.purchaseFactory(factoryPurchaseTerritories, enemyAttackMap, PUsRemaining, purchaseTerritories, prioritizedLandTerritories, purchaseOptions, true);
        if (!factoryPurchaseTerritories.isEmpty()) {
            purchaseTerritories.putAll(factoryPurchaseTerritories);
        }
        IntegerMap<ProductionRule> purchaseMap = this.populateProductionRuleMap(purchaseTerritories, purchaseOptions);
        ProMetricUtils.collectPurchaseStats(purchaseMap);
        String error = purchaseDelegate.purchase(purchaseMap);
        if (error != null) {
            LogUtils.log(Level.WARNING, "Purchase error: " + error);
        }
        return purchaseTerritories;
    }

    public void bidPlace(Map<Territory, ProPurchaseTerritory> purchaseTerritories, IAbstractPlaceDelegate placeDelegate, GameData data, PlayerID player) {
        LogUtils.log(Level.FINE, "Starting bid place phase");
        if (player.getUnits().isEmpty()) {
            return;
        }
        ArrayList<Territory> impassableTerrs = new ArrayList<Territory>();
        for (Territory t : data.getMap().getTerritories()) {
            if (!Matches.TerritoryIsPassableAndNotRestricted(player, data).invert().match(t) || !Matches.TerritoryIsLand.match(t)) continue;
            impassableTerrs.add(t);
        }
        BattleDelegate delegate = DelegateFinder.battleDelegate(data);
        boolean tFirst = !Properties.getTransportCasualtiesRestricted(data);
        CompositeMatchAnd ownedUnit = new CompositeMatchAnd(Matches.unitIsOwnedBy(player));
        CompositeMatchAnd<Unit> attackUnit = new CompositeMatchAnd<Unit>(Matches.UnitIsSea, Matches.UnitIsNotTransport);
        CompositeMatchAnd transUnit = new CompositeMatchAnd(Matches.UnitIsTransport);
        CompositeMatchAnd enemyUnit = new CompositeMatchAnd(Matches.enemyUnit(player, data));
        CompositeMatchAnd<Unit> enemyAttackUnit = new CompositeMatchAnd<Unit>(attackUnit, enemyUnit);
        CompositeMatchAnd<Unit> ourFactory = new CompositeMatchAnd<Unit>(ownedUnit, Matches.UnitCanProduceUnits);
        CompositeMatchAnd landUnit = new CompositeMatchAnd(ownedUnit, Matches.UnitIsLand, Matches.UnitIsNotInfrastructure, Matches.UnitCanNotProduceUnits);
        Territory capitol = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        List<Territory> factoryTerritories = Match.getMatches(SUtils.findUnitTerr(data, player, ourFactory), Matches.isTerritoryOwnedBy(player));
        factoryTerritories.removeAll(impassableTerrs);
        ArrayList<Territory> ourFriendlyTerr = new ArrayList<Territory>();
        ArrayList<Territory> ourEnemyTerr = new ArrayList<Territory>();
        ArrayList<Territory> ourSemiRankedBidTerrs = new ArrayList<Territory>();
        List<Territory> ourTerrs = SUtils.allOurTerritories(data, player);
        ourTerrs.remove(capitol);
        HashMap<Territory, Float> rankMap = SUtils.rankTerritories(data, ourFriendlyTerr, ourEnemyTerr, null, player, tFirst, false, true);
        List<Territory> ourTerrWithEnemyNeighbors = SUtils.getTerritoriesWithEnemyNeighbor(data, player, false, false);
        SUtils.reorder(ourTerrWithEnemyNeighbors, rankMap, true);
        if (ourTerrWithEnemyNeighbors.contains(capitol)) {
            ourTerrWithEnemyNeighbors.remove(capitol);
            ourTerrWithEnemyNeighbors.add(capitol);
        }
        Territory bidLandTerr = null;
        if (ourTerrWithEnemyNeighbors.size() > 0) {
            bidLandTerr = ourTerrWithEnemyNeighbors.get(0);
        }
        if (bidLandTerr == null) {
            bidLandTerr = capitol;
        }
        if (player.getUnits().someMatch(Matches.UnitIsSea)) {
            Territory checkSeaTerr;
            Territory bidSeaTerr = null;
            Territory bidTransTerr = null;
            CompositeMatchAnd<Territory> waterFactoryWaterTerr = new CompositeMatchAnd<Territory>(Matches.TerritoryIsWater, Matches.territoryHasOwnedNeighborWithOwnedUnitMatching(data, player, Matches.UnitCanProduceUnits));
            List<Territory> enemySeaTerr = SUtils.findUnitTerr(data, player, enemyAttackUnit);
            List<Territory> isWaterTerr = SUtils.onlyWaterTerr(data, enemySeaTerr);
            enemySeaTerr.retainAll(isWaterTerr);
            Territory maxEnemySeaTerr = null;
            int maxUnits = 0;
            for (Territory seaTerr : enemySeaTerr) {
                int unitCount = seaTerr.getUnits().countMatches(enemyAttackUnit);
                if (unitCount <= maxUnits) continue;
                maxUnits = unitCount;
                maxEnemySeaTerr = seaTerr;
            }
            Route seaRoute = SUtils.findNearest(maxEnemySeaTerr, waterFactoryWaterTerr, Matches.TerritoryIsWater, data);
            if (seaRoute != null && (checkSeaTerr = seaRoute.getEnd()) != null) {
                float bStrength;
                float seaStrength = SUtils.getStrengthOfPotentialAttackers(checkSeaTerr, data, player, tFirst, false, null);
                float aStrength = SUtils.strength(checkSeaTerr.getUnits().getUnits(), false, true, tFirst);
                float totStrength = aStrength + (bStrength = SUtils.strength(player.getUnits().getMatches(attackUnit), false, true, tFirst));
                if (totStrength > 0.9f * seaStrength) {
                    bidSeaTerr = checkSeaTerr;
                }
            }
            for (Territory factCheck : factoryTerritories) {
                if (bidSeaTerr == null) {
                    bidSeaTerr = SUtils.findASeaTerritoryToPlaceOn(factCheck, data, player, tFirst);
                }
                if (bidTransTerr != null) continue;
                bidTransTerr = SUtils.findASeaTerritoryToPlaceOn(factCheck, data, player, tFirst);
            }
            this.placeSeaUnits(true, data, bidSeaTerr, bidSeaTerr, placeDelegate, player);
        }
        if (player.getUnits().someMatch(Matches.UnitIsNotSea)) {
            ourSemiRankedBidTerrs.addAll(ourTerrWithEnemyNeighbors);
            ourTerrs.removeAll(ourTerrWithEnemyNeighbors);
            Collections.shuffle(ourTerrs);
            ourSemiRankedBidTerrs.addAll(ourTerrs);
            for (Territory noRouteTerr : ourTerrs) {
                if (SUtils.distanceToEnemy(noRouteTerr, data, player, false) >= 1 || TerritoryAttachment.getProduction(noRouteTerr) >= 3) continue;
                ourSemiRankedBidTerrs.remove(noRouteTerr);
            }
            List<Territory> isWaterTerr = SUtils.onlyWaterTerr(data, ourSemiRankedBidTerrs);
            ourSemiRankedBidTerrs.removeAll(isWaterTerr);
            ourSemiRankedBidTerrs.removeAll(impassableTerrs);
            int maxBidPerTerritory = 5;
            for (int bidCycle = 0; !player.getUnits().isEmpty() && bidCycle < 5; ++bidCycle) {
                for (int i = 0; i <= ourSemiRankedBidTerrs.size() - 1; ++i) {
                    bidLandTerr = (Territory)ourSemiRankedBidTerrs.get(i);
                    this.placeAllWeCanOn(true, data, null, bidLandTerr, placeDelegate, player);
                }
            }
            if (!player.getUnits().isEmpty()) {
                this.placeAllWeCanOn(true, data, null, capitol, placeDelegate, player);
            }
        }
    }

    private void placeSeaUnits(boolean bid, GameData data, Territory seaPlaceAttack, Territory seaPlaceTrans, IAbstractPlaceDelegate placeDelegate, PlayerID player) {
        CompositeMatchAnd<Unit> attackUnit = new CompositeMatchAnd<Unit>(Matches.UnitIsSea, Matches.UnitIsNotTransport);
        List<Unit> seaUnits = player.getUnits().getMatches(attackUnit);
        List<Unit> transUnits = player.getUnits().getMatches(Matches.UnitIsTransport);
        List<Unit> airUnits = player.getUnits().getMatches(Matches.UnitCanLandOnCarrier);
        List<Unit> carrierUnits = player.getUnits().getMatches(Matches.UnitIsCarrier);
        if (carrierUnits.size() > 0 && airUnits.size() > 0 && (Properties.getProduceFightersOnCarriers(data) || Properties.getLHTRCarrierProductionRules(data) || bid)) {
            int carrierSpace = 0;
            for (Unit carrier1 : carrierUnits) {
                carrierSpace += UnitAttachment.get(carrier1.getType()).getCarrierCapacity();
            }
            Iterator<Unit> airIter = airUnits.iterator();
            while (airIter.hasNext() && carrierSpace > 0) {
                Unit airPlane = airIter.next();
                seaUnits.add(airPlane);
                carrierSpace -= UnitAttachment.get(airPlane.getType()).getCarrierCost();
            }
        }
        if (bid) {
            if (!seaUnits.isEmpty()) {
                this.doPlace(seaPlaceAttack, seaUnits, placeDelegate);
            }
            if (!transUnits.isEmpty()) {
                this.doPlace(seaPlaceTrans, transUnits, placeDelegate);
            }
            return;
        }
        if (seaUnits.isEmpty() && transUnits.isEmpty()) {
            return;
        }
        if (seaPlaceAttack == seaPlaceTrans) {
            seaUnits.addAll(transUnits);
            transUnits.clear();
        }
        PlaceableUnits pu = placeDelegate.getPlaceableUnits(seaUnits, seaPlaceAttack);
        int pLeft = 0;
        if (pu.getErrorMessage() != null) {
            return;
        }
        if (!seaUnits.isEmpty()) {
            pLeft = pu.getMaxUnits();
            if (pLeft == -1) {
                pLeft = Integer.MAX_VALUE;
            }
            int numPlace = Math.min(pLeft, seaUnits.size());
            pLeft -= numPlace;
            List<Unit> toPlace = seaUnits.subList(0, numPlace);
            this.doPlace(seaPlaceAttack, toPlace, placeDelegate);
        }
        if (!transUnits.isEmpty()) {
            PlaceableUnits pu2 = placeDelegate.getPlaceableUnits(transUnits, seaPlaceTrans);
            if (pu2.getErrorMessage() != null) {
                return;
            }
            pLeft = pu2.getMaxUnits();
            if (pLeft == -1) {
                pLeft = Integer.MAX_VALUE;
            }
            int numPlace = Math.min(pLeft, transUnits.size());
            List<Unit> toPlace = transUnits.subList(0, numPlace);
            this.doPlace(seaPlaceTrans, toPlace, placeDelegate);
        }
    }

    private void placeAllWeCanOn(boolean bid, GameData data, Territory factoryPlace, Territory placeAt, IAbstractPlaceDelegate placeDelegate, PlayerID player) {
        CompositeMatchOr<Unit> landOrAir = new CompositeMatchOr<Unit>(Matches.UnitIsAir, Matches.UnitIsLand);
        if (factoryPlace != null) {
            ArrayList<Unit> toPlace = new ArrayList<Unit>(player.getUnits().getMatches(Matches.UnitCanProduceUnitsAndIsConstruction));
            if (toPlace.size() == 1) {
                this.doPlace(factoryPlace, toPlace, placeDelegate);
                return;
            }
            if (toPlace.size() > 1) {
                return;
            }
        }
        List<Unit> landUnits = player.getUnits().getMatches(landOrAir);
        Territory capitol = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        PlaceableUnits pu3 = placeDelegate.getPlaceableUnits(landUnits, placeAt);
        if (pu3.getErrorMessage() != null) {
            return;
        }
        int placementLeft3 = pu3.getMaxUnits();
        if (placementLeft3 == -1) {
            placementLeft3 = Integer.MAX_VALUE;
        }
        if (bid) {
            placementLeft3 = 1;
        }
        if (bid && placeAt == capitol) {
            placementLeft3 = 1000;
        }
        if (!landUnits.isEmpty()) {
            int landPlaceCount = Math.min(placementLeft3, landUnits.size());
            placementLeft3 -= landPlaceCount;
            List<Unit> toPlace = landUnits.subList(0, landPlaceCount);
            this.doPlace(placeAt, toPlace, placeDelegate);
        }
    }

    public void place(Map<Territory, ProPurchaseTerritory> purchaseTerritories, IAbstractPlaceDelegate placeDelegate, GameData data, PlayerID player) {
        LogUtils.log(Level.FINE, "Starting place phase");
        if (purchaseTerritories != null) {
            ArrayList<Unit> unitsToPlace;
            Collection<Unit> myUnits;
            for (Territory t : purchaseTerritories.keySet()) {
                for (ProPlaceTerritory ppt : purchaseTerritories.get(t).getCanPlaceTerritories()) {
                    if (ppt.getTerritory().isWater()) continue;
                    myUnits = player.getUnits().getUnits();
                    unitsToPlace = new ArrayList<Unit>();
                    block2: for (Unit placeUnit : ppt.getPlaceUnits()) {
                        for (Unit myUnit : myUnits) {
                            if (!myUnit.getUnitType().equals(placeUnit.getUnitType()) || unitsToPlace.contains(myUnit)) continue;
                            unitsToPlace.add(myUnit);
                            continue block2;
                        }
                    }
                    this.doPlace(data.getMap().getTerritory(ppt.getTerritory().getName()), unitsToPlace, placeDelegate);
                    LogUtils.log(Level.FINER, ppt.getTerritory() + " placed units: " + unitsToPlace);
                }
            }
            for (Territory t : purchaseTerritories.keySet()) {
                for (ProPlaceTerritory ppt : purchaseTerritories.get(t).getCanPlaceTerritories()) {
                    if (!ppt.getTerritory().isWater()) continue;
                    myUnits = player.getUnits().getUnits();
                    unitsToPlace = new ArrayList();
                    block6: for (Unit placeUnit : ppt.getPlaceUnits()) {
                        for (Unit myUnit : myUnits) {
                            if (!myUnit.getUnitType().equals(placeUnit.getUnitType()) || unitsToPlace.contains(myUnit)) continue;
                            unitsToPlace.add(myUnit);
                            continue block6;
                        }
                    }
                    this.doPlace(data.getMap().getTerritory(ppt.getTerritory().getName()), unitsToPlace, placeDelegate);
                    LogUtils.log(Level.FINER, ppt.getTerritory() + " placed units: " + unitsToPlace);
                }
            }
        }
        if (player.getUnits().getUnits().isEmpty()) {
            return;
        }
        LogUtils.log(Level.FINER, "Remaining units to place: " + player.getUnits().getUnits());
        this.data = data;
        this.player = player;
        this.myCapital = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        this.allTerritories = data.getMap().getTerritories();
        Map<Territory, ProPurchaseTerritory> placeNonConstructionTerritories = this.purchaseUtils.findPurchaseTerritories(player);
        HashMap<Territory, ProAttackTerritoryData> enemyAttackMap = new HashMap<Territory, ProAttackTerritoryData>();
        this.attackOptionsUtils.findMaxEnemyAttackUnits(player, new ArrayList<Territory>(), new ArrayList<Territory>(placeNonConstructionTerritories.keySet()), enemyAttackMap);
        this.findDefendersInPlaceTerritories(placeNonConstructionTerritories);
        List<ProPlaceTerritory> needToDefendLandTerritories = this.prioritizeTerritoriesToDefend(placeNonConstructionTerritories, enemyAttackMap, true);
        this.placeDefenders(placeNonConstructionTerritories, enemyAttackMap, needToDefendLandTerritories, placeDelegate);
        LogUtils.log(Level.FINE, "Find strategic value for place territories");
        Map<Territory, Double> territoryValueMap = this.territoryValueUtils.findTerritoryValues(player, this.minCostPerHitPoint, new ArrayList<Territory>(), new ArrayList<Territory>());
        for (Territory t : placeNonConstructionTerritories.keySet()) {
            for (ProPlaceTerritory ppt : placeNonConstructionTerritories.get(t).getCanPlaceTerritories()) {
                ppt.setStrategicValue(territoryValueMap.get(ppt.getTerritory()));
                LogUtils.log(Level.FINER, ppt.getTerritory() + ", strategicValue=" + territoryValueMap.get(ppt.getTerritory()));
            }
        }
        List<ProPlaceTerritory> prioritizedLandTerritories = this.prioritizeLandTerritories(placeNonConstructionTerritories);
        for (ProPurchaseTerritory ppt : placeNonConstructionTerritories.values()) {
            for (ProPlaceTerritory placeTerritory : ppt.getCanPlaceTerritories()) {
                Territory t = placeTerritory.getTerritory();
                if (t.isWater() || prioritizedLandTerritories.contains(placeTerritory)) continue;
                prioritizedLandTerritories.add(placeTerritory);
            }
        }
        this.placeLandUnits(placeNonConstructionTerritories, enemyAttackMap, prioritizedLandTerritories, placeDelegate, false);
        this.placeLandUnits(placeNonConstructionTerritories, enemyAttackMap, prioritizedLandTerritories, placeDelegate, true);
    }

    private void findDefendersInPlaceTerritories(Map<Territory, ProPurchaseTerritory> purchaseTerritories) {
        LogUtils.log(Level.FINE, "Find defenders in possible place territories");
        for (ProPurchaseTerritory ppt : purchaseTerritories.values()) {
            for (ProPlaceTerritory placeTerritory : ppt.getCanPlaceTerritories()) {
                Territory t = placeTerritory.getTerritory();
                List<Unit> units = t.getUnits().getMatches(Matches.isUnitAllied(this.player, this.data));
                placeTerritory.setDefendingUnits(units);
                LogUtils.log(Level.FINER, t + " has numDefenders=" + units.size());
            }
        }
    }

    private List<ProPlaceTerritory> prioritizeTerritoriesToDefend(Map<Territory, ProPurchaseTerritory> purchaseTerritories, Map<Territory, ProAttackTerritoryData> enemyAttackMap, boolean isLand) {
        LogUtils.log(Level.FINE, "Prioritize territories to defend with isLand=" + isLand);
        IntegerMap<UnitType> playerCostMap = BattleCalculator.getCostsForTUV(this.player, this.data);
        HashSet<ProPlaceTerritory> needToDefendTerritories = new HashSet<ProPlaceTerritory>();
        for (ProPurchaseTerritory proPurchaseTerritory : purchaseTerritories.values()) {
            for (ProPlaceTerritory placeTerritory : proPurchaseTerritory.getCanPlaceTerritories()) {
                boolean isLandAndCanOnlyBeAttackedByAir;
                Territory t = placeTerritory.getTerritory();
                if (enemyAttackMap.get(t) == null || t.isWater() && placeTerritory.getDefendingUnits().isEmpty() || isLand && t.isWater() || !isLand && !t.isWater()) continue;
                HashSet<Unit> enemyAttackingUnits = new HashSet<Unit>(enemyAttackMap.get(t).getMaxUnits());
                enemyAttackingUnits.addAll(enemyAttackMap.get(t).getMaxAmphibUnits());
                ProBattleResultData result = this.battleUtils.calculateBattleResults(this.player, t, new ArrayList<Unit>(enemyAttackingUnits), placeTerritory.getDefendingUnits(), enemyAttackMap.get(t).getMaxBombardUnits(), false);
                placeTerritory.setMinBattleResult(result);
                double holdValue = 0.0;
                if (t.isWater()) {
                    double unitValue = BattleCalculator.getTUV(Match.getMatches(placeTerritory.getDefendingUnits(), Matches.unitIsOwnedBy(this.player)), playerCostMap);
                    holdValue = unitValue / 8.0;
                }
                LogUtils.log(Level.FINEST, t.getName() + " TUVSwing=" + result.getTUVSwing() + ", win%=" + result.getWinPercentage() + ", hasLandUnitRemaining=" + result.isHasLandUnitRemaining() + ", holdValue=" + holdValue + ", enemyAttackers=" + enemyAttackingUnits + ", defenders=" + placeTerritory.getDefendingUnits());
                boolean bl = isLandAndCanOnlyBeAttackedByAir = !t.isWater() && Match.allMatch(enemyAttackingUnits, Matches.UnitIsAir);
                if (!(!t.isWater() && result.isHasLandUnitRemaining() || result.getTUVSwing() > holdValue) && (!t.equals(this.myCapital) || isLandAndCanOnlyBeAttackedByAir || !(result.getWinPercentage() > 5.0))) continue;
                needToDefendTerritories.add(placeTerritory);
            }
        }
        for (ProPlaceTerritory proPlaceTerritory : needToDefendTerritories) {
            Territory t = proPlaceTerritory.getTerritory();
            int isMyCapital = 0;
            if (t.equals(this.myCapital)) {
                isMyCapital = 1;
            }
            int isFactory = 0;
            if (ProMatches.territoryHasInfraFactoryAndIsOwnedLand(this.player).match(t)) {
                isFactory = 1;
            }
            int production = 0;
            TerritoryAttachment ta = TerritoryAttachment.get(t);
            if (ta != null) {
                production = ta.getProduction();
            }
            double defendingUnitValue = BattleCalculator.getTUV(proPlaceTerritory.getDefendingUnits(), playerCostMap);
            if (t.isWater() && Match.noneMatch(proPlaceTerritory.getDefendingUnits(), Matches.unitIsOwnedBy(this.player))) {
                defendingUnitValue = 0.0;
            }
            double territoryValue = ((double)(2 * production + 4 * isFactory) + 0.5 * defendingUnitValue) * (double)(1 + isFactory) * (double)(1 + 10 * isMyCapital);
            proPlaceTerritory.setDefenseValue(territoryValue);
        }
        Iterator it = needToDefendTerritories.iterator();
        while (it.hasNext()) {
            ProPlaceTerritory proPlaceTerritory = (ProPlaceTerritory)it.next();
            if (!(proPlaceTerritory.getDefenseValue() <= 0.0)) continue;
            it.remove();
        }
        ArrayList<ProPlaceTerritory> sortedTerritories = new ArrayList<ProPlaceTerritory>(needToDefendTerritories);
        Collections.sort(sortedTerritories, new Comparator<ProPlaceTerritory>(){

            @Override
            public int compare(ProPlaceTerritory t1, ProPlaceTerritory t2) {
                double value1 = t1.getDefenseValue();
                double value2 = t2.getDefenseValue();
                return Double.compare(value2, value1);
            }
        });
        for (ProPlaceTerritory placeTerritory : sortedTerritories) {
            LogUtils.log(Level.FINER, placeTerritory.toString() + " defenseValue=" + placeTerritory.getDefenseValue());
        }
        return sortedTerritories;
    }

    private int purchaseDefenders(Map<Territory, ProPurchaseTerritory> purchaseTerritories, Map<Territory, ProAttackTerritoryData> enemyAttackMap, List<ProPlaceTerritory> needToDefendTerritories, int PUsRemaining, List<ProPurchaseOption> defensePurchaseOptions, List<ProPurchaseOption> airPurchaseOptions, boolean isLand) {
        if (PUsRemaining == 0) {
            return PUsRemaining;
        }
        LogUtils.log(Level.FINE, "Purchase defenders with PUsRemaining=" + PUsRemaining + ", isLand=" + isLand);
        for (ProPlaceTerritory placeTerritory : needToDefendTerritories) {
            Territory t = placeTerritory.getTerritory();
            LogUtils.log(Level.FINER, "Purchasing defenders for " + t.getName() + ", enemyAttackers=" + enemyAttackMap.get(t).getMaxUnits() + ", amphibEnemyAttackers=" + enemyAttackMap.get(t).getMaxAmphibUnits() + ", defenders=" + placeTerritory.getDefendingUnits());
            List<Unit> ownedLocalUnits = t.getUnits().getMatches(Matches.unitIsOwnedBy(this.player));
            int unusedCarrierCapacity = Math.min(0, this.transportUtils.getUnusedCarrierCapacity(this.player, t, new ArrayList<Unit>()));
            int unusedLocalCarrierCapacity = this.transportUtils.getUnusedLocalCarrierCapacity(this.player, t, new ArrayList<Unit>());
            LogUtils.log(Level.FINEST, t + ", unusedCarrierCapacity=" + unusedCarrierCapacity + ", unusedLocalCarrierCapacity=" + unusedLocalCarrierCapacity);
            boolean needDestroyer = false;
            if (Match.someMatch(enemyAttackMap.get(t).getMaxUnits(), Matches.UnitIsSub) && Match.noneMatch(ownedLocalUnits, Matches.UnitIsDestroyer)) {
                needDestroyer = true;
            }
            int PUsSpent = 0;
            ArrayList<Unit> unitsToPlace = new ArrayList<Unit>();
            ProBattleResultData finalResult = new ProBattleResultData();
            List<ProPurchaseTerritory> selectedPurchaseTerritories = this.getPurchaseTerritories(placeTerritory, purchaseTerritories);
            block1: for (ProPurchaseTerritory purchaseTerritory : selectedPurchaseTerritories) {
                int remainingUnitProduction = purchaseTerritory.getRemainingUnitProduction();
                LogUtils.log(Level.FINER, purchaseTerritory.getTerritory() + ", remainingUnitProduction=" + remainingUnitProduction);
                if (remainingUnitProduction <= 0) continue;
                List<ProPurchaseOption> purchaseOptionsForTerritory = this.purchaseUtils.findPurchaseOptionsForTerritory(this.player, defensePurchaseOptions, t);
                purchaseOptionsForTerritory.addAll(airPurchaseOptions);
                do {
                    this.purchaseUtils.removePurchaseOptionsByCostAndProductionAndLimits(this.player, this.startOfTurnData, purchaseOptionsForTerritory, PUsRemaining - PUsSpent, remainingUnitProduction, unitsToPlace, purchaseTerritories);
                    if (purchaseOptionsForTerritory.isEmpty()) continue block1;
                    HashMap<ProPurchaseOption, Double> defenseEfficiencies = new HashMap<ProPurchaseOption, Double>();
                    for (ProPurchaseOption ppo : purchaseOptionsForTerritory) {
                        if (isLand) {
                            defenseEfficiencies.put(ppo, ppo.getDefenseEfficiency2(1, this.data, ownedLocalUnits, unitsToPlace));
                            continue;
                        }
                        defenseEfficiencies.put(ppo, ppo.getSeaDefenseEfficiency(this.data, ownedLocalUnits, unitsToPlace, needDestroyer, unusedCarrierCapacity, unusedLocalCarrierCapacity));
                    }
                    ProPurchaseOption selectedOption = this.purchaseUtils.randomizePurchaseOption(defenseEfficiencies, "Defense");
                    if (selectedOption.isDestroyer()) {
                        needDestroyer = false;
                    }
                    PUsSpent += selectedOption.getCost();
                    remainingUnitProduction -= selectedOption.getQuantity();
                    unitsToPlace.addAll(selectedOption.getUnitType().create(selectedOption.getQuantity(), this.player, true));
                    if (selectedOption.isCarrier() || selectedOption.isAir()) {
                        unusedCarrierCapacity = this.transportUtils.getUnusedCarrierCapacity(this.player, t, unitsToPlace);
                        unusedLocalCarrierCapacity = this.transportUtils.getUnusedLocalCarrierCapacity(this.player, t, unitsToPlace);
                    }
                    LogUtils.log(Level.FINEST, "Selected unit=" + selectedOption.getUnitType().getName() + ", unusedCarrierCapacity=" + unusedCarrierCapacity + ", unusedLocalCarrierCapacity=" + unusedLocalCarrierCapacity);
                    HashSet<Unit> enemyAttackingUnits = new HashSet<Unit>(enemyAttackMap.get(t).getMaxUnits());
                    enemyAttackingUnits.addAll(enemyAttackMap.get(t).getMaxAmphibUnits());
                    ArrayList<Unit> defenders = new ArrayList<Unit>(placeTerritory.getDefendingUnits());
                    defenders.addAll(unitsToPlace);
                    finalResult = this.battleUtils.calculateBattleResults(this.player, t, new ArrayList<Unit>(enemyAttackingUnits), defenders, enemyAttackMap.get(t).getMaxBombardUnits(), false);
                } while (!(!t.equals(this.myCapital) && !finalResult.isHasLandUnitRemaining() && finalResult.getTUVSwing() <= 0.0) && (!t.equals(this.myCapital) || !(finalResult.getWinPercentage() < 5.0) || !(finalResult.getTUVSwing() <= 0.0)));
            }
            boolean hasLocalSuperiority = this.battleUtils.territoryHasLocalLandSuperiority(t, 2, this.player, purchaseTerritories);
            if (!finalResult.isHasLandUnitRemaining() || finalResult.getTUVSwing() - (double)(PUsSpent / 2) < placeTerritory.getMinBattleResult().getTUVSwing() || t.equals(this.myCapital) || !t.isWater() && hasLocalSuperiority) {
                PUsRemaining -= PUsSpent;
                LogUtils.log(Level.FINEST, t + ", placedUnits=" + unitsToPlace + ", TUVSwing=" + finalResult.getTUVSwing() + ", hasLandUnitRemaining=" + finalResult.isHasLandUnitRemaining() + ", hasLocalSuperiority=" + hasLocalSuperiority);
                this.addUnitsToPlaceTerritory(placeTerritory, unitsToPlace, purchaseTerritories);
                continue;
            }
            this.setCantHoldPlaceTerritory(placeTerritory, purchaseTerritories);
            LogUtils.log(Level.FINEST, t + ", unable to defend with placedUnits=" + unitsToPlace + ", TUVSwing=" + finalResult.getTUVSwing() + ", minTUVSwing=" + placeTerritory.getMinBattleResult().getTUVSwing() + ", PUsSpent=" + PUsSpent);
        }
        return PUsRemaining;
    }

    private List<ProPlaceTerritory> prioritizeLandTerritories(Map<Territory, ProPurchaseTerritory> purchaseTerritories) {
        LogUtils.log(Level.FINE, "Prioritize land territories to place");
        ArrayList<ProPlaceTerritory> prioritizedLandTerritories = new ArrayList<ProPlaceTerritory>();
        for (ProPurchaseTerritory ppt : purchaseTerritories.values()) {
            for (ProPlaceTerritory placeTerritory : ppt.getCanPlaceTerritories()) {
                Territory t = placeTerritory.getTerritory();
                if (t.isWater() || !(placeTerritory.getStrategicValue() >= 1.0) || !placeTerritory.isCanHold()) continue;
                boolean hasEnemyNeighbors = !this.data.getMap().getNeighbors(t, ProMatches.territoryIsEnemyLand(this.player, this.data)).isEmpty();
                Set<Territory> nearbyLandTerritories = this.data.getMap().getNeighbors(t, 9, ProMatches.territoryCanPotentiallyMoveLandUnits(this.player, this.data, false));
                int numNearbyEnemyTerritories = Match.countMatches(nearbyLandTerritories, Matches.isTerritoryOwnedBy(this.utils.getPotentialEnemyPlayers(this.player)));
                boolean hasLocalLandSuperiority = this.battleUtils.territoryHasLocalLandSuperiority(t, 2, this.player);
                if (!hasEnemyNeighbors && numNearbyEnemyTerritories < 3 && hasLocalLandSuperiority) continue;
                prioritizedLandTerritories.add(placeTerritory);
            }
        }
        Collections.sort(prioritizedLandTerritories, new Comparator<ProPlaceTerritory>(){

            @Override
            public int compare(ProPlaceTerritory t1, ProPlaceTerritory t2) {
                double value1 = t1.getStrategicValue();
                double value2 = t2.getStrategicValue();
                return Double.compare(value2, value1);
            }
        });
        for (ProPlaceTerritory placeTerritory : prioritizedLandTerritories) {
            LogUtils.log(Level.FINER, placeTerritory.toString() + " strategicValue=" + placeTerritory.getStrategicValue());
        }
        return prioritizedLandTerritories;
    }

    private int purchaseAAUnits(Map<Territory, ProPurchaseTerritory> purchaseTerritories, Map<Territory, ProAttackTerritoryData> enemyAttackMap, List<ProPlaceTerritory> prioritizedLandTerritories, int PUsRemaining, List<ProPurchaseOption> specialPurchaseOptions) {
        if (PUsRemaining == 0) {
            return PUsRemaining;
        }
        LogUtils.log(Level.FINE, "Purchase AA units with PUsRemaining=" + PUsRemaining);
        for (ProPlaceTerritory placeTerritory : prioritizedLandTerritories) {
            Territory t = placeTerritory.getTerritory();
            LogUtils.log(Level.FINER, "Checking AA place for " + t);
            if (enemyAttackMap.get(t) == null) continue;
            int remainingUnitProduction = purchaseTerritories.get(t).getRemainingUnitProduction();
            LogUtils.log(Level.FINER, t + ", remainingUnitProduction=" + remainingUnitProduction);
            if (remainingUnitProduction <= 0) continue;
            boolean enemyCanBomb = Match.someMatch(enemyAttackMap.get(t).getMaxUnits(), Matches.UnitIsStrategicBomber);
            boolean territoryCanBeBombed = t.getUnits().someMatch(Matches.UnitCanProduceUnitsAndCanBeDamaged);
            boolean hasAABombingDefense = t.getUnits().someMatch(Matches.UnitIsAAforBombingThisUnitOnly);
            LogUtils.log(Level.FINER, t + ", enemyCanBomb=" + enemyCanBomb + ", territoryCanBeBombed=" + territoryCanBeBombed + ", hasAABombingDefense=" + hasAABombingDefense);
            if (!enemyCanBomb || !territoryCanBeBombed || hasAABombingDefense) continue;
            List<ProPurchaseOption> purchaseOptionsForTerritory = this.purchaseUtils.findPurchaseOptionsForTerritory(this.player, specialPurchaseOptions, t);
            this.purchaseUtils.removePurchaseOptionsByCostAndProductionAndLimits(this.player, this.startOfTurnData, purchaseOptionsForTerritory, PUsRemaining, remainingUnitProduction, new ArrayList<Unit>(), purchaseTerritories);
            if (purchaseOptionsForTerritory.isEmpty()) continue;
            ProPurchaseOption bestAAOption = null;
            int minCost = Integer.MAX_VALUE;
            for (ProPurchaseOption ppo : purchaseOptionsForTerritory) {
                boolean isAAForBombing = Matches.UnitTypeIsAAforBombingThisUnitOnly.match(ppo.getUnitType());
                if (!isAAForBombing || ppo.getCost() >= minCost || Matches.UnitTypeConsumesUnitsOnCreation.match(ppo.getUnitType())) continue;
                bestAAOption = ppo;
                minCost = ppo.getCost();
            }
            if (bestAAOption == null) continue;
            LogUtils.log(Level.FINEST, "Best AA unit: " + bestAAOption.getUnitType().getName());
            PUsRemaining -= bestAAOption.getCost();
            remainingUnitProduction -= bestAAOption.getQuantity();
            List<Unit> unitsToPlace = bestAAOption.getUnitType().create(bestAAOption.getQuantity(), this.player, true);
            placeTerritory.getPlaceUnits().addAll(unitsToPlace);
            LogUtils.log(Level.FINEST, t + ", placedUnits=" + unitsToPlace);
        }
        return PUsRemaining;
    }

    private int purchaseLandUnits(Map<Territory, ProPurchaseTerritory> purchaseTerritories, Map<Territory, ProAttackTerritoryData> enemyAttackMap, List<ProPlaceTerritory> prioritizedLandTerritories, int PUsRemaining, ProPurchaseOptionMap purchaseOptions, Map<Territory, Double> territoryValueMap) {
        List<Unit> unplacedUnits = this.player.getUnits().getMatches(Matches.UnitIsNotSea);
        if (PUsRemaining == 0 && unplacedUnits.isEmpty()) {
            return PUsRemaining;
        }
        LogUtils.log(Level.FINE, "Purchase land units with PUsRemaining=" + PUsRemaining);
        if (!unplacedUnits.isEmpty()) {
            LogUtils.log(Level.FINE, "Purchase land units with unplaced units=" + unplacedUnits);
        }
        for (ProPlaceTerritory placeTerritory : prioritizedLandTerritories) {
            Territory t = placeTerritory.getTerritory();
            LogUtils.log(Level.FINER, "Checking land place for " + t.getName());
            int remainingUnitProduction = purchaseTerritories.get(t).getRemainingUnitProduction();
            LogUtils.log(Level.FINER, t + ", remainingUnitProduction=" + remainingUnitProduction);
            if (remainingUnitProduction <= 0) continue;
            List<ProPurchaseOption> landFodderOptions = this.purchaseUtils.findPurchaseOptionsForTerritory(this.player, purchaseOptions.getLandFodderOptions(), t);
            List<ProPurchaseOption> landAttackOptions = this.purchaseUtils.findPurchaseOptionsForTerritory(this.player, purchaseOptions.getLandAttackOptions(), t);
            List<ProPurchaseOption> landDefenseOptions = this.purchaseUtils.findPurchaseOptionsForTerritory(this.player, purchaseOptions.getLandDefenseOptions(), t);
            int enemyDistance = this.utils.getClosestEnemyOrNeutralLandTerritoryDistance(this.data, this.player, t, territoryValueMap);
            if (enemyDistance <= 0) {
                enemyDistance = 10;
            }
            int fodderPercent = 80 - enemyDistance * 5;
            LogUtils.log(Level.FINER, t + ", enemyDistance=" + enemyDistance + ", fodderPercent=" + fodderPercent);
            Set<Territory> neighbors = this.data.getMap().getNeighbors(t, 2, ProMatches.territoryCanMoveLandUnits(this.player, this.data, false));
            neighbors.add(t);
            ArrayList<Unit> ownedLocalUnits = new ArrayList<Unit>();
            for (Territory neighbor : neighbors) {
                ownedLocalUnits.addAll(neighbor.getUnits().getMatches(Matches.unitIsOwnedBy(this.player)));
            }
            ArrayList<Unit> unitsToPlace = new ArrayList<Unit>();
            Iterator<Unit> it = unplacedUnits.iterator();
            while (it.hasNext()) {
                Unit u = it.next();
                if (remainingUnitProduction <= 0 || !this.purchaseUtils.canUnitsBePlaced(Collections.singletonList(u), this.player, t)) continue;
                --remainingUnitProduction;
                unitsToPlace.add(u);
                it.remove();
                LogUtils.log(Level.FINEST, "Selected unplaced unit=" + u);
            }
            int addedFodderUnits = 0;
            double attackAndDefenseDifference = 0.0;
            boolean selectFodderUnit = true;
            while (true) {
                this.purchaseUtils.removePurchaseOptionsByCostAndProductionAndLimits(this.player, this.startOfTurnData, landFodderOptions, PUsRemaining, remainingUnitProduction, unitsToPlace, purchaseTerritories);
                this.purchaseUtils.removePurchaseOptionsByCostAndProductionAndLimits(this.player, this.startOfTurnData, landAttackOptions, PUsRemaining, remainingUnitProduction, unitsToPlace, purchaseTerritories);
                this.purchaseUtils.removePurchaseOptionsByCostAndProductionAndLimits(this.player, this.startOfTurnData, landDefenseOptions, PUsRemaining, remainingUnitProduction, unitsToPlace, purchaseTerritories);
                ProPurchaseOption selectedOption = null;
                if (!selectFodderUnit && attackAndDefenseDifference > 0.0 && !landDefenseOptions.isEmpty()) {
                    HashMap<ProPurchaseOption, Double> defenseEfficiencies = new HashMap<ProPurchaseOption, Double>();
                    for (ProPurchaseOption ppo : landDefenseOptions) {
                        defenseEfficiencies.put(ppo, ppo.getDefenseEfficiency2(enemyDistance, this.data, ownedLocalUnits, unitsToPlace));
                    }
                    selectedOption = this.purchaseUtils.randomizePurchaseOption(defenseEfficiencies, "Land Defense");
                } else if (!selectFodderUnit && !landAttackOptions.isEmpty()) {
                    HashMap<ProPurchaseOption, Double> attackEfficiencies = new HashMap<ProPurchaseOption, Double>();
                    for (ProPurchaseOption ppo : landAttackOptions) {
                        attackEfficiencies.put(ppo, ppo.getAttackEfficiency2(enemyDistance, this.data, ownedLocalUnits, unitsToPlace));
                    }
                    selectedOption = this.purchaseUtils.randomizePurchaseOption(attackEfficiencies, "Land Attack");
                } else {
                    if (landFodderOptions.isEmpty()) break;
                    HashMap<ProPurchaseOption, Double> fodderEfficiencies = new HashMap<ProPurchaseOption, Double>();
                    for (ProPurchaseOption ppo : landFodderOptions) {
                        fodderEfficiencies.put(ppo, ppo.getFodderEfficiency(enemyDistance, this.data, ownedLocalUnits, unitsToPlace));
                    }
                    selectedOption = this.purchaseUtils.randomizePurchaseOption(fodderEfficiencies, "Land Fodder");
                    addedFodderUnits += selectedOption.getQuantity();
                }
                PUsRemaining -= selectedOption.getCost();
                remainingUnitProduction -= selectedOption.getQuantity();
                unitsToPlace.addAll(selectedOption.getUnitType().create(selectedOption.getQuantity(), this.player, true));
                attackAndDefenseDifference += selectedOption.getAttack() - selectedOption.getDefense();
                selectFodderUnit = (double)addedFodderUnits / (double)unitsToPlace.size() * 100.0 <= (double)fodderPercent;
                LogUtils.log(Level.FINEST, "Selected unit=" + selectedOption.getUnitType().getName());
            }
            placeTerritory.getPlaceUnits().addAll(unitsToPlace);
            LogUtils.log(Level.FINER, t + ", placedUnits=" + unitsToPlace);
        }
        return PUsRemaining;
    }

    private int purchaseFactory(Map<Territory, ProPurchaseTerritory> factoryPurchaseTerritories, Map<Territory, ProAttackTerritoryData> enemyAttackMap, int PUsRemaining, Map<Territory, ProPurchaseTerritory> purchaseTerritories, List<ProPlaceTerritory> prioritizedLandTerritories, ProPurchaseOptionMap purchaseOptions, boolean hasExtraPUs) {
        if (PUsRemaining == 0) {
            return PUsRemaining;
        }
        LogUtils.log(Level.FINE, "Purchase factory with PUsRemaining=" + PUsRemaining + ", hasExtraPUs=" + hasExtraPUs);
        for (ProPlaceTerritory placeTerritory : prioritizedLandTerritories) {
            for (Territory t : purchaseTerritories.keySet()) {
                if (!placeTerritory.getTerritory().equals(t) || purchaseTerritories.get(t).getRemainingUnitProduction() <= 0) continue;
                LogUtils.log(Level.FINER, "Not purchasing a factory since remaining land production in " + t);
                return PUsRemaining;
            }
        }
        List<Territory> possibleFactoryTerritories = Match.getMatches(this.data.getMap().getTerritories(), ProMatches.territoryHasNoInfraFactoryAndIsNotConqueredOwnedLand(this.player, this.data));
        possibleFactoryTerritories.removeAll(factoryPurchaseTerritories.keySet());
        HashSet<Territory> purchaseFactoryTerritories = new HashSet<Territory>();
        ArrayList<Territory> territoriesThatCantBeHeld = new ArrayList<Territory>();
        for (Territory t : possibleFactoryTerritories) {
            int production = TerritoryAttachment.get(t).getProduction();
            if (production < 3 && !hasExtraPUs || production < 2) continue;
            if (enemyAttackMap.get(t) == null) {
                purchaseFactoryTerritories.add(t);
                LogUtils.log(Level.FINEST, "Possible factory since no enemy attackers: " + t.getName());
                continue;
            }
            List<Unit> defenders = t.getUnits().getMatches(Matches.isUnitAllied(this.player, this.data));
            HashSet<Unit> enemyAttackingUnits = new HashSet<Unit>(enemyAttackMap.get(t).getMaxUnits());
            enemyAttackingUnits.addAll(enemyAttackMap.get(t).getMaxAmphibUnits());
            ProBattleResultData result = this.battleUtils.estimateDefendBattleResults(this.player, t, new ArrayList<Unit>(enemyAttackingUnits), defenders, enemyAttackMap.get(t).getMaxBombardUnits());
            if (result.isHasLandUnitRemaining() || result.getTUVSwing() > 0.0) {
                territoriesThatCantBeHeld.add(t);
                LogUtils.log(Level.FINEST, "Can't hold territory: " + t.getName() + ", hasLandUnitRemaining=" + result.isHasLandUnitRemaining() + ", TUVSwing=" + result.getTUVSwing() + ", enemyAttackers=" + enemyAttackingUnits.size() + ", myDefenders=" + defenders.size());
                continue;
            }
            purchaseFactoryTerritories.add(t);
            LogUtils.log(Level.FINEST, "Possible factory: " + t.getName() + ", hasLandUnitRemaining=" + result.isHasLandUnitRemaining() + ", TUVSwing=" + result.getTUVSwing() + ", enemyAttackers=" + enemyAttackingUnits.size() + ", myDefenders=" + defenders.size());
        }
        LogUtils.log(Level.FINER, "Possible factory territories: " + purchaseFactoryTerritories);
        if (!hasExtraPUs) {
            Iterator it = purchaseFactoryTerritories.iterator();
            while (it.hasNext()) {
                Territory t;
                t = (Territory)it.next();
                if (this.battleUtils.territoryHasLocalLandSuperiority(t, 3, this.player, purchaseTerritories)) continue;
                it.remove();
            }
            LogUtils.log(Level.FINER, "Possible factory territories that have land superiority: " + purchaseFactoryTerritories);
        }
        Map<Territory, Double> territoryValueMap = this.territoryValueUtils.findTerritoryValues(this.player, this.minCostPerHitPoint, territoriesThatCantBeHeld, new ArrayList<Territory>());
        double maxValue = 0.0;
        Territory maxTerritory = null;
        for (Territory t : purchaseFactoryTerritories) {
            int production = TerritoryAttachment.get(t).getProduction();
            double value = territoryValueMap.get(t) * (double)production + 0.1 * (double)production;
            boolean isAdjacentToSea = Matches.territoryHasNeighborMatching(this.data, Matches.TerritoryIsWater).match(t);
            Set<Territory> nearbyLandTerritories = this.data.getMap().getNeighbors(t, 9, ProMatches.territoryCanMoveLandUnits(this.player, this.data, false));
            int numNearbyEnemyTerritories = Match.countMatches(nearbyLandTerritories, Matches.isTerritoryEnemy(this.player, this.data));
            LogUtils.log(Level.FINEST, t + ", strategic value=" + territoryValueMap.get(t) + ", value=" + value + ", numNearbyEnemyTerritories=" + numNearbyEnemyTerritories);
            if (!(value > maxValue) || !(numNearbyEnemyTerritories >= 4 && territoryValueMap.get(t) >= 1.0) && (!isAdjacentToSea || !hasExtraPUs)) continue;
            maxValue = value;
            maxTerritory = t;
        }
        LogUtils.log(Level.FINER, "Try to purchase factory for territory: " + maxTerritory);
        if (maxTerritory != null) {
            int maxPlacedCost = 0;
            ProPlaceTerritory maxPlacedTerritory = null;
            Unit maxPlacedUnit = null;
            for (ProPlaceTerritory placeTerritory : prioritizedLandTerritories) {
                for (Unit u : placeTerritory.getPlaceUnits()) {
                    for (ProPurchaseOption ppo : purchaseOptions.getLandOptions()) {
                        if (!u.getType().equals(ppo.getUnitType()) || ppo.getQuantity() != 1 || ppo.getCost() < maxPlacedCost) continue;
                        maxPlacedCost = ppo.getCost();
                        maxPlacedTerritory = placeTerritory;
                        maxPlacedUnit = u;
                    }
                }
            }
            List<ProPurchaseOption> purchaseOptionsForTerritory = this.purchaseUtils.findPurchaseOptionsForTerritory(this.player, purchaseOptions.getFactoryOptions(), maxTerritory);
            this.purchaseUtils.removePurchaseOptionsByCostAndProductionAndLimits(this.player, this.startOfTurnData, purchaseOptionsForTerritory, PUsRemaining + maxPlacedCost, 1, new ArrayList<Unit>(), purchaseTerritories);
            ProPurchaseOption bestFactoryOption = null;
            double maxFactoryEfficiency = 0.0;
            for (ProPurchaseOption ppo : purchaseOptionsForTerritory) {
                if (ppo.getMovement() != 0 || !((double)ppo.getCost() > maxFactoryEfficiency)) continue;
                bestFactoryOption = ppo;
                maxFactoryEfficiency = ppo.getCost();
            }
            if (bestFactoryOption != null) {
                LogUtils.log(Level.FINER, "Best factory unit: " + bestFactoryOption.getUnitType().getName());
                ProPurchaseTerritory factoryPurchaseTerritory = new ProPurchaseTerritory(maxTerritory, this.data, this.player, 0);
                factoryPurchaseTerritories.put(maxTerritory, factoryPurchaseTerritory);
                for (ProPlaceTerritory ppt : factoryPurchaseTerritory.getCanPlaceTerritories()) {
                    if (!ppt.getTerritory().equals(maxTerritory)) continue;
                    List<Unit> factory = bestFactoryOption.getUnitType().create(bestFactoryOption.getQuantity(), this.player, true);
                    ppt.getPlaceUnits().addAll(factory);
                    if (PUsRemaining >= bestFactoryOption.getCost()) {
                        PUsRemaining -= bestFactoryOption.getCost();
                        LogUtils.log(Level.FINER, maxTerritory + ", placedFactory=" + factory);
                        continue;
                    }
                    PUsRemaining -= bestFactoryOption.getCost() - maxPlacedCost;
                    maxPlacedTerritory.getPlaceUnits().remove(maxPlacedUnit);
                    LogUtils.log(Level.FINER, maxTerritory + ", placedFactory=" + factory + ", removedUnit=" + maxPlacedUnit);
                }
            }
        }
        return PUsRemaining;
    }

    private List<ProPlaceTerritory> prioritizeSeaTerritories(Map<Territory, ProPurchaseTerritory> purchaseTerritories, Map<Territory, ProAttackTerritoryData> enemyAttackMap) {
        LogUtils.log(Level.FINE, "Prioritize sea territories");
        HashSet<ProPlaceTerritory> seaPlaceTerritories = new HashSet<ProPlaceTerritory>();
        for (ProPurchaseTerritory ppt : purchaseTerritories.values()) {
            for (ProPlaceTerritory placeTerritory : ppt.getCanPlaceTerritories()) {
                Territory t = placeTerritory.getTerritory();
                if (!t.isWater() || !(placeTerritory.getStrategicValue() > 0.0) || !placeTerritory.isCanHold()) continue;
                seaPlaceTerritories.add(placeTerritory);
            }
        }
        LogUtils.log(Level.FINER, "Determine sea place value:");
        for (ProPlaceTerritory placeTerritory : seaPlaceTerritories) {
            boolean hasLocalNavalSuperiority;
            double strengthDifference;
            Territory t = placeTerritory.getTerritory();
            ArrayList<Unit> units = new ArrayList<Unit>(placeTerritory.getDefendingUnits());
            units.addAll(ProPurchaseUtils.getPlaceUnits(t, purchaseTerritories));
            List<Unit> myUnits = Match.getMatches(units, Matches.unitIsOwnedBy(this.player));
            int numMyTransports = Match.countMatches(myUnits, Matches.UnitIsTransport);
            int numSeaDefenders = Match.countMatches(units, Matches.UnitIsNotTransport);
            int needDefenders = 0;
            if (enemyAttackMap.get(t) != null && (strengthDifference = this.battleUtils.estimateStrengthDifference(t, enemyAttackMap.get(t).getMaxUnits(), units)) > 50.0) {
                needDefenders = 1;
            }
            if (!(hasLocalNavalSuperiority = this.battleUtils.territoryHasLocalNavalSuperiority(t, this.player, null, new ArrayList<Unit>()))) {
                needDefenders = 1;
            }
            double territoryValue = placeTerritory.getStrategicValue() * ((double)(1 + numMyTransports) + 0.1 * (double)numSeaDefenders) / (double)(1 + 3 * needDefenders);
            LogUtils.log(Level.FINER, t + ", value=" + territoryValue + ", strategicValue=" + placeTerritory.getStrategicValue() + ", numMyTransports=" + numMyTransports + ", numSeaDefenders=" + numSeaDefenders + ", needDefenders=" + needDefenders);
            placeTerritory.setStrategicValue(territoryValue);
        }
        ArrayList<ProPlaceTerritory> sortedTerritories = new ArrayList<ProPlaceTerritory>(seaPlaceTerritories);
        Collections.sort(sortedTerritories, new Comparator<ProPlaceTerritory>(){

            @Override
            public int compare(ProPlaceTerritory t1, ProPlaceTerritory t2) {
                double value1 = t1.getStrategicValue();
                double value2 = t2.getStrategicValue();
                return Double.compare(value2, value1);
            }
        });
        LogUtils.log(Level.FINER, "Sorted sea territories:");
        for (ProPlaceTerritory placeTerritory : sortedTerritories) {
            LogUtils.log(Level.FINER, placeTerritory.toString() + " value=" + placeTerritory.getStrategicValue());
        }
        return sortedTerritories;
    }

    private int purchaseSeaAndAmphibUnits(Map<Territory, ProPurchaseTerritory> purchaseTerritories, Map<Territory, ProAttackTerritoryData> enemyAttackMap, List<ProPlaceTerritory> prioritizedSeaTerritories, Map<Territory, Double> territoryValueMap, int PUsRemaining, ProPurchaseOptionMap purchaseOptions) {
        if (PUsRemaining == 0) {
            return PUsRemaining;
        }
        LogUtils.log(Level.FINE, "Purchase sea and amphib units with PUsRemaining=" + PUsRemaining);
        for (ProPlaceTerritory placeTerritory : prioritizedSeaTerritories) {
            int numMyDestroyers;
            int landDistance;
            Territory t = placeTerritory.getTerritory();
            LogUtils.log(Level.FINER, "Checking sea place for " + t.getName());
            List<ProPurchaseTerritory> selectedPurchaseTerritories = this.getPurchaseTerritories(placeTerritory, purchaseTerritories);
            Set<Territory> neighbors = this.data.getMap().getNeighbors(t, 2, ProMatches.territoryCanMoveSeaUnits(this.player, this.data, false));
            neighbors.add(t);
            ArrayList<Unit> ownedLocalUnits = new ArrayList<Unit>();
            for (Territory neighbor : neighbors) {
                ownedLocalUnits.addAll(neighbor.getUnits().getMatches(Matches.unitIsOwnedBy(this.player)));
            }
            int unusedCarrierCapacity = Math.min(0, this.transportUtils.getUnusedCarrierCapacity(this.player, t, new ArrayList<Unit>()));
            int unusedLocalCarrierCapacity = this.transportUtils.getUnusedLocalCarrierCapacity(this.player, t, new ArrayList<Unit>());
            boolean needDestroyer = false;
            LogUtils.log(Level.FINEST, t + ", unusedCarrierCapacity=" + unusedCarrierCapacity + ", unusedLocalCarrierCapacity=" + unusedLocalCarrierCapacity);
            if (enemyAttackMap.get(t) != null) {
                if (Match.someMatch(enemyAttackMap.get(t).getMaxUnits(), Matches.UnitIsSub) && Match.noneMatch(t.getUnits().getMatches(Matches.unitIsOwnedBy(this.player)), Matches.UnitIsDestroyer)) {
                    needDestroyer = true;
                }
                LogUtils.log(Level.FINEST, t + ", needDestroyer=" + needDestroyer + ", checking defense since has enemy attackers: " + enemyAttackMap.get(t).getMaxUnits());
                int PUsSpent = 0;
                ArrayList<Unit> unitsToPlace = new ArrayList<Unit>();
                ArrayList<Unit> initialDefendingUnits = new ArrayList<Unit>(placeTerritory.getDefendingUnits());
                initialDefendingUnits.addAll(ProPurchaseUtils.getPlaceUnits(t, purchaseTerritories));
                ProBattleResultData result = this.battleUtils.calculateBattleResults(this.player, t, enemyAttackMap.get(t).getMaxUnits(), initialDefendingUnits, enemyAttackMap.get(t).getMaxBombardUnits(), false);
                boolean hasOnlyRetreatingSubs = Properties.getSubRetreatBeforeBattle(this.data) && Match.allMatch(initialDefendingUnits, Matches.UnitIsSub) && Match.noneMatch(enemyAttackMap.get(t).getMaxUnits(), Matches.UnitIsDestroyer);
                block2: for (ProPurchaseTerritory purchaseTerritory : selectedPurchaseTerritories) {
                    int remainingUnitProduction = purchaseTerritory.getRemainingUnitProduction();
                    LogUtils.log(Level.FINEST, t + ", purchaseTerritory=" + purchaseTerritory.getTerritory() + ", remainingUnitProduction=" + remainingUnitProduction);
                    if (remainingUnitProduction <= 0) continue;
                    List<ProPurchaseOption> seaPurchaseOptionsForTerritory = this.purchaseUtils.findPurchaseOptionsForTerritory(this.player, purchaseOptions.getSeaDefenseOptions(), t);
                    seaPurchaseOptionsForTerritory.addAll(purchaseOptions.getAirOptions());
                    while (true) {
                        this.purchaseUtils.removePurchaseOptionsByCostAndProductionAndLimits(this.player, this.startOfTurnData, seaPurchaseOptionsForTerritory, PUsRemaining - PUsSpent, remainingUnitProduction, unitsToPlace, purchaseTerritories);
                        if (seaPurchaseOptionsForTerritory.isEmpty() || !hasOnlyRetreatingSubs && (result.getTUVSwing() < -1.0 || result.getWinPercentage() < 95.0)) continue block2;
                        HashMap<ProPurchaseOption, Double> defenseEfficiencies = new HashMap<ProPurchaseOption, Double>();
                        for (ProPurchaseOption ppo : seaPurchaseOptionsForTerritory) {
                            defenseEfficiencies.put(ppo, ppo.getSeaDefenseEfficiency(this.data, ownedLocalUnits, unitsToPlace, needDestroyer, unusedCarrierCapacity, unusedLocalCarrierCapacity));
                        }
                        ProPurchaseOption selectedOption = this.purchaseUtils.randomizePurchaseOption(defenseEfficiencies, "Sea Defense");
                        if (selectedOption.isDestroyer()) {
                            needDestroyer = false;
                        }
                        PUsSpent += selectedOption.getCost();
                        remainingUnitProduction -= selectedOption.getQuantity();
                        unitsToPlace.addAll(selectedOption.getUnitType().create(selectedOption.getQuantity(), this.player, true));
                        if (selectedOption.isCarrier() || selectedOption.isAir()) {
                            unusedCarrierCapacity = this.transportUtils.getUnusedCarrierCapacity(this.player, t, unitsToPlace);
                            unusedLocalCarrierCapacity = this.transportUtils.getUnusedLocalCarrierCapacity(this.player, t, unitsToPlace);
                        }
                        LogUtils.log(Level.FINEST, t + ", added sea defender for defense: " + selectedOption.getUnitType().getName() + ", TUVSwing=" + result.getTUVSwing() + ", win%=" + result.getWinPercentage() + ", unusedCarrierCapacity=" + unusedCarrierCapacity + ", unusedLocalCarrierCapacity=" + unusedLocalCarrierCapacity);
                        ArrayList<Unit> defendingUnits = new ArrayList<Unit>(placeTerritory.getDefendingUnits());
                        defendingUnits.addAll(ProPurchaseUtils.getPlaceUnits(t, purchaseTerritories));
                        defendingUnits.addAll(unitsToPlace);
                        result = this.battleUtils.estimateDefendBattleResults(this.player, t, enemyAttackMap.get(t).getMaxUnits(), defendingUnits, enemyAttackMap.get(t).getMaxBombardUnits());
                        hasOnlyRetreatingSubs = Properties.getSubRetreatBeforeBattle(this.data) && Match.allMatch(defendingUnits, Matches.UnitIsSub) && Match.noneMatch(enemyAttackMap.get(t).getMaxUnits(), Matches.UnitIsDestroyer);
                    }
                }
                if (result.getTUVSwing() < 0.0 || result.getWinPercentage() < 95.0) {
                    PUsRemaining -= PUsSpent;
                    LogUtils.log(Level.FINEST, t + ", placedUnits=" + unitsToPlace + ", TUVSwing=" + result.getTUVSwing() + ", hasLandUnitRemaining=" + result.isHasLandUnitRemaining());
                    this.addUnitsToPlaceTerritory(placeTerritory, unitsToPlace, purchaseTerritories);
                } else {
                    this.setCantHoldPlaceTerritory(placeTerritory, purchaseTerritories);
                    LogUtils.log(Level.FINEST, t + ", can't defend TUVSwing=" + result.getTUVSwing() + ", win%=" + result.getWinPercentage() + ", tried to placeDefenders=" + unitsToPlace + ", enemyAttackers=" + enemyAttackMap.get(t).getMaxUnits());
                    continue;
                }
            }
            if ((landDistance = this.utils.getClosestEnemyLandTerritoryDistanceOverWater(this.data, this.player, t)) <= 0) {
                landDistance = 10;
            }
            int enemyDistance = Math.max(3, landDistance + 1);
            int alliedDistance = (enemyDistance + 1) / 2;
            Set<Territory> nearbyTerritories = this.data.getMap().getNeighbors(t, enemyDistance, ProMatches.territoryCanMoveAirUnits(this.player, this.data, false));
            List<Territory> nearbyLandTerritories = Match.getMatches(nearbyTerritories, Matches.TerritoryIsLand);
            Set<Territory> nearbyEnemySeaTerritories = this.data.getMap().getNeighbors(t, enemyDistance, Matches.TerritoryIsWater);
            nearbyEnemySeaTerritories.add(t);
            Set<Territory> nearbyAlliedSeaTerritories = this.data.getMap().getNeighbors(t, alliedDistance, Matches.TerritoryIsWater);
            nearbyAlliedSeaTerritories.add(t);
            ArrayList<Unit> enemyUnitsInSeaTerritories = new ArrayList<Unit>();
            ArrayList<Unit> enemyUnitsInLandTerritories = new ArrayList<Unit>();
            ArrayList<Unit> myUnitsInSeaTerritories = new ArrayList<Unit>();
            ArrayList<Unit> alliedUnitsInSeaTerritories = new ArrayList<Unit>();
            for (Territory nearbyLandTerritory : nearbyLandTerritories) {
                enemyUnitsInLandTerritories.addAll(nearbyLandTerritory.getUnits().getMatches(ProMatches.unitIsEnemyAir(this.player, this.data)));
            }
            for (Territory nearbySeaTerritory : nearbyEnemySeaTerritories) {
                int routeLength;
                Route route;
                List<Unit> enemySeaUnits = nearbySeaTerritory.getUnits().getMatches(ProMatches.unitIsEnemyNotLand(this.player, this.data));
                if (enemySeaUnits.isEmpty() || (route = this.data.getMap().getRoute_IgnoreEnd(t, nearbySeaTerritory, Matches.TerritoryIsWater)) == null || MoveValidator.validateCanal(route, enemySeaUnits, enemySeaUnits.get(0).getOwner(), this.data) != null || (routeLength = route.numberOfSteps()) > enemyDistance) continue;
                enemyUnitsInSeaTerritories.addAll(enemySeaUnits);
            }
            for (Territory nearbySeaTerritory : nearbyAlliedSeaTerritories) {
                myUnitsInSeaTerritories.addAll(nearbySeaTerritory.getUnits().getMatches(ProMatches.unitIsOwnedNotLand(this.player, this.data)));
                myUnitsInSeaTerritories.addAll(ProPurchaseUtils.getPlaceUnits(nearbySeaTerritory, purchaseTerritories));
                alliedUnitsInSeaTerritories.addAll(nearbySeaTerritory.getUnits().getMatches(ProMatches.unitIsAlliedNotOwned(this.player, this.data)));
            }
            int numEnemySubs = Match.countMatches(enemyUnitsInSeaTerritories, Matches.UnitIsSub);
            if (numEnemySubs > 2 * (numMyDestroyers = Match.countMatches(myUnitsInSeaTerritories, Matches.UnitIsDestroyer))) {
                needDestroyer = true;
            }
            LogUtils.log(Level.FINEST, t + ", enemyDistance=" + enemyDistance + ", alliedDistance=" + alliedDistance + ", enemyAirUnits=" + enemyUnitsInLandTerritories + ", enemySeaUnits=" + enemyUnitsInSeaTerritories + ", mySeaUnits=" + myUnitsInSeaTerritories + ", needDestroyer=" + needDestroyer);
            ArrayList<Unit> unitsToPlace = new ArrayList<Unit>();
            block8: for (ProPurchaseTerritory purchaseTerritory : selectedPurchaseTerritories) {
                int remainingUnitProduction = purchaseTerritory.getRemainingUnitProduction();
                LogUtils.log(Level.FINEST, t + ", purchaseTerritory=" + purchaseTerritory.getTerritory() + ", remainingUnitProduction=" + remainingUnitProduction);
                if (remainingUnitProduction <= 0) continue;
                List<ProPurchaseOption> seaPurchaseOptionsForTerritory = this.purchaseUtils.findPurchaseOptionsForTerritory(this.player, purchaseOptions.getSeaDefenseOptions(), t);
                seaPurchaseOptionsForTerritory.addAll(purchaseOptions.getAirOptions());
                while (true) {
                    this.purchaseUtils.removePurchaseOptionsByCostAndProductionAndLimits(this.player, this.startOfTurnData, seaPurchaseOptionsForTerritory, PUsRemaining, remainingUnitProduction, unitsToPlace, purchaseTerritories);
                    if (seaPurchaseOptionsForTerritory.isEmpty() || this.battleUtils.territoryHasLocalNavalSuperiority(t, this.player, purchaseTerritories, unitsToPlace)) continue block8;
                    HashMap<ProPurchaseOption, Double> defenseEfficiencies = new HashMap<ProPurchaseOption, Double>();
                    for (ProPurchaseOption ppo : seaPurchaseOptionsForTerritory) {
                        defenseEfficiencies.put(ppo, ppo.getSeaDefenseEfficiency(this.data, ownedLocalUnits, unitsToPlace, needDestroyer, unusedCarrierCapacity, unusedLocalCarrierCapacity));
                    }
                    ProPurchaseOption selectedOption = this.purchaseUtils.randomizePurchaseOption(defenseEfficiencies, "Sea Defense");
                    if (selectedOption.isDestroyer()) {
                        needDestroyer = false;
                    }
                    PUsRemaining -= selectedOption.getCost();
                    remainingUnitProduction -= selectedOption.getQuantity();
                    unitsToPlace.addAll(selectedOption.getUnitType().create(selectedOption.getQuantity(), this.player, true));
                    if (selectedOption.isCarrier() || selectedOption.isAir()) {
                        unusedCarrierCapacity = this.transportUtils.getUnusedCarrierCapacity(this.player, t, unitsToPlace);
                        unusedLocalCarrierCapacity = this.transportUtils.getUnusedLocalCarrierCapacity(this.player, t, unitsToPlace);
                    }
                    LogUtils.log(Level.FINEST, t + ", added sea defender for naval superiority: " + selectedOption.getUnitType().getName() + ", unusedCarrierCapacity=" + unusedCarrierCapacity + ", unusedLocalCarrierCapacity=" + unusedLocalCarrierCapacity);
                }
            }
            this.addUnitsToPlaceTerritory(placeTerritory, unitsToPlace, purchaseTerritories);
            int distance = this.transportUtils.findMaxMovementForTransports(purchaseOptions.getSeaTransportOptions());
            LogUtils.log(Level.FINEST, t + ", transportMovement=" + distance);
            for (ProPurchaseTerritory purchaseTerritory : selectedPurchaseTerritories) {
                Territory landTerritory = purchaseTerritory.getTerritory();
                int remainingUnitProduction = purchaseTerritory.getRemainingUnitProduction();
                LogUtils.log(Level.FINEST, t + ", purchaseTerritory=" + landTerritory + ", remainingUnitProduction=" + remainingUnitProduction);
                if (remainingUnitProduction <= 0) continue;
                List<Unit> ownedLocalAmphibUnits = landTerritory.getUnits().getMatches(Matches.unitIsOwnedBy(this.player));
                List<ProPurchaseOption> seaTransportPurchaseOptionsForTerritory = this.purchaseUtils.findPurchaseOptionsForTerritory(this.player, purchaseOptions.getSeaTransportOptions(), t);
                List<ProPurchaseOption> amphibPurchaseOptionsForTerritory = this.purchaseUtils.findPurchaseOptionsForTerritory(this.player, purchaseOptions.getLandOptions(), landTerritory);
                ArrayList<Unit> transportsThatNeedUnits = new ArrayList<Unit>();
                HashSet<Unit> potentialUnitsToLoad = new HashSet<Unit>();
                Set<Territory> seaTerritories = this.data.getMap().getNeighbors(landTerritory, distance, ProMatches.territoryCanMoveSeaUnits(this.player, this.data, false));
                for (Territory seaTerritory : seaTerritories) {
                    List<Unit> unitsInTerritory = ProPurchaseUtils.getPlaceUnits(seaTerritory, purchaseTerritories);
                    unitsInTerritory.addAll(seaTerritory.getUnits().getUnits());
                    List<Unit> transports = Match.getMatches(unitsInTerritory, ProMatches.unitIsOwnedTransport(this.player));
                    for (Unit transport : transports) {
                        transportsThatNeedUnits.add(transport);
                        HashSet<Territory> territoriesToLoadFrom = new HashSet<Territory>(this.data.getMap().getNeighbors(seaTerritory, distance));
                        Iterator it = territoriesToLoadFrom.iterator();
                        while (it.hasNext()) {
                            Territory potentialTerritory = (Territory)it.next();
                            if (!potentialTerritory.isWater() && !(territoryValueMap.get(potentialTerritory) > 0.25)) continue;
                            it.remove();
                        }
                        List<Unit> units = this.transportUtils.getUnitsToTransportFromTerritories(this.player, transport, territoriesToLoadFrom, new ArrayList<Unit>(potentialUnitsToLoad), ProMatches.unitIsOwnedCombatTransportableUnit(this.player));
                        potentialUnitsToLoad.addAll(units);
                    }
                }
                Set<Territory> landNeighbors = this.data.getMap().getNeighbors(t, Matches.TerritoryIsLand);
                for (Territory neighbor : landNeighbors) {
                    if (!(territoryValueMap.get(neighbor) <= 0.25)) continue;
                    ArrayList<Unit> unitsInTerritory = new ArrayList<Unit>(neighbor.getUnits().getUnits());
                    unitsInTerritory.addAll(ProPurchaseUtils.getPlaceUnits(neighbor, purchaseTerritories));
                    potentialUnitsToLoad.addAll(Match.getMatches(unitsInTerritory, ProMatches.unitIsOwnedCombatTransportableUnit(this.player)));
                }
                LogUtils.log(Level.FINEST, t + ", potentialUnitsToLoad=" + potentialUnitsToLoad + ", transportsThatNeedUnits=" + transportsThatNeedUnits);
                ArrayList<Unit> amphibUnitsToPlace = new ArrayList<Unit>();
                ArrayList<Unit> transportUnitsToPlace = new ArrayList<Unit>();
                while (true) {
                    if (!transportsThatNeedUnits.isEmpty()) {
                        Unit transport = (Unit)transportsThatNeedUnits.get(0);
                        int transportCapacity = UnitAttachment.get(transport.getType()).getTransportCapacity();
                        List<Unit> selectedUnits = this.transportUtils.selectUnitsToTransportFromList(transport, new ArrayList<Unit>(potentialUnitsToLoad));
                        if (!selectedUnits.isEmpty()) {
                            potentialUnitsToLoad.removeAll(selectedUnits);
                            transportCapacity -= this.transportUtils.findUnitsTransportCost(selectedUnits);
                        }
                        while (transportCapacity > 0) {
                            this.purchaseUtils.removePurchaseOptionsByCostAndProductionAndLimits(this.player, this.startOfTurnData, amphibPurchaseOptionsForTerritory, PUsRemaining, remainingUnitProduction, amphibUnitsToPlace, purchaseTerritories);
                            if (amphibPurchaseOptionsForTerritory.isEmpty()) break;
                            HashMap<ProPurchaseOption, Double> amphibEfficiencies = new HashMap<ProPurchaseOption, Double>();
                            for (ProPurchaseOption ppo : amphibPurchaseOptionsForTerritory) {
                                if (ppo.getTransportCost() > transportCapacity) continue;
                                amphibEfficiencies.put(ppo, ppo.getAmphibEfficiency(this.data, ownedLocalAmphibUnits, amphibUnitsToPlace));
                            }
                            if (amphibEfficiencies.isEmpty()) break;
                            ProPurchaseOption ppo = this.purchaseUtils.randomizePurchaseOption(amphibEfficiencies, "Amphib");
                            List<Unit> amphibUnits = ppo.getUnitType().create(ppo.getQuantity(), this.player, true);
                            amphibUnitsToPlace.addAll(amphibUnits);
                            PUsRemaining -= ppo.getCost();
                            remainingUnitProduction -= ppo.getQuantity();
                            transportCapacity -= ppo.getTransportCost();
                            LogUtils.log(Level.FINEST, "Selected unit=" + ppo.getUnitType().getName());
                        }
                        transportsThatNeedUnits.remove(transport);
                        continue;
                    }
                    this.purchaseUtils.removePurchaseOptionsByCostAndProductionAndLimits(this.player, this.startOfTurnData, seaTransportPurchaseOptionsForTerritory, PUsRemaining, remainingUnitProduction, transportUnitsToPlace, purchaseTerritories);
                    if (seaTransportPurchaseOptionsForTerritory.isEmpty()) break;
                    HashMap<ProPurchaseOption, Double> transportEfficiencies = new HashMap<ProPurchaseOption, Double>();
                    for (ProPurchaseOption ppo : seaTransportPurchaseOptionsForTerritory) {
                        transportEfficiencies.put(ppo, ppo.getTransportEfficiency(this.data));
                    }
                    ProPurchaseOption ppo = this.purchaseUtils.randomizePurchaseOption(transportEfficiencies, "Sea Transport");
                    List<Unit> transports = ppo.getUnitType().create(ppo.getQuantity(), this.player, true);
                    transportUnitsToPlace.addAll(transports);
                    PUsRemaining -= ppo.getCost();
                    remainingUnitProduction -= ppo.getQuantity();
                    transportsThatNeedUnits.addAll(transports);
                    LogUtils.log(Level.FINEST, "Selected unit=" + ppo.getUnitType().getName() + ", potentialUnitsToLoad=" + potentialUnitsToLoad + ", transportsThatNeedUnits=" + transportsThatNeedUnits);
                }
                for (ProPlaceTerritory ppt : purchaseTerritory.getCanPlaceTerritories()) {
                    if (landTerritory.equals(ppt.getTerritory())) {
                        ppt.getPlaceUnits().addAll(amphibUnitsToPlace);
                        continue;
                    }
                    if (!placeTerritory.equals(ppt)) continue;
                    ppt.getPlaceUnits().addAll(transportUnitsToPlace);
                }
                LogUtils.log(Level.FINEST, t + ", purchaseTerritory=" + landTerritory + ", transportUnitsToPlace=" + transportUnitsToPlace + ", amphibUnitsToPlace=" + amphibUnitsToPlace);
            }
        }
        return PUsRemaining;
    }

    private int purchaseUnitsWithRemainingProduction(Map<Territory, ProPurchaseTerritory> purchaseTerritories, int PUsRemaining, List<ProPurchaseOption> landPurchaseOptions, List<ProPurchaseOption> airPurchaseOptions) {
        List<Unit> newUnit;
        Territory t;
        if (PUsRemaining == 0) {
            return PUsRemaining;
        }
        LogUtils.log(Level.FINE, "Purchase units in territories with remaining production with PUsRemaining=" + PUsRemaining);
        ArrayList<ProPlaceTerritory> prioritizedLandTerritories = new ArrayList<ProPlaceTerritory>();
        ArrayList<ProPlaceTerritory> prioritizedCantHoldLandTerritories = new ArrayList<ProPlaceTerritory>();
        for (ProPurchaseTerritory ppt : purchaseTerritories.values()) {
            for (ProPlaceTerritory placeTerritory : ppt.getCanPlaceTerritories()) {
                Territory t2 = placeTerritory.getTerritory();
                if (!t2.isWater() && placeTerritory.isCanHold() && purchaseTerritories.get(t2).getRemainingUnitProduction() > 0) {
                    prioritizedLandTerritories.add(placeTerritory);
                    continue;
                }
                if (t2.isWater() || purchaseTerritories.get(t2).getRemainingUnitProduction() <= 0) continue;
                prioritizedCantHoldLandTerritories.add(placeTerritory);
            }
        }
        Collections.sort(prioritizedLandTerritories, new Comparator<ProPlaceTerritory>(){

            @Override
            public int compare(ProPlaceTerritory t1, ProPlaceTerritory t2) {
                double value1 = t1.getStrategicValue();
                double value2 = t2.getStrategicValue();
                return Double.compare(value2, value1);
            }
        });
        LogUtils.log(Level.FINER, "Sorted land territories with remaining production: " + prioritizedLandTerritories);
        block2: for (ProPlaceTerritory placeTerritory : prioritizedLandTerritories) {
            t = placeTerritory.getTerritory();
            LogUtils.log(Level.FINER, "Checking territory: " + t);
            ArrayList<ProPurchaseOption> airAndLandPurchaseOptions = new ArrayList<ProPurchaseOption>(airPurchaseOptions);
            airAndLandPurchaseOptions.addAll(landPurchaseOptions);
            List<ProPurchaseOption> purchaseOptionsForTerritory = this.purchaseUtils.findPurchaseOptionsForTerritory(this.player, airAndLandPurchaseOptions, t);
            int remainingUnitProduction = purchaseTerritories.get(t).getRemainingUnitProduction();
            while (true) {
                this.purchaseUtils.removePurchaseOptionsByCostAndProductionAndLimits(this.player, this.startOfTurnData, purchaseOptionsForTerritory, PUsRemaining, remainingUnitProduction, new ArrayList<Unit>(), purchaseTerritories);
                if (purchaseOptionsForTerritory.isEmpty()) continue block2;
                ProPurchaseOption bestAttackOption = null;
                double maxAttackEfficiency = 0.0;
                for (ProPurchaseOption ppo : purchaseOptionsForTerritory) {
                    double attackEfficiency = ppo.getAttackEfficiency() * (double)ppo.getMovement() / (double)ppo.getQuantity();
                    if (ppo.isAir()) {
                        attackEfficiency *= 10.0;
                    }
                    if (!(attackEfficiency > maxAttackEfficiency)) continue;
                    bestAttackOption = ppo;
                    maxAttackEfficiency = attackEfficiency;
                }
                if (bestAttackOption == null) continue block2;
                PUsRemaining -= bestAttackOption.getCost();
                remainingUnitProduction -= bestAttackOption.getQuantity();
                newUnit = bestAttackOption.getUnitType().create(bestAttackOption.getQuantity(), this.player, true);
                placeTerritory.getPlaceUnits().addAll(newUnit);
                LogUtils.log(Level.FINEST, t + ", addedUnit=" + newUnit);
            }
        }
        Collections.sort(prioritizedCantHoldLandTerritories, new Comparator<ProPlaceTerritory>(){

            @Override
            public int compare(ProPlaceTerritory t1, ProPlaceTerritory t2) {
                double value1 = t1.getDefenseValue();
                double value2 = t2.getDefenseValue();
                return Double.compare(value2, value1);
            }
        });
        LogUtils.log(Level.FINER, "Sorted can't hold land territories with remaining production: " + prioritizedCantHoldLandTerritories);
        block5: for (ProPlaceTerritory placeTerritory : prioritizedCantHoldLandTerritories) {
            t = placeTerritory.getTerritory();
            LogUtils.log(Level.FINER, "Checking territory: " + t);
            List<Unit> ownedLocalUnits = t.getUnits().getMatches(Matches.unitIsOwnedBy(this.player));
            ArrayList<ProPurchaseOption> airAndLandPurchaseOptions = new ArrayList<ProPurchaseOption>(airPurchaseOptions);
            airAndLandPurchaseOptions.addAll(landPurchaseOptions);
            List<ProPurchaseOption> purchaseOptionsForTerritory = this.purchaseUtils.findPurchaseOptionsForTerritory(this.player, airAndLandPurchaseOptions, t);
            int remainingUnitProduction = purchaseTerritories.get(t).getRemainingUnitProduction();
            while (true) {
                this.purchaseUtils.removePurchaseOptionsByCostAndProductionAndLimits(this.player, this.startOfTurnData, purchaseOptionsForTerritory, PUsRemaining, remainingUnitProduction, new ArrayList<Unit>(), purchaseTerritories);
                if (purchaseOptionsForTerritory.isEmpty()) continue block5;
                HashMap<ProPurchaseOption, Double> defenseEfficiencies = new HashMap<ProPurchaseOption, Double>();
                for (ProPurchaseOption ppo : purchaseOptionsForTerritory) {
                    defenseEfficiencies.put(ppo, Math.pow(ppo.getCost(), 2.0) * ppo.getDefenseEfficiency2(1, this.data, ownedLocalUnits, placeTerritory.getPlaceUnits()));
                }
                ProPurchaseOption selectedOption = this.purchaseUtils.randomizePurchaseOption(defenseEfficiencies, "Defense");
                PUsRemaining -= selectedOption.getCost();
                remainingUnitProduction -= selectedOption.getQuantity();
                newUnit = selectedOption.getUnitType().create(selectedOption.getQuantity(), this.player, true);
                placeTerritory.getPlaceUnits().addAll(newUnit);
                LogUtils.log(Level.FINEST, t + ", addedUnit=" + newUnit);
            }
        }
        return PUsRemaining;
    }

    private int upgradeUnitsWithRemainingPUs(Map<Territory, ProPurchaseTerritory> purchaseTerritories, int PUsRemaining, ProPurchaseOptionMap purchaseOptions) {
        if (PUsRemaining == 0) {
            return PUsRemaining;
        }
        LogUtils.log(Level.FINE, "Upgrade units with PUsRemaining=" + PUsRemaining);
        ArrayList<ProPlaceTerritory> prioritizedLandTerritories = new ArrayList<ProPlaceTerritory>();
        for (ProPurchaseTerritory ppt : purchaseTerritories.values()) {
            for (ProPlaceTerritory placeTerritory : ppt.getCanPlaceTerritories()) {
                Territory t = placeTerritory.getTerritory();
                if (t.isWater() || !placeTerritory.isCanHold()) continue;
                prioritizedLandTerritories.add(placeTerritory);
            }
        }
        Collections.sort(prioritizedLandTerritories, new Comparator<ProPlaceTerritory>(){

            @Override
            public int compare(ProPlaceTerritory t1, ProPlaceTerritory t2) {
                double value1 = t1.getStrategicValue();
                double value2 = t2.getStrategicValue();
                return Double.compare(value1, value2);
            }
        });
        LogUtils.log(Level.FINER, "Sorted land territories: " + prioritizedLandTerritories);
        block2: for (ProPlaceTerritory placeTerritory : prioritizedLandTerritories) {
            Territory t = placeTerritory.getTerritory();
            LogUtils.log(Level.FINER, "Checking territory: " + t);
            ArrayList<ProPurchaseOption> airAndLandPurchaseOptions = new ArrayList<ProPurchaseOption>(purchaseOptions.getAirOptions());
            airAndLandPurchaseOptions.addAll(purchaseOptions.getLandOptions());
            List<ProPurchaseOption> purchaseOptionsForTerritory = this.purchaseUtils.findPurchaseOptionsForTerritory(this.player, airAndLandPurchaseOptions, t);
            int remainingUpgradeUnits = purchaseTerritories.get(t).getUnitProduction() / 3;
            while (remainingUpgradeUnits > 0) {
                int minPlacedCost = Integer.MAX_VALUE;
                ProPurchaseOption minPurchaseOption = null;
                for (Unit u : placeTerritory.getPlaceUnits()) {
                    for (ProPurchaseOption ppo : airAndLandPurchaseOptions) {
                        if (!u.getType().equals(ppo.getUnitType()) || ppo.getCost() >= minPlacedCost) continue;
                        minPlacedCost = ppo.getCost();
                        minPurchaseOption = ppo;
                    }
                }
                if (minPurchaseOption == null) continue block2;
                this.purchaseUtils.removePurchaseOptionsByCostAndProductionAndLimits(this.player, this.startOfTurnData, purchaseOptionsForTerritory, PUsRemaining + minPlacedCost, 1, new ArrayList<Unit>(), purchaseTerritories);
                if (purchaseOptionsForTerritory.isEmpty()) continue block2;
                ProPurchaseOption bestAttackOption = null;
                double maxAttackEfficiency = minPurchaseOption.getAttackEfficiency() * (double)minPurchaseOption.getMovement() * (double)minPurchaseOption.getCost() / (double)minPurchaseOption.getQuantity();
                for (ProPurchaseOption ppo : purchaseOptionsForTerritory) {
                    if (ppo.getCost() <= minPlacedCost || !ppo.isAir() && !(placeTerritory.getStrategicValue() >= 0.25) && ppo.getTransportCost() > minPurchaseOption.getTransportCost()) continue;
                    double attackEfficiency = ppo.getAttackEfficiency() * (double)ppo.getMovement() * (double)ppo.getCost() / (double)ppo.getQuantity();
                    if (ppo.isAir()) {
                        attackEfficiency *= 10.0;
                    }
                    if (ppo.getCarrierCost() > 0) {
                        int unusedLocalCarrierCapacity = this.transportUtils.getUnusedLocalCarrierCapacity(this.player, t, placeTerritory.getPlaceUnits());
                        int neededFighters = unusedLocalCarrierCapacity / ppo.getCarrierCost();
                        attackEfficiency *= (double)(1 + neededFighters);
                    }
                    if (!(attackEfficiency > maxAttackEfficiency)) continue;
                    bestAttackOption = ppo;
                    maxAttackEfficiency = attackEfficiency;
                }
                if (bestAttackOption == null) {
                    airAndLandPurchaseOptions.remove(minPurchaseOption);
                    continue;
                }
                ArrayList<Unit> unitsToRemove = new ArrayList<Unit>();
                int numUnitsToRemove = minPurchaseOption.getQuantity();
                for (Unit u : placeTerritory.getPlaceUnits()) {
                    if (numUnitsToRemove <= 0) break;
                    if (!u.getType().equals(minPurchaseOption.getUnitType())) continue;
                    unitsToRemove.add(u);
                    --numUnitsToRemove;
                }
                if (numUnitsToRemove > 0) {
                    airAndLandPurchaseOptions.remove(minPurchaseOption);
                    continue;
                }
                PUsRemaining += minPurchaseOption.getCost();
                remainingUpgradeUnits -= minPurchaseOption.getQuantity();
                placeTerritory.getPlaceUnits().removeAll(unitsToRemove);
                LogUtils.log(Level.FINEST, t + ", removedUnits=" + unitsToRemove);
                for (int i = 0; i < unitsToRemove.size(); ++i) {
                    if (PUsRemaining < bestAttackOption.getCost()) continue;
                    PUsRemaining -= bestAttackOption.getCost();
                    List<Unit> newUnit = bestAttackOption.getUnitType().create(bestAttackOption.getQuantity(), this.player, true);
                    placeTerritory.getPlaceUnits().addAll(newUnit);
                    LogUtils.log(Level.FINEST, t + ", addedUnit=" + newUnit);
                }
            }
        }
        return PUsRemaining;
    }

    private IntegerMap<ProductionRule> populateProductionRuleMap(Map<Territory, ProPurchaseTerritory> purchaseTerritories, ProPurchaseOptionMap purchaseOptions) {
        LogUtils.log(Level.FINE, "Populate production rule map");
        List<Unit> unplacedUnits = this.player.getUnits().getMatches(Matches.UnitIsNotSea);
        IntegerMap<ProductionRule> purchaseMap = new IntegerMap<ProductionRule>();
        for (ProPurchaseOption ppo : purchaseOptions.getAllOptions()) {
            int numUnits = 0;
            for (Territory t : purchaseTerritories.keySet()) {
                for (ProPlaceTerritory ppt : purchaseTerritories.get(t).getCanPlaceTerritories()) {
                    for (Unit u : ppt.getPlaceUnits()) {
                        if (!u.getUnitType().equals(ppo.getUnitType()) || unplacedUnits.contains(u)) continue;
                        ++numUnits;
                    }
                }
            }
            if (numUnits <= 0) continue;
            int numProductionRule = numUnits / ppo.getQuantity();
            purchaseMap.put(ppo.getProductionRule(), numProductionRule);
            LogUtils.log(Level.FINE, numProductionRule + " " + ppo.getProductionRule());
        }
        return purchaseMap;
    }

    private void placeDefenders(Map<Territory, ProPurchaseTerritory> placeNonConstructionTerritories, Map<Territory, ProAttackTerritoryData> enemyAttackMap, List<ProPlaceTerritory> needToDefendTerritories, IAbstractPlaceDelegate placeDelegate) {
        LogUtils.log(Level.FINE, "Place defenders with units=" + this.player.getUnits().getUnits());
        for (ProPlaceTerritory placeTerritory : needToDefendTerritories) {
            Territory t = placeTerritory.getTerritory();
            LogUtils.log(Level.FINER, "Placing defenders for " + t.getName() + ", enemyAttackers=" + enemyAttackMap.get(t).getMaxUnits() + ", amphibEnemyAttackers=" + enemyAttackMap.get(t).getMaxAmphibUnits() + ", defenders=" + placeTerritory.getDefendingUnits());
            PlaceableUnits placeableUnits = placeDelegate.getPlaceableUnits(this.player.getUnits().getMatches(Matches.UnitIsNotConstruction), t);
            if (placeableUnits.isError()) {
                LogUtils.log(Level.FINEST, t + " can't place units with error: " + placeableUnits.getErrorMessage());
                continue;
            }
            int remainingUnitProduction = placeableUnits.getMaxUnits();
            if (remainingUnitProduction == -1) {
                remainingUnitProduction = Integer.MAX_VALUE;
            }
            LogUtils.log(Level.FINEST, t + ", remainingUnitProduction=" + remainingUnitProduction);
            ArrayList<Unit> unitsThatCanBePlaced = new ArrayList<Unit>(placeableUnits.getUnits());
            int landPlaceCount = Math.min(remainingUnitProduction, unitsThatCanBePlaced.size());
            ArrayList<Unit> unitsToPlace = new ArrayList<Unit>();
            ProBattleResultData finalResult = new ProBattleResultData();
            for (int i = 0; i < landPlaceCount; ++i) {
                unitsToPlace.add((Unit)unitsThatCanBePlaced.get(i));
                HashSet<Unit> enemyAttackingUnits = new HashSet<Unit>(enemyAttackMap.get(t).getMaxUnits());
                enemyAttackingUnits.addAll(enemyAttackMap.get(t).getMaxAmphibUnits());
                ArrayList<Unit> defenders = new ArrayList<Unit>(placeTerritory.getDefendingUnits());
                defenders.addAll(unitsToPlace);
                finalResult = this.battleUtils.calculateBattleResults(this.player, t, new ArrayList<Unit>(enemyAttackingUnits), defenders, enemyAttackMap.get(t).getMaxBombardUnits(), false);
                if (!t.equals(this.myCapital) && !finalResult.isHasLandUnitRemaining() && finalResult.getTUVSwing() <= 0.0 || t.equals(this.myCapital) && finalResult.getWinPercentage() < 5.0 && finalResult.getTUVSwing() <= 0.0) break;
            }
            if (!finalResult.isHasLandUnitRemaining() || finalResult.getTUVSwing() < placeTerritory.getMinBattleResult().getTUVSwing() || t.equals(this.myCapital)) {
                LogUtils.log(Level.FINEST, t + ", placedUnits=" + unitsToPlace + ", TUVSwing=" + finalResult.getTUVSwing());
                this.doPlace(t, unitsToPlace, placeDelegate);
                continue;
            }
            this.setCantHoldPlaceTerritory(placeTerritory, placeNonConstructionTerritories);
            LogUtils.log(Level.FINEST, t + ", unable to defend with placedUnits=" + unitsToPlace + ", TUVSwing=" + finalResult.getTUVSwing() + ", minTUVSwing=" + placeTerritory.getMinBattleResult().getTUVSwing());
        }
    }

    private void placeLandUnits(Map<Territory, ProPurchaseTerritory> placeNonConstructionTerritories, Map<Territory, ProAttackTerritoryData> enemyAttackMap, List<ProPlaceTerritory> prioritizedLandTerritories, IAbstractPlaceDelegate placeDelegate, boolean isConstruction) {
        LogUtils.log(Level.FINE, "Place land with isConstruction=" + isConstruction + ", units=" + this.player.getUnits().getUnits());
        Match<Unit> unitMatch = Matches.UnitIsNotConstruction;
        if (isConstruction) {
            unitMatch = Matches.UnitIsConstruction;
        }
        for (ProPlaceTerritory placeTerritory : prioritizedLandTerritories) {
            Territory t = placeTerritory.getTerritory();
            LogUtils.log(Level.FINER, "Checking land place for " + t.getName());
            PlaceableUnits placeableUnits = placeDelegate.getPlaceableUnits(this.player.getUnits().getMatches(unitMatch), t);
            if (placeableUnits.isError()) {
                LogUtils.log(Level.FINEST, t + " can't place units with error: " + placeableUnits.getErrorMessage());
                continue;
            }
            int remainingUnitProduction = placeableUnits.getMaxUnits();
            if (remainingUnitProduction == -1) {
                remainingUnitProduction = Integer.MAX_VALUE;
            }
            LogUtils.log(Level.FINEST, t + ", remainingUnitProduction=" + remainingUnitProduction);
            ArrayList<Unit> unitsThatCanBePlaced = new ArrayList<Unit>(placeableUnits.getUnits());
            int landPlaceCount = Math.min(remainingUnitProduction, unitsThatCanBePlaced.size());
            List<Unit> unitsToPlace = unitsThatCanBePlaced.subList(0, landPlaceCount);
            LogUtils.log(Level.FINEST, t + ", placedUnits=" + unitsToPlace);
            this.doPlace(t, unitsToPlace, placeDelegate);
        }
    }

    private void addUnitsToPlaceTerritory(ProPlaceTerritory placeTerritory, List<Unit> unitsToPlace, Map<Territory, ProPurchaseTerritory> purchaseTerritories) {
        for (Territory purchaseTerritory : purchaseTerritories.keySet()) {
            for (ProPlaceTerritory ppt : purchaseTerritories.get(purchaseTerritory).getCanPlaceTerritories()) {
                if (!placeTerritory.equals(ppt) || purchaseTerritories.get(purchaseTerritory).getRemainingUnitProduction() <= 0) continue;
                int numUnits = Math.min(purchaseTerritories.get(purchaseTerritory).getRemainingUnitProduction(), unitsToPlace.size());
                List<Unit> units = unitsToPlace.subList(0, numUnits);
                ppt.getPlaceUnits().addAll(units);
                units.clear();
            }
        }
    }

    private void setCantHoldPlaceTerritory(ProPlaceTerritory placeTerritory, Map<Territory, ProPurchaseTerritory> purchaseTerritories) {
        for (Territory purchaseTerritory : purchaseTerritories.keySet()) {
            for (ProPlaceTerritory ppt : purchaseTerritories.get(purchaseTerritory).getCanPlaceTerritories()) {
                if (!placeTerritory.equals(ppt)) continue;
                ppt.setCanHold(false);
            }
        }
    }

    private List<ProPurchaseTerritory> getPurchaseTerritories(ProPlaceTerritory placeTerritory, Map<Territory, ProPurchaseTerritory> purchaseTerritories) {
        ArrayList<ProPurchaseTerritory> territories = new ArrayList<ProPurchaseTerritory>();
        for (Territory t : purchaseTerritories.keySet()) {
            for (ProPlaceTerritory ppt : purchaseTerritories.get(t).getCanPlaceTerritories()) {
                if (!placeTerritory.equals(ppt)) continue;
                territories.add(purchaseTerritories.get(t));
            }
        }
        return territories;
    }

    private void doPlace(Territory t, Collection<Unit> toPlace, IAbstractPlaceDelegate del) {
        for (Unit unit : toPlace) {
            ArrayList<Unit> unitList = new ArrayList<Unit>();
            unitList.add(unit);
            String message = del.placeUnits(unitList, t);
            if (message == null) continue;
            LogUtils.log(Level.WARNING, message);
            LogUtils.log(Level.WARNING, "Attempt was at: " + t + " with: " + unit);
        }
        this.utils.pause();
    }
}

