/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.proAI;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.Properties;
import games.strategy.triplea.ai.proAI.util.LogUtils;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.attatchments.UnitSupportAttachment;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TechTracker;
import games.strategy.util.IntegerMap;
import games.strategy.util.LinkedIntegerMap;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class ProPurchaseOption {
    private final ProductionRule productionRule;
    private final UnitType unitType;
    private final PlayerID player;
    private final int cost;
    private final int movement;
    private final int quantity;
    private int hitPoints;
    private final double attack;
    private final double amphibAttack;
    private final double defense;
    private final int transportCost;
    private final int carrierCost;
    private final boolean isAir;
    private final boolean isSub;
    private final boolean isDestroyer;
    private final boolean isTransport;
    private final boolean isCarrier;
    private final boolean isInfra;
    private final int transportCapacity;
    private final int carrierCapacity;
    private final double transportEfficiency;
    private final double carrierEfficiency;
    private double costPerHitPoint;
    private final double hitPointEfficiency;
    private final double attackEfficiency;
    private final double defenseEfficiency;
    private final int maxBuiltPerPlayer;
    private final Set<UnitSupportAttachment> unitSupportAttachments;
    private boolean isAttackSupport;
    private boolean isDefenseSupport;

    public ProPurchaseOption(ProductionRule productionRule, UnitType unitType, PlayerID player, GameData data) {
        this.productionRule = productionRule;
        this.unitType = unitType;
        this.player = player;
        UnitAttachment unitAttachment = UnitAttachment.get(unitType);
        Resource PUs = data.getResourceList().getResource("PUs");
        this.cost = productionRule.getCosts().getInt(PUs);
        this.movement = unitAttachment.getMovement(player);
        this.quantity = productionRule.getResults().totalValues();
        this.isInfra = unitAttachment.getIsInfrastructure();
        this.hitPoints = unitAttachment.getHitPoints() * this.quantity;
        if (this.isInfra) {
            this.hitPoints = 0;
        }
        this.attack = unitAttachment.getAttack(player) * this.quantity;
        this.amphibAttack = this.attack + 0.5 * (double)unitAttachment.getIsMarine() * (double)this.quantity;
        this.defense = unitAttachment.getDefense(player) * this.quantity;
        this.transportCost = unitAttachment.getTransportCost() * this.quantity;
        this.carrierCost = unitAttachment.getCarrierCost() * this.quantity;
        this.isAir = unitAttachment.getIsAir();
        this.isSub = unitAttachment.getIsSub();
        this.isDestroyer = unitAttachment.getIsDestroyer();
        this.isTransport = unitAttachment.getTransportCapacity() > 0;
        this.isCarrier = unitAttachment.getCarrierCapacity() > 0;
        this.transportCapacity = unitAttachment.getTransportCapacity() * this.quantity;
        this.carrierCapacity = unitAttachment.getCarrierCapacity() * this.quantity;
        this.transportEfficiency = (double)unitAttachment.getTransportCapacity() / (double)this.cost;
        this.carrierEfficiency = (double)unitAttachment.getCarrierCapacity() / (double)this.cost;
        this.costPerHitPoint = this.hitPoints == 0 ? Double.POSITIVE_INFINITY : (double)this.cost / (double)this.hitPoints;
        this.hitPointEfficiency = ((double)this.hitPoints + 0.1 * this.attack * 6.0 / (double)data.getDiceSides() + 0.2 * this.defense * 6.0 / (double)data.getDiceSides()) / (double)this.cost;
        this.attackEfficiency = (double)(1 + this.hitPoints) * ((double)this.hitPoints + this.attack * 6.0 / (double)data.getDiceSides() + 0.5 * this.defense * 6.0 / (double)data.getDiceSides()) / (double)this.cost;
        this.defenseEfficiency = (double)(1 + this.hitPoints) * ((double)this.hitPoints + 0.5 * this.attack * 6.0 / (double)data.getDiceSides() + this.defense * 6.0 / (double)data.getDiceSides()) / (double)this.cost;
        this.maxBuiltPerPlayer = unitAttachment.getMaxBuiltPerPlayer();
        this.unitSupportAttachments = UnitSupportAttachment.get(unitType);
        this.isAttackSupport = false;
        this.isDefenseSupport = false;
        for (UnitSupportAttachment usa : this.unitSupportAttachments) {
            if (usa.getOffence()) {
                this.isAttackSupport = true;
            }
            if (!usa.getDefence()) continue;
            this.isDefenseSupport = true;
        }
    }

    public String toString() {
        return this.productionRule + " | cost=" + this.cost + " | moves=" + this.movement + " | quantity=" + this.quantity + " | hitPointEfficiency=" + this.hitPointEfficiency + " | attackEfficiency=" + this.attackEfficiency + " | defenseEfficiency=" + this.defenseEfficiency + " | isSub=" + this.isSub + " | isTransport=" + this.isTransport + " | isCarrier=" + this.isCarrier;
    }

    public ProductionRule getProductionRule() {
        return this.productionRule;
    }

    public int getCost() {
        return this.cost;
    }

    public int getMovement() {
        return this.movement;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public int getHitPoints() {
        return this.hitPoints;
    }

    public double getAttack() {
        return this.attack;
    }

    public double getDefense() {
        return this.defense;
    }

    public boolean isSub() {
        return this.isSub;
    }

    public boolean isDestroyer() {
        return this.isDestroyer;
    }

    public boolean isTransport() {
        return this.isTransport;
    }

    public boolean isCarrier() {
        return this.isCarrier;
    }

    public double getTransportEfficiency() {
        return this.transportEfficiency;
    }

    public double getCarrierEfficiency() {
        return this.carrierEfficiency;
    }

    public double getHitPointEfficiency() {
        return this.hitPointEfficiency;
    }

    public double getAttackEfficiency() {
        return this.attackEfficiency;
    }

    public double getDefenseEfficiency() {
        return this.defenseEfficiency;
    }

    public UnitType getUnitType() {
        return this.unitType;
    }

    public int getTransportCapacity() {
        return this.transportCapacity;
    }

    public int getCarrierCapacity() {
        return this.carrierCapacity;
    }

    public int getTransportCost() {
        return this.transportCost;
    }

    public int getCarrierCost() {
        return this.carrierCost;
    }

    public boolean isAir() {
        return this.isAir;
    }

    public void setCostPerHitPoint(double costPerHitPoint) {
        this.costPerHitPoint = costPerHitPoint;
    }

    public double getCostPerHitPoint() {
        return this.costPerHitPoint;
    }

    public int getMaxBuiltPerPlayer() {
        return this.maxBuiltPerPlayer;
    }

    public boolean isAttackSupport() {
        return this.isAttackSupport;
    }

    public boolean isDefenseSupport() {
        return this.isDefenseSupport;
    }

    public double getFodderEfficiency(int enemyDistance, GameData data, List<Unit> ownedLocalUnits, List<Unit> unitsToPlace) {
        double supportAttackFactor = this.calculateSupportFactor(ownedLocalUnits, unitsToPlace, data, false);
        double supportDefenseFactor = this.calculateSupportFactor(ownedLocalUnits, unitsToPlace, data, true);
        double distanceFactor = Math.sqrt(this.calculateLandDistanceFactor(enemyDistance));
        return this.calculateEfficiency(0.25, 0.25, supportAttackFactor, supportDefenseFactor, distanceFactor, data);
    }

    public double getAttackEfficiency2(int enemyDistance, GameData data, List<Unit> ownedLocalUnits, List<Unit> unitsToPlace) {
        double supportAttackFactor = this.calculateSupportFactor(ownedLocalUnits, unitsToPlace, data, false);
        double supportDefenseFactor = this.calculateSupportFactor(ownedLocalUnits, unitsToPlace, data, true);
        double distanceFactor = this.calculateLandDistanceFactor(enemyDistance);
        return this.calculateEfficiency(1.25, 0.75, supportAttackFactor, supportDefenseFactor, distanceFactor, data);
    }

    public double getDefenseEfficiency2(int enemyDistance, GameData data, List<Unit> ownedLocalUnits, List<Unit> unitsToPlace) {
        double supportAttackFactor = this.calculateSupportFactor(ownedLocalUnits, unitsToPlace, data, false);
        double supportDefenseFactor = this.calculateSupportFactor(ownedLocalUnits, unitsToPlace, data, true);
        double distanceFactor = this.calculateLandDistanceFactor(enemyDistance);
        return this.calculateEfficiency(0.75, 1.25, supportAttackFactor, supportDefenseFactor, distanceFactor, data);
    }

    public double getSeaDefenseEfficiency(GameData data, List<Unit> ownedLocalUnits, List<Unit> unitsToPlace, boolean needDestroyer, int unusedCarrierCapacity, int unusedLocalCarrierCapacity) {
        if (this.isAir && (this.carrierCost <= 0 || this.carrierCost > unusedCarrierCapacity || !Properties.getProduceFightersOnCarriers(data))) {
            return 0.0;
        }
        double supportAttackFactor = this.calculateSupportFactor(ownedLocalUnits, unitsToPlace, data, false);
        double supportDefenseFactor = this.calculateSupportFactor(ownedLocalUnits, unitsToPlace, data, true);
        double seaFactor = 1.0;
        if (needDestroyer && this.isDestroyer) {
            seaFactor = 8.0;
        }
        if (this.isAir) {
            seaFactor = 4.0;
        } else if (this.carrierCapacity > 0 && unusedLocalCarrierCapacity <= 0) {
            seaFactor = 4.0;
        }
        return this.calculateEfficiency(0.75, 1.0, supportAttackFactor, supportDefenseFactor, this.movement, seaFactor, data);
    }

    public double getAmphibEfficiency(GameData data, List<Unit> ownedLocalUnits, List<Unit> unitsToPlace) {
        double supportAttackFactor = this.calculateSupportFactor(ownedLocalUnits, unitsToPlace, data, false);
        double supportDefenseFactor = this.calculateSupportFactor(ownedLocalUnits, unitsToPlace, data, true);
        double hitPointPerUnitFactor = 3 + this.hitPoints / this.quantity;
        double transportCostFactor = Math.pow(1.0 / (double)this.transportCost, 0.2);
        double hitPointValue = 2 * this.hitPoints;
        double attackValue = (this.amphibAttack + supportAttackFactor * (double)this.quantity) * 6.0 / (double)data.getDiceSides();
        double defenseValue = (this.defense + supportDefenseFactor * (double)this.quantity) * 6.0 / (double)data.getDiceSides();
        return Math.pow((hitPointValue + attackValue + defenseValue) * hitPointPerUnitFactor * transportCostFactor / (double)this.cost, 30.0) / (double)this.quantity;
    }

    public double getTransportEfficiency(GameData data) {
        return Math.pow(this.transportEfficiency, 30.0) / (double)this.quantity;
    }

    private double calculateLandDistanceFactor(int enemyDistance) {
        double distance = Math.max(0.0, (double)enemyDistance - 1.5);
        double moveFactor = 1.0 + 2.0 * (Math.pow(2.0, this.movement - 1) - 1.0) / Math.pow(2.0, this.movement - 1);
        double distanceFactor = Math.pow(moveFactor, distance / 5.0);
        return distanceFactor;
    }

    private double calculateSupportFactor(List<Unit> ownedLocalUnits, List<Unit> unitsToPlace, GameData data, boolean defense) {
        if (!this.isAttackSupport && !defense || !this.isDefenseSupport && defense) {
            return 0.0;
        }
        ArrayList<Unit> units = new ArrayList<Unit>(ownedLocalUnits);
        units.addAll(unitsToPlace);
        units.addAll(this.unitType.create(1, this.player, true));
        HashSet<List<UnitSupportAttachment>> supportsAvailable = new HashSet<List<UnitSupportAttachment>>();
        IntegerMap<UnitSupportAttachment> supportLeft = new IntegerMap<UnitSupportAttachment>();
        DiceRoll.getSupport(units, supportsAvailable, supportLeft, new HashMap<UnitSupportAttachment, LinkedIntegerMap<Unit>>(), data, defense, true);
        double totalSupportFactor = 0.0;
        for (UnitSupportAttachment usa : this.unitSupportAttachments) {
            for (List list : supportsAvailable) {
                if (!list.contains(usa)) continue;
                int numAddedSupport = usa.getNumber();
                if (usa.getImpArtTech() && TechTracker.hasImprovedArtillerySupport(this.player)) {
                    numAddedSupport *= 2;
                }
                int numSupportProvided = -numAddedSupport;
                HashSet<Unit> supportableUnits = new HashSet<Unit>();
                for (UnitSupportAttachment usa2 : list) {
                    numSupportProvided += supportLeft.getInt(usa2);
                    supportableUnits.addAll(Match.getMatches(units, Matches.unitIsOfTypes(usa2.getUnitType())));
                }
                int numSupportableUnits = supportableUnits.size();
                int numExtraSupportableUnits = Math.max(0, numSupportableUnits - numSupportProvided);
                double ratio = Math.min(1.0, 2.0 * (double)numExtraSupportableUnits / (double)(numSupportableUnits + numAddedSupport));
                double bonus = 0.0;
                if (usa.getStrength()) {
                    bonus += (double)usa.getBonus();
                }
                if (usa.getRoll()) {
                    bonus += (double)(usa.getBonus() * data.getDiceSides()) * 0.75;
                }
                double supportFactor = Math.pow((double)numAddedSupport * 0.9, 0.9) * bonus * ratio;
                totalSupportFactor += supportFactor;
                LogUtils.log(Level.FINEST, this.unitType.getName() + ", bonusType=" + usa.getBonusType() + ", supportFactor=" + supportFactor + ", numSupportProvided=" + numSupportProvided + ", numSupportableUnits=" + numSupportableUnits + ", numAddedSupport=" + numAddedSupport + ", ratio=" + ratio + ", bonus=" + bonus);
            }
        }
        LogUtils.log(Level.FINER, this.unitType.getName() + ", defense=" + defense + ", totalSupportFactor=" + totalSupportFactor);
        return totalSupportFactor;
    }

    private double calculateEfficiency(double attackFactor, double defenseFactor, double supportAttackFactor, double supportDefenseFactor, double distanceFactor, GameData data) {
        return this.calculateEfficiency(attackFactor, defenseFactor, supportAttackFactor, supportDefenseFactor, distanceFactor, 1.0, data);
    }

    private double calculateEfficiency(double attackFactor, double defenseFactor, double supportAttackFactor, double supportDefenseFactor, double distanceFactor, double seaFactor, GameData data) {
        double hitPointPerUnitFactor = 3 + this.hitPoints / this.quantity;
        double hitPointValue = 2 * this.hitPoints;
        double attackValue = attackFactor * (this.attack + supportAttackFactor * (double)this.quantity) * 6.0 / (double)data.getDiceSides();
        double defenseValue = defenseFactor * (this.defense + supportDefenseFactor * (double)this.quantity) * 6.0 / (double)data.getDiceSides();
        return Math.pow((hitPointValue + attackValue + defenseValue) * hitPointPerUnitFactor * distanceFactor * seaFactor / (double)this.cost, 30.0) / (double)this.quantity;
    }
}

