/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.proAI;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.NamedAttachable;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.ai.proAI.ProPurchaseOption;
import games.strategy.triplea.ai.proAI.util.LogUtils;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.Matches;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;

public class ProPurchaseOptionMap {
    private final List<ProPurchaseOption> landFodderOptions;
    private final List<ProPurchaseOption> landAttackOptions;
    private final List<ProPurchaseOption> landDefenseOptions;
    private final List<ProPurchaseOption> airOptions;
    private final List<ProPurchaseOption> seaDefenseOptions;
    private final List<ProPurchaseOption> seaTransportOptions;
    private final List<ProPurchaseOption> seaCarrierOptions;
    private final List<ProPurchaseOption> seaSubOptions;
    private final List<ProPurchaseOption> aaOptions;
    private final List<ProPurchaseOption> factoryOptions;
    private final List<ProPurchaseOption> specialOptions;

    public ProPurchaseOptionMap(PlayerID player, GameData data) {
        LogUtils.log(Level.FINE, "Purchase Options");
        this.landFodderOptions = new ArrayList<ProPurchaseOption>();
        this.landAttackOptions = new ArrayList<ProPurchaseOption>();
        this.landDefenseOptions = new ArrayList<ProPurchaseOption>();
        this.airOptions = new ArrayList<ProPurchaseOption>();
        this.seaDefenseOptions = new ArrayList<ProPurchaseOption>();
        this.seaTransportOptions = new ArrayList<ProPurchaseOption>();
        this.seaCarrierOptions = new ArrayList<ProPurchaseOption>();
        this.seaSubOptions = new ArrayList<ProPurchaseOption>();
        this.aaOptions = new ArrayList<ProPurchaseOption>();
        this.factoryOptions = new ArrayList<ProPurchaseOption>();
        this.specialOptions = new ArrayList<ProPurchaseOption>();
        List<ProductionRule> rules = player.getProductionFrontier().getRules();
        for (ProductionRule rule : rules) {
            ProPurchaseOption ppo;
            NamedAttachable resourceOrUnit = rule.getResults().keySet().iterator().next();
            if (!(resourceOrUnit instanceof UnitType)) continue;
            UnitType unitType = (UnitType)resourceOrUnit;
            if (UnitAttachment.get(unitType).getMovement(player) <= 0 && !UnitAttachment.get(unitType).getCanProduceUnits() || Matches.UnitTypeConsumesUnitsOnCreation.match(unitType) || UnitAttachment.get(unitType).getIsSuicide()) {
                ppo = new ProPurchaseOption(rule, unitType, player, data);
                this.specialOptions.add(ppo);
                LogUtils.log(Level.FINER, "Special: " + ppo);
                continue;
            }
            if (Matches.UnitTypeCanProduceUnits.match(unitType) && Matches.UnitTypeIsInfrastructure.match(unitType)) {
                ppo = new ProPurchaseOption(rule, unitType, player, data);
                this.factoryOptions.add(ppo);
                LogUtils.log(Level.FINER, "Factory: " + ppo);
                continue;
            }
            if (Matches.UnitTypeIsAAforBombingThisUnitOnly.match(unitType)) {
                ppo = new ProPurchaseOption(rule, unitType, player, data);
                this.aaOptions.add(ppo);
                LogUtils.log(Level.FINER, "AA: " + ppo);
                continue;
            }
            if (Matches.UnitTypeIsLand.match(unitType)) {
                ppo = new ProPurchaseOption(rule, unitType, player, data);
                this.landFodderOptions.add(ppo);
                if (ppo.getAttack() >= ppo.getDefense() || ppo.isAttackSupport() || ppo.getMovement() > 1) {
                    this.landAttackOptions.add(ppo);
                }
                if (ppo.getDefense() >= ppo.getAttack() || ppo.isDefenseSupport() || ppo.getMovement() > 1) {
                    this.landDefenseOptions.add(ppo);
                }
                LogUtils.log(Level.FINER, "Land: " + ppo);
                continue;
            }
            if (Matches.UnitTypeIsAir.match(unitType)) {
                ppo = new ProPurchaseOption(rule, unitType, player, data);
                this.airOptions.add(ppo);
                LogUtils.log(Level.FINER, "Air: " + ppo);
                continue;
            }
            if (!Matches.UnitTypeIsSea.match(unitType)) continue;
            ppo = new ProPurchaseOption(rule, unitType, player, data);
            if (!ppo.isSub()) {
                this.seaDefenseOptions.add(ppo);
            }
            if (ppo.isTransport()) {
                this.seaTransportOptions.add(ppo);
            }
            if (ppo.isCarrier()) {
                this.seaCarrierOptions.add(ppo);
            }
            if (ppo.isSub()) {
                this.seaSubOptions.add(ppo);
            }
            LogUtils.log(Level.FINER, "Sea: " + ppo);
        }
        if (this.landAttackOptions.isEmpty()) {
            this.landAttackOptions.addAll(this.landDefenseOptions);
        }
        if (this.landDefenseOptions.isEmpty()) {
            this.landDefenseOptions.addAll(this.landAttackOptions);
        }
        LogUtils.log(Level.FINE, "Purchase Categories");
        this.logOptions(this.landFodderOptions, "Land Fodder Options: ");
        this.logOptions(this.landAttackOptions, "Land Attack Options: ");
        this.logOptions(this.landDefenseOptions, "Land Defense Options: ");
        this.logOptions(this.airOptions, "Air Options: ");
        this.logOptions(this.seaDefenseOptions, "Sea Defense Options: ");
        this.logOptions(this.seaTransportOptions, "Sea Transport Options: ");
        this.logOptions(this.seaCarrierOptions, "Sea Carrier Options: ");
        this.logOptions(this.seaSubOptions, "Sea Sub Options: ");
        this.logOptions(this.aaOptions, "AA Options: ");
        this.logOptions(this.factoryOptions, "Factory Options: ");
        this.logOptions(this.specialOptions, "Special Options: ");
    }

    public List<ProPurchaseOption> getAllOptions() {
        HashSet<ProPurchaseOption> allOptions = new HashSet<ProPurchaseOption>();
        allOptions.addAll(this.getLandOptions());
        allOptions.addAll(this.airOptions);
        allOptions.addAll(this.getSeaOptions());
        allOptions.addAll(this.aaOptions);
        allOptions.addAll(this.factoryOptions);
        allOptions.addAll(this.specialOptions);
        return new ArrayList<ProPurchaseOption>(allOptions);
    }

    public List<ProPurchaseOption> getLandOptions() {
        HashSet<ProPurchaseOption> landOptions = new HashSet<ProPurchaseOption>();
        landOptions.addAll(this.landFodderOptions);
        landOptions.addAll(this.landAttackOptions);
        landOptions.addAll(this.landDefenseOptions);
        return new ArrayList<ProPurchaseOption>(landOptions);
    }

    public List<ProPurchaseOption> getSeaOptions() {
        HashSet<ProPurchaseOption> seaOptions = new HashSet<ProPurchaseOption>();
        seaOptions.addAll(this.seaDefenseOptions);
        seaOptions.addAll(this.seaTransportOptions);
        seaOptions.addAll(this.seaCarrierOptions);
        seaOptions.addAll(this.seaSubOptions);
        return new ArrayList<ProPurchaseOption>(seaOptions);
    }

    public List<ProPurchaseOption> getLandFodderOptions() {
        return this.landFodderOptions;
    }

    public List<ProPurchaseOption> getLandAttackOptions() {
        return this.landAttackOptions;
    }

    public List<ProPurchaseOption> getLandDefenseOptions() {
        return this.landDefenseOptions;
    }

    public List<ProPurchaseOption> getAirOptions() {
        return this.airOptions;
    }

    public List<ProPurchaseOption> getSeaDefenseOptions() {
        return this.seaDefenseOptions;
    }

    public List<ProPurchaseOption> getSeaTransportOptions() {
        return this.seaTransportOptions;
    }

    public List<ProPurchaseOption> getSeaCarrierOptions() {
        return this.seaCarrierOptions;
    }

    public List<ProPurchaseOption> getSeaSubOptions() {
        return this.seaSubOptions;
    }

    public List<ProPurchaseOption> getAAOptions() {
        return this.aaOptions;
    }

    public List<ProPurchaseOption> getFactoryOptions() {
        return this.factoryOptions;
    }

    public List<ProPurchaseOption> getSpecialOptions() {
        return this.specialOptions;
    }

    private void logOptions(List<ProPurchaseOption> purchaseOptions, String name) {
        StringBuilder sb = new StringBuilder(name);
        for (ProPurchaseOption ppo : purchaseOptions) {
            sb.append(ppo.getUnitType().getName());
            sb.append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        LogUtils.log(Level.FINER, sb.toString());
    }
}

