/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.proAI;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.triplea.Properties;
import games.strategy.triplea.ai.proAI.ProPlaceTerritory;
import games.strategy.triplea.ai.proAI.util.ProMatches;
import games.strategy.triplea.delegate.Matches;
import java.util.ArrayList;
import java.util.List;

public class ProPurchaseTerritory {
    private Territory territory;
    private int unitProduction;
    private List<ProPlaceTerritory> canPlaceTerritories;

    public ProPurchaseTerritory(Territory territory, GameData data, PlayerID player, int unitProduction) {
        this.territory = territory;
        this.unitProduction = unitProduction;
        this.canPlaceTerritories = new ArrayList<ProPlaceTerritory>();
        this.canPlaceTerritories.add(new ProPlaceTerritory(territory));
        if (ProMatches.territoryHasInfraFactoryAndIsNotConqueredOwnedLand(player, data).match(territory)) {
            for (Territory t : data.getMap().getNeighbors(territory, Matches.TerritoryIsWater)) {
                if (!Properties.getWW2V2(data) && !Properties.getUnitPlacementInEnemySeas(data) && t.getUnits().someMatch(Matches.enemyUnit(player, data))) continue;
                this.canPlaceTerritories.add(new ProPlaceTerritory(t));
            }
        }
    }

    public int getRemainingUnitProduction() {
        int remainingUnitProduction = this.unitProduction;
        for (ProPlaceTerritory ppt : this.canPlaceTerritories) {
            remainingUnitProduction -= ppt.getPlaceUnits().size();
        }
        return remainingUnitProduction;
    }

    public Territory getTerritory() {
        return this.territory;
    }

    public String toString() {
        return this.territory + " | unitProduction=" + this.unitProduction + " | placeTerritories=" + this.canPlaceTerritories;
    }

    public void setTerritory(Territory territory) {
        this.territory = territory;
    }

    public int getUnitProduction() {
        return this.unitProduction;
    }

    public void setUnitProduction(int unitProduction) {
        this.unitProduction = unitProduction;
    }

    public List<ProPlaceTerritory> getCanPlaceTerritories() {
        return this.canPlaceTerritories;
    }

    public void setCanPlaceTerritories(List<ProPlaceTerritory> canPlaceTerritories) {
        this.canPlaceTerritories = canPlaceTerritories;
    }
}

