/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.proAI;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.net.GUID;
import games.strategy.triplea.ai.proAI.ProAI;
import games.strategy.triplea.ai.proAI.ProBattleResultData;
import games.strategy.triplea.ai.proAI.util.LogUtils;
import games.strategy.triplea.ai.proAI.util.ProBattleUtils;
import games.strategy.triplea.ai.proAI.util.ProMatches;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.BattleDelegate;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.Matches;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;

public class ProRetreatAI {
    private final ProAI ai;
    private final ProBattleUtils battleUtils;

    public ProRetreatAI(ProAI ai, ProBattleUtils battleUtils) {
        this.ai = ai;
        this.battleUtils = battleUtils;
    }

    public Territory retreatQuery(GUID battleID, boolean submerge, Territory battleTerritory, Collection<Territory> possibleTerritories, String message) {
        GameData data = this.ai.getGameData();
        PlayerID player = this.ai.getPlayerID();
        BattleDelegate delegate = DelegateFinder.battleDelegate(data);
        IBattle battle = delegate.getBattleTracker().getPendingBattle(battleID);
        boolean isAttacker = player.equals(battle.getAttacker());
        List attackers = (List)battle.getAttackingUnits();
        List defenders = (List)battle.getDefendingUnits();
        ProBattleResultData result = this.battleUtils.calculateBattleResults(player, battleTerritory, attackers, defenders, new HashSet<Unit>(), isAttacker);
        int isFactory = 0;
        if (ProMatches.territoryHasInfraFactoryAndIsLand(player).match(battleTerritory)) {
            isFactory = 1;
        }
        int production = 0;
        int isCapital = 0;
        TerritoryAttachment ta = TerritoryAttachment.get(battleTerritory);
        if (ta != null) {
            production = ta.getProduction();
            if (ta.isCapital()) {
                isCapital = 1;
            }
        }
        double territoryValue = 0.0;
        if (result.isHasLandUnitRemaining() || Match.noneMatch(attackers, Matches.UnitIsAir)) {
            territoryValue = result.getWinPercentage() / 100.0 * (double)(2 * production * (1 + isFactory) * (1 + isCapital));
        }
        double battleValue = result.getTUVSwing() + territoryValue;
        if (!isAttacker) {
            battleValue = -battleValue;
        }
        if (battleValue < 0.0) {
            Territory retreatTerritory = null;
            double maxStrength = Double.NEGATIVE_INFINITY;
            Territory myCapital = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
            for (Territory t : possibleTerritories) {
                if (t.equals(myCapital)) {
                    retreatTerritory = t;
                    break;
                }
                double strength = this.battleUtils.estimateStrength(player, t, t.getUnits().getMatches(Matches.isUnitAllied(player, data)), new ArrayList<Unit>(), false);
                if (!(strength > maxStrength)) continue;
                retreatTerritory = t;
                maxStrength = strength;
            }
            LogUtils.log(Level.FINER, player.getName() + " retreating from territory " + battleTerritory + " to " + retreatTerritory + " because AttackValue=" + battleValue + ", TUVSwing=" + result.getTUVSwing() + ", possibleTerritories=" + possibleTerritories.size());
            return retreatTerritory;
        }
        LogUtils.log(Level.FINER, player.getName() + " not retreating from territory " + battleTerritory + " with AttackValue=" + battleValue + ", TUVSwing=" + result.getTUVSwing());
        return null;
    }
}

