/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.proAI;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.Properties;
import games.strategy.triplea.ai.proAI.ProAI;
import games.strategy.triplea.ai.proAI.ProBattleResultData;
import games.strategy.triplea.ai.proAI.util.LogUtils;
import games.strategy.triplea.ai.proAI.util.ProAttackOptionsUtils;
import games.strategy.triplea.ai.proAI.util.ProBattleUtils;
import games.strategy.triplea.ai.proAI.util.ProMatches;
import games.strategy.triplea.delegate.BattleDelegate;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class ProScrambleAI {
    public static double WIN_PERCENTAGE = 95.0;
    public static double MIN_WIN_PERCENTAGE = 80.0;
    private final ProAI ai;
    private final ProBattleUtils battleUtils;
    private final ProAttackOptionsUtils attackOptionsUtils;

    public ProScrambleAI(ProAI ai, ProBattleUtils battleUtils, ProAttackOptionsUtils attackOptionsUtils) {
        this.ai = ai;
        this.battleUtils = battleUtils;
        this.attackOptionsUtils = attackOptionsUtils;
    }

    public HashMap<Territory, Collection<Unit>> scrambleUnitsQuery(final Territory scrambleTo, Map<Territory, Tuple<Collection<Unit>, Collection<Unit>>> possibleScramblers) {
        GameData data = this.ai.getGameData();
        final PlayerID player = this.ai.getPlayerID();
        BattleDelegate delegate = DelegateFinder.battleDelegate(data);
        IBattle battle = delegate.getBattleTracker().getPendingBattle(scrambleTo, false, IBattle.BattleType.NORMAL);
        if (!Properties.getLow_Luck(data)) {
            WIN_PERCENTAGE = 90.0;
            MIN_WIN_PERCENTAGE = 65.0;
        }
        List attackers = (List)battle.getAttackingUnits();
        List defenders = (List)battle.getDefendingUnits();
        HashSet<Unit> bombardingUnits = new HashSet<Unit>(battle.getBombardingUnits());
        ProBattleResultData minResult = this.battleUtils.calculateBattleResults(player, scrambleTo, attackers, defenders, bombardingUnits, false);
        LogUtils.log(Level.FINER, scrambleTo + ", minTUVSwing=" + minResult.getTUVSwing() + ", minWin%=" + minResult.getWinPercentage());
        if (minResult.getTUVSwing() <= 0.0 && minResult.getWinPercentage() < 100.0 - MIN_WIN_PERCENTAGE) {
            return null;
        }
        HashSet<Unit> allScramblers = new HashSet<Unit>();
        HashMap<Territory, ArrayList<Unit>> possibleMaxScramblerMap = new HashMap<Territory, ArrayList<Unit>>();
        for (Territory t : possibleScramblers.keySet()) {
            List<Unit> canScrambleAir;
            int maxCanScramble = BattleDelegate.getMaxScrambleCount(possibleScramblers.get(t).getFirst());
            if (maxCanScramble < (canScrambleAir = new ArrayList<Unit>(possibleScramblers.get(t).getSecond())).size()) {
                Collections.sort(canScrambleAir, new Comparator<Unit>(){

                    @Override
                    public int compare(Unit o1, Unit o2) {
                        double strength1 = ProScrambleAI.this.battleUtils.estimateStrength(player, scrambleTo, Collections.singletonList(o1), new ArrayList<Unit>(), false);
                        double strength2 = ProScrambleAI.this.battleUtils.estimateStrength(player, scrambleTo, Collections.singletonList(o2), new ArrayList<Unit>(), false);
                        return Double.compare(strength2, strength1);
                    }
                });
                canScrambleAir = canScrambleAir.subList(0, maxCanScramble);
            }
            allScramblers.addAll(canScrambleAir);
            possibleMaxScramblerMap.put(t, (ArrayList<Unit>)canScrambleAir);
        }
        defenders.addAll(allScramblers);
        ProBattleResultData maxResult = this.battleUtils.calculateBattleResults(player, scrambleTo, attackers, defenders, bombardingUnits, false);
        LogUtils.log(Level.FINER, scrambleTo + ", maxTUVSwing=" + maxResult.getTUVSwing() + ", maxWin%=" + maxResult.getWinPercentage());
        if (maxResult.getTUVSwing() >= minResult.getTUVSwing()) {
            return null;
        }
        HashMap<Unit, Set<Territory>> unitDefendOptions = new HashMap<Unit, Set<Territory>>();
        for (Territory t : possibleMaxScramblerMap.keySet()) {
            Set<Territory> possibleTerritories = data.getMap().getNeighbors(t, ProMatches.territoryCanMoveSeaUnits(player, data, true));
            possibleTerritories.add(t);
            HashSet<Territory> battleTerritories = new HashSet<Territory>();
            for (Territory possibleTerritory : possibleTerritories) {
                IBattle possibleBattle = delegate.getBattleTracker().getPendingBattle(possibleTerritory, false, IBattle.BattleType.NORMAL);
                if (possibleBattle == null) continue;
                battleTerritories.add(possibleTerritory);
            }
            for (Unit u : (List)possibleMaxScramblerMap.get(t)) {
                unitDefendOptions.put(u, battleTerritories);
            }
        }
        Map<Unit, Set<Territory>> sortedUnitDefendOptions = this.attackOptionsUtils.sortUnitMoveOptions(player, unitDefendOptions);
        ArrayList<Unit> unitsToScramble = new ArrayList<Unit>();
        ProBattleResultData result = minResult;
        for (Unit u : sortedUnitDefendOptions.keySet()) {
            unitsToScramble.add(u);
            List currentDefenders = (List)battle.getDefendingUnits();
            currentDefenders.addAll(unitsToScramble);
            result = this.battleUtils.calculateBattleResults(player, scrambleTo, attackers, currentDefenders, bombardingUnits, false);
            LogUtils.log(Level.FINER, scrambleTo + ", TUVSwing=" + result.getTUVSwing() + ", Win%=" + result.getWinPercentage() + ", addedUnit=" + u);
            if (!(result.getTUVSwing() <= 0.0) || !(result.getWinPercentage() < 100.0 - MIN_WIN_PERCENTAGE)) continue;
            break;
        }
        if (result.getTUVSwing() >= minResult.getTUVSwing()) {
            return null;
        }
        HashMap<Territory, Collection<Unit>> scrambleMap = new HashMap<Territory, Collection<Unit>>();
        for (Territory t : possibleScramblers.keySet()) {
            for (Unit u : possibleScramblers.get(t).getSecond()) {
                if (!unitsToScramble.contains(u)) continue;
                if (scrambleMap.containsKey(t)) {
                    scrambleMap.get(t).add(u);
                    continue;
                }
                ArrayList<Unit> units = new ArrayList<Unit>();
                units.add(u);
                scrambleMap.put(t, units);
            }
        }
        return scrambleMap;
    }
}

