/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.proAI.logging;

import games.strategy.triplea.ai.proAI.ProAI;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class LogSettings
implements Serializable {
    private static final long serialVersionUID = 2696071717784800413L;
    public boolean LimitLogHistory = true;
    public int LimitLogHistoryTo = 5;
    public boolean EnableAILogging = true;
    public Level AILoggingDepth = Level.FINEST;
    private static LogSettings s_lastSettings = null;
    private static String PROGRAM_SETTINGS = "Program Settings";

    public static LogSettings loadSettings() {
        if (s_lastSettings == null) {
            LogSettings result = new LogSettings();
            try {
                byte[] pool = Preferences.userNodeForPackage(ProAI.class).getByteArray(PROGRAM_SETTINGS, null);
                if (pool != null) {
                    result = (LogSettings)new ObjectInputStream(new ByteArrayInputStream(pool)).readObject();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                result = new LogSettings();
            }
            s_lastSettings = result;
            return result;
        }
        return s_lastSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSettings(LogSettings settings) {
        s_lastSettings = settings;
        ObjectOutputStream outputStream = null;
        try {
            ByteArrayOutputStream pool = new ByteArrayOutputStream(10000);
            outputStream = new ObjectOutputStream(pool);
            outputStream.writeObject(settings);
            Preferences prefs = Preferences.userNodeForPackage(ProAI.class);
            prefs.putByteArray(PROGRAM_SETTINGS, pool.toByteArray());
            try {
                prefs.flush();
            }
            catch (BackingStoreException ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

